/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Hashtable;
import oracle.ldap.admin.AuditLevelFlags;
import oracle.ldap.admin.DebugFlags;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.ProcDebugFlags;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.SysPasswords;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class DSEEntry
extends Entry {
    int m_orclAuditLevelPropId;
    int m_orclDebugFlagsPropId;
    int[] m_passwordsPropIds;
    static String[] m_passwordsAttr = new String[]{"orclsuname", "orclsupassword", "orclguname", "orclgupassword", "orclprname", "orclprpassword"};
    static Hashtable m_serverModeLov;
    static Hashtable m_cryptoLov;
    public IAdminProp m_edit;
    public IAdminProp m_debugFlagsEdit;
    public IAdminProp m_passwordsEdit;

    public DSEEntry(Root root, Directory directory, String string, Object[] objectArray) {
        super(root, directory, string, objectArray);
        Integer n = root.getAttrPropId("orclauditlevel");
        this.m_orclAuditLevelPropId = n;
        n = root.getAttrPropId("orcldebugflag");
        this.m_orclDebugFlagsPropId = n;
        this.m_passwordsPropIds = new int[m_passwordsAttr.length];
        int n2 = 0;
        while (n2 < m_passwordsAttr.length) {
            this.m_passwordsPropIds[n2] = root.getAttrPropId(m_passwordsAttr[n2]);
            ++n2;
        }
        n = root.getAttrPropId("orclservermode");
        if (m_serverModeLov == null) {
            m_serverModeLov = new Hashtable();
            m_serverModeLov.put("rw", LDAPLang.getStrReadWrite());
            m_serverModeLov.put("ro", LDAPLang.getStrReadOnly());
        }
        this.registerPropListOfValues(n, m_serverModeLov);
        n = root.getAttrPropId("orclcryptoscheme");
        if (m_cryptoLov == null) {
            m_cryptoLov = new Hashtable();
            m_cryptoLov.put("SHA", LDAPLang.getStrSHA());
            m_cryptoLov.put("MD5", LDAPLang.getStrMD5());
            m_cryptoLov.put("MD4", LDAPLang.getStrMD4());
            m_cryptoLov.put("crypt", LDAPLang.getStrCrypt());
            m_cryptoLov.put("none", LDAPLang.getStrNoEncryption());
        }
        this.registerPropListOfValues(n, m_cryptoLov);
    }

    public boolean alwaysUseDisplayName() {
        return true;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 2163876: {
                return new Integer(170);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (n == 2163220 || n == 2163740) {
            if (this.m_edit != null) {
                ((AuditLevelFlags)this.m_edit).editorCancel(true);
            }
            if (this.m_debugFlagsEdit != null) {
                ((DebugFlags)this.m_debugFlagsEdit).editorCancel(true);
            }
            if (this.m_passwordsEdit != null) {
                ((SysPasswords)this.m_passwordsEdit).editorCancel(true);
            }
        }
        super.setProp(n, object);
    }

    public IAdminProp getAuditLevelEditor() {
        if (this.m_edit != null) {
            return this.m_edit;
        }
        try {
            String string = (String)this.getProp(this.m_orclAuditLevelPropId);
            if (string == null) {
                return null;
            }
            this.m_edit = new AuditLevelFlags(this, this.m_orclAuditLevelPropId, Integer.parseInt(string), false);
            this.setPropHidden(this.m_orclAuditLevelPropId, true, false);
            return this.m_edit;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IAdminProp getDebugFlagsEditor() {
        if (this.m_debugFlagsEdit != null) {
            return this.m_debugFlagsEdit;
        }
        try {
            String string = (String)this.getProp(this.m_orclDebugFlagsPropId);
            if (string == null) {
                return null;
            }
            this.m_debugFlagsEdit = new DebugFlags(this, this.m_orclDebugFlagsPropId, Integer.parseInt(string), false);
            this.setPropHidden(this.m_orclDebugFlagsPropId, true, false);
            return this.m_debugFlagsEdit;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IAdminProp getPasswordsEditor() {
        if (this.m_passwordsEdit != null) {
            return this.m_passwordsEdit;
        }
        try {
            int n = 0;
            String[] stringArray = new String[this.m_passwordsPropIds.length];
            int n2 = 0;
            while (n2 < this.m_passwordsPropIds.length) {
                stringArray[n2] = (String)this.getProp(this.m_passwordsPropIds[n2]);
                if (stringArray[n2] != null) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                return null;
            }
            String[] stringArray2 = new String[n];
            int[] nArray = new int[n];
            String[] stringArray3 = new String[n];
            boolean[] blArray = new boolean[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.m_passwordsPropIds.length) {
                if (stringArray[n4] != null) {
                    stringArray2[n3] = this.getPropName(this.m_passwordsPropIds[n4]);
                    nArray[n3] = this.m_passwordsPropIds[n4];
                    stringArray3[n3] = stringArray[n4];
                    blArray[n3] = n4 == 0 || n4 == 2 || n4 == 4;
                    ++n3;
                }
                ++n4;
            }
            this.m_passwordsEdit = new SysPasswords(this.m_parent, this, stringArray2, nArray, stringArray3, blArray);
            ((SysPasswords)this.m_passwordsEdit).update();
            int n5 = 0;
            while (n5 < this.m_passwordsPropIds.length) {
                this.setPropHidden(this.m_passwordsPropIds[n5], true, false);
                ++n5;
            }
            return this.m_passwordsEdit;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return null;
        }
    }

    public void cleanup() {
        super.cleanup();
        if (this.m_edit != null) {
            ((AuditLevelFlags)this.m_edit).cleanup();
        }
        this.m_edit = null;
        if (this.m_passwordsEdit != null) {
            ((SysPasswords)this.m_passwordsEdit).cleanup();
        }
        this.m_passwordsEdit = null;
        if (this.m_debugFlagsEdit != null) {
            ((ProcDebugFlags)this.m_debugFlagsEdit).cleanup();
        }
        this.m_debugFlagsEdit = null;
    }
}

