/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.DirTreeOutPort;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.NewEntry;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class DirTree
extends Entry {
    static final int CMD_REFRESH_ENTRY = -8194;
    static final int CMD_REFRESH_SUBENTRIES = -8195;
    static int m_sizeLimit = 200;
    static int m_timeLimit = 25;
    static int m_count;
    boolean m_normalColor = true;
    int m_count2 = 1;
    String m_basedn = "objectclass= ";
    String m_displayMsg;
    Object[] m_attrs;
    Vector m_children;
    Root m_parent;
    boolean m_topLevel = false;
    IAdminProp m_inPort;
    IAdminProp m_outPort;
    String m_displayName = LDAPLang.getStrTreeView();
    boolean m_hideInPort = false;
    Directory m_directory;
    static final String DSE_DISP_NAME2 = "Root";
    static final String[] dseRoots;

    public int countChildren() {
        if (this.m_children == null) {
            return 0;
        }
        return this.m_children.size();
    }

    public void addChild(Object object) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        try {
            String string = (String)this.getProp(0x110001);
            if (string.equalsIgnoreCase(LDAPLang.getStrTreeView()) || string.equalsIgnoreCase(DSE_DISP_NAME2)) {
                IAdminProp iAdminProp = (IAdminProp)object;
                String string2 = (String)iAdminProp.getProp(0x110001);
                int n = dseRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    if (string2.equalsIgnoreCase(dseRoots[n2])) {
                        return;
                    }
                    ++n2;
                }
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        if (Root.debugDirTree) {
            System.out.println("DirTree.addChild: child = " + object);
        }
        this.m_children.addElement(object);
        ((Entry)object).setDirTreeParent(this);
    }

    public void removeChild(Object object) {
        if (this.m_children == null) {
            return;
        }
        this.m_children.removeElement(object);
        this.sendAdminPropertyChangeEvents(273612805, this.m_children);
        Directory directory = this.m_directory;
        if (directory == null && this.m_parent != null) {
            directory = this.m_parent.getDirectory();
        }
        if (directory != null && (this.m_topLevel || this.getDn().equals(""))) {
            directory.sendAdminPropertyChangeEvents(273612805, null);
        }
    }

    public DirTree(Root root, Vector vector, Directory directory) {
        this(root, vector);
        this.m_directory = directory;
    }

    public DirTree(Root root) {
        this.m_parent = root;
        this.m_basedn = "";
        this.m_count2 = m_count++;
        this.m_topLevel = true;
        this.registerProp(1458176, LDAPLang.getStrRoot(), LDAPLang.getStrEmptyString());
        try {
            this.setProp(0x110001, (Object)LDAPLang.getStrTabName());
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        this.initPorts();
    }

    public DirTree(Root root, Vector vector) {
        super(root, null, "", root.m_serverAccess.createAttributeArray(0));
        this.m_parent = root;
        this.m_basedn = "";
        this.m_count2 = m_count++;
        this.m_topLevel = true;
        this.registerProp(1458176, LDAPLang.getStrRoot(), LDAPLang.getStrEmptyString());
        try {
            this.setProp(0x110001, (Object)LDAPLang.getStrTabName());
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        this.initPorts();
    }

    public DirTree(Root root, Directory directory, String string, String string2, Object[] objectArray) {
        super(root, directory, string, objectArray, true);
        this.init(root, string, string2, objectArray);
    }

    public DirTree(Root root, Directory directory, String string, String string2, Object[] objectArray, boolean bl) {
        super(root, directory, string, objectArray, bl);
        this.init(root, string, string2, objectArray);
    }

    void init(Root root, String string, String string2, Object[] objectArray) {
        this.m_parent = root;
        this.m_basedn = string;
        this.m_displayName = string2;
        this.m_attrs = objectArray;
        this.m_count2 = m_count++;
        try {
            this.setProp(0x110001, (Object)LDAPLang.getStrTabName());
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        this.initPorts();
    }

    public void initPorts() {
    }

    public Object getNodeProp(int n) throws PropertyException {
        switch (n) {
            case 8389738: {
                return Boolean.TRUE;
            }
            case 2098184: {
                return new Integer(2);
            }
            case 0x200400: {
                return new Integer(3);
            }
            case 7341059: {
                return this.getProp(0x110001);
            }
            case 8389686: {
                return Boolean.FALSE;
            }
            case 2098192: {
                return new Integer(1);
            }
            case 1049653: {
                if (this.m_normalColor) {
                    return "images/object.gif";
                }
                return "images/robject.gif";
            }
        }
        return super.getProp(n);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                if (!this.m_topLevel) {
                    return super.getProp(n);
                }
                return "browsing_root_of_search";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 0x110001: {
                return this.m_displayName;
            }
            case 1638408: {
                return "images/ldapdir.gif";
            }
            case 2031768: {
                return LDAPLang.getStrEntry();
            }
            case 3080204: {
                if (this.m_topLevel) {
                    return new Integer(4 | (this.m_directory != null ? 512 : 32768) | 0x100000);
                }
                return new Integer(0x1004 | this.m_status | 0x100000);
            }
            case 1458176: {
                return this.m_basedn;
            }
            case 272630352: {
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int[] nArray = new int[]{3080204, 282001422, 2687386};
                int[] nArray2 = new int[]{1458176};
                Object[] objectArray = new Object[]{new Integer(8192), nArray2, new Integer(48)};
                iAdminPropArray[0] = new AdminPropView((IAdminProp)this, nArray, objectArray);
                int[] nArray3 = new int[]{3080204};
                Object[] objectArray2 = new Object[]{new Integer(512)};
                iAdminPropArray[1] = new AdminPropView((IAdminProp)this, nArray3, objectArray2);
                return iAdminPropArray;
            }
            case 0x10400414: {
                if (this.m_topLevel || this.m_hideInPort) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_outPort};
                    return iAdminPropArray;
                }
                if (this.m_children != null && this.m_children.size() == 0) {
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_inPort};
                    return iAdminPropArray;
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_inPort, this.m_outPort};
                return iAdminPropArray;
            }
            case 272630786: {
                if (this.m_topLevel) {
                    IAdminProp[] iAdminPropArray;
                    this.initTopLevelChildren();
                    if (this.m_directory != null && (this.m_children == null || this.m_children.size() == 0)) {
                        return null;
                    }
                    if (this.m_directory != null) {
                        iAdminPropArray = (IAdminProp[])AdminProp.vectorToObjectArray(this.m_children);
                    } else {
                        IAdminProp[] iAdminPropArray2 = new IAdminProp[]{(IAdminProp)this.m_children.elementAt(0)};
                        iAdminPropArray = iAdminPropArray2;
                    }
                    int n2 = 0;
                    while (n2 < iAdminPropArray.length) {
                        ((DirTree)iAdminPropArray[n2]).m_hideInPort = true;
                        String string = ((DirTree)iAdminPropArray[n2]).m_displayName;
                        if (string == null || string.trim().length() == 0) {
                            ((DirTree)iAdminPropArray[n2]).m_displayName = DSE_DISP_NAME2;
                        }
                        ++n2;
                    }
                    return iAdminPropArray;
                }
                return null;
            }
            case 273612805: {
                this.m_refreshEntry = false;
                if (this.m_topLevel) {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])this.getProp(272630786);
                    if (iAdminPropArray == null) {
                        return null;
                    }
                    return iAdminPropArray[0].getProp(273612805);
                }
                if (this.m_children == null) {
                    String[] stringArray = new String[]{"*"};
                    int[] nArray = new int[]{7};
                    String[] stringArray2 = new String[]{"objectclass"};
                    String[] stringArray3 = new String[]{"dn"};
                    int n3 = this.m_parent.getSizelimit();
                    int n4 = this.m_parent.getTimelimit();
                    this.m_parent.setErrorMessage("");
                    try {
                        boolean bl = this.m_parent.m_serverAccess.findEntry(stringArray, nArray, this.m_basedn, false, stringArray3, (Object)this, n3, n4, stringArray2);
                    }
                    catch (Exception exception) {
                        throw new PropertyException(exception);
                    }
                    String string = this.m_parent.getErrorMessage();
                    if (!string.equals("")) {
                        PropertyException propertyException = new PropertyException(string);
                        if (this.m_children != null) {
                            Directory directory = this.m_directory;
                            if (directory == null && this.m_parent != null) {
                                directory = this.m_parent.getDirectory();
                            }
                            if (directory != null && (this.m_topLevel || this.getDn().equals(""))) {
                                directory.sendAdminPropertyChangeEvents(273612805, null);
                            }
                            this.sendAdminPropertyChangeEvents(n, null);
                            propertyException.setNotice();
                        }
                        throw propertyException;
                    }
                }
                return AdminProp.vectorToObjectArray(this.m_children);
            }
            case 273613313: {
                return this.getRefreshCommandList(super.getProp(n));
            }
            case 272695330: {
                if (this.m_attributes == null && !this.loadAttrs(false)) {
                    return null;
                }
                return this.getNodeProp(n);
            }
        }
        return this.getNodeProp(n);
    }

    public IAdminProp[] getRefreshCommandList(Object object) throws PropertyException {
        IAdminProp[] iAdminPropArray = (IAdminProp[])object;
        int n = iAdminPropArray.length;
        int n2 = 0;
        IAdminProp[] iAdminPropArray2 = new IAdminProp[n + 3];
        iAdminPropArray2[n2++] = new CommandProp((IAdminProp)this.m_parent, -8, LDAPLang.getStrCreateLabel(), LDAPLang.getStrNewEntryDesc(), "images/create.gif");
        if (!this.hasSubSchema()) {
            iAdminPropArray2[n2 - 1].setProp(8978948, new Boolean(false));
        }
        int n3 = 0;
        while (n3 < n) {
            iAdminPropArray2[n2++] = iAdminPropArray[n3];
            ++n3;
        }
        iAdminPropArray2[n2++] = new CommandProp((IAdminProp)this, -8194, LDAPLang.getStrCmdRefreshEntry(), String.valueOf(LDAPLang.getStrRefreshEntryDescp2()) + "...", "images/updateentry.gif");
        iAdminPropArray2[n2 - 1].setProp(2687509, new Integer(4));
        iAdminPropArray2[n2++] = new CommandProp((IAdminProp)this, -8195, LDAPLang.getStrCmdRefreshSubentries(), String.valueOf(LDAPLang.getStrRefreshSubentriesDescp1()) + "...", "images/updateentry.gif");
        iAdminPropArray2[n2 - 1].setProp(2687509, new Integer(4));
        return iAdminPropArray2;
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1458176: {
                if (this.m_basedn == null || this.m_basedn.equals(object)) break;
                this.m_basedn = (String)object;
                this.m_children = null;
                this.setDn(this.m_basedn);
                this.refresh();
            }
        }
        super.setProp(n, object);
    }

    public void update() {
        if (this.m_refreshEntry) {
            super.update();
            return;
        }
        this.sendAdminPropertyChangeEvents(272630786, null);
        this.sendAdminPropertyChangeEvents(273612805, null);
    }

    public void refresh(IAdminProp iAdminProp) throws PropertyException {
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
        if (this.m_refreshEntry) {
            this.emptySetAttrName();
            this.emptyUnsetAttrName();
            this.emptyCircleV();
            this.m_objectClasses = null;
            try {
                this.m_parent.m_serverAccess.findObjectSync(this.m_dn, null, this);
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        } else {
            this.refresh();
        }
        iAdminProp.setProp(0x1F000F, "finish");
        ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
    }

    public void refresh() throws PropertyException {
        this.initPorts();
        if (this.m_children != null && this.m_children.size() > 0) {
            int n = 0;
            while (n < this.m_children.size()) {
                ((DirTree)this.m_children.elementAt(n)).cleanup();
                ++n;
            }
            this.m_children.removeAllElements();
        }
        this.m_children = null;
        this.update();
        Runtime.getRuntime().gc();
    }

    public synchronized void initTopLevelChildren() throws PropertyException {
        if (this.m_directory != null) {
            PseudoTree pseudoTree = new PseudoTree();
            this.m_children = pseudoTree.createDirTree(this.m_parent, this.m_directory);
            return;
        }
        if (this.m_children == null) {
            this.m_parent.setErrorMessage("");
            try {
                this.m_parent.m_serverAccess.findObjectSync(this.m_basedn, null, this);
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
            String string = this.m_parent.getErrorMessage();
            if (!string.equals("")) {
                if (string.equals(LDAPLang.getStrNotConnectToServer())) {
                    string = new String(LDAPLang.getStrBindingFailed());
                }
                this.m_children = new Vector();
                string = new String(LDAPLang.getStrBindingFailed());
                throw new PropertyException(string);
            }
        }
        if (this.m_children == null || this.m_children.size() < 1) {
            throw new PropertyException("Root of tree is an invalid Distinguished Name");
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            switch (n) {
                case -8194: {
                    this.m_refreshEntry = true;
                    this.m_repaint = true;
                    this.refresh(iAdminProp);
                    break;
                }
                case -8195: {
                    this.m_refreshEntry = false;
                    this.refresh(iAdminProp);
                    break;
                }
                case -10: {
                    boolean bl = this.m_attributes == null && this.loadAttrs(true);
                }
                default: {
                    return super.doCommand(iAdminProp);
                }
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    Vector getDNVector(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim().toLowerCase();
        Vector<String> vector = new Vector<String>();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf(",", n3)) > 0) {
            vector.insertElementAt(string.substring(n3, n2).trim(), 0);
            n3 = n2 + 1;
        }
        if (n2 < 0 && n3 < n) {
            vector.insertElementAt(string.substring(n3).trim(), 0);
        }
        return vector;
    }

    public Object nthChild(int n) {
        if (this.m_children == null) {
            return null;
        }
        if (n > this.m_children.size()) {
            return null;
        }
        return this.m_children.elementAt(n);
    }

    public void addNewChild(NewEntry newEntry) {
        try {
            this.addOrRemoveChild(newEntry, null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void removeOldChild(Entry entry) {
        try {
            this.addOrRemoveChild(null, entry);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addOrRemoveChild(NewEntry newEntry, Entry entry) {
        block25: {
            String string;
            int n = this.countChildren();
            if (Root.debugDirTree) {
                System.out.println(String.valueOf(newEntry == null ? "removeOldChild" : "addNewChild") + " children size=" + n);
            }
            if (n == 0) {
                if (Root.debugDirTree) {
                    System.out.println("no children loaded yet");
                }
                return;
            }
            Vector vector = this.getDNVector(newEntry != null ? newEntry.getDn() : entry.getDn());
            Vector vector2 = this.getDNVector(this.getDn());
            if (vector == null || vector2 == null) {
                return;
            }
            int n2 = vector.size();
            int n3 = vector2.size();
            if (Root.debugDirTree) {
                System.out.println("old dn " + vector2);
            }
            if (Root.debugDirTree) {
                System.out.println("new dn " + vector);
            }
            if (n3 >= n2) {
                if (Root.debugDirTree) {
                    System.out.println("old dn is longer than new dn");
                }
                return;
            }
            int n4 = 0;
            while (n4 < n3) {
                string = (String)vector.elementAt(n4);
                String string2 = (String)vector2.elementAt(n4);
                if (string2 == null || string == null) {
                    return;
                }
                if (!string.equals(string2)) break;
                ++n4;
            }
            if (n4 == n3) {
                if (Root.debugDirTree) {
                    System.out.println("old dn matches ansestor of new dn");
                }
                if (n3 + 1 == n2 && newEntry != null && !this.m_topLevel) {
                    if (Root.debugDirTree) {
                        System.out.println("old dn matches parent of new dn");
                    }
                    try {
                        this.m_parent.m_serverAccess.findObjectSync(newEntry.getDn(), null, this);
                        if (n != this.countChildren()) {
                            this.update();
                            return;
                        }
                        break block25;
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                        return;
                    }
                }
                string = (String)vector.elementAt(n4);
                if (string == null) {
                    return;
                }
                int n5 = 0;
                while (n5 < n) {
                    DirTree dirTree = (DirTree)this.nthChild(n5);
                    String string3 = dirTree.getDisplayName();
                    if (Root.debugDirTree) {
                        System.out.println("old dn has child " + n5 + " named = '" + string3 + "' dn=" + dirTree.getDn());
                    }
                    if (string3 != null && (string.equalsIgnoreCase(string3) || dirTree.getDn().equals(""))) {
                        if (Root.debugDirTree) {
                            System.out.println("old dn is younger ansestor of new dn at " + string3);
                        }
                        if (Root.debugDirTree) {
                            System.out.println();
                        }
                        if (entry != null) {
                            if (n3 + 1 == n2 && !this.m_topLevel) {
                                this.removeChild(dirTree);
                                return;
                            }
                            dirTree.removeOldChild(entry);
                            return;
                        }
                        dirTree.addNewChild(newEntry);
                        return;
                    }
                    ++n5;
                }
            }
        }
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public boolean isEntryRefreshed() {
        return this.m_refreshEntry;
    }

    public void cleanup() {
        try {
            this.m_attrs = null;
            this.m_children = null;
            this.m_parent = null;
            if (this.m_inPort != null) {
                this.m_inPort.setProp(4195352, null);
            }
            this.m_inPort = null;
            if (this.m_outPort != null) {
                this.m_outPort.setProp(4195352, null);
                ((DirTreeOutPort)this.m_outPort).cleanup();
            }
            this.m_outPort = null;
            this.m_directory = null;
            super.cleanup();
            return;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return;
        }
    }

    static {
        dseRoots = new String[]{"cn=subconfigsubentry", "cn=orclreplagreements", "cn=subregistrysubentry", "cn=changeLog", "cn=changestatus", "cn=eventlog", "cn=baseschema"};
    }

    class PseudoTree {
        PseudoTree m_child;
        PseudoTree m_sibling;
        String m_rdn;
        DirTree m_entry;
        String m_baseDn;

        public PseudoTree() {
            DirTree.this = DirTree.this;
        }

        public String getBaseDn() {
            return this.m_baseDn;
        }

        public void setBaseDn(Vector vector, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n;
            while (n2 >= 0) {
                stringBuffer.append(vector.elementAt(n2));
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                --n2;
            }
            this.m_baseDn = stringBuffer.toString();
        }

        public void add(Vector vector, String string, int n, DirTree dirTree) {
            if (this.m_rdn == null) {
                this.m_rdn = string;
                this.setBaseDn(vector, n);
                if (++n < vector.size()) {
                    this.m_child = new PseudoTree();
                    string = (String)vector.elementAt(n);
                    this.m_child.add(vector, string, n, dirTree);
                    return;
                }
                this.m_entry = dirTree;
                return;
            }
            if (this.m_rdn.equalsIgnoreCase(string)) {
                if (++n < vector.size()) {
                    if (this.m_child == null) {
                        this.m_child = new PseudoTree();
                    }
                    string = (String)vector.elementAt(n);
                    this.m_child.add(vector, string, n, dirTree);
                    return;
                }
                this.m_entry = dirTree;
                return;
            }
            if (this.m_sibling == null) {
                this.m_sibling = new PseudoTree();
            }
            this.m_sibling.add(vector, string, n, dirTree);
        }

        Vector getDirTreeChildren(Root root) {
            Vector<DirTree> vector = new Vector<DirTree>();
            PseudoTree pseudoTree = this;
            while (pseudoTree != null) {
                DirTree dirTree = pseudoTree.m_entry;
                Vector vector2 = pseudoTree.m_child != null ? pseudoTree.m_child.getDirTreeChildren(root) : new Vector();
                if (dirTree == null) {
                    dirTree = new DirTree(root, null, pseudoTree.getBaseDn(), pseudoTree.m_rdn, root.m_serverAccess.createAttributeArray(0));
                    dirTree.m_normalColor = false;
                }
                dirTree.m_children = vector2;
                vector.addElement(dirTree);
                pseudoTree = pseudoTree.m_sibling;
            }
            return vector;
        }

        public Vector createDirTree(Root root, Directory directory) {
            Vector vector = directory.getChildren();
            if (vector == null) {
                return null;
            }
            int n = vector.size();
            Vector<String> vector2 = new Vector<String>();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                DirTree dirTree = (DirTree)vector.elementAt(n2);
                String string = String.valueOf(dirTree.getDn()) + ",";
                int n4 = 0;
                while ((n3 = string.indexOf(",", n4)) > 0) {
                    String string2 = string.substring(n4, n3).trim();
                    vector2.insertElementAt(string2, 0);
                    n4 = n3 + 1;
                    if (n4 >= string.length()) break;
                }
                this.add(vector2, (String)vector2.elementAt(0), 0, dirTree);
                vector2.removeAllElements();
                ++n2;
            }
            return this.getDirTreeChildren(root);
        }

        public void print() {
            System.out.print("(");
            System.out.print(this.m_rdn);
            System.out.print("[");
            if (this.m_child != null) {
                this.m_child.print();
            }
            System.out.print("]");
            System.out.print(")");
            if (this.m_sibling != null) {
                System.out.print(", ");
                this.m_sibling.print();
            }
        }
    }
}

