/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class ManageTableColumns
extends AdminProp {
    static final int PR_FROM_LIST = 0x10103000;
    static final int PR_TO_LIST = 0x10103001;
    Vector m_existingAttrs;
    Vector m_availableAttrs;
    Directory m_directory;

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x10103000, LDAPLang.getStrFromListPlbl(), LDAPLang.getStrFromListPdsc());
        this.registerProp(0x10103001, LDAPLang.getStrToListPlbl(), LDAPLang.getStrToListPdsc());
    }

    public ManageTableColumns(Directory directory) {
        this.m_directory = directory;
        this.m_existingAttrs = (Vector)this.m_directory.getDeletableAttrs().clone();
        this.m_availableAttrs = this.m_directory.getAddableAttrs();
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "managing_search_results";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle10();
            }
            case 3080204: {
                return new Integer(2048);
            }
            case 0x110001: {
                return this.m_directory.getProp(0x110001);
            }
            case 2098433: {
                return new Integer(1);
            }
            case 281085184: {
                int[] nArray = new int[]{0x10103000, 0x10103001};
                return nArray;
            }
            case 0x10103001: {
                return AdminProp.vectorToObjectArray(this.m_existingAttrs);
            }
            case 0x10103000: {
                return AdminProp.vectorToObjectArray(this.m_availableAttrs);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x10103001: {
                String[] stringArray = (String[])object;
                if (stringArray == null) {
                    stringArray = new String[]{};
                }
                int n2 = this.m_existingAttrs.size();
                int n3 = 0;
                while (n3 < n2) {
                    String string = (String)this.m_existingAttrs.elementAt(n3);
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (stringArray[n4].equalsIgnoreCase(string)) break;
                        ++n4;
                    }
                    if (n4 == stringArray.length) {
                        this.m_directory.removeAttr(string, false);
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < stringArray.length) {
                    if (!this.m_existingAttrs.contains(stringArray[n3])) {
                        this.m_directory.addAttr(stringArray[n3]);
                    }
                    ++n3;
                }
                this.m_directory.sendAdminPropertyChangeEvents(282001424, null);
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
    }
}

