/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.ObjectClass;
import oracle.ldap.admin.ObjectClasses;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class NewObjectClass
extends ObjectClass {
    ObjectClasses m_container;
    boolean m_newObject = true;
    String m_title;

    public NewObjectClass(ObjectClasses objectClasses, SubSchema subSchema) {
        this.m_container = objectClasses;
        this.m_subSchema = subSchema;
    }

    public void initProps() throws PropertyException {
        this.setProp(8466446, (Object)Boolean.TRUE);
    }

    public Object getProp(int n) throws PropertyException {
        if (!this.m_newObject) {
            return super.getProp(n);
        }
        switch (n) {
            case 3081366: {
                return new Integer(12);
            }
            case 1048745: {
                return "adding_new_object_classes";
            }
            case 1638408: {
                return "images/ldapobjcls.gif";
            }
            case 2031768: {
                if (this.m_title == null) {
                    this.m_title = LDAPLang.getStrEditorTitle19();
                }
                return this.m_title;
            }
            case 273613313: {
                return null;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 2031768: {
                this.m_title = (String)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (!this.m_newObject) {
            super.saveChanges(n);
            return;
        }
        if (!Root.isClientCommandLine()) {
            this.setListProp(this.m_supObjs, 269496329);
            this.setListProp(this.m_mayObjs, 269496331);
            this.setListProp(this.m_mustObjs, 269496330);
        }
        if (!this.validate()) {
            return;
        }
        try {
            this.m_subSchema.saveNewObjectClass(this);
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
        Root root = this.m_subSchema.getParent();
        String string = root.getErrorMessage();
        if (!string.trim().equals("")) {
            throw new SaveChangeException(string);
        }
        this.m_newObject = false;
        this.setOriginalString(this.toString());
        this.setExisting(true);
        this.m_supObjs = null;
        this.m_mayObjs = null;
        this.m_mustObjs = null;
    }
}

