/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.INewEntry;
import oracle.ldap.admin.Proc;
import oracle.ldap.admin.ProcBase;
import oracle.ldap.admin.ProcBases;
import oracle.ldap.admin.ProcConfSet;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class NewProcConfSet
extends ProcConfSet
implements INewEntry {
    boolean isNewObject = true;
    int m_objectClassPropId;
    int m_cnPropId;
    AdminList m_pcss;
    static final int CUTOFF = 8;
    private Object[] m_modAttrs;
    String m_cn;

    public NewProcConfSet(Root root, Proc proc, AdminList adminList, Object[] objectArray, String string, boolean bl, String string2) {
        super(root, string, string2, objectArray);
        this.m_pcss = adminList;
        this.m_holder = adminList;
        Vector vector = root.getSubSchemas();
        if (vector != null && vector.size() != 0) {
            this.setSubSchema((SubSchema)vector.elementAt(0));
        }
        this.m_objectClassPropId = this.m_parent.getAttrPropId("objectClass");
        this.m_cnPropId = this.m_parent.getAttrPropId("cn");
        if (!bl) {
            try {
                int[] nArray = (int[])this.getProp(282001422);
                int n = 0;
                while (n < nArray.length) {
                    if (nArray[n] != this.m_objectClassPropId && nArray[n] != 2510848 && AdminProp.getPropType(nArray[n]) != 0x400000) {
                        this.setProp(nArray[n], null);
                    }
                    ++n;
                }
                return;
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
                return;
            }
        }
    }

    public Object getProp(int n) throws PropertyException {
        if (!this.isNewObject) {
            return super.getProp(n);
        }
        switch (n) {
            case 3080204: {
                Integer n2 = (Integer)super.getProp(n);
                return new Integer(n2 | 2);
            }
            case 273613313: {
                return null;
            }
            case 3081366: {
                return new Integer(12);
            }
        }
        return super.getProp(n);
    }

    public Object[] getMods() {
        if (!this.isNewObject) {
            return super.getMods();
        }
        int n = this.m_modAttrs.length - 8;
        Object[] objectArray = this.m_parent.m_serverAccess.createModificationArray(n);
        if (Root.debugSaveEntry) {
            this.debugMessageLn("\nNewProcConfSet.getMod(): mod remaining " + n);
        }
        int n2 = 8;
        while (n2 < this.m_modAttrs.length) {
            objectArray[n2 - 8] = this.m_parent.m_serverAccess.createModification(1, this.m_modAttrs[n2]);
            ++n2;
        }
        return objectArray;
    }

    public Object[] getAttributes() {
        Object[] objectArray = this.getAttributes2();
        if (objectArray == null || objectArray.length <= 8) {
            return objectArray;
        }
        if (Root.debugSaveEntry) {
            this.debugMessageLn("\nNewProcConfSet.getAttributes(): init create " + 8 + " of " + objectArray.length + " attributes.");
        }
        Object[] objectArray2 = this.m_parent.m_serverAccess.createAttributeArray(8);
        System.arraycopy(objectArray, 0, objectArray2, 0, 8);
        this.m_modAttrs = objectArray;
        return objectArray2;
    }

    public Object[] getAttributes2() {
        if (!this.isNewObject) {
            return super.getAttributes();
        }
        if (Root.debugSaveEntry) {
            this.setDebug(true);
            this.debugMessageLn("\nNewProcConfSet.getAttributes(): Entered");
        }
        int n = 0;
        int n2 = 0;
        Object[] objectArray = null;
        int[] nArray = null;
        try {
            int[] nArray2 = (int[])this.getProp(282001422);
            int n3 = 0;
            while (n3 < nArray2.length) {
                if (this.m_parent.validAttributePropId(new Integer(nArray2[n3]))) {
                    ++n;
                }
                ++n3;
            }
            nArray = new int[n + 2];
            n = 2;
            nArray[0] = this.m_objectClassPropId;
            nArray[1] = this.m_cnPropId;
            n3 = 0;
            while (n3 < nArray2.length) {
                if (this.m_parent.validAttributePropId(new Integer(nArray2[n3]))) {
                    nArray[n++] = nArray2[n3];
                }
                ++n3;
            }
            objectArray = this.getProps(nArray);
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
        if (objectArray == null) {
            return null;
        }
        objectArray[0] = this.getSampleObjectClasses();
        objectArray[1] = this.getCn();
        n = 0;
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (objectArray[n4] != null) {
                ++n;
            }
            ++n4;
        }
        if (n == 0) {
            return null;
        }
        Object[] objectArray2 = this.m_parent.m_serverAccess.createAttributeArray(n);
        if (this.isDebug()) {
            this.debugMessageLn("allocating attributes =" + n);
        }
        int n5 = 0;
        while (n5 < objectArray.length) {
            if (objectArray[n5] != null) {
                boolean bl;
                int n6 = nArray[n5];
                String string = this.m_objectClassPropId == n6 ? "objectClass" : (this.m_cnPropId == n6 ? "cn" : super.getPropNameNormal(n6));
                if (string == null) {
                    System.out.println("didn't get attr for propid=" + n6);
                    this.debugMessageLn("NewEntry.getAttributes(): Returned\n");
                    return null;
                }
                if (this.isDebug()) {
                    this.debugMessageLn("attr='" + string + "' m=" + n2);
                }
                if (!(bl = false)) {
                    String[] stringArray;
                    if (AdminProp.isPropArray(n6)) {
                        stringArray = (String[])objectArray[n5];
                        if (this.isDebug()) {
                            int n7 = 0;
                            while (n7 < stringArray.length) {
                                this.debugMessageLn("val[" + n7 + "]='" + stringArray[n7] + "'");
                                ++n7;
                            }
                        }
                        objectArray2[n2++] = this.m_parent.m_serverAccess.createAttribute(string, stringArray);
                    } else {
                        stringArray = objectArray[n5].toString();
                        if (this.isDebug()) {
                            this.debugMessageLn(" val='" + (String)stringArray + "'");
                        }
                        objectArray2[n2++] = this.m_parent.m_serverAccess.createAttribute(string, (String)stringArray);
                    }
                }
            }
            ++n5;
        }
        if (Root.debugSaveEntry) {
            this.debugMessageLn("NewProcConfSet.getAttributes(): Returned\n");
            this.setDebug(false);
        }
        return objectArray2;
    }

    public String[] getSampleObjectClasses() {
        String[] stringArray = new String[]{"top"};
        if (this.m_pcss == null || this.m_pcss.m_children == null || this.m_pcss.m_children.size() == 0) {
            return stringArray;
        }
        if (((ProcConfSet)this.m_pcss.m_children.elementAt(0)).getSampleObjectClasses() != null) {
            return ((ProcConfSet)this.m_pcss.m_children.elementAt(0)).getSampleObjectClasses();
        }
        return stringArray;
    }

    public String[] getCn() {
        if (this.m_cn == null) {
            String[] stringArray = new String[]{"configset" + this.getBaseNum()};
            return stringArray;
        }
        if (this.m_cn.startsWith("cn=")) {
            this.m_cn = this.m_cn.substring(3);
        }
        String[] stringArray = new String[]{this.m_cn};
        return stringArray;
    }

    public void validate() throws SaveChangeException {
        Object object;
        int n = this.m_pcss.countChildren();
        int n2 = 0;
        while (n2 < n) {
            object = (ProcConfSet)this.m_pcss.m_children.elementAt(n2);
            if (object != this && ((ProcBase)object).getBaseNum() == this.getBaseNum()) {
                throw new SaveChangeException("Duplication configuration set number are not allowed: " + this.getBaseNum());
            }
            ++n2;
        }
        object = this.getDn().trim();
        n = ((String)object).length();
        if (Root.debugSaveEntry) {
            System.out.println("dn starting = " + (String)object);
        }
        int n3 = 0;
        block1: while (n3 < n) {
            char c = ((String)object).charAt(n3);
            if (Character.isDigit(c)) {
                int n4 = n3 + 1;
                while (n4 < n) {
                    c = ((String)object).charAt(n4);
                    if (!Character.isDigit(c)) {
                        this.m_cn = String.valueOf(((String)object).substring(0, n3)) + this.getBaseNum();
                        this.setDn(String.valueOf(this.m_cn) + ((String)object).substring(n4));
                        if (!Root.debugSaveEntry) break block1;
                        System.out.println("dn ending = " + this.getDn());
                        return;
                    }
                    ++n4;
                }
                return;
            }
            if (Character.isSpaceChar(c) || c == ',') {
                this.m_cn = String.valueOf(((String)object).substring(0, n3)) + this.getBaseNum();
                this.setDn(String.valueOf(this.m_cn) + ((String)object).substring(n3));
                if (!Root.debugSaveEntry) break;
                System.out.println("dn ending = " + this.getDn());
                return;
            }
            ++n3;
        }
    }

    public void saveChanges(int n) throws SaveChangeException {
        this.validate();
        if (this.isNewObject) {
            if (!this.m_parent.addEntry(this)) {
                throw new SaveChangeException(this.m_parent.getErrorMessage());
            }
            try {
                if (this.m_modAttrs != null && !this.m_parent.saveEntry(this)) {
                    this.m_parent.deleteEntry(this);
                    throw new SaveChangeException(this.m_parent.getErrorMessage());
                }
                int n2 = this.m_pcss.countChildren();
                this.m_parent.findObject(this.getDn(), null, ((ProcBases)this.m_pcss).getQueryBase());
                int n3 = 0;
                while (++n3 < 20 && n2 == this.m_pcss.countChildren()) {
                    Thread.sleep(600L);
                }
            }
            catch (Exception exception) {
                throw new SaveChangeException(exception);
            }
            this.m_pcss.update();
            this.isNewObject = false;
            this.m_mods = new Vector();
            return;
        }
        super.saveChanges(n);
        this.m_pcss.update();
    }
}

