/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.Connectors;
import oracle.ldap.admin.INewEntry;
import oracle.ldap.admin.ProcConnector;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class NewProcConnector
extends ProcConnector
implements INewEntry {
    static final int PR_NEW_CONN_NAME = 0x103100;
    static final String STR_BINDDN = "orclmetaconnbinddn";
    static final String STR_CONN_NAME = "orclmetaconnname";
    boolean isNewObject = true;
    boolean m_createLike = true;
    Connectors m_holder;
    String m_metaconnbindpasswd;

    public NewProcConnector(Root root, String string, String string2, Object[] objectArray, boolean bl, Connectors connectors) {
        super(root, string, string2, objectArray);
        this.m_createLike = bl;
        this.m_holder = connectors;
        this.unregisterProp(1454336);
        Integer n = this.m_parent.getAttrPropId(STR_BINDDN);
        int n2 = n;
        this.unregisterProp(n2);
        this.registerProp(0x103100, STR_CONN_NAME, "");
    }

    void init() {
        this.m_isBrandNew = !this.m_createLike;
        super.init();
    }

    public Object getProp(int n) throws PropertyException {
        if (!this.isNewObject) {
            return super.getProp(n);
        }
        switch (n) {
            case 0x103100: {
                return this.m_connRDN;
            }
            case 3080204: {
                Integer n2 = (Integer)super.getProp(n);
                return new Integer(n2 | 2);
            }
            case 273613313: {
                return null;
            }
            case 3081366: {
                return new Integer(12);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (!this.isNewObject) {
            super.getProp(n);
        }
        switch (n) {
            case 0x103100: {
                this.m_connRDN = (String)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    boolean skip(String string, Object object) {
        String string2;
        if (string.equalsIgnoreCase("userpassword")) {
            return true;
        }
        if (object == null) {
            return true;
        }
        if (object instanceof String && (string2 = ((String)object).trim()).length() == 0) {
            return true;
        }
        if (string.equalsIgnoreCase("orclmetaconnbindpasswd")) {
            this.m_metaconnbindpasswd = new String((String)object);
        }
        if (string.equalsIgnoreCase(STR_CONN_NAME)) {
            this.m_connRDN = new String((String)object);
        }
        return false;
    }

    public Object[] getAttributes() {
        try {
            String[] stringArray;
            Object[] objectArray;
            int[] nArray = (int[])this.getProp(282001422);
            int n = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                Object object;
                objectArray = super.getPropNameNormal(nArray[n2]);
                if (!this.skip((String)objectArray, object = this.getProp(nArray[n2]))) {
                    ++n;
                }
                ++n2;
            }
            ++n;
            ++n;
            objectArray = this.m_parent.m_serverAccess.createAttributeArray(++n);
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray.length) {
                Object object;
                stringArray = super.getPropNameNormal(nArray[n4]);
                if (!this.skip((String)stringArray, object = this.getProp(nArray[n4]))) {
                    objectArray[n3++] = AdminProp.isPropArray(nArray[n4]) ? this.m_parent.m_serverAccess.createAttribute((String)stringArray, (String[])object) : (stringArray.equalsIgnoreCase("orclmetaconnlastckpttime") ? this.m_parent.m_serverAccess.createAttribute((String)stringArray, AdminProp.convertCalendar2String((Calendar)object)) : this.m_parent.m_serverAccess.createAttribute((String)stringArray, (String)object));
                }
                ++n4;
            }
            objectArray[n3++] = this.m_parent.m_serverAccess.createAttribute(STR_BINDDN, this.getDn());
            objectArray[n3++] = this.m_parent.m_serverAccess.createAttribute("userpassword", this.m_metaconnbindpasswd);
            stringArray = new String[]{"top", "orclmetaconn", "orclchangesubscriber"};
            objectArray[n3++] = this.m_parent.m_serverAccess.createAttribute("objectclass", stringArray);
            return objectArray;
        }
        catch (PropertyException propertyException) {
            return null;
        }
    }

    public String getDn() {
        return new String("orclmetaconnname=" + this.m_connRDN + "," + "cn=subscriber profile,cn=changelog subscriber, cn=oracle internet directory");
    }

    void fixup() throws PropertyException {
        this.registerProp(1454336, STR_CONN_NAME, "");
        this.setProp(1454336, (Object)("orclmetaconnname=" + this.m_connRDN));
        Integer n = this.m_parent.getAttrPropId(STR_BINDDN);
        int n2 = n;
        this.registerProp(n2, STR_BINDDN, "");
        this.setProp(n2, (Object)this.getDn());
        this.m_displayName = this.m_connRDN;
        this.unregisterProp(0x103100);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.isNewObject) {
            try {
                this.updateSyncNameContext();
            }
            catch (PropertyException propertyException) {
                throw new SaveChangeException(propertyException);
            }
            if (!this.m_parent.addEntry(this)) {
                throw new SaveChangeException(this.m_parent.getErrorMessage());
            }
            try {
                this.fixup();
            }
            catch (PropertyException propertyException) {
                throw new SaveChangeException(propertyException);
            }
            this.m_holder.addChild(this);
            this.m_holder.update();
            if (this.m_mods.size() != 0) {
                this.m_mods = new Vector();
                this.m_addMods = new Hashtable();
            }
            this.isNewObject = false;
            return;
        }
        super.saveChanges(n);
    }
}

