/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.AttributeSample;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.NewObjectClass;
import oracle.ldap.admin.ObjectClassSample;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;
import oracle.ldap.admin.common.TableSelector;

public class ObjectClass
extends SchemaObject
implements ICommandParent {
    static final int CMD_CREATE_MAY = 1;
    static final int CMD_DELETE_MAY = 2;
    static final int CMD_EDIT_MAY = 3;
    static final int CMD_CREATE_SUP = 6;
    static final int CMD_DELETE_SUP = 7;
    static final int CMD_EDIT_SUP = 8;
    static final int CMD_CREATE_MUST = 10;
    static final int CMD_DELETE_MUST = 11;
    static final int CMD_EDIT_MUST = 12;
    static final int CMD_MAKE_OPTIONAL = 13;
    static final int[] m_readOnlyProps = new int[]{0x103000, 0x103013, 1060866, 1060887};
    static final int[] m_readOnlyProps2 = new int[]{0x103000, 0x103013};
    public static ObjectClass m_sampleOC;
    static Attribute m_sampleAttr;
    AdminList m_supObjs;
    AdminList m_mayObjs;
    AdminList m_mustObjs;
    TableSelector m_maySelector;
    TableSelector m_mustSelector;
    TableSelector m_supSelector;

    public static ObjectClass getSampleOC() {
        if (m_sampleOC == null) {
            m_sampleOC = new ObjectClassSample();
        }
        return m_sampleOC;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x103000, LDAPLang.getStrDisplayNamePlbl(), LDAPLang.getStrNamePdsc2());
        this.registerProp(0x103013, LDAPLang.getStrOidPlbl(), LDAPLang.getStrOidPdsc());
        this.registerProp(1060866, LDAPLang.getStrDescPlbl(), LDAPLang.getStrDescPdsc());
        this.registerProp(8466448, LDAPLang.getStrObsoletePlbl(), LDAPLang.getStrObsoletePdsc());
        if (Root.isClientCommandLine()) {
            this.registerProp(269496329, LDAPLang.getStrSupPlbl1(), LDAPLang.getStrSupPdsc2());
        } else {
            this.setPropHidden(269496329, true, false);
            this.registerProp(4206619, LDAPLang.getStrSupPlbl1(), LDAPLang.getStrSupPdsc2());
            this.setPropertyLabelHidden(4206619, true, false);
        }
        this.registerProp(8466445, LDAPLang.getStrAbstractPlbl(), LDAPLang.getStrAbstractPdsc());
        this.registerProp(8466446, LDAPLang.getStrStructuralPlbl(), LDAPLang.getStrStructuralPdsc());
        this.registerProp(8466447, LDAPLang.getStrAuxiliaryPlbl(), LDAPLang.getStrAuxiliaryPdsc());
        if (Root.isClientCommandLine()) {
            this.registerProp(269496330, LDAPLang.getStrMustPlbl(), LDAPLang.getStrMustPdsc1());
        } else {
            this.setPropHidden(269496330, true, false);
            this.registerProp(4206620, LDAPLang.getStrMustPlbl(), LDAPLang.getStrMustPdsc1());
            this.setPropertyLabelHidden(4206620, true, false);
        }
        if (Root.isClientCommandLine()) {
            this.registerProp(269496331, LDAPLang.getStrMayPlbl(), LDAPLang.getStrMayPdsc1());
        } else {
            this.setPropHidden(269496331, true, false);
            this.registerProp(4206621, LDAPLang.getStrMayPlbl(), LDAPLang.getStrMayPdsc1());
            this.setPropertyLabelHidden(4206621, true, false);
        }
        this.registerProp(1060887, LDAPLang.getStrTypePlbl2(), LDAPLang.getStrTypePdsc());
    }

    public ObjectClass(String string, int[] nArray, SubSchema subSchema) {
        super(string, nArray, subSchema);
        this.m_originalString = string;
        this.m_subSchema = subSchema;
    }

    public ObjectClass() {
    }

    public String getOriginalString() {
        return this.m_originalString;
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (!Root.isClientCommandLine()) {
            this.setListProp(this.m_supObjs, 269496329);
            this.setListProp(this.m_mayObjs, 269496331);
            this.setListProp(this.m_mustObjs, 269496330);
        }
        if (!this.validate()) {
            return;
        }
        try {
            this.m_subSchema.saveObjectClass(this);
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
        this.m_originalString = this.toString();
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 272642073: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])object;
                if (iAdminPropArray == null) {
                    return;
                }
                int n2 = this.m_mayObjs.countChildren();
                int n3 = 0;
                while (n3 < iAdminPropArray.length) {
                    this.m_mayObjs.addChildUnique(iAdminPropArray[n3]);
                    ++n3;
                }
                if (n2 != this.m_mayObjs.countChildren()) {
                    this.m_mayObjs.update();
                    this.setModified(true);
                }
                return;
            }
            case 272642074: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])object;
                if (iAdminPropArray == null) {
                    return;
                }
                int n4 = this.m_mustObjs.countChildren();
                int n5 = 0;
                while (n5 < iAdminPropArray.length) {
                    this.m_mustObjs.addChildUnique(iAdminPropArray[n5]);
                    ++n5;
                }
                if (n4 != this.m_mustObjs.countChildren()) {
                    this.m_mustObjs.update();
                    this.setModified(true);
                }
                return;
            }
            case 272642072: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])object;
                if (iAdminPropArray == null) {
                    return;
                }
                int n6 = this.m_supObjs.countChildren();
                int n7 = 0;
                while (n7 < iAdminPropArray.length) {
                    this.m_supObjs.addChildUnique(iAdminPropArray[n7]);
                    ++n7;
                }
                if (n6 != this.m_supObjs.countChildren()) {
                    this.m_supObjs.update();
                    this.setModified(true);
                }
                return;
            }
            case 2163220: {
                if (!this.isExisting()) {
                    return;
                }
            }
            case 2163740: {
                Object[] objectArray;
                int n8;
                String[] stringArray;
                if (this.m_supObjs != null) {
                    this.m_supObjs.removeAllChildren();
                    stringArray = (String[])this.getProp(269496329);
                    if (stringArray != null) {
                        n8 = 0;
                        while (n8 < stringArray.length) {
                            objectArray = this.m_subSchema.findObjectClasses(1519616, stringArray[n8]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_supObjs.addChild(objectArray[0]);
                            }
                            ++n8;
                        }
                    }
                    if (n == 2163740) {
                        this.m_supObjs.update();
                    }
                }
                if (this.m_mayObjs != null) {
                    this.m_mayObjs.removeAllChildren();
                    stringArray = (String[])this.getProp(269496331);
                    if (stringArray != null) {
                        n8 = 0;
                        while (n8 < stringArray.length) {
                            objectArray = this.m_subSchema.findAttributeTypes(1519616, stringArray[n8]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_mayObjs.addChild(objectArray[0]);
                            }
                            ++n8;
                        }
                    }
                    if (n == 2163740) {
                        this.m_mayObjs.update();
                    }
                }
                if (this.m_mustObjs != null) {
                    this.m_mustObjs.removeAllChildren();
                    stringArray = (String[])this.getProp(269496330);
                    if (stringArray != null) {
                        n8 = 0;
                        while (n8 < stringArray.length) {
                            objectArray = this.m_subSchema.findAttributeTypes(1519616, stringArray[n8]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_mustObjs.addChild(objectArray[0]);
                            }
                            ++n8;
                        }
                    }
                    if (n == 2163740) {
                        this.m_mustObjs.update();
                    }
                }
                this.setModified(false);
                return;
            }
        }
        super.setProp(n, object);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 281609325: {
                if (this.isReadonly()) {
                    return m_readOnlyProps;
                }
                if (!this.isExisting()) break;
                return m_readOnlyProps2;
            }
            case 1048745: {
                return "viewing_and_changing_object_classes";
            }
            case 1638408: {
                if (this.isReadonly()) {
                    return "images/ldapobjclsro.gif";
                }
                return "images/ldapobjcls.gif";
            }
            case 2031768: {
                return LDAPLang.getStrObjectClassPlbl();
            }
            case 3080204: {
                if (!this.m_bValid) {
                    return new Integer(1);
                }
                return new Integer(4 | (this.isModified() ? 2 : 0) | 0x2000 | (this.m_subSchema.findObjectClass(269496329, this.getName()) != null ? 0x100000 : 0) | 0x200000);
            }
            case 4206619: {
                if (this.m_supObjs == null) {
                    this.m_supObjs = new AdminList((IAdminProp)this, new Vector());
                    if (m_sampleOC == null) {
                        m_sampleOC = new ObjectClassSample();
                    }
                    this.m_supObjs.setSampleChild(m_sampleOC);
                    this.m_supObjs.setDisplayNameProp(0x103000);
                    String[] stringArray = (String[])this.getProp(269496329);
                    if (stringArray != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            Object[] objectArray = this.m_subSchema.findObjectClasses(1519616, stringArray[n2]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_supObjs.addChild(objectArray[0]);
                            } else {
                                IAdminProp iAdminProp = this.m_subSchema.createObjectClass();
                                iAdminProp.setProp(0x103000, stringArray[n2]);
                                iAdminProp.setProp(1638914, LDAPLang.getStrUnknownObjclass());
                                this.m_supObjs.addChild(iAdminProp);
                            }
                            ++n2;
                        }
                    }
                    this.m_supObjs.setProp(2032706, (Object)this.getPropName(n));
                    this.m_supObjs.setProp(2162725, 114688);
                    IAdminProp[] iAdminPropArray = new CommandProp[3];
                    int n3 = 0;
                    iAdminPropArray[n3++] = new CommandProp((IAdminProp)this, 6, LDAPLang.getStrAccessAddPlbl(), LDAPLang.getStrAddDesc1(), "images/create.gif");
                    iAdminPropArray[n3++] = new CommandProp(this, 7, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc5(), "images/delete.gif", 1, 0);
                    iAdminPropArray[n3 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDelete1());
                    if (this.isExisting()) {
                        iAdminPropArray[n3 - 1].setEnabled(false);
                    }
                    iAdminPropArray[n3++] = new CommandProp(this, 8, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDesc3(), "images/edit.gif", 1, 1);
                    this.m_supObjs.setCommandList(iAdminPropArray);
                }
                return this.m_supObjs;
            }
            case 4206621: {
                if (this.m_mayObjs == null) {
                    this.m_mayObjs = new AdminList((IAdminProp)this, new Vector());
                    this.m_mayObjs.setSampleChild(m_sampleAttr);
                    this.m_mayObjs.setDisplayNameProp(0x103000);
                    String[] stringArray = (String[])this.getProp(269496331);
                    if (stringArray != null) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            Object[] objectArray = this.m_subSchema.findAttributeTypes(1519616, stringArray[n4]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_mayObjs.addChild(objectArray[0]);
                            } else {
                                IAdminProp iAdminProp = this.m_subSchema.createAttribute();
                                iAdminProp.setProp(0x103000, stringArray[n4]);
                                iAdminProp.setProp(1638914, LDAPLang.getStrUnknownAttribute());
                                this.m_mayObjs.addChild(iAdminProp);
                            }
                            ++n4;
                        }
                    }
                    this.m_mayObjs.setProp(2032706, (Object)this.getPropName(n));
                    this.m_mayObjs.setProp(2162725, 114688);
                    IAdminProp[] iAdminPropArray = new CommandProp[3];
                    int n5 = 0;
                    iAdminPropArray[n5++] = new CommandProp((IAdminProp)this, 1, LDAPLang.getStrAccessAddPlbl(), LDAPLang.getStrAddDesc1(), "images/create.gif");
                    iAdminPropArray[n5++] = new CommandProp(this, 2, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc5(), "images/delete.gif", 1, 0);
                    iAdminPropArray[n5 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDelete1());
                    if (this.isExisting()) {
                        iAdminPropArray[n5 - 1].setEnabled(false);
                    }
                    iAdminPropArray[n5++] = new CommandProp(this, 3, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDesc3(), "images/edit.gif", 1, 1);
                    this.m_mayObjs.setCommandList(iAdminPropArray);
                }
                return this.m_mayObjs;
            }
            case 4206620: {
                if (this.m_mustObjs == null) {
                    this.m_mustObjs = new AdminList((IAdminProp)this, new Vector());
                    this.m_mustObjs.setSampleChild(m_sampleAttr);
                    this.m_mustObjs.setDisplayNameProp(0x103000);
                    String[] stringArray = (String[])this.getProp(269496330);
                    if (stringArray != null) {
                        int n6 = 0;
                        while (n6 < stringArray.length) {
                            Object[] objectArray = this.m_subSchema.findAttributeTypes(1519616, stringArray[n6]);
                            if (objectArray != null && objectArray.length > 0) {
                                this.m_mustObjs.addChild(objectArray[0]);
                            } else {
                                IAdminProp iAdminProp = this.m_subSchema.createAttribute();
                                iAdminProp.setProp(0x103000, stringArray[n6]);
                                iAdminProp.setProp(1638914, LDAPLang.getStrUnknownAttribute());
                                this.m_mustObjs.addChild(iAdminProp);
                            }
                            ++n6;
                        }
                    }
                    this.m_mustObjs.setProp(2032706, (Object)this.getPropName(n));
                    this.m_mustObjs.setProp(2162725, 114688);
                    IAdminProp[] iAdminPropArray = new CommandProp[this.isExisting() ? 4 : 3];
                    int n7 = 0;
                    iAdminPropArray[n7++] = new CommandProp((IAdminProp)this, 10, LDAPLang.getStrAccessAddPlbl(), LDAPLang.getStrAddDesc1(), "images/create.gif");
                    iAdminPropArray[n7++] = new CommandProp(this, 11, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc5(), "images/delete.gif", 1, 0);
                    iAdminPropArray[n7 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDelete1());
                    iAdminPropArray[n7++] = new CommandProp(this, 12, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDesc3(), "images/edit.gif", 1, 1);
                    if (this.isExisting()) {
                        int n8 = 0;
                        while (n8 < n7 - 1) {
                            ((CommandProp)iAdminPropArray[n8]).setEnabled(false);
                            ++n8;
                        }
                        iAdminPropArray[n7++] = new CommandProp(this, 13, LDAPLang.getStrMakeOpt(), LDAPLang.getStrMakeOptDesc(), "images/makeoptional.gif", 1, 0);
                        ((CommandProp)iAdminPropArray[n7 - 1]).setProp(1639168, LDAPLang.getStrConfirmMakeOpt());
                    }
                    this.m_mustObjs.setCommandList(iAdminPropArray);
                }
                return this.m_mustObjs;
            }
            case 273612805: {
                return this.m_subSchema.findObjectClasses(269496329, this.getName());
            }
            case 273613313: {
                CommandProp[] commandPropArray = new CommandProp[2];
                int n9 = 0;
                commandPropArray[n9++] = new CommandProp((IAdminProp)this, -10, LDAPLang.getStrCreateLikeLabel(), LDAPLang.getStrCreateLikeDesc2(), "images/createlike.gif");
                commandPropArray[n9++] = new CommandProp((IAdminProp)this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDesc5(), "images/delete.gif");
                if (this.isReadonly()) {
                    commandPropArray[n9 - 1].setEnabled(false);
                }
                commandPropArray[n9 - 1].setProp(1639168, (Object)LDAPLang.getStrConfirmDelete1());
                return commandPropArray;
            }
        }
        return super.getProp(n);
    }

    boolean isAbstract() throws PropertyException {
        return this.getBoolean(8466445);
    }

    boolean isStructural() throws PropertyException {
        return this.getBoolean(8466446);
    }

    boolean isAuxiliary() throws PropertyException {
        return this.getBoolean(8466447);
    }

    String hasDuplicates(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(stringArray[n2])) {
                    return stringArray[n];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public boolean validate() throws SaveChangeException {
        int n;
        String[] stringArray;
        String string;
        Object[] objectArray;
        String string2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        block51: {
            bl3 = false;
            bl2 = false;
            boolean bl4 = false;
            bl = false;
            string2 = "";
            try {
                bl4 = this.getBoolean(8466452);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            try {
                super.validate();
            }
            catch (SaveChangeException saveChangeException) {
                string2 = String.valueOf(string2) + saveChangeException.toString();
                if (!this.isDebug()) break block51;
                this.debugMessageLn("super validate failed");
            }
        }
        try {
            bl = this.isAbstract();
            bl3 = this.isStructural();
            bl2 = this.isAuxiliary();
            int n2 = 0;
            if (bl) {
                ++n2;
            }
            if (bl3) {
                ++n2;
            }
            if (bl2) {
                ++n2;
            }
            if (n2 > 1) {
                string2 = String.valueOf(string2) + LDAPLang.getStrInvalidModifier();
                if (this.isDebug()) {
                    this.debugMessageLn("invalid modifier");
                }
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        try {
            objectArray = (String[])this.getProp(269496329);
            string = (String)this.getProp(0x103000);
            stringArray = (String[])this.getProp(0x103013);
            if (objectArray != null) {
                String string3 = null;
                string3 = this.hasDuplicates((String[])objectArray);
                if (string3 != null) {
                    string2 = String.valueOf(string2) + LDAPLang.getStrDupSup() + ": " + string3;
                    if (this.isDebug()) {
                        this.debugMessageLn("duplicate super");
                    }
                }
                n = 0;
                while (n < objectArray.length) {
                    ObjectClass objectClass;
                    if (this.isDebug()) {
                        if (string == null) {
                            this.debugMessageLn("name == null");
                        }
                        if (objectArray == null) {
                            this.debugMessageLn("astrs == null");
                        }
                        if (objectArray[n] == null) {
                            this.debugMessageLn("astrs[" + n + "] == null");
                        }
                        if (stringArray == null) {
                            this.debugMessageLn("id == null");
                        }
                    }
                    if (string.equalsIgnoreCase((String)objectArray[n]) || stringArray.equalsIgnoreCase((String)objectArray[n])) {
                        string2 = String.valueOf(string2) + LDAPLang.getStrSelfSup();
                        if (this.isDebug()) {
                            this.debugMessageLn("self super");
                        }
                    }
                    if ((objectClass = this.m_subSchema.findObjectClass(0x103000, objectArray[n])) == null) {
                        objectClass = this.m_subSchema.findObjectClass(0x103013, objectArray[n]);
                    }
                    if (objectClass != null) {
                        if (bl) {
                            if (!objectClass.isAbstract() && !objectClass.isStructural()) {
                                objectClass.isAuxiliary();
                            }
                        } else if (bl3) {
                            if (!objectClass.isAbstract() && !objectClass.isStructural()) {
                                objectClass.isAuxiliary();
                            }
                        } else if (bl2 && !objectClass.isAbstract() && !objectClass.isStructural()) {
                            objectClass.isAuxiliary();
                        }
                    }
                    ++n;
                }
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        try {
            objectArray = (String[])this.getProp(269496330);
            string = null;
            if (objectArray != null && (string = this.hasDuplicates((String[])objectArray)) != null) {
                string2 = String.valueOf(string2) + LDAPLang.getStrDupMust() + ": " + string;
                if (this.isDebug()) {
                    this.debugMessageLn("dup must");
                }
            }
            if ((stringArray = (String[])this.getProp(269496331)) != null && (string = this.hasDuplicates(stringArray)) != null) {
                string2 = String.valueOf(string2) + LDAPLang.getStrDupMay() + ": " + string;
                if (this.isDebug()) {
                    this.debugMessageLn("dup may");
                }
            }
            if (this.isExisting()) {
                if (stringArray != null && objectArray != null) {
                    Vector vector = AdminProp.objectArrayToVector(objectArray);
                    boolean bl5 = false;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        int n4 = 0;
                        while (n4 < objectArray.length) {
                            if (stringArray[n3].equalsIgnoreCase((String)objectArray[n4])) {
                                vector.removeElement(objectArray[n4]);
                                bl5 = true;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    if (bl5) {
                        this.setProp(269496330, (Object)AdminProp.vectorToStringArray(vector));
                    }
                }
            } else if (stringArray != null && objectArray != null) {
                n = 0;
                while (n < stringArray.length) {
                    int n5 = 0;
                    while (n5 < objectArray.length) {
                        if (stringArray[n].equalsIgnoreCase((String)objectArray[n5])) {
                            string2 = String.valueOf(string2) + LDAPLang.getStrDupMayMust();
                            if (!this.isDebug()) break;
                            this.debugMessageLn("dup may must");
                            break;
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        if (!string2.trim().equals("")) {
            throw new SaveChangeException(string2);
        }
        return true;
    }

    public Vector getSuperClasses() {
        Vector<ObjectClass> vector = new Vector<ObjectClass>();
        String[] stringArray = null;
        try {
            stringArray = (String[])this.getProp(269496329);
            if (stringArray == null) {
                return vector;
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return vector;
        }
        int n = 0;
        while (n < stringArray.length) {
            ObjectClass objectClass = this.m_subSchema.findObjectClass(0x103000, stringArray[n]);
            if (objectClass != null) {
                vector.addElement(objectClass);
            }
            ++n;
        }
        return vector;
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            switch (n) {
                case -9: {
                    this.m_subSchema.deleteObjectClass(this);
                    this.m_bValid = false;
                    this.sendAdminPropertyChangeEvents(3080204, new Integer(1));
                    break;
                }
                case -10: {
                    NewObjectClass newObjectClass = new NewObjectClass(this.m_subSchema.m_objectClassHolder, this.m_subSchema);
                    this.copyTo(newObjectClass);
                    newObjectClass.setProp(2031768, (Object)(String.valueOf(LDAPLang.getStrEditorTitle19()) + ": " + LDAPLang.getStrCreateLikeLabel() + " " + (String)this.getProp(0x103000)));
                    return newObjectClass;
                }
                case 1: {
                    if (this.m_maySelector == null) {
                        this.m_maySelector = new TableSelector(this, this.m_subSchema.getAttributeTypes(), 272642073, LDAPLang.getStrOptAttrSelector(), null, null);
                        this.m_maySelector.setProp(1048745, (Object)"optional_attribute_selector");
                        this.m_maySelector.setProp(1049370, (Object)RootList.getHelpBaseFileName());
                    }
                    return this.m_maySelector;
                }
                case 10: {
                    if (this.m_mustSelector == null) {
                        this.m_mustSelector = new TableSelector(this, this.m_subSchema.getAttributeTypes(), 272642074, LDAPLang.getStrManAttrSelector(), null, null);
                        this.m_mustSelector.setProp(1048745, (Object)"mandatory_attributes");
                        this.m_mustSelector.setProp(1049370, (Object)RootList.getHelpBaseFileName());
                    }
                    return this.m_mustSelector;
                }
                case 6: {
                    if (this.m_supSelector == null) {
                        this.m_supSelector = new TableSelector(this, this.m_subSchema.getObjectClasses(), 272642072, LDAPLang.getStrObjclassSelector(), null, null);
                        this.m_supSelector.setProp(1048745, (Object)"super_class_selector");
                        this.m_supSelector.setProp(1049370, (Object)RootList.getHelpBaseFileName());
                    }
                    return this.m_supSelector;
                }
                case 11: {
                    this.m_mustObjs.removeChildren(iAdminProp);
                    this.setModified(true);
                    break;
                }
                case 2: {
                    this.m_mayObjs.removeChildren(iAdminProp);
                    this.setModified(true);
                    break;
                }
                case 7: {
                    this.m_supObjs.removeChildren(iAdminProp);
                    this.setModified(true);
                    break;
                }
                case 13: {
                    this.setProp(272642073, iAdminProp.getProp(273220105));
                    this.m_mustObjs.removeChildren(iAdminProp);
                    this.setModified(true);
                    break;
                }
                case 3: 
                case 8: 
                case 12: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                        return null;
                    }
                    return iAdminPropArray[0];
                }
                default: {
                    return null;
                }
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    public Vector getSiblings() {
        return this.m_subSchema.getObjectClasses();
    }

    public void cleanup() {
        super.cleanup();
        this.m_supObjs = null;
        this.m_mayObjs = null;
        this.m_mustObjs = null;
        this.m_maySelector = null;
        this.m_mustSelector = null;
        this.m_supSelector = null;
    }

    static {
        m_sampleAttr = new AttributeSample();
    }
}

