/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.ProcConfSet;
import oracle.ldap.admin.ProcConfSets;
import oracle.ldap.admin.ProcInst;
import oracle.ldap.admin.ProcInsts;
import oracle.ldap.admin.ProcMetaConfSet;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class Proc
extends AdminProp {
    static final int PR_NAME = 0x104000;
    static final String DN_FOR_LDAP_SERVER = "osdldapd";
    static final String DN_FOR_REPL_SERVER = "osdrepld";
    static final String DN_FOR_META_SERVER = "metadird";
    Root m_parent;
    String m_basedn;
    String m_displayName;
    Object[] m_attrs;
    ProcConfSets m_confSets;
    ProcInsts m_procInsts;
    Vector m_children;
    ProcMetaConfSet m_pmcs;

    public Proc() {
    }

    public Proc(Root root, String string, String string2, Object[] objectArray) {
        this.m_parent = root;
        this.m_basedn = string;
        this.m_displayName = string2;
        this.m_attrs = objectArray;
        this.m_confSets = new ProcConfSets(root, string, this);
        this.m_procInsts = new ProcInsts(root, string, this);
        this.m_children = new Vector();
        this.m_children.addElement(this.m_confSets);
        this.m_children.addElement(this.m_procInsts);
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x104000, LDAPLang.getStrNamePlbl1(), LDAPLang.getStrNamePdsc3());
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                String string = LDAPLang.getStrReplServer();
                if (this.m_displayName.equalsIgnoreCase(string)) {
                    return "viewing_replication_servers";
                }
                return "browsing_directory_instances";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 0x110001: {
                return this.m_displayName;
            }
            case 1638408: {
                return "images/msproc.gif";
            }
            case 3080204: {
                if (Root.isClientCommandLine()) {
                    return new Integer(4100);
                }
                return new Integer(0x100044);
            }
            case 2162846: {
                return new Integer(1);
            }
            case 272695330: {
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this.getConfSets(), this.getProcInsts()};
                return iAdminPropArray;
            }
            case 2032706: {
                return LDAPLang.getStrActiveProcesses();
            }
            case 2032708: 
            case 2032714: 
            case 2162725: 
            case 2686994: 
            case 2686995: 
            case 0x10110021: 
            case 273219601: 
            case 273220105: 
            case 273220108: 
            case 276758684: 
            case 281083936: 
            case 282001424: {
                return this.m_procInsts.getProp(n);
            }
            case 1639559: {
                return LDAPLang.getStrViewProps();
            }
            case 273612805: {
                return this.m_confSets.getProp(n);
            }
            case 0x104000: {
                return String.valueOf(this.m_displayName) + " process";
            }
            case 273613313: {
                if (this.m_confSets.countChildren() > 0) {
                    ProcConfSet procConfSet = (ProcConfSet)this.m_confSets.nthChild(0);
                    return procConfSet.getParentCommandList();
                }
                if (this.isMETAServer()) {
                    if (this.m_pmcs == null) {
                        this.m_pmcs = new ProcMetaConfSet(this.m_parent, this);
                    }
                    return this.m_pmcs.getParentCommandList();
                }
                return null;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    public void addConfSet(ProcConfSet procConfSet) {
        this.m_confSets.addChild(procConfSet);
        procConfSet.setHolder(this.m_confSets);
    }

    public void addProcInst(ProcInst procInst) {
        this.m_procInsts.addChild(procInst);
        procInst.setHolder(this.m_procInsts);
    }

    public AdminList getConfSets() {
        try {
            if (this.m_confSets.countChildren() == 0) {
                this.m_confSets.loadProcDetails();
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        return this.m_confSets;
    }

    public AdminList getProcInsts() {
        try {
            if (this.m_procInsts.countChildren() == 0) {
                this.m_procInsts.loadProcDetails();
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        return this.m_procInsts;
    }

    public ProcConfSets getHolder() {
        return this.m_confSets;
    }

    public boolean isLDAPServer() {
        return this.m_basedn.indexOf(DN_FOR_LDAP_SERVER) > 0;
    }

    public boolean isREPLServer() {
        return this.m_basedn.indexOf(DN_FOR_REPL_SERVER) > 0;
    }

    public boolean isMETAServer() {
        return this.m_basedn.indexOf(DN_FOR_META_SERVER) > 0;
    }

    public void cleanup() {
        this.m_parent = null;
        this.m_basedn = null;
        this.m_displayName = null;
        this.m_attrs = null;
        this.m_confSets = null;
        this.m_procInsts = null;
        this.m_children = null;
    }
}

