/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.Proc;
import oracle.ldap.admin.ProcConfSet;
import oracle.ldap.admin.ProcConfSets;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class ProcBases
extends AdminList {
    static ProcConfSet m_sampleChild;
    String m_basedn;
    Proc m_process;
    String m_tabName;
    AdminProp m_queryBase;
    boolean debug;

    public ProcBases(Root root, String string, Proc proc) {
        super(root);
        this.m_children = null;
        this.m_basedn = string;
        this.m_process = proc;
        this.m_queryBase = this.m_process;
        this.m_tabName = "Configuration Set ";
        this.setDisplayName("Configuration Sets");
        this.setIconName("images/msprpms.gif");
        boolean bl = Root.debugConfMgmt;
        if (bl) {
            this.setDebug(true);
        }
        if (m_sampleChild == null) {
            m_sampleChild = new ProcConfSet(root);
        }
        this.setSampleChild(m_sampleChild);
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 2686995: 
            case 0x10110021: 
            case 282001424: {
                if (this.m_children != null) break;
                this.loadProcDetails();
                break;
            }
        }
        switch (n) {
            case 1048745: {
                return "browsing_configuration_sets";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 3080204: {
                return new Integer(0x300044);
            }
            case 273219601: 
            case 273612805: {
                if (this.m_children == null) {
                    this.loadProcDetails();
                }
                if (this.debug) {
                    this.debugMessageLn("ProcConfSets::PR_TREE_VIEW_CHILDREN_LIST");
                    int n2 = 0;
                    while (n2 < this.m_children.size()) {
                        AdminProp adminProp = (AdminProp)this.m_children.elementAt(n2);
                        this.debugMessageLn("child[" + n2 + "] = " + adminProp.getProp(0x110001));
                        ++n2;
                    }
                }
                return AdminProp.vectorToObjectArray(this.m_children);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    public Proc getProc() {
        return this.m_process;
    }

    public void setQueryBase(AdminProp adminProp) {
        this.m_queryBase = adminProp;
    }

    public AdminProp getQueryBase() {
        return this.m_queryBase;
    }

    void execFunc() throws PropertyException {
        String[] stringArray = new String[]{"*"};
        int[] nArray = new int[]{7};
        String[] stringArray2 = new String[]{"objectclass"};
        int n = ((Root)this.m_parent).getSizelimit();
        int n2 = ((Root)this.m_parent).getTimelimit();
        ((AdminProp)this.m_parent).setErrorMessage("");
        int n3 = 0;
        try {
            if (Root.debugServerAccess) {
                System.out.println("ProcBases.execFunc " + this.m_basedn + " " + this.getClass().getName());
            }
            if (this instanceof ProcConfSets) {
                ((Root)this.m_parent).findObject("cn=configset0, " + this.m_basedn, null, this.m_queryBase);
                if (this.m_process != null && !this.m_process.isMETAServer()) {
                    while (n3++ < 20 && (this.m_children == null || this.m_children.size() == 0)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            boolean bl = ((Root)this.m_parent).m_serverAccess.findEntry(stringArray, nArray, this.m_basedn, false, null, (Object)this.m_queryBase, n, n2, stringArray2);
        }
        catch (Exception exception) {
            if (this.debug) {
                this.debugMessageLn(exception.getMessage());
            }
            throw new PropertyException(exception);
        }
        String string = ((AdminProp)this.m_parent).getErrorMessage();
        if (!string.equals("") && this.debug) {
            this.debugMessageLn(string);
        }
    }

    public void loadProcDetails() throws PropertyException {
        if (this.debug) {
            this.debugMessageLn("ProcBases::loadProcDetails() start...");
        }
        this.m_children = new Vector();
        this.execFunc();
        int n = this.countChildren();
        if (n >= 1) {
            this.setSampleChild((IAdminProp)this.m_children.elementAt(0));
            try {
                int n2 = 0;
                while (n2 < n) {
                    ProcConfSet procConfSet = (ProcConfSet)this.nthChild(n2);
                    int n3 = n2 + 1;
                    while (n3 < n) {
                        ProcConfSet procConfSet2 = (ProcConfSet)this.nthChild(n3);
                        if (procConfSet.getBaseNum() == procConfSet2.getBaseNum()) {
                            this.removeChild(procConfSet2);
                            --n3;
                            --n;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public String getDn() {
        return this.m_basedn;
    }
}

