/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.ProcBase;
import oracle.ldap.admin.ProcConfSet;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class ProcInst
extends ProcBase {
    static final int PR_PROC_TYPE = 0x103000;
    static final int PR_INST_NAME = 0x204000;
    ProcConfSet m_cs;

    private void init() {
        this.m_cs = null;
        this.registerProp(0x204000, LDAPLang.getStrInstNamePlbl(), LDAPLang.getStrInstNamePdsc());
        if (this.m_parent != null) {
            Integer n = this.m_parent.getAttrPropId("dn");
            this.unregisterProp(n);
        }
    }

    public ProcInst() {
        this.init();
    }

    public ProcInst(Root root, String string, String string2, Object[] objectArray) {
        super(root, string, string2, objectArray);
        this.init();
        this.m_displayName = String.valueOf(LDAPLang.getStrInstNamePlbl()) + this.getBaseNum();
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 2031768: {
                return LDAPLang.getStrEditorTitle24();
            }
            case 2686979: {
                return new Integer(1);
            }
            case 3080204: {
                if (!this.m_bValid) {
                    return new Integer(1);
                }
                return new Integer(1056772);
            }
            case 272695330: {
                IAdminProp[] iAdminPropArray = new IAdminProp[2];
                int[] nArray = new int[]{3080204, 273613313};
                Object[] objectArray = new Object[]{new Integer(8196), null};
                iAdminPropArray[0] = new AdminPropView((IAdminProp)this, nArray, objectArray);
                iAdminPropArray[1] = this.m_cs;
                return iAdminPropArray;
            }
            case 273613313: {
                return null;
            }
            case 0x204000: {
                return new Integer(this.getBaseNum());
            }
            case 0x103000: {
                if (this.getDn().toLowerCase().indexOf("repl") > 0) {
                    return LDAPLang.getStrReplType();
                }
                return LDAPLang.getStrEditorTitle9();
            }
            case 269550752: {
                String[] stringArray = new String[]{"view_configset_general", "view_debug_flags", "view_ssl_settings"};
                return stringArray;
            }
            case 269550753: {
                String[] stringArray = new String[]{RootList.getHelpBaseFileName(), RootList.getHelpBaseFileName(), RootList.getHelpBaseFileName()};
                return stringArray;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        super.setProp(n, object);
    }

    public void setConfSet(ProcConfSet procConfSet) {
        this.m_cs = procConfSet;
    }

    public void saveChanges() {
    }

    public boolean isReadonly() {
        return true;
    }
}

