/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.ACPsMgmt;
import oracle.ldap.admin.AccessCtrlPoint;
import oracle.ldap.admin.AccessCtrlPoints;
import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.AccessList;
import oracle.ldap.admin.AgreementDN;
import oracle.ldap.admin.AgreementDNs;
import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.AuditLog;
import oracle.ldap.admin.AuditLogs;
import oracle.ldap.admin.Connectors;
import oracle.ldap.admin.DSEEntry;
import oracle.ldap.admin.DirTree;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.INewEntry;
import oracle.ldap.admin.IServerAccess;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.LogonLookup;
import oracle.ldap.admin.MatchingRule;
import oracle.ldap.admin.Names;
import oracle.ldap.admin.NamingContexts;
import oracle.ldap.admin.NewAccessCtrlPoint;
import oracle.ldap.admin.ObjectClass;
import oracle.ldap.admin.Options;
import oracle.ldap.admin.Proc;
import oracle.ldap.admin.ProcConfSet;
import oracle.ldap.admin.ProcConnector;
import oracle.ldap.admin.ProcInst;
import oracle.ldap.admin.ProcMetaConfSet;
import oracle.ldap.admin.Procs;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.ServerList;
import oracle.ldap.admin.SubACLDns;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.SubSchemaDns;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.AdminURL;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class Root
extends AdminProp
implements ICommandParent {
    static final String ATTR_BASE_SCHEMA_LIST = "cn=baseschema";
    static final String ATTR_CATALOG_ENTRY_DN = "orclcatalogentrydn";
    int m_acpoption;
    int m_timelimit = 25;
    int m_sizelimit = 200;
    public static final int CMD_OPTIONS = -8198;
    static final String ACCESSDIRECTIVE = "accessdirective";
    static final int CMD_NEW_ENTRY = -8;
    static final int PR_HOST = 1585154;
    static final int PR_HOST_HIDDEN = 1650690;
    static final int PR_PORT = 3026947;
    static final int PR_USER = 1585157;
    static final int PR_PASSWORD = 14168070;
    static final int PR_MARK = 8990727;
    static final int PR_IDLE_AMOUNT = 2699272;
    static final int PR_SSL_ENABLED = 8925193;
    static final int PR_NAMING_CONTEXTS = 4730891;
    static final int PR_SUBSCHEMA_DNS = 4730892;
    static final int PR_SUBACL_DNS = 4730893;
    static final int PR_SYS_OP_ATTRS = 4730894;
    static final int PR_SSL_LOCATION = 1585167;
    static final int PR_SSL_PASSWD = 14168080;
    static final int PR_SSL_AUTH_LEVEL = 1585169;
    static final AdminProp m_dummySysOpParams = new AdminProp();
    static int[] sslLogonProps = new int[]{1585157, 14168070, 1585154, 3026947, 8925193, 1585167, 14168080, 1585169};
    static int[] logonProps = new int[]{1585157, 14168070, 1585154, 3026947};
    static final int m_maxResults = 200;
    NamingContexts m_namingContexts;
    RootServerList m_rootServerList;
    Directory m_directory;
    Names m_adminNamesHolder;
    String m_connectedHost;
    String m_connectedUser;
    String m_connectedPassword;
    int m_connectedPort;
    RootList m_parent;
    IServerAccess m_serverAccess;
    int m_idleAmount = 200;
    String m_password = "";
    String m_displayName;
    Vector m_children;
    String m_user = "";
    int m_port = 389;
    String m_host = "";
    boolean m_ssl_enabled = false;
    IAdminProp[] m_newChildren;
    DSEEntry m_sysOpParams;
    IAdminProp m_serverManager;
    IAdminProp m_auditLogs;
    int m_namingCtxPropId;
    static Hashtable m_sslLevels;
    public String m_sslLevel = "1";
    public String m_sslPassword = "";
    public String m_sslLocation = "";
    boolean m_bBound = false;
    boolean m_bConnectionOk = false;
    static boolean m_usingCommandLine;
    IAdminProp[] m_cmdList;
    Vector m_catalogDn;
    boolean m_refreshSysOp = false;
    Server m_server;
    public static boolean SSLEnabled;
    public static boolean MetaDirEnabled;
    public static boolean DEBUG;
    public static boolean debugSaveEntry;
    public static boolean debugLoadSchema;
    public static boolean debugSearchEntry;
    public static boolean debugSaveACI;
    public static boolean debugSaveObjectClass;
    public static boolean debugSaveAttribute;
    public static boolean debugDeleteEntry;
    public static boolean debugAccessItemEntry;
    public static boolean debugConfMgmt;
    public static boolean debugDirTree;
    public static boolean debugAuditLog;
    public static boolean debugServerAccess;
    public static boolean debugDirectory;
    boolean m_bShutdowning = false;
    boolean m_bConnected = false;
    private boolean m_bLockConnect = false;
    boolean m_active = false;
    boolean m_loadingDSE = true;
    Vector m_subSchemas = new Vector();
    Vector m_subACLDns = new Vector();
    Vector m_sysOpAttrs = new Vector();
    ACPsMgmt m_acpMgmt;
    AccessCtrlPoints m_accessCtrlPoints;
    static final String ATTR_NAME_FOR_DN_OF_SUBSCHEMA = "subschemasubentry";
    static final String ATTR_NAME_FOR_DN_OF_ACL = "subaclsubentry";
    static final String ATTR_NAME_FOR_NAMING_CONTEXTS = "namingconexts";
    int requestCount;
    static final String DN_FOR_CONF_MGMT = "subconfigsubentry";
    static final String DN_FOR_CONF_MGMT_META = "metadird";
    static final String DN_FOR_REGISTRY = "subregistrysubentry";
    Hashtable m_attrPropIds = new Hashtable();
    static String[] m_readOnlyAttributes;
    static String[] m_hiddenAttributes;
    int m_lastAttrPropId;
    Object[] m_dseAttributes;
    String m_serverVer;
    boolean m_isVerGreater = false;

    public static boolean isClientCommandLine() {
        return m_usingCommandLine;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerPropOnTabPage(1585154, LDAPLang.getStrHostPlbl(), LDAPLang.getStrHostPdsc(), LDAPLang.getStrHostPtab());
        this.registerPropOnTabPage(1650690, LDAPLang.getStrHostPlbl(), LDAPLang.getStrHostPdsc(), LDAPLang.getStrHostPtab());
        this.registerPropOnTabPage(3026947, LDAPLang.getStrPortPlbl(), LDAPLang.getStrPortPdsc(), LDAPLang.getStrHostPtab());
        this.registerPropOnTabPage(1585157, LDAPLang.getStrUserPlbl(), LDAPLang.getStrUserPdsc(), LDAPLang.getStrHostPtab());
        this.registerPropOnTabPage(14168070, LDAPLang.getStrPasswordPlbl(), LDAPLang.getStrPasswordPdsc(), LDAPLang.getStrHostPtab());
        this.registerPropOnTabPage(8925193, "SSL Enabled", "", LDAPLang.getStrHostPtab());
        this.registerProp(2699272, LDAPLang.getStrIdleAmountPlbl(), LDAPLang.getStrIdleAmountPdsc());
        this.registerPropOnTabPage(1585167, LDAPLang.getStrSslLocationPlbl(), LDAPLang.getStrEmptyString(), LDAPLang.getStrSslLocationPtab());
        this.registerPropWidth(1585167, 30);
        this.registerPropOnTabPage(14168080, LDAPLang.getStrSslPasswdPlbl(), LDAPLang.getStrEmptyString(), LDAPLang.getStrSslLocationPtab());
        this.registerPropOnTabPage(1585169, LDAPLang.getStrSslAuthLevelPlbl(), LDAPLang.getStrEmptyString(), LDAPLang.getStrSslLocationPtab());
        if (m_sslLevels == null) {
            m_sslLevels = new Hashtable();
            m_sslLevels.put("1", LDAPLang.getStrNoSslAuth());
            m_sslLevels.put("32", LDAPLang.getStrNoSslServer());
            m_sslLevels.put("64", LDAPLang.getStrNoSslClientServer());
        }
        this.registerPropListOfValues(1585169, m_sslLevels);
        this.registerPropField(1585167, "m_sslLocation");
        this.registerPropField(14168080, "m_sslPassword");
        this.registerPropField(1585169, "m_sslLevel");
    }

    public Root() {
        this.setStatusMessage(LDAPLang.getStrNotConnected());
        this.m_cmdList = new IAdminProp[3];
        this.m_cmdList[0] = this.isConnected() ? new CommandProp((IAdminProp)this, -4, LDAPLang.getStrDisconnect(), String.valueOf(LDAPLang.getStrDisconnect()) + "...", "images/disconnect.gif") : new CommandProp((IAdminProp)this, -4, LDAPLang.getStrConnect(), String.valueOf(LDAPLang.getStrConnect()) + "...", "images/connect.gif");
        this.m_cmdList[1] = new CommandProp((IAdminProp)this, -5, LDAPLang.getStrCmdRefresh(), String.valueOf(LDAPLang.getStrCmdRefresh()) + "...", "images/refresh.gif");
        this.m_cmdList[2] = new CommandProp((IAdminProp)this, -8198, LDAPLang.getStrUserPrefTitle(), LDAPLang.getStrUserPrefTitle(), "images/options.gif");
        try {
            this.m_cmdList[1].setProp(2687509, new Integer(4));
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public Root(RootList rootList) {
        this();
        this.m_parent = rootList;
    }

    public Root(String string) {
        this();
        this.m_host = string;
    }

    public Root(String string, int n) {
        this(string);
        this.m_port = n;
    }

    public Root(String string, int n, boolean bl, String string2, String string3, String string4) {
        this(string, n);
        this.m_ssl_enabled = bl;
        this.m_sslLevel = string2;
        this.m_sslLocation = string3;
        this.m_sslPassword = string4;
    }

    public Object getProp(int n) throws PropertyException {
        int n2 = 0;
        switch (n) {
            case 3081366: {
                return new Integer(8);
            }
            case 2163837: {
                if (this.isConnected()) break;
                return new Integer(100);
            }
            case 1639539: {
                return LDAPLang.getStrOracleCopyrights();
            }
            case 2687386: {
                return new Integer(0x100800);
            }
            case 276758675: {
                if (this.m_rootServerList != null) break;
                this.m_rootServerList = new RootServerList(this);
                this.registerPropListOfValues(1585154, this.m_rootServerList);
                this.registerPropListOfValues(1585157, new LogonLookup(this));
                break;
            }
            case 1639496: {
                return "images/logonBkgrnd.gif";
            }
            case 2031768: {
                return LDAPLang.getStrOIDServer();
            }
            case 1048745: {
                return "logging_on";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 269550752: {
                String[] stringArray = new String[]{"logging_on", "ssl_login"};
                return stringArray;
            }
            case 269550753: {
                String[] stringArray = new String[]{RootList.getHelpBaseFileName(), RootList.getHelpBaseFileName()};
                return stringArray;
            }
            case 1638408: {
                return "images/ldapadmin.gif";
            }
            case 2162846: {
                return new Integer(1);
            }
            case 12583682: {
                return new Integer(this.isConnected() ? 1 : 2);
            }
            case 2031764: {
                return LDAPLang.getStrLogonTitle1();
            }
            case 282001422: {
                if (SSLEnabled) {
                    return sslLogonProps;
                }
                return logonProps;
            }
            case 0x110001: {
                if (this.m_displayName != null) {
                    return this.m_displayName;
                }
                if (this.isConnected()) {
                    if (!this.m_user.trim().equals("")) {
                        return String.valueOf(this.m_user) + "@" + this.m_host + ":" + this.m_port;
                    }
                    return String.valueOf(this.m_host) + ":" + this.m_port;
                }
                if (!this.m_host.trim().equals("")) {
                    return String.valueOf(this.m_host) + ":" + this.m_port + LDAPLang.getStrNotConnected();
                }
                return LDAPLang.getStrOIDServerNotConnected();
            }
            case 2032789: {
                if (DEBUG) {
                    System.out.println("PR_ADMPROP_URL");
                }
                return AdminURL.makeComponent(this.getClass().getName(), !this.m_user.trim().equals("") ? String.valueOf(this.m_user) + ":" + this.m_host + ":" + this.m_port : String.valueOf(this.m_host) + ":" + this.m_port);
            }
            case 2686979: {
                return new Integer(3);
            }
            case 3084300: {
                m_usingCommandLine = true;
                break;
            }
            case 3080204: {
                if (this.isShutdowning()) {
                    return new Integer(1);
                }
                return new Integer(0x300000 | (this.isConnected() ? (this.m_children == null || this.m_sysOpParams == null ? 1 : 4096) : 24576) | (this.isModified() ? 2 : 0) | (this.isConnected() ? 4 : 0) | (this.isAnonymous() ? 0x800000 : 0));
            }
            case 0x1F000F: {
                return this.m_statusMessage;
            }
            case 272630352: 
            case 272695330: {
                n2 = 0;
                while (this.m_sysOpParams == null && n2++ < 50) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
                if (this.m_sysOpParams == null) {
                    PropertyException propertyException = new PropertyException(LDAPLang.getStrErrInsufficientAccessRights());
                    propertyException.setReminder();
                    throw propertyException;
                }
                if (n == 272630352) {
                    this.m_sysOpParams.setProp(1638690, (Object)LDAPLang.getStrSysOpAttrs());
                    IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_sysOpParams, this.m_serverManager};
                    return iAdminPropArray;
                }
                LDAPLang.getStrServerManager();
                int[] nArray = new int[]{273613313};
                Object[] objectArray = new Object[]{null};
                IAdminProp iAdminProp = this.m_sysOpParams.getAuditLevelEditor();
                IAdminProp iAdminProp2 = this.m_sysOpParams.getPasswordsEditor();
                IAdminProp iAdminProp3 = this.m_sysOpParams.getDebugFlagsEditor();
                Vector<IAdminProp> vector = new Vector<IAdminProp>();
                vector.addElement(new AdminPropView((IAdminProp)this.m_sysOpParams, nArray, objectArray));
                if (iAdminProp2 != null) {
                    vector.addElement(iAdminProp2);
                }
                if (iAdminProp != null) {
                    vector.addElement(iAdminProp);
                }
                if (iAdminProp3 != null) {
                    vector.addElement(iAdminProp3);
                }
                vector.addElement(this.m_serverManager);
                IAdminProp[] iAdminPropArray = (IAdminProp[])AdminProp.vectorToObjectArray(vector);
                return iAdminPropArray;
            }
            case 273612805: {
                if (this.isShutdowning()) {
                    return null;
                }
                if (!this.isConnected()) {
                    this.connect();
                    if (!this.m_bConnectionOk) {
                        throw new PropertyException(this.getErrorMessage(), 6, n, null);
                    }
                }
                if (this.m_children == null) {
                    this.setStatusMessage(LDAPLang.getStrNoChildren());
                    return null;
                }
                this.setStatusMessage(LDAPLang.getStrReady());
                if (this.m_newChildren == null) {
                    n2 = 0;
                    while (this.m_sysOpParams == null && n2++ < 50) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                    if (this.m_children.size() < 9) {
                        Object object;
                        StringBuffer stringBuffer = new StringBuffer();
                        int n3 = this.m_children.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            object = this.m_children.elementAt(n4);
                            if (object != null) {
                                stringBuffer.append("   " + object.toString() + "\n");
                            }
                            ++n4;
                        }
                        this.setProp(8454180, (Object)Boolean.TRUE);
                        object = new Object[]{stringBuffer.toString()};
                        throw new PropertyException(this.getMessage(LDAPLang.getStrEmptyString(), (Object[])object));
                    }
                    int n5 = 0;
                    this.m_newChildren = new IAdminProp[5];
                    this.m_newChildren[n5++] = (IAdminProp)this.m_children.elementAt(7);
                    this.m_newChildren[n5++] = (IAdminProp)this.m_children.elementAt(3);
                    this.m_newChildren[n5++] = (IAdminProp)this.m_children.elementAt(6);
                    this.m_newChildren[n5++] = (IAdminProp)this.m_children.elementAt(1);
                    this.m_newChildren[n5++] = (IAdminProp)this.m_children.elementAt(8);
                }
                return this.m_newChildren;
            }
            case 273613313: {
                return this.m_cmdList;
            }
            case 14168070: {
                return this.m_password;
            }
            case 1585157: {
                return this.m_user;
            }
            case 1585154: 
            case 1650690: {
                if (this.m_host == null || this.m_host.equals("")) {
                    Server server = this.m_parent.getDefaultServer();
                    this.m_host = server.getHost();
                    this.m_port = server.getPort();
                }
                if (DEBUG) {
                    System.out.println("PR_HOST");
                }
                return this.m_host;
            }
            case 3026947: {
                if (this.m_host == null || this.m_host.equals("")) {
                    Server server = this.m_parent.getDefaultServer();
                    this.m_host = server.getHost();
                    this.m_port = server.getPort();
                }
                if (DEBUG) {
                    System.out.println("PR_PORT");
                }
                return new Integer(this.m_port);
            }
            case 8925193: {
                return new Boolean(this.m_ssl_enabled);
            }
            case 7929867: {
                if (!this.isConnected()) {
                    return null;
                }
                int n6 = (Integer)this.getProp(3080204);
                if ((n6 & 1) != 1) break;
                PropertyException propertyException = new PropertyException(LDAPLang.getStrErrInsufficientAccessRights());
                propertyException.setReminder();
                throw propertyException;
            }
        }
        return super.getProp(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            if (n == -8) {
                return (IAdminProp)this.m_directory.getProp(5177493);
            }
            if (n == -4) {
                if (!this.isConnected()) return this;
                this.setProp(8454180, (Object)Boolean.TRUE);
                return null;
            } else if (n == -5) {
                ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
                this.m_refreshSysOp = true;
                this.m_serverAccess.findObjectSync("", null, this);
                this.initDSE();
                this.sendAdminPropertyChangeEvents(272695330, null);
                iAdminProp.setProp(0x1F000F, "finish");
                ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
                return null;
            } else {
                if (n != -8198) return null;
                return new Options(this, this.m_rootServerList);
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public void shutdown() {
        if (this.isConnected()) {
            this.setShutdowning(true);
            this.setBound(false);
            this.setConnected(false);
            this.m_children = null;
            this.m_newChildren = null;
            this.m_catalogDn = null;
            this.m_password = "";
            this.sendAdminPropertyChangeEvents(273612805, null);
            this.makeInvalid();
            if (this.m_serverAccess != null) {
                this.m_serverAccess.shutdown();
            }
            this.m_serverAccess = null;
            int n = 0;
            while (n < this.m_subSchemas.size()) {
                ((SubSchema)this.m_subSchemas.elementAt(n)).cleanup();
                ++n;
            }
            this.m_subSchemas = new Vector();
            if (this.m_adminNamesHolder != null) {
                this.m_adminNamesHolder.cleanup();
            }
            this.m_adminNamesHolder = null;
            if (this.m_directory != null) {
                this.m_directory.cleanup();
            }
            this.m_directory = null;
            if (this.m_namingContexts != null) {
                this.m_namingContexts.cleanup();
            }
            this.m_namingContexts = null;
            if (this.m_sysOpParams != null) {
                this.m_sysOpParams.cleanup();
            }
            this.m_sysOpParams = null;
            if (this.m_serverManager != null) {
                ((Procs)this.m_serverManager).cleanup();
            }
            this.m_serverManager = null;
            if (this.m_auditLogs != null) {
                ((AuditLogs)this.m_auditLogs).cleanup();
            }
            this.m_auditLogs = null;
            if (this.m_catalogDn != null) {
                this.m_catalogDn.removeAllElements();
            }
            this.m_catalogDn = null;
            if (this.m_subACLDns != null) {
                this.m_subACLDns.removeAllElements();
            }
            this.m_subACLDns = new Vector();
            if (this.m_sysOpAttrs != null) {
                this.m_sysOpAttrs.removeAllElements();
            }
            this.m_sysOpAttrs = null;
            if (this.m_accessCtrlPoints != null) {
                this.m_accessCtrlPoints.cleanup();
            }
            this.m_accessCtrlPoints = null;
            Runtime.getRuntime().gc();
            this.m_connectedHost = null;
            this.m_connectedUser = null;
            this.m_connectedPassword = null;
            this.m_connectedPort = 0;
            this.m_directory = null;
            if (this.m_parent != null) {
                this.m_parent.enableMenuList();
            }
            this.setShutdowning(false);
        }
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1585154: {
                this.m_port = this.m_parent.getHostPort((String)object, this.m_port);
                this.sendAdminPropertyChangeEvents(3026947, null);
            }
            case 1650690: {
                this.m_host = (String)object;
                return;
            }
            case 1585157: {
                this.m_user = (String)object;
                return;
            }
            case 14168070: {
                this.m_password = (String)object;
                return;
            }
            case 3026947: {
                this.m_port = (Integer)object;
                return;
            }
            case 8925193: {
                this.m_ssl_enabled = (Boolean)object;
                return;
            }
            case 8454180: {
                this.shutdown();
                return;
            }
            case 2163220: 
            case 2163740: {
                this.m_sysOpParams.setProp(n, object);
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        Object[] objectArray;
        if (this.m_serverAccess != null && (this.m_connectedHost != null && this.m_host != null && !this.m_connectedHost.equals(this.m_host) || this.m_connectedPort != this.m_port || this.m_connectedUser != null && this.m_user != null && this.m_connectedUser != this.m_user || this.m_connectedPassword != null && this.m_password != null && this.m_connectedPassword != this.m_password)) {
            objectArray = this.m_password;
            this.shutdown();
            this.m_password = objectArray;
            this.initClient();
        } else if (this.isConnected()) {
            return;
        }
        if (!this.isRunning()) {
            throw new SaveChangeException(String.valueOf(LDAPLang.getStrNotRunning()) + ": " + this.m_host + "/" + this.m_port);
        }
        this.connect();
        if (!this.m_bConnectionOk) {
            objectArray = this.getErrorMessage();
            if (this.isConnected()) {
                this.shutdown();
            }
            throw new SaveChangeException((String)objectArray);
        }
        if (!this.m_serverAccess.isBound()) {
            if (this.isConnected()) {
                this.shutdown();
            }
            objectArray = new Object[]{this.m_host, new Integer(this.m_port)};
            throw new SaveChangeException(this.getMessage(LDAPLang.getStrCannotBind(), objectArray));
        }
        if (this.m_parent != null) {
            this.m_parent.save(this);
        }
    }

    boolean isRunning() {
        try {
            Socket socket = new Socket(this.m_host, this.m_port);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IServerAccess loadServerAccess(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object var3_3 = null;
            if (clazz != null) {
                var3_3 = clazz.newInstance();
            }
            if (var3_3 instanceof IServerAccess) {
                return var3_3;
            }
            System.out.println("Couldn't IServerAccess class " + string);
        }
        catch (Exception exception) {}
        return null;
    }

    void initClient() {
        String string = this.m_user;
        if (string.indexOf("=") < 0 && string.length() > 0) {
            string = "cn=" + string;
        }
        if (this.m_serverAccess == null) {
            if (SSLEnabled) {
                if (DEBUG) {
                    System.out.println("Using Net8 package...");
                }
                this.m_serverAccess = this.loadServerAccess("oracle.ldap.admin.ServerAccessNet8");
            } else {
                if (DEBUG) {
                    System.out.println("Using Sumatra package...");
                }
                this.m_serverAccess = this.loadServerAccess("oracle.ldap.admin.ServerAccessSumatra");
            }
        }
        if (this.m_serverAccess != null) {
            this.m_serverAccess.initInstance(string, this.m_password, this.m_host, this.m_port, this.m_ssl_enabled, this.m_sslLevel, this.m_sslLocation, this.m_sslPassword, this);
        }
        if (this.isAnonymous()) {
            this.m_user = "";
        }
        this.m_connectedPort = this.m_port;
        this.m_connectedUser = this.m_user;
        this.m_connectedHost = this.m_host;
        this.m_connectedPassword = this.m_password;
    }

    synchronized boolean isShutdowning() {
        return this.m_bShutdowning;
    }

    synchronized void setShutdowning(boolean bl) {
        this.m_bShutdowning = bl;
    }

    synchronized boolean isBound() {
        return this.m_bBound;
    }

    synchronized void setBound(boolean bl) {
        this.m_bBound = bl;
    }

    synchronized boolean isConnected() {
        return this.m_bConnected;
    }

    synchronized boolean isAnonymous() {
        return (this.m_password == null || this.m_password.length() <= 0) && !this.m_user.equalsIgnoreCase("orcladmin") && !this.m_user.equalsIgnoreCase("cn=orcladmin");
    }

    synchronized void setConnected(boolean bl) {
        this.m_bConnected = bl;
        try {
            this.sendAdminPropertyChangeEvents(3080204, this.getProp(3080204));
            this.sendAdminPropertyChangeEvents(0x110001, this.getProp(0x110001));
            this.m_cmdList[1].setProp(8978948, bl ? Boolean.TRUE : Boolean.FALSE);
            if (bl) {
                this.m_cmdList[0].setProp(1638408, "images/disconnect.gif");
                this.m_cmdList[0].setProp(0x110001, LDAPLang.getStrDisconnect());
                this.m_cmdList[0].setProp(1638914, String.valueOf(LDAPLang.getStrDisconnect()) + "...");
                return;
            }
            this.m_cmdList[0].setProp(1638408, "images/connect.gif");
            this.m_cmdList[0].setProp(0x110001, LDAPLang.getStrConnect());
            this.m_cmdList[0].setProp(1638914, String.valueOf(LDAPLang.getStrConnect()) + "...");
            return;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return;
        }
    }

    void connect() {
        if (this.m_host != null && !this.isConnected()) {
            if (this.m_bLockConnect) {
                return;
            }
            this.m_bLockConnect = true;
            this.initClient();
            this.m_bConnectionOk = this.m_serverAccess.connect();
            this.m_bLockConnect = false;
        }
    }

    boolean isActive() {
        return this.m_active;
    }

    void setActive(boolean bl) {
        this.m_active = bl;
    }

    public void setLoadingDSE(boolean bl) {
        this.m_loadingDSE = bl;
    }

    public void doBoundCallback() {
        this.setBound(true);
        this.setConnected(true);
        try {
            this.findDSE("", null, this);
            this.setStatusMessage(LDAPLang.getStrInitializing());
            return;
        }
        catch (Exception exception) {
            this.debugMessageLn("Error searching " + this.m_host + " " + exception);
            return;
        }
    }

    public Names getAdminNames() {
        return this.m_adminNamesHolder;
    }

    public String getAttrDisplayName(String string) {
        return this.m_adminNamesHolder.getPropName(string);
    }

    public String getAttrDisplayNameReal(String string) {
        return this.m_adminNamesHolder.getPropNameReal(string);
    }

    public void setAttrDisplayName(String string, String string2) {
        this.m_adminNamesHolder.setPropName(string, string2);
    }

    public String getAttrInternalName(String string) {
        return this.m_adminNamesHolder.getAttrName(string);
    }

    void addSubSchemas(AdminProp adminProp) {
        AdminProp.addSorted(this.m_subSchemas, adminProp);
    }

    public Vector getSubSchemas() {
        return this.m_subSchemas;
    }

    public SubSchema getSubSchema() {
        if (this.m_subSchemas == null || this.m_subSchemas.size() == 0) {
            return null;
        }
        return (SubSchema)this.m_subSchemas.elementAt(0);
    }

    void addSubACLDns(AdminProp adminProp) {
        AdminProp.addSorted(this.m_subACLDns, adminProp);
    }

    public Vector getSubACLDns() {
        return this.m_subACLDns;
    }

    void addSysOpAttrs(AdminProp adminProp) {
        AdminProp.addSorted(this.m_sysOpAttrs, adminProp);
    }

    public Vector getSysOpAttrs() {
        return this.m_sysOpAttrs;
    }

    public boolean saveEntry(Entry entry) throws PropertyException {
        String string = "";
        if (this.m_sysOpParams != entry) {
            string = entry.getDn();
        }
        if (DEBUG) {
            System.out.println("Root.saveEntry: dn='" + string + "'");
        }
        boolean bl = this.m_serverAccess.saveEntry(string, entry.getMods()) == 2;
        return bl;
    }

    public boolean addEntry(INewEntry iNewEntry) {
        return this.m_serverAccess.addEntry(iNewEntry.getDn(), iNewEntry.getAttributes()) == 2;
    }

    public boolean deleteEntry(Entry entry) {
        boolean bl = this.m_serverAccess.deleteEntry(entry.getDn()) == 2;
        return bl;
    }

    public int findDSE(String string, String[] stringArray, Object object) throws Exception {
        return this.m_serverAccess.findObject(string, stringArray, object);
    }

    public int findSubschema(String string, String[] stringArray, Object object) throws Exception {
        if (string == null) {
            string = "cn=subschemasubentry,dc=oracle,dc=com";
        }
        return this.m_serverAccess.findObject(string, stringArray, object);
    }

    public int findACL(String string, String[] stringArray, Object object) throws Exception {
        if (string == null) {
            string = "cn=aclsubentry,dc=oracle,dc=com";
        }
        return this.m_serverAccess.findObject(string, stringArray, object);
    }

    public int findObject(String string, String[] stringArray, Object object) throws Exception {
        return this.m_serverAccess.findObject(string, stringArray, object);
    }

    public boolean validate(Vector vector) {
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            SchemaObject schemaObject = (SchemaObject)vector.elementAt(n2);
            try {
                schemaObject.validate();
            }
            catch (SaveChangeException saveChangeException) {
                this.debugMessageLn(String.valueOf(schemaObject.getClass().getName()) + "=" + schemaObject);
                System.out.println(saveChangeException.toString());
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public boolean saveNewSchemaObject(String string, String string2, String string3) throws Exception {
        this.setErrorMessage("");
        return this.m_serverAccess.addAttributeValue(string2, string3, string) == 2;
    }

    void addAttributeList(Vector vector) {
        if (this.m_adminNamesHolder != null) {
            this.m_adminNamesHolder.addAttributeList(vector);
        }
    }

    void updateACL(AccessList accessList) {
        accessList.setChildren(new Vector());
        try {
            this.findACL(accessList.getDn(), null, accessList);
            accessList.update();
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    void updateSchema(SubSchema subSchema) {
        try {
            this.findSubschema(subSchema.getDn(), null, subSchema);
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public static void main(String[] stringArray) {
        Root root = new Root();
        root.setDebug(true);
        try {
            if (stringArray.length < 1 || stringArray.length > 3) {
                System.out.println("usage: java Root host [basedn] [port]");
            }
            if (stringArray.length >= 1) {
                root.setProp(1650690, (Object)stringArray[0]);
            }
            if (stringArray.length >= 2) {
                root.setProp(3026947, (Object)new Integer(Integer.parseInt(stringArray[1])));
            }
        }
        catch (PropertyException propertyException) {
            root.unexpectedException(propertyException);
            root.debugMessageLn("Can't set basic properties");
        }
        root.connect();
    }

    MatchingRule findMatchingRule(int n, Object object) {
        int n2 = this.m_subSchemas.size();
        int n3 = 0;
        while (n3 < n2) {
            SubSchema subSchema = (SubSchema)this.m_subSchemas.elementAt(n3);
            MatchingRule matchingRule = subSchema.findMatchingRule(n, object);
            if (matchingRule != null) {
                return matchingRule;
            }
            ++n3;
        }
        return null;
    }

    Attribute findAttributeType(int n, Object object) {
        int n2 = this.m_subSchemas.size();
        int n3 = 0;
        while (n3 < n2) {
            SubSchema subSchema = (SubSchema)this.m_subSchemas.elementAt(n3);
            Attribute attribute = subSchema.findAttributeType(n, object);
            if (attribute != null) {
                return attribute;
            }
            ++n3;
        }
        return null;
    }

    ObjectClass findObjectClass(int n, Object object) {
        int n2 = this.m_subSchemas.size();
        int n3 = 0;
        while (n3 < n2) {
            SubSchema subSchema = (SubSchema)this.m_subSchemas.elementAt(n3);
            ObjectClass objectClass = subSchema.findObjectClass(n, object);
            if (objectClass != null) {
                return objectClass;
            }
            ++n3;
        }
        return null;
    }

    public String getPropIdAttr(Integer n) {
        return (String)this.m_attrPropIds.get(n);
    }

    public Vector getAllAttrNames() {
        Vector<String> vector = new Vector<String>();
        int n = this.m_subSchemas.size();
        int n2 = 0;
        while (n2 < n) {
            SubSchema subSchema = (SubSchema)this.m_subSchemas.elementAt(n2);
            Vector vector2 = subSchema.getAttributeTypes();
            int n3 = vector2.size();
            int n4 = 0;
            while (n4 < n3) {
                Attribute attribute = (Attribute)vector2.elementAt(n4);
                try {
                    String string = attribute.getName();
                    if (string != null) {
                        vector.addElement(string);
                    }
                }
                catch (Exception exception) {
                    this.unexpectedException(exception);
                }
                ++n4;
            }
            ++n2;
        }
        return vector;
    }

    public Vector getAllObjectClassNames() {
        Vector<String> vector = new Vector<String>();
        int n = this.m_subSchemas.size();
        int n2 = 0;
        while (n2 < n) {
            SubSchema subSchema = (SubSchema)this.m_subSchemas.elementAt(n2);
            Vector vector2 = subSchema.getObjectClasses();
            if (vector2 != null) {
                int n3 = vector2.size();
                int n4 = 0;
                while (n4 < n3) {
                    ObjectClass objectClass = (ObjectClass)vector2.elementAt(n4);
                    try {
                        String string = objectClass.getName();
                        if (string != null) {
                            vector.addElement(string);
                        }
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    Integer getAttrPropId(Object var1_1) {
        block43: {
            block42: {
                block44: {
                    block41: {
                        block46: {
                            block45: {
                                var2_2 = null;
                                var3_3 = null;
                                if (var1_1 instanceof String) {
                                    var1_1 = ((String)var1_1).toLowerCase();
                                    var2_2 = (Integer)this.m_attrPropIds.get(var1_1);
                                } else if (var1_1 instanceof AdminProp) {
                                    try {
                                        var3_3 = (AdminProp)var1_1;
                                        var4_4 = (String)var3_3.getProp(0x103013);
                                        if (var4_4 == null) {
                                            System.out.println("This object as no object id:");
                                            var3_3.printDebug(System.out);
                                            var1_1 = "Unknown";
                                            var2_2 = null;
                                        } else {
                                            var2_2 = (Integer)this.m_attrPropIds.get(var4_4);
                                            var1_1 = var4_4;
                                        }
                                    }
                                    catch (ClassCastException var4_5) {
                                        this.unexpectedException(var4_5);
                                    }
                                    catch (PropertyException var4_6) {
                                        this.unexpectedException(var4_6);
                                    }
                                }
                                if (var2_2 != null) break block43;
                                var4_7 = 16384 + this.m_lastAttrPropId++;
                                var5_8 = null;
                                if (var3_3 != null) {
                                    try {
                                        var5_8 = (Attribute)var3_3;
                                    }
                                    catch (Exception var6_9) {
                                        System.out.println("class is " + var3_3.getClass().getName());
                                        var6_9.printStackTrace();
                                    }
                                } else {
                                    var5_8 = this.findAttributeType(0x103000, var1_1);
                                }
                                if (var5_8 == null) break block44;
                                var6_10 = "";
                                try {
                                    var6_10 = var5_8.getName();
                                }
                                catch (Exception v0) {}
                                if (!var5_8.isSingleValue()) break block45;
                                try {
                                    if (var6_10 == null) ** GOTO lbl-1000
                                    var7_12 = "assword";
                                    if (var6_10.endsWith("assword")) ** GOTO lbl-1000
                                    var7_12 = "asswd";
                                    if (var6_10.endsWith("asswd")) lbl-1000:
                                    // 2 sources

                                    {
                                        var4_7 |= 0xD00000;
                                        var8_17 = var6_10.length() - var7_12.length() - 1;
                                        var6_10 = String.valueOf(var6_10.substring(0, var8_17)) + "Confirm" + var6_10.substring(var8_17);
                                        this.getAttrPropId(var6_10);
                                    } else if (var6_10 != null && var6_10.equalsIgnoreCase("orclmetaconnlocalacctpass")) {
                                        var4_7 |= 0xD00000;
                                    } else if (var5_8 != null && var5_8.hasJpegSyntax() || var6_10 != null && var6_10.equalsIgnoreCase("jpegphoto")) {
                                        var4_7 |= 0x400000;
                                    } else if (var6_10.equalsIgnoreCase("orclsequence")) {
                                        var4_7 |= 0x200000;
                                    } else if (var6_10.equalsIgnoreCase("orclmetaconnlastckpttime")) {
                                        var4_7 |= 0x300000;
                                    }
                                    var4_7 |= 0x100000;
                                }
                                catch (Exception v1) {
                                    var4_7 |= 0x100000;
                                }
                                break block46;
                            }
                            var4_7 = var6_10.equalsIgnoreCase("userPassword") || var6_10.equalsIgnoreCase("orclmetaconnlocalacctpass") ? (var4_7 |= 0xD00000) : (var6_10.equalsIgnoreCase("orclauditlevel") || var6_10.equalsIgnoreCase("orclcatalogentrydn") ? (var4_7 |= 0x100000) : (var5_8 != null && var5_8.hasJpegSyntax() || var6_10 != null && var6_10.equalsIgnoreCase("jpegphoto") ? (var4_7 |= 0x400000) : (var4_7 |= 0x10100000)));
                        }
                        try {
                            if (var6_10 == null) break block41;
                            var7_13 = 0;
                            while (var7_13 < Root.m_readOnlyAttributes.length) {
                                if (var6_10.equalsIgnoreCase(Root.m_readOnlyAttributes[var7_13])) {
                                    var4_7 |= 393216;
                                    break;
                                }
                                ++var7_13;
                            }
                            var8_17 = 0;
                            while (var8_17 < Root.m_hiddenAttributes.length) {
                                if (var6_10.equalsIgnoreCase(Root.m_hiddenAttributes[var8_17])) {
                                    var4_7 |= 65536;
                                    break;
                                }
                                ++var8_17;
                            }
                        }
                        catch (Exception v2) {}
                    }
                    try {
                        var7_14 = (String)var5_8.getProp(1060869);
                        if (!(var7_14 == null || var7_14.equals("") || var7_14.equalsIgnoreCase("userApplications") || var7_14.equalsIgnoreCase("dsaOperation"))) {
                            var4_7 |= 393216;
                        }
                        break block42;
                    }
                    catch (Exception var7_15) {
                        this.unexpectedException(var7_15);
                    }
                    break block42;
                }
                var6_10 = var1_1.toString();
                var4_7 = var6_10 != null && (var6_10.endsWith("assword") || var6_10.endsWith("asswd")) ? (var4_7 |= 0xD00000) : (var4_7 |= 0x100000);
                if (var6_10 != null) {
                    var7_16 = 0;
                    while (var7_16 < Root.m_readOnlyAttributes.length) {
                        if (var6_10.equalsIgnoreCase(Root.m_readOnlyAttributes[var7_16])) {
                            var4_7 |= 393216;
                            break;
                        }
                        ++var7_16;
                    }
                }
            }
            var2_2 = new Integer(var4_7);
            this.m_attrPropIds.put(var1_1, var2_2);
            if (var1_1 instanceof String) {
                this.m_attrPropIds.put(var2_2, var1_1);
            }
            if (var3_3 == null) break block43;
            try {
                var6_10 = (String)var3_3.getProp(0x103000);
                if (var6_10 != null) {
                    this.m_attrPropIds.put(var6_10.toLowerCase(), var2_2);
                }
            }
            catch (PropertyException var6_11) {
                this.unexpectedException(var6_11);
            }
        }
        return var2_2;
    }

    public Attribute getAttributeByPropId(Integer n) {
        int n2;
        int n3;
        String string = (String)this.m_attrPropIds.get(n);
        if (string == null) {
            return null;
        }
        if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            n3 = 0x103000;
            n2 = 0x103013;
        } else {
            n2 = 0x103000;
            n3 = 0x103013;
        }
        Attribute attribute = this.findAttributeType(n2, string);
        if (attribute == null) {
            attribute = this.findAttributeType(n3, string);
        }
        return attribute;
    }

    public boolean validAttributePropId(Integer n) {
        return this.getAttributeByPropId(n) != null;
    }

    protected void finalize() {
    }

    public boolean isServerGreaterThan(String string) {
        int n;
        Object object;
        int n2;
        if (this.m_dseAttributes == null || this.m_dseAttributes.length == 0) {
            return false;
        }
        if (this.m_serverVer == null) {
            n2 = 0;
            while (n2 < this.m_dseAttributes.length) {
                String string2 = this.m_serverAccess.getType(this.m_dseAttributes[n2]);
                if (string2.equalsIgnoreCase("orcldirectoryversion")) {
                    object = this.m_serverAccess.getValues(this.m_dseAttributes[n2]);
                    this.m_serverVer = object[0];
                    break;
                }
                ++n2;
            }
        }
        if (this.m_serverVer == null) {
            return false;
        }
        if (this.m_isVerGreater) {
            return true;
        }
        n2 = this.m_serverVer.indexOf(" ");
        object = this.m_serverVer.substring(n2 + 1, n = this.m_serverVer.indexOf("."));
        int n3 = new Integer((String)object);
        if (n3 < 2) {
            return false;
        }
        if (n3 > 2) {
            this.m_isVerGreater = true;
            return true;
        }
        String string3 = this.m_serverVer.substring(n + 1);
        object = string3.substring(0, string3.indexOf("."));
        n3 = new Integer((String)object);
        if (n3 == 0) {
            return false;
        }
        this.m_isVerGreater = true;
        return true;
    }

    public void initDSE() {
        if (this.m_sysOpParams != null || this.m_dseAttributes == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("Building DSE Entry");
        }
        try {
            DSEEntry dSEEntry;
            this.m_sysOpParams = dSEEntry = new DSEEntry(this, null, LDAPLang.getStrSysOpAttrs(), this.m_dseAttributes);
            dSEEntry.setProp(1048745, (Object)"viewing_server_attributes");
            Integer n = this.getAttrPropId("dn");
            dSEEntry.unregisterProp(n);
            n = this.getAttrPropId("matchingRules");
            dSEEntry.unregisterProp(n);
            n = this.getAttrPropId("namingcontexts");
            this.m_namingCtxPropId = n;
            dSEEntry.getProp(n);
            this.m_children.insertElementAt(dSEEntry, 0);
            this.m_children.removeElement(m_dummySysOpParams);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void searchFoundEntry(Object object) {
        try {
            this.searchFoundEntry2(object);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void reloadSchemaModifiers() {
        if (this.m_catalogDn != null) {
            int n = this.m_catalogDn.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.m_catalogDn.elementAt(n2);
                try {
                    this.m_serverAccess.findObject(string, null, ATTR_CATALOG_ENTRY_DN);
                }
                catch (Exception exception) {
                    this.setErrorMessage(String.valueOf(LDAPLang.getStrExecutionFailed()) + " " + exception);
                }
                ++n2;
            }
        }
        try {
            this.m_serverAccess.findObject(ATTR_BASE_SCHEMA_LIST, null, ATTR_BASE_SCHEMA_LIST);
            return;
        }
        catch (Exception exception) {
            this.setErrorMessage(String.valueOf(LDAPLang.getStrExecutionFailed()) + " " + exception);
            return;
        }
    }

    public void searchFoundEntry2(Object object) {
        if (DEBUG) {
            System.out.println("Search found something");
        }
        Object object2 = this.m_serverAccess.getSearchEntry(object);
        Object object3 = this.m_serverAccess.getUserParm(object);
        if (debugSearchEntry) {
            this.setDebug(true);
        }
        if (object3 == this) {
            String string;
            int n;
            String[] stringArray;
            String string2;
            this.debugMessageLn("search for DSE completed");
            this.loadOptions();
            Object[] objectArray = this.m_serverAccess.getAttributes(object2);
            this.m_children = new Vector();
            this.m_children.addElement(m_dummySysOpParams);
            this.m_newChildren = null;
            this.m_dseAttributes = objectArray;
            this.m_sysOpParams = null;
            if (this.m_refreshSysOp) {
                return;
            }
            this.m_namingContexts = new NamingContexts(this, null);
            this.m_children.addElement(new SubSchemaDns(this, this.getSubSchemas()));
            this.m_children.addElement(new SubACLDns(this, this.getSubACLDns()));
            if (this.m_directory != null) {
                this.m_children.addElement(this.m_directory);
            } else {
                this.m_directory = new Directory(this);
                this.m_children.addElement(this.m_directory);
            }
            this.m_children.addElement(new DirTree(this, null));
            if (this.m_adminNamesHolder != null) {
                this.m_children.addElement(this.m_adminNamesHolder);
            } else {
                this.m_adminNamesHolder = new Names(this, null);
                this.m_children.addElement(this.m_adminNamesHolder);
            }
            this.m_serverManager = new Procs(this);
            this.m_children.addElement(this.m_serverManager);
            if (this.m_acpoption == 1) {
                this.m_acpMgmt = new ACPsMgmt(this);
                this.m_children.addElement(this.m_acpMgmt);
            } else {
                this.m_accessCtrlPoints = new AccessCtrlPoints(this);
                this.m_children.addElement(this.m_accessCtrlPoints);
            }
            this.m_auditLogs = new AuditLogs(this);
            this.m_children.addElement(this.m_auditLogs);
            int n2 = 0;
            while (n2 < objectArray.length) {
                string2 = this.m_serverAccess.getType(objectArray[n2]);
                this.debugMessageLn("DSE type=" + string2);
                stringArray = this.m_serverAccess.getValues(objectArray[n2]);
                if (stringArray != null) {
                    if (string2.equalsIgnoreCase(ATTR_NAME_FOR_DN_OF_ACL)) {
                        n = 0;
                        while (n < stringArray.length) {
                            string = stringArray[n];
                            this.debugMessageLn("dn acl=" + string);
                            try {
                                this.m_serverAccess.incrementRequestCount();
                                AccessList accessList = new AccessList(this, string);
                                this.findACL(string, null, accessList);
                                this.addSubACLDns(accessList);
                            }
                            catch (Exception exception) {
                                this.setErrorMessage(String.valueOf(LDAPLang.getStrExecutionFailed()) + " " + exception);
                            }
                            ++n;
                        }
                    } else if (string2.equalsIgnoreCase(ATTR_CATALOG_ENTRY_DN)) {
                        n = 0;
                        while (n < stringArray.length) {
                            string = stringArray[n];
                            if (this.m_catalogDn == null) {
                                this.m_catalogDn = new Vector();
                            }
                            this.debugMessageLn("dn catelog entry=" + string);
                            this.m_catalogDn.addElement(string);
                            ++n;
                        }
                    } else if (this.isDebug()) {
                        n = 0;
                        while (n < stringArray.length) {
                            string = stringArray[n];
                            this.debugMessageLn("DSE value=" + string);
                            ++n;
                        }
                    }
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < objectArray.length) {
                string2 = this.m_serverAccess.getType(objectArray[n3]);
                this.debugMessageLn("DSE type=" + string2);
                stringArray = this.m_serverAccess.getValues(objectArray[n3]);
                if (stringArray != null && string2.equalsIgnoreCase(ATTR_NAME_FOR_DN_OF_SUBSCHEMA)) {
                    n = 0;
                    while (n < stringArray.length) {
                        string = stringArray[n];
                        this.debugMessageLn("dn subschema=" + string);
                        try {
                            this.m_serverAccess.incrementRequestCount();
                            SubSchema subSchema = new SubSchema(this, string);
                            this.addSubSchemas(subSchema);
                            this.findSubschema(string, null, subSchema);
                            this.m_directory.setSubSchema(subSchema);
                        }
                        catch (Exception exception) {
                            this.setErrorMessage(String.valueOf(LDAPLang.getStrExecutionFailed()) + " " + exception);
                        }
                        ++n;
                    }
                }
                ++n3;
            }
            this.setStatusMessage(LDAPLang.getStrReady());
        } else if (object3 instanceof String && object3.equals(ATTR_BASE_SCHEMA_LIST)) {
            Object[] objectArray = this.m_serverAccess.getAttributes(object2);
            int n = 0;
            while (n < objectArray.length) {
                String string = this.m_serverAccess.getType(objectArray[n]);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                bl = string.equalsIgnoreCase("orclbaseattribute");
                if (bl || (bl2 = string.equalsIgnoreCase("orclbaseobjectclass")) || (bl3 = string.equalsIgnoreCase("orclbaseelement"))) {
                    this.debugMessageLn("Base Schema List Type=" + string);
                    String[] stringArray = this.m_serverAccess.getValues(objectArray[n]);
                    if (stringArray != null) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            SchemaObject schemaObject;
                            String string3 = stringArray[n4];
                            if ((bl || bl3) && (schemaObject = this.findAttributeType(1519616, string3)) != null) {
                                if (DEBUG) {
                                    System.out.println("attr.setReadonly() = " + string3);
                                }
                                schemaObject.setReadonly(true);
                            }
                            if ((bl2 || bl3) && (schemaObject = this.findObjectClass(0x103000, string3)) != null) {
                                if (DEBUG) {
                                    System.out.println("objectClass.setReadonly = " + string3);
                                }
                                schemaObject.setReadonly(true);
                            }
                            ++n4;
                        }
                    }
                }
                ++n;
            }
        } else if (object3 instanceof String && object3.equals(ATTR_CATALOG_ENTRY_DN)) {
            boolean bl = true;
            Object[] objectArray = this.m_serverAccess.getAttributes(object2);
            int n = 0;
            while (n < objectArray.length) {
                String string = this.m_serverAccess.getType(objectArray[n]);
                if (string.equalsIgnoreCase("orclindexedattribute") || string.equalsIgnoreCase("orclindexedattributes")) {
                    this.debugMessageLn("Attr Catalog entry type=" + string);
                    String[] stringArray = this.m_serverAccess.getValues(objectArray[n]);
                    if (stringArray != null) {
                        int n5 = 0;
                        while (n5 < stringArray.length) {
                            Attribute attribute;
                            String string4 = stringArray[n5];
                            if (DEBUG) {
                                System.out.println("attr.findAttributeType() searching for " + string4);
                            }
                            if ((attribute = this.findAttributeType(1519616, string4)) != null) {
                                if (bl) {
                                    bl = false;
                                    SubSchema subSchema = attribute.getSubSchema();
                                    subSchema.setCataloged(false);
                                }
                                if (DEBUG) {
                                    System.out.println("attr.setCataloged() " + string4);
                                }
                                attribute.setCataloged(true);
                            } else if (DEBUG) {
                                System.out.println("Couldn't find cataloged attribute: " + string4);
                            }
                            ++n5;
                        }
                    }
                }
                ++n;
            }
        } else if (object3 instanceof SubSchema) {
            try {
                SubSchema subSchema = (SubSchema)object3;
                if (debugLoadSchema) {
                    this.setDebug(true);
                    this.debugMessageLn("Search for Subschema completed");
                    subSchema.setDebug(true);
                }
                subSchema.parseSubschema(object);
                if (debugLoadSchema) {
                    subSchema.setDebug(false);
                    this.setDebug(false);
                }
                subSchema.updateClient();
                this.reloadSchemaModifiers();
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
            this.initDSE();
            this.sendAdminPropertyChangeEvents(273612805, null);
        } else if (object3 instanceof AccessList) {
            try {
                AccessList accessList = (AccessList)object3;
                if (debugLoadSchema) {
                    this.setDebug(true);
                    this.debugMessageLn("Search for ACL completed");
                }
                Object[] objectArray = this.m_serverAccess.getAttributes(object2);
                int[] nArray = new int[1];
                int n = 0;
                while (n < objectArray.length) {
                    String string = this.m_serverAccess.getType(objectArray[n]);
                    if (debugLoadSchema) {
                        this.debugMessageLn("type=" + string);
                    }
                    if (string.equalsIgnoreCase(ACCESSDIRECTIVE)) {
                        String[] stringArray = this.m_serverAccess.getValues(objectArray[n]);
                        int n6 = 0;
                        while (n6 < stringArray.length) {
                            nArray[0] = 0;
                            if (debugLoadSchema) {
                                this.debugMessageLn("aci= '" + stringArray[n6] + "'");
                            }
                            accessList.addAccessItem(new AccessItem(this, stringArray[n6], nArray, accessList));
                            ++n6;
                        }
                    }
                    ++n;
                }
                if (debugLoadSchema) {
                    this.debugMessageLn("Done");
                    this.setDebug(false);
                }
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
        } else if (object3 instanceof DirTree) {
            String string;
            DirTree dirTree = (DirTree)object3;
            String string5 = string = this.m_serverAccess.getName(object2);
            int n = string5.indexOf(",");
            if (dirTree.isEntryRefreshed()) {
                dirTree.update(this.m_serverAccess.getAttributes(object2));
            } else {
                DirTree dirTree2 = new DirTree(this, null, string, n <= 0 ? string5 : string5.substring(0, n), null, false);
                dirTree.addChild(dirTree2);
            }
        } else if (object3 instanceof AuditLogs) {
            String string;
            boolean bl = debugConfMgmt;
            if (bl) {
                this.setDebug(true);
            }
            if (bl) {
                this.debugMessageLn("AuditLogs result");
            }
            AuditLogs auditLogs = (AuditLogs)object3;
            String string6 = string = this.m_serverAccess.getName(object2);
            int n = string6.indexOf("=");
            int n7 = string6.indexOf(",");
            AuditLog auditLog = new AuditLog(this, string, n7 <= 0 ? string6 : string6.substring(n + 1, n7), this.m_serverAccess.getAttributes(object2));
            auditLogs.addChild(auditLog);
            if (bl) {
                this.debugMessageLn("AuditLogs result Done.");
            }
        } else if (object3 instanceof Directory) {
            if (debugSearchEntry) {
                this.setDebug(true);
            }
            try {
                Directory directory = (Directory)object3;
                if (debugSearchEntry) {
                    this.debugMessageLn("Search for Directory Entry completed");
                    this.debugMessageLn("dn=" + this.m_serverAccess.getName(object2));
                }
                String string = this.m_serverAccess.getName(object2);
                try {
                    String string7 = string = this.m_serverAccess.getName(object2);
                    int n = string7.indexOf(",");
                    DirTree dirTree = new DirTree(this, directory, string, n <= 0 ? string7 : string7.substring(0, n), null, false);
                    directory.addChild(dirTree);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (debugSearchEntry) {
                    this.debugMessageLn("Done");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (debugSearchEntry) {
                this.setDebug(false);
            }
        } else if (object3 instanceof NamingContexts) {
            if (debugLoadSchema) {
                this.setDebug(true);
            }
            try {
                NamingContexts namingContexts = (NamingContexts)object3;
                if (debugLoadSchema) {
                    this.debugMessageLn("Search for naming contexts completed");
                    this.debugMessageLn("dn=" + this.m_serverAccess.getName(object2));
                }
                String string = this.m_serverAccess.getName(object2);
                Object[] objectArray = this.m_serverAccess.getAttributes(object2);
                Entry entry = null;
                if (this.isDebug()) {
                    int n = 0;
                    while (n < objectArray.length) {
                        String string8 = this.m_serverAccess.getType(objectArray[n]);
                        if (debugLoadSchema) {
                            this.debugMessageLn("type=" + string8);
                        }
                        String[] stringArray = this.m_serverAccess.getValues(objectArray[n]);
                        if (debugLoadSchema) {
                            int n8 = 0;
                            while (n8 < stringArray.length) {
                                this.debugMessageLn("val=" + stringArray[n8]);
                                ++n8;
                            }
                        }
                        ++n;
                    }
                }
                try {
                    entry = new Entry(this, null, string, objectArray);
                    entry.setProp(2686979, (Object)new Integer(1));
                    namingContexts.addChild(entry);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (debugLoadSchema) {
                    this.debugMessageLn("Done");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (debugLoadSchema) {
                this.setDebug(false);
            }
        } else if (object3 instanceof Procs) {
            String string;
            boolean bl = debugConfMgmt;
            if (bl) {
                this.setDebug(true);
            }
            if (bl) {
                this.debugMessageLn("Procs result");
            }
            Procs procs = (Procs)object3;
            String string9 = string = this.m_serverAccess.getName(object2);
            int n = string9.indexOf("=");
            int n9 = string9.indexOf(",");
            Proc proc = new Proc(this, string, n9 <= 0 ? string9 : string9.substring(n + 1, n9), this.m_serverAccess.getAttributes(object2));
            procs.addChild(proc);
            if (bl) {
                this.debugMessageLn("Procs result Done.");
            }
        } else if (object3 instanceof Proc) {
            boolean bl = debugConfMgmt;
            if (bl) {
                this.debugMessageLn("Proc result");
            }
            Proc proc = (Proc)object3;
            String string = this.m_serverAccess.getName(object2);
            if (string.indexOf("catalogs") > 0) {
                return;
            }
            if (bl) {
                this.setDebug(true);
            }
            boolean bl4 = string.indexOf(DN_FOR_CONF_MGMT) > 0;
            boolean bl5 = string.indexOf(DN_FOR_CONF_MGMT_META) > 0;
            String string10 = string;
            int n = string10.indexOf(",");
            if (bl4) {
                ProcConfSet procConfSet = new ProcConfSet(this, string, n <= 0 ? string10 : string10.substring(0, n), this.m_serverAccess.getAttributes(object2));
                proc.addConfSet(procConfSet);
            } else if (bl5) {
                ProcMetaConfSet procMetaConfSet = new ProcMetaConfSet(this, string, n <= 0 ? string10 : string10.substring(0, n), this.m_serverAccess.getAttributes(object2));
                proc.addConfSet(procMetaConfSet);
            } else {
                ProcInst procInst = new ProcInst(this, string, n <= 0 ? string10 : string10.substring(0, n), this.m_serverAccess.getAttributes(object2));
                proc.addProcInst(procInst);
            }
            if (bl) {
                this.debugMessageLn("Proc result Done.");
            }
        } else if (object3 instanceof ProcMetaConfSet) {
            String string;
            boolean bl = debugConfMgmt;
            if (bl) {
                this.setDebug(true);
            }
            if (bl) {
                this.debugMessageLn("ProcMetaConfSet result");
            }
            ProcMetaConfSet procMetaConfSet = (ProcMetaConfSet)object3;
            String string11 = string = this.m_serverAccess.getName(object2);
            int n = string11.indexOf("=");
            int n10 = string11.indexOf(",");
            ProcConnector procConnector = new ProcConnector(this, string, n10 <= 0 ? string11 : string11.substring(n + 1, n10), this.m_serverAccess.getAttributes(object2), procMetaConfSet.getHolder());
            procMetaConfSet.addChild(procConnector);
            if (bl) {
                this.debugMessageLn("ProcMetaConfSet result Done.");
            }
        } else if (object3 instanceof Connectors) {
            String string;
            boolean bl = debugConfMgmt;
            if (bl) {
                this.setDebug(true);
            }
            if (bl) {
                this.debugMessageLn("Connectors result");
            }
            Connectors connectors = (Connectors)object3;
            String string12 = string = this.m_serverAccess.getName(object2);
            int n = string12.indexOf("=");
            int n11 = string12.indexOf(",");
            ProcConnector procConnector = new ProcConnector(this, string, n11 <= 0 ? string12 : string12.substring(n + 1, n11), this.m_serverAccess.getAttributes(object2), connectors.getHolder());
            connectors.addChild(procConnector);
            if (bl) {
                this.debugMessageLn("Connectors result Done.");
            }
        } else if (object3 instanceof ProcConnector) {
            boolean bl = debugConfMgmt;
            if (bl) {
                this.setDebug(true);
            }
            if (bl) {
                this.debugMessageLn("ProcConnector result");
            }
            ProcConnector procConnector = (ProcConnector)object3;
            String string = this.m_serverAccess.getName(object2);
            Entry entry = new Entry(this, null, string, this.m_serverAccess.getAttributes(object2), true);
            procConnector.addSyncNameCtx(entry);
            if (bl) {
                this.debugMessageLn("ProcConnector result Done.");
            }
        } else if (object3 instanceof AgreementDNs) {
            String string;
            boolean bl = debugConfMgmt;
            if (bl) {
                this.setDebug(true);
            }
            if (bl) {
                this.debugMessageLn("AgreementDNs result");
            }
            AgreementDNs agreementDNs = (AgreementDNs)object3;
            String string13 = string = this.m_serverAccess.getName(object2);
            int n = string13.indexOf(",");
            AgreementDN agreementDN = new AgreementDN(this, string, n <= 0 ? string13 : string13.substring(0, n), this.m_serverAccess.getAttributes(object2));
            agreementDNs.addChild(agreementDN);
            if (bl) {
                this.debugMessageLn("AgreementDNs result Done.");
            }
        } else if (!(object3 instanceof NewAccessCtrlPoint)) {
            if (object3 instanceof AccessCtrlPoints) {
                String string;
                AccessCtrlPoints accessCtrlPoints = (AccessCtrlPoints)object3;
                String string14 = string = this.m_serverAccess.getName(object2);
                int n = string14.indexOf(",");
                AccessCtrlPoint accessCtrlPoint = new AccessCtrlPoint(this, string, n <= 0 ? string14 : string14.substring(0, n), null, false, accessCtrlPoints);
                accessCtrlPoints.addChild(accessCtrlPoint);
            } else if (object3 instanceof AccessCtrlPoint) {
                AccessCtrlPoint accessCtrlPoint = (AccessCtrlPoint)object3;
                accessCtrlPoint.update(this.m_serverAccess.getAttributes(object2));
            } else {
                System.out.println("Got unknown search results: " + object3);
            }
        }
        if (debugSearchEntry) {
            this.setDebug(false);
        }
    }

    public void setErrorMessage(String string) {
        if (this.m_serverAccess != null) {
            this.m_serverAccess.setErrorMessage(string);
        }
        super.setErrorMessage(string);
    }

    public String getErrorMessage() {
        if (this.m_serverAccess != null) {
            return this.m_serverAccess.getErrorMessage();
        }
        return super.getErrorMessage();
    }

    public String[] getAttributeNames() throws PropertyException {
        return this.m_directory.getAttributeNames();
    }

    public String[] getAttributeNames(String string, boolean bl, boolean bl2) throws PropertyException {
        return this.m_directory.getAttributeNames(string, bl, bl2);
    }

    public String[] getOperationNames() {
        return this.m_directory.getOperationNames();
    }

    public Directory getDirectory() {
        return this.m_directory;
    }

    public IAdminProp createObjectClass() {
        int n = this.m_subSchemas.size();
        int n2 = 0;
        if (n2 < n) {
            SubSchema subSchema = (SubSchema)this.m_subSchemas.elementAt(n2);
            return subSchema.createObjectClass();
        }
        return null;
    }

    public IAdminProp createAttribute() {
        int n = this.m_subSchemas.size();
        int n2 = 0;
        if (n2 < n) {
            SubSchema subSchema = (SubSchema)this.m_subSchemas.elementAt(n2);
            return subSchema.createAttribute();
        }
        return null;
    }

    public IAdminProp createEntry() {
        return this.m_directory.createChild();
    }

    public IAdminProp createACP() {
        return this.m_accessCtrlPoints.createChild();
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    boolean getSSLEnabled() {
        return this.m_ssl_enabled;
    }

    String getSSLLevel() {
        return this.m_sslLevel;
    }

    String getSSLLocation() {
        return this.m_sslLocation;
    }

    String getSSLPassword() {
        return this.m_sslPassword;
    }

    public int getAcpoption() {
        return this.m_acpoption;
    }

    public void setAcpoption(int n) {
        this.m_acpoption = n;
    }

    public int getTimelimit() {
        return this.m_timelimit;
    }

    public void setTimelimit(int n) {
        this.m_timelimit = n;
    }

    public int getSizelimit() {
        return this.m_sizelimit;
    }

    public void setSizelimit(int n) {
        this.m_sizelimit = n;
    }

    public void saveData() {
        this.m_rootServerList.saveData("dummy");
    }

    public Server getCurrentServer() {
        return this.m_server;
    }

    public void loadOptions() {
        if (this.m_rootServerList == null) {
            return;
        }
        if (this.m_server == null) {
            this.m_server = this.m_rootServerList.getCurrentServer(this.m_host, this.m_port);
        }
        if (this.m_server != null) {
            this.m_acpoption = this.m_server.getAcpOption();
            this.m_sizelimit = this.m_server.getSizeLimit();
            this.m_timelimit = this.m_server.getTimeLimit();
            this.m_rootServerList.unsetDefServer();
            this.m_server.setDefaultServer();
            this.m_rootServerList.saveData("dummy");
        }
    }

    static {
        m_readOnlyAttributes = new String[]{"orclSymmetricAgreement", "orclDirReplGroupAgreement", "changeLog", "changeStatus", "orclAgreementId", "orclReplicationProtocol", "orclreplagreements", "createTimestamp", "orclDbType", "creatorsName", ATTR_CATALOG_ENTRY_DN, "orclguid", "orclsequence", "orcleventtime", "orclopresult", "orcleventtype", "orclauditmessage", "orclmetaconnbinddn", "orclmetaconnconfigrefreshflag", "dn", "orclmetaconnname"};
        m_hiddenAttributes = new String[]{"orclaci", "orclDbType", "orclSuffix", "orclDitRoot", "orclEntrylevelaci", "orclsslversion", "orclmetaconnconfigdns", "orclmetaconnserverinstance", "orclmetaconninstance", "orclmetaconnname", "orcloptcontainsquery"};
    }

    class RootServerList
    extends ServerList {
        Root m_root;

        public RootServerList(Root root2) {
            Root.this = Root.this;
            this.setChildren(root2.m_parent.getServerList().getChildren());
            this.m_root = root2;
        }

        public Object getProp(int n) throws PropertyException {
            switch (n) {
                case 8978950: {
                    return Boolean.TRUE;
                }
                case 2031768: {
                    return LDAPLang.getStrServerListTitle();
                }
                case 2162725: {
                    return new Integer(55360);
                }
            }
            return super.getProp(n);
        }

        public void saveChanges(int n) throws SaveChangeException {
            super.saveChanges(n);
            try {
                IAdminProp[] iAdminPropArray = (IAdminProp[])this.getProp(273220105);
                if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                    this.m_root.sendAdminPropertyChangeEvents(282001422, null);
                    return;
                }
                Server server = (Server)iAdminPropArray[0];
                int[] nArray = new int[]{1650690, 3026947};
                Object[] objectArray = new Object[]{server.getHost(), server.getPort()};
                this.m_root.setProps(nArray, objectArray);
                this.m_root.sendAdminPropertyChangeEvents(282001422, null);
                return;
            }
            catch (Exception exception) {
                throw new SaveChangeException(exception);
            }
        }
    }
}

