/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.MatchingRule;
import oracle.ldap.admin.NewObjectClass;
import oracle.ldap.admin.ObjectClass;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SubSchema;
import oracle.ldap.admin.Syntax;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class SchemaObject
extends AdminProp {
    public static boolean NO_SYNTAX_LOV;
    static final char LEFT_PAREN = '(';
    static final char RIGHT_PAREN = ')';
    static final int PR_NAME = 0x103000;
    static final int PR_SHORT_NAME = 1519616;
    static final int PR_DESC = 1060866;
    static final int PR_SYNTAX = 0x103003;
    static final int PR_SIZE = 2109444;
    static final int PR_USAGE = 1060869;
    static final int PR_ORDERING = 1060870;
    static final int PR_EQUALITY = 1060871;
    static final int PR_SUBSTR = 1060872;
    static final int PR_SUP = 269496329;
    static final int PR_MUST = 269496330;
    static final int PR_MAY = 269496331;
    static final int PR_NO_USER_MOD = 8466444;
    static final int PR_ABSTRACT = 8466445;
    static final int PR_STRUCTURAL = 8466446;
    static final int PR_AUXILIARY = 8466447;
    static final int PR_OBSOLETE = 8466448;
    static final int PR_SINGLE_VALUE = 8400913;
    static final int PR_SINGLE_VALUE_READONLY = 8794129;
    static final int PR_COLLECTIVE = 8400914;
    static final int PR_OID = 0x103013;
    static final int PR_EXISTING = 8466452;
    static final int PR_INDEX = 8466453;
    static final int PR_IS_CATALOGED = 8794113;
    static final int PR_IS_CATALOGED_WRITABLE = 8400897;
    static final int PR_PROPID = 2174998;
    static final int PR_TYPE = 1060887;
    static final int PR_SELECT_SUP = 272642072;
    static final int PR_SELECT_MAY = 272642073;
    static final int PR_SELECT_MUST = 272642074;
    static final int PR_SUP_OBJS = 4206619;
    static final int PR_MUST_OBJS = 4206620;
    static final int PR_MAY_OBJS = 4206621;
    static final String[] keyList;
    static int[] idKeyList;
    static final String[] modList;
    static final int[] idModList;
    static final String[] ATTRIBUTEUSAGES;
    boolean m_bValid = true;
    String m_originalString;
    boolean m_readonly = false;
    static final int OBJECT_ID = 1;
    static final int KEY = 2;
    static final int VALUE = 3;
    SubSchema m_subSchema;
    boolean m_bExisting = false;
    Root m_parent;
    static final int[] m_printQuotesList;
    static int[] m_printOrderList;
    Hashtable _syntaxHashtable;
    static final String[] m_printKeyList;
    private boolean m_convertOk = true;

    public String getOriginalString() {
        return this.m_originalString;
    }

    public void setOriginalString(String string) {
        this.m_originalString = string;
    }

    public boolean isReadonly() {
        return this.m_readonly;
    }

    public void setReadonly(boolean bl) {
        this.m_readonly = bl;
        this.sendAdminPropertyChangeEvents(1638408, null);
    }

    public void setSubSchema(SubSchema subSchema) {
        this.m_subSchema = subSchema;
    }

    public SubSchema getSubSchema() {
        return this.m_subSchema;
    }

    public void init() {
        this.registerProp(0x103000, LDAPLang.getStrDisplayNamePlbl1(), LDAPLang.getStrNamePdsc2());
        this.registerProp(0x103003, LDAPLang.getStrSyntaxPlbl(), LDAPLang.getStrSyntaxPdsc());
        String string = "The object's usage (e.g. one of ";
        int n = 0;
        while (n < ATTRIBUTEUSAGES.length) {
            string = String.valueOf(string) + ATTRIBUTEUSAGES[n];
            if (n != ATTRIBUTEUSAGES.length - 1) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
        }
        string = ")";
        this.registerProp(1060869, LDAPLang.getStrUsagePlbl(), string);
        this.registerProp(1060870, LDAPLang.getStrOrderingPlbl(), LDAPLang.getStrOrderingPdsc());
        this.registerProp(1060871, LDAPLang.getStrEqualityPlbl(), LDAPLang.getStrEqualityPdsc1());
        this.registerProp(1060872, LDAPLang.getStrSubstrPlbl1(), LDAPLang.getStrSubstrPdsc());
        this.registerProp(1060866, LDAPLang.getStrDescPlbl(), LDAPLang.getStrDescPdsc());
        this.registerProp(8466444, LDAPLang.getStrNoUserModPlbl(), LDAPLang.getStrNoUserModPdsc1());
        this.registerProp(8466445, LDAPLang.getStrAbstractPlbl(), LDAPLang.getStrAbstractPdsc1());
        this.registerProp(8466453, LDAPLang.getStrIndexPlbl(), LDAPLang.getStrIndexPdsc1());
        this.registerProp(8466446, LDAPLang.getStrStructuralPlbl(), LDAPLang.getStrStructuralPdsc());
        this.registerProp(8466447, LDAPLang.getStrAuxiliaryPlbl1(), LDAPLang.getStrAuxiliaryPdsc1());
        this.registerProp(8466448, LDAPLang.getStrObsoletePlbl(), LDAPLang.getStrObsoletePdsc());
        this.registerProp(8400913, LDAPLang.getStrSingleValuePlbl(), LDAPLang.getStrSingleValuePdsc1());
        this.registerProp(0x103013, LDAPLang.getStrOidPlbl(), LDAPLang.getStrOidPdsc());
        this.registerProp(8466452, LDAPLang.getStrExistingPlbl(), LDAPLang.getStrExistingPdsc1());
    }

    public void registerMessages() {
        super.registerMessages();
    }

    public SchemaObject() {
    }

    public SchemaObject(String string, int[] nArray, SubSchema subSchema) {
        this.m_subSchema = subSchema;
        this.m_originalString = string;
        this.parseSubschemaAttributeValue(nArray, string);
        try {
            this.setExisting(true);
            this.setProp(8466452, (Object)Boolean.TRUE);
            return;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return;
        }
    }

    String fixupValue(String string) {
        int n;
        while ((n = string.indexOf(10)) > 0 || (n = string.indexOf(13)) > 0) {
            string = n == string.length() ? string.substring(0, n) : (n == 0 ? string.substring(n + 1) : String.valueOf(string.substring(0, n)) + string.substring(n + 1));
        }
        return string;
    }

    boolean isExisting() {
        return this.m_bExisting;
    }

    void setExisting(boolean bl) {
        this.m_bExisting = bl;
    }

    public void setModified(boolean bl) {
        super.setModified(true);
        this.sendAdminPropertyChangeEvents(3080204, null);
    }

    String getName() throws PropertyException {
        Object object = this.getProp(0x103000);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public String getSyntax() throws PropertyException {
        Object object = this.getProp(0x103003);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public Object getProp2(int n) throws PropertyException {
        if (n == 0x103003) {
            return (String)this.getProp(0x103003);
        }
        if (n == 1519616) {
            int n2;
            String string = (String)this.getProp(0x103000);
            if (string != null && (n2 = string.indexOf(";")) > 0) {
                return string.substring(0, n2);
            }
            return string;
        }
        return this.getProp(n);
    }

    public void setProp2(int n, Object object) throws PropertyException {
        if (n == 0x103003) {
            object = (String)object;
        }
        this.setProp(n, object);
    }

    public Root getParent() {
        return this.m_parent;
    }

    public void setParent(Root root) {
        this.m_parent = root;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "understanding_directory_schema";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 276758675: {
                return this.getLOV((int[])this.getProp(282001422));
            }
            case 282001422: {
                int[] nArray = (int[])super.getProp(282001422);
                if (nArray == null) {
                    System.out.println("No visible properties");
                    return null;
                }
                if ((nArray = this.sortInPrintOrder(nArray)) == null) {
                    System.out.println("Sort failed");
                    return null;
                }
                if (nArray[0] == 0x103013) {
                    int n2 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n2;
                }
                return nArray;
            }
            case 281608215: {
                int[] nArray = (int[])super.getProp(282001422);
                int n3 = 0;
                int n4 = 0;
                while (n4 < nArray.length) {
                    switch (nArray[n4]) {
                        default: {
                            ++n3;
                        }
                        case 0x103000: 
                        case 0x103013: 
                    }
                    ++n4;
                }
                if (n3 != nArray.length) {
                    int[] nArray2 = new int[n3];
                    n3 = 0;
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        switch (nArray[n5]) {
                            default: {
                                nArray2[n3++] = nArray[n5];
                            }
                            case 0x103000: 
                            case 0x103013: 
                        }
                        ++n5;
                    }
                    return nArray2;
                }
                return nArray;
            }
            case 281608214: {
                n = 282001422;
                break;
            }
            case 0x790007: {
                n = 0x103013;
                break;
            }
            case 4784130: {
                return this.m_subSchema;
            }
            case 0x110001: {
                return this.getProp(0x103000);
            }
            case 2686979: {
                return new Integer(3);
            }
            case 2687386: {
                return new Integer(0x400000);
            }
            case 3080204: {
                if (!this.m_bValid) {
                    return new Integer(1);
                }
                return new Integer(0x2004 | (this.isModified() ? 2 : 0));
            }
            case 0x1F000F: {
                return this.m_subSchema.getProp(0x1F000F);
            }
            case 1060887: {
                if (this.getBoolean(8466445)) {
                    return LDAPLang.getStrAbstractPlbl();
                }
                if (this.getBoolean(8466446)) {
                    return LDAPLang.getStrStructuralPlbl();
                }
                if (this.getBoolean(8466447)) {
                    return LDAPLang.getStrAuxiliaryPlbl1();
                }
                return LDAPLang.getStrBindNone();
            }
            case 1519616: {
                int n6;
                String string = (String)this.getProp(0x103000);
                if (string != null && (n6 = string.indexOf(";")) > 0) {
                    return string.substring(0, n6);
                }
                return string;
            }
        }
        Object object = super.getProp(n);
        if (object == null) {
            switch (n) {
                case 1060866: 
                case 0x103003: 
                case 1060869: 
                case 1060870: 
                case 1060871: 
                case 1060872: 
                case 0x103013: 
                case 1060887: {
                    object = "";
                    break;
                }
                case 8400913: 
                case 8400914: 
                case 8466444: 
                case 8466445: 
                case 8466446: 
                case 8466447: 
                case 8466448: 
                case 8466453: {
                    object = Boolean.FALSE;
                    break;
                }
            }
        }
        return object;
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 4784130: {
                return;
            }
            case 1060887: {
                Boolean bl = Boolean.FALSE;
                Boolean bl2 = Boolean.FALSE;
                Boolean bl3 = Boolean.FALSE;
                String string = (String)object;
                if (string != null) {
                    if (string.equals(LDAPLang.getStrAbstractPlbl())) {
                        bl = Boolean.TRUE;
                    } else if (string.equals(LDAPLang.getStrStructuralPlbl())) {
                        bl2 = Boolean.TRUE;
                    } else if (string.equals(LDAPLang.getStrAuxiliaryPlbl1())) {
                        bl3 = Boolean.TRUE;
                    }
                }
                this.setProp(8466445, (Object)bl);
                this.setProp(8466446, (Object)bl2);
                this.setProp(8466447, (Object)bl3);
                this.setModified(true);
                return;
            }
        }
        this.setModified(true);
        super.setProp(n, object);
    }

    static boolean isSpace(String string, int n) {
        if (n >= string.length()) {
            return false;
        }
        char c = string.charAt(n);
        return Character.isSpaceChar(c);
    }

    static String removeQuotes(String string) {
        if (string.charAt(0) == '\'' && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.charAt(0) == '\'') {
            return string.substring(1, string.length());
        }
        if (string.endsWith("'")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    int isOnTokenList(String[] stringArray, int[] nArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return nArray[n];
            }
            ++n;
        }
        return 0;
    }

    static void skipSpace(String string, int[] nArray) {
        int n = string.length();
        while (SchemaObject.isSpace(string, nArray[0]) && nArray[0] < n) {
            nArray[0] = nArray[0] + 1;
        }
    }

    static void skipNonSpace(String string, int[] nArray) {
        int n = string.length();
        while (!SchemaObject.isSpace(string, nArray[0]) && nArray[0] < n) {
            nArray[0] = nArray[0] + 1;
            if (nArray[0] >= n) continue;
            if (string.charAt(nArray[0]) == ')') break;
            if (string.charAt(nArray[0]) != '(') continue;
            return;
        }
    }

    static String getNextToken(String string, int[] nArray) throws PropertyException {
        try {
            int n;
            SchemaObject.skipSpace(string, nArray);
            int n2 = nArray[0];
            if (n2 >= string.length()) {
                return null;
            }
            if (string.charAt(n2) == '\'') {
                n = string.length();
                int n3 = n2;
                while (n3++ < n) {
                    if (string.charAt(n3) != '\'' || !Character.isSpaceChar(string.charAt(n3 + 1))) continue;
                    nArray[0] = ++n3;
                    return string.substring(n2, n3);
                }
            }
            SchemaObject.skipNonSpace(string, nArray);
            n = nArray[0];
            if (n2 == n) {
                return "";
            }
            return string.substring(n2, n);
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public static String getId(String string) {
        try {
            int[] nArray = new int[1];
            String string2 = null;
            nArray[0] = 0;
            SchemaObject.skipSpace(string, nArray);
            string2 = SchemaObject.getNextToken(string, nArray);
            if (string2 == null || string2.charAt(0) != '(') {
                return "";
            }
            return SchemaObject.getNextToken(string, nArray);
        }
        catch (PropertyException propertyException) {
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public void parseSubschemaAttributeValue(int[] var1_1, String var2_2) {
        block34: {
            try {
                var3_3 = this.isDebug();
                var4_6 = 0;
                var2_2 = this.fixupValue(var2_2);
                var1_1[0] = 0;
                SchemaObject.skipSpace(var2_2, var1_1);
                if (var2_2.charAt(var1_1[0]) != '(') {
                    AdminProp.errorMessageLn("Unexpected char =" + var2_2.substring(var1_1[0]));
                    return;
                }
                SchemaObject.getNextToken(var2_2, var1_1);
                SchemaObject.skipSpace(var2_2, var1_1);
                var5_8 = 1;
                var6_9 = -1;
                ** GOTO lbl105
                while ((var7_10 = SchemaObject.getNextToken(var2_2, var1_1)).charAt(0) != ')') {
                    switch (var5_8) {
                        case 1: {
                            if (var3_3) {
                                this.debugMessageLn("id=" + var7_10);
                            }
                            try {
                                this.setProp(0x103013, (Object)var7_10);
                            }
                            catch (PropertyException var8_11) {
                                this.unexpectedException(var8_11);
                            }
                            var5_8 = 2;
                            break;
                        }
                        case 2: {
                            var6_9 = -1;
                            var4_6 = this.isOnTokenList(SchemaObject.keyList, SchemaObject.idKeyList, var7_10);
                            if (var4_6 != 0) {
                                if (var3_3) {
                                    this.debugMessageLn("key=" + var7_10);
                                }
                                var5_8 = 3;
                                var6_9 = var4_6;
                                break;
                            }
                            var4_6 = this.isOnTokenList(SchemaObject.modList, SchemaObject.idModList, var7_10);
                            if (var4_6 != 0) {
                                try {
                                    this.setProp(var4_6, (Object)Boolean.TRUE);
                                }
                                catch (PropertyException var8_12) {
                                    this.unexpectedException(var8_12);
                                }
                                if (!var3_3) break;
                                this.debugMessageLn("mod=" + var7_10);
                                break;
                            }
                            var8_13 = this.getClass().getName();
                            var9_17 = var8_13.lastIndexOf(46);
                            if (var9_17 > 0) {
                                var8_13 = var8_13.substring(var9_17 + 1);
                            }
                            AdminProp.errorMessageLn(String.valueOf(var8_13) + ".parseSubschemaAttributeValue");
                            AdminProp.errorMessageLn("Unexpected token=" + var7_10);
                            AdminProp.errorMessageLn("Input: " + var2_2);
                            break;
                        }
                        case 3: {
                            try {
                                if (!AdminProp.isPropArray(var4_6)) ** GOTO lbl83
                                var8_14 = new Vector<String>();
                                SchemaObject.skipSpace(var2_2, var1_1);
                                if (var3_3) {
                                    this.debugMessageLn("Array property");
                                }
                                if (var7_10.charAt(0) != '(') ** GOTO lbl76
                                while (var2_2.charAt(var1_1[0]) != ')') {
                                    var7_10 = SchemaObject.getNextToken(var2_2, var1_1);
                                    var7_10 = SchemaObject.removeQuotes(var7_10);
                                    if (var3_3) {
                                        this.debugMessageLn("array value=" + var7_10);
                                    }
                                    var8_14.addElement(var7_10);
                                    SchemaObject.skipSpace(var2_2, var1_1);
                                    var7_10 = SchemaObject.getNextToken(var2_2, var1_1);
                                    if (var7_10.charAt(0) != ')') {
                                        SchemaObject.skipSpace(var2_2, var1_1);
                                        continue;
                                    }
                                    ** GOTO lbl80
                                }
                                ** GOTO lbl80
lbl76:
                                // 1 sources

                                var7_10 = SchemaObject.removeQuotes(var7_10);
                                if (var3_3) {
                                    this.debugMessageLn("non array value=" + var7_10);
                                }
                                var8_14.addElement(var7_10);
lbl80:
                                // 3 sources

                                if (var8_14.size() != 0) {
                                    this.setProp(var4_6, (Object)AdminProp.vectorToStringArray(var8_14));
                                }
                                ** GOTO lbl104
lbl83:
                                // 1 sources

                                if (AdminProp.getPropType(var4_6) == 0x200000) {
                                    var7_10 = SchemaObject.removeQuotes(var7_10);
                                    if (var3_3) {
                                        this.debugMessageLn("value=" + var7_10);
                                    }
                                    this.setProp(var4_6, (Object)new Integer(var7_10));
                                } else {
                                    if (var3_3) {
                                        this.debugMessageLn("String property");
                                    }
                                    var7_10 = SchemaObject.removeQuotes(var7_10);
                                    if (var3_3) {
                                        this.debugMessageLn("value=" + var7_10);
                                    }
                                    if (var6_9 == 0x103003) {
                                        var8_15 = var7_10.indexOf("{");
                                        if (var8_15 > 0 && (var9_17 = var7_10.indexOf("}", var8_15)) > var8_15) {
                                            this.setProp(2109444, (Object)new Integer(var7_10.substring(var8_15 + 1, var9_17)));
                                            var7_10 = var7_10.substring(0, var8_15);
                                        }
                                        var6_9 = -1;
                                    }
                                    this.setProp2(var4_6, var7_10);
                                }
                            }
                            catch (PropertyException var8_16) {
                                this.unexpectedException(var8_16);
                            }
lbl104:
                            // 4 sources

                            var5_8 = 2;
                        }
                    }
lbl105:
                    // 8 sources

                    if (var1_1[0] < var2_2.length()) {
                        if (var2_2.charAt(var1_1[0]) != ')') continue;
                    }
                    break block34;
                }
                return;
            }
            catch (PropertyException var3_4) {
                var4_7 = var3_4.getMessage();
                var4_7 = "\nInvalid schema syntax. Schema Object is : \n" + var2_2 + "\n" + var4_7;
                var3_5 = new PropertyException(var4_7);
                this.unexpectedException(var3_5);
            }
        }
    }

    int[] getPrintQuotesList() {
        return m_printQuotesList;
    }

    int[] getPrintOrderList() {
        return m_printOrderList;
    }

    int[] sortInPrintOrder(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 0x103013) {
                nArray2[n++] = nArray[n2];
                break;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] != 0x103013) {
                int n4 = 0;
                while (n4 < m_printOrderList.length) {
                    if (m_printOrderList[n4] == nArray[n3]) {
                        nArray2[n++] = nArray[n3];
                        break;
                    }
                    ++n4;
                }
                if (n4 == m_printOrderList.length) {
                    nArray2[n++] = nArray[n3];
                }
            }
            ++n3;
        }
        return nArray2;
    }

    String[] getMatchingRuleNames(SubSchema subSchema, String string) {
        String[] stringArray;
        Vector vector = subSchema.getMatchingRules();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n = vector.size();
        int n2 = 0;
        if (string != null && !string.trim().equals("") && subSchema.findMatchingRule(0x103000, string) == null) {
            stringArray = new String[n + 1];
            stringArray[n2++] = string;
        } else {
            stringArray = new String[n];
        }
        int n3 = 0;
        while (n3 < n) {
            MatchingRule matchingRule = (MatchingRule)vector.elementAt(n3);
            stringArray[n2] = "";
            try {
                stringArray[n2] = (String)matchingRule.getProp(0x110001);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            ++n2;
            ++n3;
        }
        return stringArray;
    }

    Hashtable getSyntaxHashtable(SubSchema subSchema, String string) {
        Vector vector = subSchema.getSyntaxes();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n = vector.size();
        this._syntaxHashtable = new Hashtable();
        int n2 = 0;
        while (n2 < n) {
            Syntax syntax = (Syntax)vector.elementAt(n2);
            try {
                this._syntaxHashtable.put(syntax.getProp(0x103013), syntax.getProp(0x110001));
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            ++n2;
        }
        if (string != null && !string.trim().equals("") && this._syntaxHashtable.get(string) == null) {
            this._syntaxHashtable.put(string, string);
        }
        this._syntaxHashtable.put("", "");
        return this._syntaxHashtable;
    }

    String[] getObjectClassNames(SubSchema subSchema, boolean bl, boolean bl2, boolean bl3) {
        Vector vector = subSchema.getObjectClasses();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            block11: {
                ObjectClass objectClass = (ObjectClass)vector.elementAt(n2);
                if (!(this instanceof NewObjectClass)) {
                    try {
                        if (!bl && objectClass.isAbstract() || !bl2 && objectClass.isStructural() || !bl3 && objectClass.isAuxiliary()) break block11;
                        if (objectClass == this) {
                        }
                    }
                    catch (PropertyException propertyException) {}
                } else {
                    String string = null;
                    try {
                        string = (String)objectClass.getProp(0x110001);
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                        break block11;
                    }
                    if (string != null) {
                        vector2.addElement(string);
                    }
                }
            }
            ++n2;
        }
        if (vector2.size() == 0) {
            return new String[0];
        }
        return AdminProp.vectorToStringArray(vector2);
    }

    public static boolean hasName(AdminProp adminProp, String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return false;
        }
        String string = null;
        try {
            string = (String)adminProp.getProp(0x103000);
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < 2) {
            String[] stringArray3;
            String[] stringArray4 = stringArray3 = n == 0 ? stringArray : stringArray2;
            if (stringArray3 != null) {
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    if (string.equalsIgnoreCase(stringArray3[n2])) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    static String[] getAttributesNames(SubSchema subSchema, String[] stringArray, String[] stringArray2) {
        Vector vector = subSchema.getAttributeTypes();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = (Attribute)vector.elementAt(n2);
            if (!SchemaObject.hasName(attribute, stringArray, stringArray2)) {
                String string = null;
                try {
                    string = (String)attribute.getProp(0x110001);
                }
                catch (PropertyException propertyException) {
                    AdminProp.sUnexpectedException(propertyException);
                }
                if (string != null) {
                    vector2.addElement(string);
                }
            }
            ++n2;
        }
        if (vector2.size() == 0) {
            return null;
        }
        return AdminProp.vectorToStringArray(vector2);
    }

    boolean canHaveStructural() {
        ObjectClass objectClass = null;
        try {
            objectClass = (ObjectClass)this;
        }
        catch (ClassCastException classCastException) {
            this.unexpectedException(classCastException);
        }
        if (objectClass == null) {
            return true;
        }
        try {
            return objectClass.isStructural() || objectClass.isAuxiliary();
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return false;
        }
    }

    boolean canHaveAuxiliary() {
        return this.canHaveStructural();
    }

    boolean canHaveAbstract() {
        return true;
    }

    Object[] getLOV(SubSchema subSchema) {
        try {
            return this.getLOV(subSchema, (int[])this.getProp(282001422));
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return null;
        }
    }

    Object[] getLOV(int[] nArray) {
        return this.getLOV(this.m_subSchema, nArray);
    }

    Object[] getLOV(SubSchema subSchema, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = null;
            switch (nArray[n]) {
                case 1060887: {
                    Object object;
                    try {
                        if (this.isExisting()) {
                            if (this.getBoolean(8466445)) {
                                object = new String[]{LDAPLang.getStrAbstractPlbl(), LDAPLang.getStrAuxiliaryPlbl1(), LDAPLang.getStrStructuralPlbl()};
                                objectArray[n] = object;
                                break;
                            }
                            if (this.getBoolean(8466447)) {
                                object = new String[]{LDAPLang.getStrAuxiliaryPlbl1(), LDAPLang.getStrStructuralPlbl()};
                                objectArray[n] = object;
                                break;
                            }
                            object = new String[]{LDAPLang.getStrStructuralPlbl(), LDAPLang.getStrBindNone()};
                            objectArray[n] = object;
                            break;
                        }
                        object = new String[]{LDAPLang.getStrAbstractPlbl(), LDAPLang.getStrStructuralPlbl(), LDAPLang.getStrAuxiliaryPlbl1(), LDAPLang.getStrBindNone()};
                        objectArray[n] = object;
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 269496329: {
                    Object object;
                    if (this instanceof ObjectClass) {
                        objectArray[n] = this.getObjectClassNames(subSchema, this.canHaveAbstract(), this.canHaveStructural(), this.canHaveAuxiliary());
                        break;
                    }
                    try {
                        object = (String)this.getProp(0x103000);
                        String[] stringArray = new String[]{object};
                        objectArray[n] = SchemaObject.getAttributesNames(subSchema, stringArray, null);
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                    break;
                }
                case 0x103003: {
                    try {
                        if (NO_SYNTAX_LOV) break;
                        objectArray[n] = this.getSyntaxHashtable(subSchema, (String)this.getProp(nArray[n]));
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                    break;
                }
                case 1060870: 
                case 1060871: 
                case 1060872: {
                    try {
                        objectArray[n] = this.getMatchingRuleNames(subSchema, (String)this.getProp(nArray[n]));
                    }
                    catch (PropertyException propertyException) {
                        this.unexpectedException(propertyException);
                    }
                    break;
                }
                case 269496330: 
                case 269496331: {
                    try {
                        objectArray[n] = SchemaObject.getAttributesNames(subSchema, null, null);
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                    }
                    break;
                }
                case 1060869: {
                    objectArray[n] = ATTRIBUTEUSAGES;
                }
            }
            ++n;
        }
        return objectArray;
    }

    String[] getPrintKeyList() {
        return m_printKeyList;
    }

    static boolean memberOfArray(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static void appendStringWithQuotes(StringBuffer stringBuffer, boolean bl, String string) {
        if (bl) {
            stringBuffer.append('\'');
            stringBuffer.append(string);
            stringBuffer.append('\'');
            return;
        }
        stringBuffer.append(string);
    }

    boolean canConvertOk() {
        return this.m_convertOk;
    }

    void setConvertOk(boolean bl) {
        this.m_convertOk = bl;
    }

    public String toString() {
        int[] nArray;
        try {
            nArray = (int[])this.getProp(282001422);
        }
        catch (PropertyException propertyException) {
            this.setConvertOk(false);
            return super.toString();
        }
        int[] nArray2 = this.getPrintOrderList();
        String[] stringArray = this.getPrintKeyList();
        int[] nArray3 = this.getPrintQuotesList();
        if (nArray == null) {
            this.setConvertOk(false);
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("( ");
        try {
            String string = (String)this.getProp(0x103013);
            if (string != null && !string.trim().equals("")) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("0.0.0.0");
            }
            int n = 0;
            while (n < nArray2.length) {
                Object object;
                int n2 = nArray2[n];
                if (!(n2 == 1060887 || !SchemaObject.memberOfArray(nArray, n2) && n2 != 8466446 && n2 != 8466447 && n2 != 8466445 || (object = this.getProp(n2)) == null || object instanceof String && ((String)object).trim().equals("") || object instanceof String[] && ((String[])object).length == 0)) {
                    Object object2;
                    boolean bl = SchemaObject.memberOfArray(nArray3, n2);
                    if (AdminProp.isPropArray(n2)) {
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray[n]);
                        stringBuffer.append(" ");
                        object2 = (String[])object;
                        if (((String[])object2).length == 1) {
                            SchemaObject.appendStringWithQuotes(stringBuffer, bl, object2[0]);
                        } else {
                            stringBuffer.append("( ");
                            int n3 = 0;
                            while (n3 < ((String[])object2).length) {
                                SchemaObject.appendStringWithQuotes(stringBuffer, bl, object2[n3]);
                                if (n3 != ((String[])object2).length - 1) {
                                    stringBuffer.append(" $ ");
                                }
                                ++n3;
                            }
                            stringBuffer.append(" )");
                        }
                    } else if (AdminProp.getPropType(n2) == 0x800000) {
                        object2 = (String[])object;
                        if (object2.booleanValue()) {
                            stringBuffer.append(" ");
                            stringBuffer.append(stringArray[n]);
                        }
                    } else {
                        Integer n4;
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray[n]);
                        stringBuffer.append(" ");
                        object2 = (String)this.getProp2(n2);
                        if (n2 == 0x103003 && (n4 = (Integer)this.getProp(2109444)) != null && n4 > 0) {
                            object2 = String.valueOf(object2) + "{" + n4 + "}";
                        }
                        SchemaObject.appendStringWithQuotes(stringBuffer, bl, (String)object2);
                    }
                }
                ++n;
            }
        }
        catch (PropertyException propertyException) {
            this.setConvertOk(false);
            return LDAPLang.getStrCouldNotConvert();
        }
        stringBuffer.append(" )");
        this.setConvertOk(true);
        return stringBuffer.toString();
    }

    public void reset() {
        int[] nArray;
        this.m_bValid = true;
        try {
            nArray = (int[])this.getProp(282001422);
            if (nArray == null) {
                return;
            }
        }
        catch (PropertyException propertyException) {
            return;
        }
        int[] nArray2 = this.getPrintOrderList();
        try {
            this.setProp(0x103013, null);
        }
        catch (PropertyException propertyException) {}
        int n = 0;
        while (n < nArray2.length) {
            int n2 = nArray2[n];
            if (SchemaObject.memberOfArray(nArray, n2)) {
                try {
                    this.setProp(n2, null);
                }
                catch (PropertyException propertyException) {}
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        String string;
        int[] nArray = new int[]{0};
        String string2 = " ONE TWO 'THREE FOUR' FIVE SIX ";
        do {
            string = null;
            try {
                string = SchemaObject.getNextToken(string2, nArray);
            }
            catch (PropertyException propertyException) {}
            System.out.println("token=" + string);
        } while (!string.equals("SIX"));
    }

    public boolean validate() throws SaveChangeException {
        String string;
        String string2;
        block23: {
            SubSchema subSchema = this.m_subSchema;
            string2 = "";
            if (this.isExisting()) {
                try {
                    string = (String)this.getProp(0x103013);
                    if (string == null || !subSchema.areThereDuplicates(null, 0x103013, string)) break block23;
                    string2 = String.valueOf(string2) + LDAPLang.getStrDupOid() + string;
                    if (this.isDebug()) {
                        this.debugMessageLn("Duplicate oids");
                    }
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
            } else {
                try {
                    string = (String)this.getProp(0x103013);
                    if (string != null && AdminProp.count(this.getSiblings(), 0x103013, string, 1) > 0) {
                        string2 = String.valueOf(string2) + LDAPLang.getStrDupOid() + string;
                        if (this.isDebug()) {
                            this.debugMessageLn("Duplicate oids");
                        }
                    }
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
            }
        }
        try {
            string = (String)this.getProp(0x103000);
            if (string == null) {
                if (this.isDebug()) {
                    this.debugMessageLn("name value array is null");
                }
                string2 = String.valueOf(string2) + LDAPLang.getStrMissingName();
            } else {
                boolean bl;
                Vector vector = this.getSiblings();
                if (vector.contains(this)) {
                    bl = AdminProp.count(vector, 0x103000, string, 2) > 1;
                } else {
                    boolean bl2 = bl = AdminProp.count(vector, 0x103000, string, 1) > 0;
                }
                if (bl) {
                    if (this.isDebug()) {
                        this.debugMessageLn("val=" + string);
                    }
                    string2 = String.valueOf(string2) + LDAPLang.getStrDupName() + string;
                    if (this.isDebug()) {
                        this.debugMessageLn("Duplicate names");
                    }
                }
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        if (!string2.trim().equals("")) {
            throw new SaveChangeException(string2);
        }
        try {
            string = (String)this.getProp(0x103013);
            if (string == null || string.equals("")) {
                string2 = String.valueOf(string2) + LDAPLang.getStrMissingOid();
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        return true;
    }

    public Vector getSiblings() {
        return null;
    }

    public void setListProp(AdminList adminList, int n) throws SaveChangeException {
        try {
            int n2 = adminList.countChildren();
            if (n2 != 0) {
                String[] stringArray = new String[n2];
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3] = (String)((IAdminProp)adminList.nthChild(n3)).getProp(1519616);
                    ++n3;
                }
                this.setProp(n, (Object)stringArray);
                return;
            }
            this.setProp(n, (Object)new String[0]);
            return;
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
    }

    public void cleanup() {
        this.m_subSchema = null;
        this.m_parent = null;
        this.m_originalString = null;
    }

    static {
        keyList = new String[]{"NAME", "SYNTAX", "USAGE", "ORDERING", "EQUALITY", "SUBSTR", "SUP", "MUST", "MAY", "DESC"};
        idKeyList = new int[]{0x103000, 0x103003, 1060869, 1060870, 1060871, 1060872, 269496329, 269496330, 269496331, 1060866};
        modList = new String[]{"SINGLE-VALUE", "SINGLE_VALUE", "NO-USER-MODIFICATION", "NO_USER_MODIFICATION", "ABSTRACT", "STRUCTURAL", "AUXILIARY", "OBSOLETE", "COLLECTIVE", "INDEX"};
        idModList = new int[]{8400913, 8400913, 8466444, 8466444, 8466445, 8466446, 8466447, 8466448, 8400914, 8466453};
        ATTRIBUTEUSAGES = new String[]{"userApplications", "directoryOperation", "distributedOperation", "dSAOperation"};
        m_printQuotesList = new int[]{0x103000, 1060866, 0x103003};
        m_printOrderList = new int[]{0x103000, 1060866, 8466448, 269496329, 1060887, 8466445, 8466446, 8466447, 1060871, 1060870, 1060872, 0x103003, 269496330, 269496331, 8400913, 8400914, 8466444, 1060869, 8466453};
        m_printKeyList = new String[]{"NAME", "DESC", "OBSOLETE", "SUP", "TYPE", "ABSTRACT", "STRUCTURAL", "AUXILIARY", "EQUALITY", "ORDERING", "SUBSTR", "SYNTAX", "MUST", "MAY", "SINGLE-VALUE", "COLLECTIVE", "NO-USER-MODIFICATION", "USAGE", "INDEX"};
    }
}

