/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.AccessItem;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SelectAccessPermission;
import oracle.ldap.admin.StructAccessItem;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class SelectAccessPermissions
extends AdminList {
    static final int PR_PERMISSION = 1585152;
    static String[] cols;
    String[] rows;
    String[] parseWords;
    int GAP;
    String m_orgPermission;
    boolean debug;
    StructAccessItem m_aci;

    public SelectAccessPermissions() {
    }

    public SelectAccessPermissions(StructAccessItem structAccessItem, String string, String[] stringArray, int n) {
        this.m_aci = structAccessItem;
        this.init(string, stringArray, n);
    }

    public SelectAccessPermissions(AccessItem accessItem, String string, String[] stringArray, int n) {
        super(accessItem);
        this.init(string, stringArray, n);
    }

    public void registerMessages() {
        super.registerMessages();
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "structural_access_rights";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 0x110001: {
                return LDAPLang.getStrAccessRightPlbl();
            }
            case 2032706: {
                return LDAPLang.getStrAccessRightPlbl();
            }
            case 2162725: {
                return new Integer(128);
            }
            case 1585152: {
                return this.m_orgPermission;
            }
            case 3080204: {
                return new Integer(8192);
            }
            case 270074403: {
                return cols;
            }
            case 270074404: {
                return this.rows;
            }
            case 2687386: {
                return new Integer(0x200000);
            }
        }
        int n2 = AdminProp.getPropNumber(n) - 12288;
        if (n2 >= 0 && n2 <= this.rows.length * 3) {
            SelectAccessPermission selectAccessPermission = (SelectAccessPermission)this.m_children.elementAt(n2 / 3);
            switch (n2 % 3) {
                case 0: {
                    return selectAccessPermission.m_can;
                }
                case 1: {
                    return selectAccessPermission.m_cannot;
                }
                case 2: {
                    if (!selectAccessPermission.m_can.booleanValue() && !selectAccessPermission.m_cannot.booleanValue()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        int n2 = AdminProp.getPropNumber(n) - 12288;
        if (n2 >= 0 && n2 <= this.rows.length * 3) {
            SelectAccessPermission selectAccessPermission = (SelectAccessPermission)this.m_children.elementAt(n2 / 3);
            switch (n2 % 3) {
                case 0: {
                    selectAccessPermission.m_can = (Boolean)object;
                    return;
                }
                case 1: {
                    selectAccessPermission.m_cannot = (Boolean)object;
                    return;
                }
                case 2: {
                    if (!((Boolean)object).booleanValue()) break;
                    selectAccessPermission.m_can = selectAccessPermission.m_cannot = Boolean.FALSE;
                    return;
                }
            }
            return;
        }
        super.setProp(n, object);
    }

    public void init(String string, String[] stringArray, int n) {
        if (cols == null) {
            cols = new String[3];
            SelectAccessPermissions.cols[0] = LDAPLang.getStrCanPlbl();
            SelectAccessPermissions.cols[1] = LDAPLang.getStrCannotPlbl();
            SelectAccessPermissions.cols[2] = LDAPLang.getStrUnspecified();
        }
        this.m_orgPermission = string;
        this.rows = this.getRows();
        int n2 = 0;
        while (n2 < this.rows.length) {
            this.registerProp(0x803000 + n2 * 3, String.valueOf(this.rows[n2]) + " " + cols[0], "");
            this.registerProp(0x803000 + n2 * 3 + 1, String.valueOf(this.rows[n2]) + " " + cols[1], "");
            this.registerProp(0x803000 + n2 * 3 + 2, String.valueOf(this.rows[n2]) + " " + cols[2], "");
            ++n2;
        }
        this.parseWords = stringArray;
        this.GAP = n;
        this.init();
    }

    void init() {
        this.debug = Root.debugAccessItemEntry;
        if (this.debug) {
            this.setDebug(true);
        }
        this.initMatrix();
        this.parse(this.m_orgPermission, false);
    }

    public void initMatrix() {
        int n = 0;
        while (n < this.rows.length) {
            this.addChild(new SelectAccessPermission(this.parseWords[n]));
            ++n;
        }
    }

    void markMatrix(String string) {
        int n = 0;
        while (n < this.parseWords.length) {
            if (string.equalsIgnoreCase(this.parseWords[n]) || this.parseWords[n].startsWith("no") && string.equalsIgnoreCase("none")) {
                try {
                    int n2 = n < this.GAP ? n : (n >= this.GAP && n < 2 * this.GAP ? n - this.GAP : n - 2 * this.GAP);
                    SelectAccessPermission selectAccessPermission = (SelectAccessPermission)this.nthChild(n2);
                    boolean bl = n < this.GAP;
                    selectAccessPermission.setProp(8400897, (Object)new Boolean(bl));
                    selectAccessPermission.setProp(8400898, (Object)new Boolean(!bl));
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
            }
            ++n;
        }
    }

    public void parse(String string, boolean bl) {
        if (this.debug) {
            this.debugMessageLn("permission = " + string + " test=" + bl);
        }
        if (string == null) {
            return;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        if (string.startsWith("(")) {
            if (this.debug) {
                this.debugMessageLn("permission starts with open bracket.");
            }
            n3 = ++n;
        } else if (this.debug) {
            this.debugMessageLn("permission NOT starts with open bracket.");
        }
        while (n < n2) {
            String string2;
            char c = string.charAt(n);
            if (c == ')') {
                if (this.debug) {
                    this.debugMessageLn("permission ends with ending bracket");
                }
                if (bl2) {
                    n4 = n;
                    string2 = string.substring(n3, n4);
                    if (this.debug) {
                        this.debugMessageLn("Word = " + string2);
                    }
                    if (!bl) {
                        this.markMatrix(string2);
                    }
                }
                return;
            }
            if (c == ' ' || c == '\t' || c == ',') {
                if (bl2) {
                    n4 = n;
                    string2 = string.substring(n3, n4);
                    if (string2.equalsIgnoreCase("no")) {
                        char c2;
                        while (n < n2) {
                            c2 = string.charAt(n);
                            if (c2 != ' ' && c2 != '\t') break;
                            ++n;
                        }
                        while (n < n2) {
                            c2 = string.charAt(n);
                            if (c2 == ' ' || c2 == '\t' || c2 == ',' || c2 == ')') break;
                            ++n;
                        }
                        n4 = n;
                        string2 = string.substring(n3, n4);
                    }
                    if (this.debug) {
                        this.debugMessageLn("Word = " + string2);
                    }
                    if (!bl) {
                        this.markMatrix(string2);
                    }
                    bl2 = false;
                }
                ++n;
                continue;
            }
            if (c == ' ' || c == '\t' || c == ',') continue;
            if (!bl2) {
                n3 = n;
            }
            ++n;
            bl2 = true;
        }
        if (this.debug) {
            this.debugMessageLn("permission NOT ends with ending bracket");
        }
        if (bl2) {
            n4 = n;
            String string3 = string.substring(n3, n4);
            if (this.debug) {
                this.debugMessageLn("Word = " + string3);
            }
            if (!bl) {
                this.markMatrix(string3);
            }
        }
    }

    public String toString() {
        if (this.debug) {
            this.debugMessageLn("SelectAccessPermissions::toString() starts...");
        }
        int n = this.countChildren();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                SelectAccessPermission selectAccessPermission = (SelectAccessPermission)this.nthChild(n3);
                boolean bl = (Boolean)selectAccessPermission.getProp(8400897);
                boolean bl2 = (Boolean)selectAccessPermission.getProp(8400898);
                if (bl2) {
                    ++n2;
                }
                if (bl || bl2) {
                    String string;
                    String string2 = (String)selectAccessPermission.getProp(1519616);
                    String string3 = bl ? string2 : "no" + string2;
                    String string4 = string = stringBuffer.charAt(stringBuffer.length() - 1) == '(' ? string3 : "," + string3;
                    if (this.debug) {
                        this.debugMessageLn("action = " + string2 + " action1= " + string3 + " action2=" + string);
                    }
                    stringBuffer.append(string);
                }
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            ++n3;
        }
        if (n2 == n) {
            stringBuffer.setLength(0);
            stringBuffer.append("(none)");
        } else {
            stringBuffer.append(")");
        }
        if (this.debug) {
            this.debugMessageLn("permStr = " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void saveChanges(int n) throws SaveChangeException {
        int n2 = 0;
        while (n2 < this.rows.length) {
            SelectAccessPermission selectAccessPermission = (SelectAccessPermission)this.m_children.elementAt(n2);
            if (selectAccessPermission.m_can.booleanValue() || selectAccessPermission.m_cannot.booleanValue()) break;
            if (n2 + 1 == this.rows.length) {
                throw new SaveChangeException(LDAPLang.getStrMustSpecifyOne());
            }
            ++n2;
        }
        if (this.m_aci != null) {
            this.m_aci.setAccessRights(this.toString());
        }
    }

    public String[] getRows() {
        return null;
    }
}

