/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.io.File;
import java.util.Vector;
import oracle.ldap.admin.ConfigFile;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.Server;
import oracle.ldap.admin.ServerSample;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ServerList
extends AdminList
implements ICommandParent {
    static final boolean DEBUG = false;
    static final int CMD_EDIT = 1;
    public ConfigFile m_cfgFile;
    IAdminProp[] _cmdList;
    static final String CONFIG_FILE = "osdadmin.ini";
    static final char ENDOFLINE_MARK = '\n';
    static final char SEPARATOR_MARK = '@';

    public ServerList() {
        super(null, new Vector());
        this.loadData(CONFIG_FILE);
        this.setSampleChild(new ServerSample());
        this.buildCmdList();
    }

    public void registerMessages() {
        super.registerMessages();
    }

    public void buildCmdList() {
        try {
            this._cmdList = new CommandProp[4];
            int n = 0;
            this._cmdList[n++] = new CommandProp((IAdminProp)this, -8, LDAPLang.getStrAccessAddPlbl(), LDAPLang.getStrAddDescp(), "images/create.gif");
            this._cmdList[n++] = new CommandProp(this, -10, LDAPLang.getStrAddLikeLabel(), LDAPLang.getStrAddLikeDescp(), "images/createlike.gif", 1, 1);
            this._cmdList[n++] = new CommandProp(this, 1, LDAPLang.getStrEditLabel(), LDAPLang.getStrEditDescp1(), "images/edit.gif", 1, 1);
            this._cmdList[n++] = new CommandProp(this, -9, LDAPLang.getStrAccessDeletePlbl(), LDAPLang.getStrDeleteDescp5(), "images/delete.gif", 1, 0);
            this._cmdList[n - 1].setProp(1639168, LDAPLang.getStrConfirmDelete());
            this.setCommandList(this._cmdList);
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        block12: {
            try {
                IAdminProp[] iAdminPropArray;
                int n = (Integer)iAdminProp.getProp(2687496);
                if (n == -8) {
                    return new Server(this);
                }
                if (n == -9) {
                    this.removeChildren(iAdminProp);
                    return null;
                }
                if (n == 1) {
                    iAdminPropArray = null;
                    try {
                        iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                    }
                    catch (Exception exception) {
                        this.unexpectedException(exception);
                        return null;
                    }
                    if (iAdminPropArray != null) {
                        return iAdminPropArray[0];
                    }
                }
                if (n != -10) break block12;
                iAdminPropArray = null;
                try {
                    iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                }
                catch (Exception exception) {
                    this.unexpectedException(exception);
                    return null;
                }
                if (iAdminPropArray != null) {
                    return new Server(this, (Server)iAdminPropArray[0]);
                }
            }
            catch (PropertyException propertyException) {
                throw propertyException;
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
        return null;
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 3080204: {
                return new Integer(66);
            }
            case 2162725: {
                return new Integer(51200);
            }
            case 8978950: {
                return Boolean.TRUE;
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle28();
            }
            case 1048745: {
                return "select_directory_server";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1639538: {
                return "images/manageDomains.gif";
            }
            case 2688106: {
                return new Integer(3);
            }
            case 276366443: {
                int n2 = this.countChildren();
                String[] stringArray = new String[n2];
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3] = ((Server)this.nthChild(n3)).getHost();
                    ++n3;
                }
                return stringArray;
            }
            case 273219601: {
                IAdminProp[] iAdminPropArray = (IAdminProp[])super.getProp(n);
                if (iAdminPropArray != null) {
                    int n4 = 0;
                    while (n4 < iAdminPropArray.length) {
                        ((Server)iAdminPropArray[n4]).checkAvailable();
                        ++n4;
                    }
                }
                return iAdminPropArray;
            }
        }
        return super.getProp(n);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.countChildren() == 0) {
            throw new SaveChangeException(LDAPLang.getStrNoServers());
        }
        this.saveData(CONFIG_FILE);
    }

    public Server getDefaultServer() {
        int n = this.countChildren();
        int n2 = 0;
        while (n2 < n) {
            Server server = (Server)this.nthChild(n2);
            if (server.isDefaultServer()) {
                return server;
            }
            ++n2;
        }
        if (n != 0) {
            return (Server)this.nthChild(0);
        }
        return new Server(this, "localhost", new Integer(389));
    }

    public void unsetDefServer() {
        int n = this.countChildren();
        int n2 = 0;
        while (n2 < n) {
            ((Server)this.nthChild(n2)).unsetDefaultServer();
            ++n2;
        }
    }

    public int getHostPort(String string, int n) {
        int n2 = this.countChildren();
        int n3 = 0;
        while (n3 < n2) {
            if (((Server)this.nthChild(n3)).getHost().equalsIgnoreCase(string)) {
                return ((Server)this.nthChild(n3)).getPort();
            }
            ++n3;
        }
        return n;
    }

    public Server getCurrentServer(String string, int n) {
        int n2 = this.countChildren();
        int n3 = 0;
        while (n3 < n2) {
            Server server = (Server)this.nthChild(n3);
            if (server.getHost().equalsIgnoreCase(string) && server.getPort() == n) {
                return server;
            }
            ++n3;
        }
        return null;
    }

    public String getConfigPath() {
        String string = System.getProperty("user.home");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        if (string == null) {
            string = ".";
        }
        return string.trim();
    }

    public File getConfigFile(String string) {
        String string2 = this.getConfigPath();
        return new File(string2, string);
    }

    public boolean loadData(String string) {
        Vector vector = null;
        this.m_cfgFile = new ConfigFile(string, this);
        vector = this.m_cfgFile.loadData();
        if (vector == null) {
            return false;
        }
        int n = 0;
        while (n < vector.size()) {
            this.addChild((Server)vector.elementAt(n));
            ++n;
        }
        return true;
    }

    public boolean saveData(String string) {
        return this.m_cfgFile.saveData();
    }

    public ConfigFile getCfgFile() {
        return this.m_cfgFile;
    }
}

