/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.ACPStructList;
import oracle.ldap.admin.Entry;
import oracle.ldap.admin.EntryPermissions;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.StructFilter;
import oracle.ldap.admin.StructUser;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class StructAccessItem
extends AdminProp {
    static final int PR_FILTER = 0x103000;
    static final int PR_USER = 0x103001;
    static final int PR_BIND_MODE = 1060866;
    static final int PR_ATTR_OP = 0x103003;
    static final int PR_ATTRIBUTE = 1060868;
    static final int PR_RIGHTS = 1060869;
    static final int PR_ACCESS_BROWSE = 0x103100;
    static final int PR_ACCESS_ADD = 0x103101;
    static final int PR_ACCESS_DELETE = 1061122;
    ACPStructList m_ai;
    String m_filter;
    String m_user;
    String m_accessRights;
    String m_bindMode;
    int m_status;
    StructFilter m_filterObj;
    StructUser m_userObj;
    EntryPermissions m_entryPermObj;
    static final String[][] m_structConflicts = new String[][]{{"add", "noadd"}, {"delete", "nodelete"}, {"browse", "nobrowse"}};
    String m_filter_backup;
    String m_user_backup;
    String m_accessRights_backup;
    String m_bindMode_backup;
    int m_status_backup;
    StructFilter m_filterObj_backup;
    StructUser m_userObj_backup;
    EntryPermissions m_entryPermObj_backup;

    public StructAccessItem() {
    }

    public boolean isDirty() {
        return this.m_status == 2;
    }

    public void setDirty(boolean bl) {
        if (bl && (this.m_status & 2) == 0) {
            this.m_status |= 2;
            this.sendAdminPropertyChangeEvents(3080204, null);
            return;
        }
        if (!bl && (this.m_status & 2) != 0) {
            this.m_status &= 0xFFFFFFFD;
            this.sendAdminPropertyChangeEvents(3080204, null);
        }
    }

    public StructAccessItem(ACPStructList aCPStructList, String string, String string2, String string3, String string4) {
        this.m_ai = aCPStructList;
        this.m_filter = string;
        this.m_user = string2;
        this.m_bindMode = string3;
        this.m_accessRights = string4;
    }

    public void setUser(String string) {
        this.m_user = string;
        if (this.m_ai != null) {
            this.m_ai.setDirty(true);
        }
        this.sendAdminPropertyChangeEvents(0x103001, string);
    }

    public void setFilter(String string) {
        this.m_filter = string;
        if (this.m_ai != null) {
            this.m_ai.setDirty(true);
        }
        this.sendAdminPropertyChangeEvents(0x103000, string);
    }

    public void setAccessRights(String string) {
        this.m_accessRights = string;
        if (this.m_ai != null) {
            this.m_ai.setDirty(true);
        }
        this.sendAdminPropertyChangeEvents(0x103100, null);
        this.sendAdminPropertyChangeEvents(0x103101, null);
        this.sendAdminPropertyChangeEvents(1061122, null);
    }

    public Entry getThisACP() {
        return this.m_ai.getThisACP();
    }

    public String getThisEntry() {
        return this.m_ai.getThisEntry();
    }

    public ACPStructList getAccessList() {
        return this.m_ai;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getBindMode() {
        return this.m_bindMode;
    }

    public void setBindMode(String string) {
        this.m_bindMode = string;
        this.m_ai.setDirty(true);
        this.sendAdminPropertyChangeEvents(1060866, string);
    }

    public String getAccessRights() {
        return this.m_accessRights;
    }

    public Root getRoot() {
        return this.m_ai.getRoot();
    }

    public String[] getAttributeNames() throws PropertyException {
        return this.getRoot().getAttributeNames();
    }

    public String[] getAttributeNames(String string, boolean bl, boolean bl2) throws PropertyException {
        return this.getRoot().getAttributeNames(string, bl, bl2);
    }

    public String[] getOperationNames() {
        return this.getRoot().getOperationNames();
    }

    public String[] getExistingFilters() {
        return this.m_ai.getExistingFilters();
    }

    public String[] getCreateLikeFilters() {
        return this.m_ai.getCreateLikeFilters();
    }

    public String getAccessColumn(String string, String string2, String string3) {
        if (string.indexOf(string2) >= 0 || string.indexOf("none") >= 0) {
            return LDAPLang.getStrDenied();
        }
        if (string.indexOf(string3) >= 0) {
            return LDAPLang.getStrGranted();
        }
        return LDAPLang.getStrUnspecified1();
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x103000, LDAPLang.getStrFilterPlbl1(), LDAPLang.getStrToWhatPdsc());
        this.registerProp(0x103001, LDAPLang.getStrByWhomPlbl(), LDAPLang.getStrUserRightsPdsc());
        this.registerProp(1060866, LDAPLang.getStrBindmodesPlbl(), LDAPLang.getStrBindModePdsc1());
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 3080204: {
                return new Integer(0x1002 | this.m_status);
            }
            case 2162846: {
                return new Integer(13);
            }
            case 272695330: {
                int[] nArray = new int[]{0x110001, 2032706};
                Object[] objectArray = new Object[]{LDAPLang.getStrAccessRightPlbl(), null};
                if (this.m_filterObj == null) {
                    this.m_filterObj = new StructFilter(this, this.m_filter);
                }
                if (this.m_userObj == null) {
                    this.m_userObj = new StructUser(this, this.m_user, this.m_bindMode);
                }
                if (this.m_entryPermObj == null) {
                    this.m_entryPermObj = new EntryPermissions(this, this.m_accessRights);
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[]{this.m_filterObj, this.m_userObj, new AdminPropView((IAdminProp)this.m_entryPermObj, nArray, objectArray)};
                return iAdminPropArray;
            }
            case 0x110001: {
                return String.valueOf(this.m_filter) + " " + this.m_user + " " + this.m_accessRights;
            }
            case 2031768: {
                return LDAPLang.getStrTitle();
            }
            case 1638408: {
                return "images/ldapaci.gif";
            }
            case 2687130: {
                return null;
            }
            case 0x103000: {
                return this.m_filter;
            }
            case 0x103001: {
                if (this.m_user != null && this.m_user.equals("*")) {
                    return LDAPLang.getStrEveryone1();
                }
                return this.m_user;
            }
            case 1060869: {
                return this.m_accessRights;
            }
            case 1060866: {
                if (this.m_bindMode == null || this.m_bindMode.equals("")) {
                    return LDAPLang.getStrBindNone();
                }
                return this.m_bindMode;
            }
            case 0x103100: {
                return this.getAccessColumn(this.m_accessRights, "nobrowse", "browse");
            }
            case 0x103101: {
                return this.getAccessColumn(this.m_accessRights, "noadd", "add");
            }
            case 1061122: {
                return this.getAccessColumn(this.m_accessRights, "nodelete", "delete");
            }
        }
        return super.getProp(n);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_ai.checkDuplicates(this)) {
            throw new SaveChangeException(LDAPLang.getStrDupError());
        }
        if (this.m_ai.checkConflicts(this)) {
            throw new SaveChangeException(LDAPLang.getStrConflictError());
        }
        boolean bl = this.m_ai.existChild(this);
        if (!bl) {
            this.m_ai.addChildUnique(this);
        }
        try {
            Entry entry = this.getThisACP();
            entry.saveChanges(0);
        }
        catch (SaveChangeException saveChangeException) {
            if (!bl) {
                this.m_ai.removeChild(this);
            } else {
                this.recover();
            }
            throw saveChangeException;
        }
        this.m_ai.update();
    }

    public boolean compare(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof StructAccessItem) {
            StructAccessItem structAccessItem = (StructAccessItem)object;
            return this.compare(this.getFilter(), structAccessItem.getFilter()) && this.compare(this.getUser(), structAccessItem.getUser()) && this.compare(this.getBindMode(), structAccessItem.getBindMode()) && this.compare(this.getAccessRights(), structAccessItem.getAccessRights());
        }
        return false;
    }

    public boolean conflicts(String string, String string2, String string3, String string4) {
        if (string.indexOf(string4) > 0) {
            return false;
        }
        return string.indexOf(string3) > 0 && string2.indexOf(string4) > 0;
    }

    public boolean conflicts(String string, String string2, String[][] stringArray) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n][0];
            String string4 = stringArray[n][1];
            if (this.conflicts(string, string2, string3, string4) || this.conflicts(string2, string, string3, string4)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean conflicts(Object object) {
        if (object instanceof StructAccessItem) {
            StructAccessItem structAccessItem = (StructAccessItem)object;
            return this.compare(this.getFilter(), structAccessItem.getFilter()) && this.compare(this.getUser(), structAccessItem.getUser()) && this.compare(this.getBindMode(), structAccessItem.getBindMode()) && this.conflicts(this.getAccessRights(), structAccessItem.getAccessRights(), m_structConflicts);
        }
        return false;
    }

    public boolean hasSameUserInfo(StructAccessItem structAccessItem) {
        return this.compare(this.getUser(), structAccessItem.getUser()) && this.compare(this.getBindMode(), structAccessItem.getBindMode()) && this.compare(this.getAccessRights(), structAccessItem.getAccessRights());
    }

    public String getCononicalFilter() {
        String string = this.getFilter();
        if (string == null) {
            string = "";
        }
        return string.trim().toLowerCase();
    }

    public void backup() {
        this.m_filter_backup = this.m_filter;
        this.m_user_backup = this.m_user;
        this.m_accessRights_backup = this.m_accessRights;
        this.m_bindMode_backup = this.m_bindMode;
        this.m_status_backup = this.m_status;
        this.m_filterObj_backup = this.m_filterObj;
        this.m_userObj_backup = this.m_userObj;
        this.m_entryPermObj_backup = this.m_entryPermObj;
    }

    public void recover() {
        this.m_filter = this.m_filter_backup;
        this.m_user = this.m_user_backup;
        this.m_accessRights = this.m_accessRights_backup;
        this.m_bindMode = this.m_bindMode_backup;
        this.m_status = this.m_status_backup;
        this.m_filterObj = this.m_filterObj_backup;
        this.m_userObj = this.m_userObj_backup;
        this.m_entryPermObj = this.m_entryPermObj_backup;
    }
}

