/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.awt.GridBagConstraints;
import oracle.ldap.admin.Directory;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.StructAccessItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class StructFilter
extends AdminProp {
    public static boolean DEBUG;
    public static final int PR_USE_EXISTING = 0x803000;
    public static final int PR_EXISTING = 0x103001;
    public static final int PR_CREATE_NEW = 8400898;
    public static final int PR_START_WITH = 0x103003;
    public static final int PR_CRITERIA_ACCESS = 2109444;
    public static final int PR_FILTER_STRING = 1060869;
    StructAccessItem m_aai;
    String m_filter;
    String m_existing;
    String m_startWith;
    public boolean m_useExisting = true;
    public boolean m_createNew = false;
    Directory m_directory;

    public StructFilter(String string) {
        this.m_filter = string;
        if (this.m_filter == null || this.m_filter.equals("")) {
            this.m_useExisting = false;
            this.m_createNew = true;
            return;
        }
        this.m_existing = this.m_filter;
        this.m_startWith = this.m_filter;
    }

    public StructFilter(StructAccessItem structAccessItem, String string) {
        this(string);
        String[] stringArray;
        this.m_aai = structAccessItem;
        if ((this.m_filter == null || this.m_filter.equals("")) && (stringArray = this.m_aai.getExistingFilters()) != null && stringArray.length != 0) {
            this.m_existing = stringArray[0];
        }
        this.m_directory = this.m_aai.getRoot().getDirectory();
    }

    public void printIt(Object object) {
        if (object instanceof Object[]) {
            System.out.print("(");
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                this.printIt(objectArray[n]);
                if (n + 1 != objectArray.length) {
                    System.out.print(" ");
                }
                ++n;
            }
            System.out.print(")");
            return;
        }
        System.out.print("\"" + object + "\"");
    }

    public void initProps() throws PropertyException {
        super.initProps();
        if (this.m_filter != null && !this.m_filter.equals("")) {
            Object object = this.m_directory.writeStringToCriteria(this.m_filter, this.m_aai.getRoot());
            if (DEBUG) {
                System.out.println("StructFilter.initProps: ");
                this.printIt(object);
                System.out.println();
            }
            this.setProp(8324195, object);
        }
    }

    public Boolean getUseExisting() {
        if (this.m_useExisting) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setUseExisting(Boolean bl) {
        if (this.m_useExisting != bl) {
            this.m_useExisting = bl;
            this.sendAdminPropertyChangeEvents(2686979, null);
            this.m_createNew = !this.m_useExisting;
        }
    }

    public Boolean getCreateNew() {
        if (this.m_createNew) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setCreateNew(Boolean bl) {
        if (this.m_createNew != bl) {
            this.m_createNew = bl;
            boolean bl2 = this.m_useExisting = !this.m_createNew;
            if (this.m_createNew) {
                this.setStartWith(this.m_startWith);
            }
        }
    }

    public String getExisting() {
        return this.m_existing;
    }

    public void setExisting(String string) {
        this.m_existing = string;
    }

    public String getStartWith() {
        return this.m_startWith;
    }

    public void setStartWith(String string) {
        this.m_startWith = string;
        try {
            Object object = this.m_directory.writeStringToCriteria(string, this.m_aai.getRoot());
            if (object == null) {
                object = this.m_directory.writeStringToCriteria("(cn=)", this.m_aai.getRoot());
            }
            if (object != null) {
                if (DEBUG) {
                    System.out.println("StructFilter.setStartWith: ");
                    this.printIt(object);
                    System.out.println();
                }
                this.setProp(8324195, object);
                this.sendAdminPropertyChangeEvents(8324195, object);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x803000, LDAPLang.getStrUseExistingPlbl(), LDAPLang.getStrEmptyString(), "getUseExisting", "setUseExisting");
        this.registerProp(8400898, LDAPLang.getStrCreateNewPlbl(), LDAPLang.getStrEmptyString(), "getCreateNew", "setCreateNew");
        this.registerProp(0x103001, LDAPLang.getStrExistingPlbl(), LDAPLang.getStrEmptyString(), "getExisting", "setExisting");
        this.registerProp(0x103003, LDAPLang.getStrStartWithPlbl(), LDAPLang.getStrEmptyString(), "getStartWith", "setStartWith");
        if (Root.isClientCommandLine()) {
            this.registerProp(1060869, LDAPLang.getStrFilter(), LDAPLang.getStrFilterStringPdsc());
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "structural_access";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 0x110001: {
                return LDAPLang.getStrFilterPlbl1();
            }
            case 3080204: {
                if (Root.isClientCommandLine()) {
                    return new Integer(8192);
                }
                return new Integer(32768);
            }
            case 270468175: {
                return this.m_aai.getAttributeNames(null, false, true);
            }
            case 270468192: {
                return this.m_aai.getOperationNames();
            }
            case 2032737: {
                return "Common Name";
            }
            case 2032738: {
                return LDAPLang.getStrCriteriaGroupTitle();
            }
            case 2687386: {
                return new Integer(0x220800);
            }
            case 281609325: {
                String[] stringArray = this.m_aai.getCreateLikeFilters();
                if (stringArray.length != 1) break;
                int[] nArray = new int[]{0x103001, 0x803000};
                return nArray;
            }
            case 276758675: {
                this.registerPropListOfValues(0x103001, this.m_aai.getExistingFilters());
                this.registerPropListOfValues(0x103003, this.m_aai.getCreateLikeFilters());
                break;
            }
            case 275841152: {
                GridBagConstraints gridBagConstraints;
                GridBagConstraints[] gridBagConstraintsArray = new GridBagConstraints[8];
                int n2 = 0;
                gridBagConstraintsArray[n2++] = null;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets.left = 20;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = null;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets.left = 30;
                gridBagConstraints.insets.right = 35;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = null;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets.left = 20;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.insets.left = 30;
                gridBagConstraints.insets.right = 5;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraintsArray[n2++] = gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.insets.left = 0;
                gridBagConstraints.insets.right = 35;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                return gridBagConstraintsArray;
            }
            case 272630352: {
                int[] nArray = new int[]{0x110001, 3080204, 273613313};
                Object[] objectArray = new Object[]{"Filter Selector", new Integer(8192), null};
                int[] nArray2 = new int[]{0x110001, 3080204, 273613313};
                Object[] objectArray2 = new Object[]{"Filter Criteria", new Integer(8), null};
                int[] nArray3 = new int[]{2686979};
                int[] nArray4 = new int[]{2109444};
                IAdminProp[] iAdminPropArray = new IAdminProp[]{new AdminPropView((IAdminProp)this, nArray, objectArray), new AdminPropView((IAdminProp)this, nArray2, objectArray2, nArray3, nArray4)};
                return iAdminPropArray;
            }
            case 2109444: {
                if (this.m_useExisting) {
                    return new Integer(1);
                }
                return new Integer(3);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            default: 
        }
        super.setProp(n, object);
    }

    public boolean uninitConstraint(Object object) {
        Object[] objectArray;
        return object instanceof Object[] && (objectArray = (Object[])object).length == 3 && objectArray[1] instanceof String && objectArray[0].equals(this.m_directory.getStrBeginsWith()) && (objectArray[2] == null || objectArray[2].equals(""));
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            Object object;
            String string;
            if (this.m_useExisting) {
                this.m_startWith = this.m_existing;
                this.m_aai.setFilter(this.m_startWith);
                return;
            }
            if (Root.isClientCommandLine()) {
                string = (String)this.getProp(1060869);
                if (string == null) {
                    return;
                }
                object = this.m_directory.writeStringToCriteria(string, this.m_aai.getRoot());
                if (object == null) {
                    throw new PropertyException(LDAPLang.getStrInvalidCriteria());
                }
            } else {
                object = this.getProp(8324195);
            }
            if (object == null || this.uninitConstraint(object)) {
                this.m_existing = "";
                this.m_startWith = "";
                this.m_aai.setFilter("");
                return;
            }
            string = this.m_directory.criteriaToString(object = this.m_directory.transformCriteria(object, this.m_aai.getRoot()));
            if (string == null) {
                throw new PropertyException(LDAPLang.getStrInvalidCriteria());
            }
            this.m_startWith = this.m_existing = string;
            this.m_aai.setFilter(this.m_existing);
            return;
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception);
        }
    }
}

