/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import oracle.ldap.admin.EntrySelector;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.StructAccessItem;
import oracle.ldap.admin.StructBindMode;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class StructUser
extends AdminProp {
    public static final int PR_BIND_MODE = 0x403000;
    public static final int PR_BY_ALL = 8400897;
    public static final int PR_BY_GROUP = 8400898;
    public static final int PR_GROUP = 0x103003;
    public static final int PR_BY_ENTRY = 8400900;
    public static final int PR_ENTRY = 1060869;
    public static final int PR_BY_SUBTREE = 8400902;
    public static final int PR_SUBTREE = 1060871;
    public static final int PR_BY_ATTR_GROUP = 0x803008;
    public static final int PR_ATTR_GROUP = 1060873;
    public static final int PR_BY_LOCAL_ACCESS = 8400906;
    public static final int PR_THIS_ENTRY = 1519629;
    public boolean m_byAll = true;
    public boolean m_byGroup;
    public boolean m_byEntry;
    public boolean m_bySubtree;
    public boolean m_byAttrGroup;
    public boolean m_byLocalAccess;
    public String m_group;
    public String m_entry;
    public String m_subtree;
    public String m_attrGroup;
    public String m_thisEntry;
    public IAdminProp m_bindMode;
    StructAccessItem m_aai;
    String m_who;

    public StructUser(StructAccessItem structAccessItem, String string, String string2) {
        this.m_who = string;
        this.m_aai = structAccessItem;
        this.m_bindMode = new StructBindMode(structAccessItem, string2);
        EntrySelector entrySelector = new EntrySelector(this.m_aai.getRoot());
        EntrySelector entrySelector2 = new EntrySelector(this.m_aai.getRoot());
        entrySelector2.initSearch("(objectClass=orclprivilegegroup)");
        this.registerPropListOfValues(0x103003, entrySelector2);
        this.registerPropListOfValues(1060869, entrySelector);
        this.registerPropListOfValues(1060871, entrySelector);
        try {
            this.registerPropListOfValues(1060873, this.m_aai.getAttributeNames(null, true, false));
        }
        catch (PropertyException propertyException) {}
        this.m_thisEntry = structAccessItem.getThisEntry();
        try {
            this.init();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerPropField(0x403000, LDAPLang.getStrBindmodesPlbl(), "", "m_bindMode");
        this.setPropertyLabelHidden(0x403000, true, false);
        this.registerPropField(8400897, LDAPLang.getStrEveryone1(), "", "m_byAll");
        this.registerPropField(8400898, LDAPLang.getStrSpecificGroup(), "", "m_byGroup");
        this.registerPropField(0x103003, LDAPLang.getStrGroup1(), "", "m_group");
        this.registerPropField(8400900, LDAPLang.getStrSpecificEntry(), "", "m_byEntry");
        this.registerPropField(1060869, LDAPLang.getStrEntry(), "", "m_entry");
        this.registerPropField(8400902, LDAPLang.getStrASubtree(), "", "m_bySubtree");
        this.registerPropField(1060871, LDAPLang.getStrSrctypeSubtree(), "", "m_subtree");
        this.registerPropField(1060873, LDAPLang.getStrPartialEntry(), "", "m_attrGroup");
        this.registerPropField(0x803008, LDAPLang.getStrByAttrGroup(), "", "m_byAttrGroup");
        this.registerPropField(8400906, LDAPLang.getStrByLocalAccess(), "", "m_byLocalAccess");
        this.registerPropField(1519629, LDAPLang.getStrThisEntry(), "", "m_thisEntry");
    }

    public void init() throws PropertyException {
        String string = this.m_who.toLowerCase().trim();
        int n = this.m_who.indexOf("=");
        String string2 = "";
        if (n > 0) {
            string2 = this.m_who.substring(n + 1).trim();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.startsWith("(") && string2.endsWith(")")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
        }
        if (string.startsWith("*") || string.startsWith("everyone")) {
            this.m_byAll = true;
            return;
        }
        if (string.startsWith("dnattr")) {
            this.m_byAttrGroup = true;
            this.m_attrGroup = this.m_aai.getRoot().getAttrDisplayName(string2);
            return;
        }
        if (string.startsWith("dn")) {
            if (string2.startsWith(".*")) {
                this.m_bySubtree = true;
                this.m_subtree = string2.substring(2).trim();
                if (this.m_subtree.startsWith(",")) {
                    this.m_subtree = string2.substring(1).trim();
                    return;
                }
            } else {
                this.m_byEntry = true;
                this.m_entry = string2;
            }
            return;
        }
        if (string.startsWith("group")) {
            this.m_byGroup = true;
            this.m_group = string2;
            return;
        }
        if (string.startsWith("self")) {
            this.m_byLocalAccess = true;
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "structural_access_by_whom";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 2687386: {
                return new Integer(0x330000);
            }
            case 0x110001: {
                return LDAPLang.getStrByWhomPlbl();
            }
            case 3080204: {
                return new Integer(8192);
            }
        }
        return super.getProp(n);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_byAll) {
            this.m_aai.setUser("*");
            return;
        }
        if (this.m_byGroup) {
            this.m_aai.setUser("group=\"" + this.m_group + "\"");
            return;
        }
        if (this.m_byEntry) {
            this.m_aai.setUser("dn=\"" + this.m_entry + "\"");
            return;
        }
        if (this.m_bySubtree) {
            if (this.m_subtree.startsWith(".*")) {
                this.m_aai.setUser("dn=\"" + this.m_subtree + "\"");
                return;
            }
            if (this.m_subtree.startsWith("*")) {
                this.m_aai.setUser("dn=\"." + this.m_subtree + "\"");
                return;
            }
            if (this.m_subtree.startsWith(",")) {
                this.m_aai.setUser("dn=\".*" + this.m_subtree + "\"");
                return;
            }
            this.m_aai.setUser("dn=\".*," + this.m_subtree + "\"");
            return;
        }
        if (this.m_byAttrGroup) {
            this.m_aai.setUser("dnAttr=(" + this.m_aai.getRoot().getAttrInternalName(this.m_attrGroup) + ")");
            return;
        }
        if (this.m_byLocalAccess) {
            this.m_aai.setUser("self");
        }
    }
}

