/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin;

import java.util.Vector;
import oracle.ldap.admin.Attribute;
import oracle.ldap.admin.Attributes;
import oracle.ldap.admin.LDAPLang;
import oracle.ldap.admin.List;
import oracle.ldap.admin.MatchingRule;
import oracle.ldap.admin.MatchingRules;
import oracle.ldap.admin.NewAttribute;
import oracle.ldap.admin.NewObjectClass;
import oracle.ldap.admin.ObjectClass;
import oracle.ldap.admin.ObjectClasses;
import oracle.ldap.admin.Root;
import oracle.ldap.admin.RootList;
import oracle.ldap.admin.SchemaObject;
import oracle.ldap.admin.Syntax;
import oracle.ldap.admin.Syntaxes;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

public class SubSchema
extends List
implements ICommandParent {
    static final String LDAPSYNTAXES = "ldapsyntaxes";
    static final String ATTRIBUTETYPES = "attributetypes";
    static final String OBJECTCLASSES = "objectclasses";
    static final String MATCHINGRULES = "matchingrules";
    static final int PR_MARK = 8990727;
    static final int CMD_NEW_ATTR = 0;
    static final int CMD_NEW_OBJ_CLASS = 1;
    static final int CMD_NEW_ENTRY = 3;
    MatchingRules m_matchingRulesHolder;
    Syntaxes m_syntaxesHolder;
    ObjectClasses m_objectClassHolder;
    Attributes m_attributesHolder;
    int m_lastAttrPropId;
    String m_subSchemaDn;
    IAdminProp refreshCmd;
    Vector m_objectClasses = new Vector();
    Vector m_matchingRules;
    Vector m_syntaxes;
    Vector m_attributeTypes = new Vector();
    public String m_DNSyntaxId;
    static final String LDAPCATALOGS = "cn=catalogs";
    static final String LDAPINDEXATTR = "orclindexedattribute";

    public String getDn() {
        return this.m_subSchemaDn;
    }

    public void setDn(String string) {
        this.m_subSchemaDn = string;
    }

    public SubSchema() {
    }

    public SubSchema(Root root, String string) {
        super(root, null);
        this.m_subSchemaDn = string;
        try {
            this.setProp(0x110001, (Object)string);
            return;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return;
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1048745: {
                return "understanding_directory_schema";
            }
            case 1049370: {
                return RootList.getHelpBaseFileName();
            }
            case 1638408: {
                return "images/ldapschs.gif";
            }
            case 272695330: {
                n = 273219601;
                break;
            }
            case 2162846: {
                return new Integer(1);
            }
            case 2031768: {
                return LDAPLang.getStrEditorTitle29();
            }
            case 2686979: {
                return new Integer(33);
            }
            case 1115212: {
                return LDAPLang.getStrTabSubTitle();
            }
            case 273613313: {
                if (!this.m_parent.isConnected() || this.m_children == null) {
                    return null;
                }
                IAdminProp[] iAdminPropArray = new IAdminProp[1];
                int n2 = 0;
                iAdminPropArray[n2++] = new CommandProp((IAdminProp)this, -5, LDAPLang.getStrCmdRefresh(), String.valueOf(LDAPLang.getStrRefreshDescp7()) + "...", "images/refresh.gif");
                iAdminPropArray[n2 - 1].setProp(2687509, new Integer(4));
                return iAdminPropArray;
            }
            case 3080204: {
                if (this.m_children == null || this.m_children.size() == 0) {
                    return new Integer(1);
                }
                return new Integer(0x1004 | (this.m_children != null && this.m_children.size() != 0 ? 0x100000 : 0) | 0x200000);
            }
            case 282001424: {
                int[] nArray = new int[]{0x110001};
                return nArray;
            }
        }
        return super.getProp(n);
    }

    public void doRefresh(IAdminProp iAdminProp) {
        try {
            ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, null);
            this.update();
            ((CommandProp)iAdminProp).sendAdminPropertyChangeEvents(0x1F000F, "finish");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        try {
            int n = (Integer)iAdminProp.getProp(2687496);
            if (n == 0) {
                return (IAdminProp)this.m_attributesHolder.getProp(5177493);
            }
            if (n == 1) {
                return (IAdminProp)this.m_objectClassHolder.getProp(5177493);
            }
            if (n == 3) {
                return (IAdminProp)this.m_parent.m_directory.getProp(5177493);
            }
            if (n == -5) {
                this.doRefresh(iAdminProp);
                return null;
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        return null;
    }

    public void update() {
        this.m_matchingRulesHolder.getChildren().removeAllElements();
        this.m_syntaxesHolder.getChildren().removeAllElements();
        this.m_objectClassHolder.getChildren().removeAllElements();
        this.m_attributesHolder.getChildren().removeAllElements();
        if (Root.debugSaveObjectClass) {
            System.out.println("schema updating...");
        }
        this.m_parent.updateSchema(this);
        int n = 0;
        while (n++ < 30 && (this.m_attributesHolder.countChildren() == 0 || this.m_syntaxesHolder.countChildren() == 0 || this.m_objectClassHolder.countChildren() == 0 || this.m_matchingRulesHolder.countChildren() == 0)) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        if (Root.debugSaveObjectClass) {
            System.out.println("schema updating (returing early)... count=" + n);
        }
    }

    public void updateClient() {
        if (Root.debugSaveObjectClass) {
            System.out.println("schema update done...");
        }
        this.m_attributesHolder.update();
        this.m_objectClassHolder.update();
        this.m_matchingRulesHolder.update();
        this.m_syntaxesHolder.update();
    }

    void parseSubschemaAttribute(int[] nArray, Object object) {
        String[] stringArray;
        if (object == null) {
            return;
        }
        String string = this.m_parent.m_serverAccess.getType(object);
        if (string == null) {
            return;
        }
        string = string.trim();
        if (this.isDebug()) {
            this.debugMessageLn("type=" + string);
        }
        if ((stringArray = this.m_parent.m_serverAccess.getValues(object)) == null) {
            return;
        }
        if (string.equalsIgnoreCase(ATTRIBUTETYPES)) {
            boolean bl;
            Vector vector = this.getAttributeTypes();
            boolean bl2 = bl = vector != null && vector.size() != 0;
            if (this.isDebug()) {
                this.debugMessageLn("Attributes");
            }
            int n = 0;
            while (n < stringArray.length) {
                block50: {
                    if (this.isDebug()) {
                        this.debugMessageLn("j=" + n + " input=" + stringArray[n]);
                    }
                    if (this.refreshCmd != null) {
                        try {
                            this.refreshCmd.setProp(0x1F000F, stringArray[n]);
                        }
                        catch (Exception exception) {}
                    }
                    if (bl && this.mergeInNewInfo(vector, nArray, stringArray[n])) {
                        if (this.isDebug()) {
                            this.debugMessageLn("mergeInNewInfo did some work");
                        }
                    } else {
                        Attribute attribute;
                        block49: {
                            attribute = new Attribute(stringArray[n], nArray, this);
                            try {
                                String string2 = (String)((SchemaObject)attribute).getProp(0x103013);
                                if (string2 != null && !string2.trim().equals("")) break block49;
                                String string3 = "Invalid attribute definition='" + stringArray[n] + "'";
                                this.setErrorMessage(string3);
                                break block50;
                            }
                            catch (Exception exception) {
                                this.unexpectedException(exception);
                            }
                        }
                        if (this.isDebug()) {
                            this.debugMessageLn(attribute.toString());
                        }
                        this.addAttributeTypes(attribute);
                        if (vector == null) {
                            vector = this.getAttributeTypes();
                        }
                    }
                }
                ++n;
            }
            this.m_parent.addAttributeList(vector);
        } else if (string.equalsIgnoreCase(OBJECTCLASSES)) {
            boolean bl;
            Vector vector = this.getObjectClasses();
            boolean bl3 = bl = vector != null && vector.size() != 0;
            if (this.isDebug()) {
                this.debugMessageLn("Object Classes");
            }
            int n = 0;
            while (n < stringArray.length) {
                if (this.refreshCmd != null) {
                    try {
                        this.refreshCmd.setProp(0x1F000F, stringArray[n]);
                    }
                    catch (Exception exception) {}
                }
                if (!bl || !this.mergeInNewInfo(vector, nArray, stringArray[n])) {
                    ObjectClass objectClass = new ObjectClass(stringArray[n], nArray, this);
                    this.addObjectClasses(objectClass);
                    if (vector == null) {
                        vector = this.getObjectClasses();
                    }
                }
                ++n;
            }
        } else if (string.equalsIgnoreCase(MATCHINGRULES)) {
            boolean bl;
            Vector vector = this.getMatchingRules();
            boolean bl4 = bl = vector != null && vector.size() != 0;
            if (this.isDebug()) {
                this.debugMessageLn("Matching Rules");
            }
            int n = 0;
            while (n < stringArray.length) {
                if (this.refreshCmd != null) {
                    try {
                        this.refreshCmd.setProp(0x1F000F, stringArray[n]);
                    }
                    catch (Exception exception) {}
                }
                if (!bl || !this.mergeInNewInfo(vector, nArray, stringArray[n])) {
                    MatchingRule matchingRule = new MatchingRule(stringArray[n], nArray, this);
                    if (this.isDebug()) {
                        this.debugMessageLn(matchingRule.toString());
                    }
                    this.addMatchingRules(matchingRule);
                    if (vector == null) {
                        vector = this.getMatchingRules();
                    }
                }
                ++n;
            }
        } else if (string.equalsIgnoreCase(LDAPSYNTAXES)) {
            boolean bl;
            Vector vector = this.getSyntaxes();
            boolean bl5 = bl = vector != null && vector.size() != 0;
            if (this.isDebug()) {
                this.debugMessageLn("Syntaxes");
            }
            int n = 0;
            while (n < stringArray.length) {
                if (this.refreshCmd != null) {
                    try {
                        this.refreshCmd.setProp(0x1F000F, stringArray[n]);
                    }
                    catch (Exception exception) {}
                }
                if (!bl || !this.mergeInNewInfo(vector, nArray, stringArray[n])) {
                    Syntax syntax = new Syntax(stringArray[n], nArray, this);
                    this.rememberDNSyntaxId(syntax);
                    if (this.isDebug()) {
                        this.debugMessageLn(syntax.toString());
                    }
                    this.addSyntaxes(syntax);
                    if (vector == null) {
                        vector = this.getSyntaxes();
                    }
                }
                ++n;
            }
        } else if (this.isDebug()) {
            this.debugMessageLn("type='" + string + "'");
        }
        this.refreshCmd = null;
    }

    void parseSubschema(Object[] objectArray) {
        this.setStatusMessage(LDAPLang.getStrInitializing());
        try {
            this.markSchemaObject(this.getMatchingRules());
            this.markSchemaObject(this.getSyntaxes());
            this.markSchemaObject(this.getAttributeTypes());
            this.markSchemaObject(this.getObjectClasses());
            int[] nArray = new int[1];
            int n = 0;
            while (n < objectArray.length) {
                this.parseSubschemaAttribute(nArray, objectArray[n]);
                ++n;
            }
            this.removeMarkedSchemaObject(this.getMatchingRules());
            this.removeMarkedSchemaObject(this.getSyntaxes());
            this.removeMarkedSchemaObject(this.getAttributeTypes());
            this.removeMarkedSchemaObject(this.getObjectClasses());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setStatusMessage(LDAPLang.getStrReady());
        if (this.m_children == null || this.m_children.size() == 0) {
            if (this.m_children == null) {
                this.m_children = new Vector();
            }
            this.m_objectClassHolder = new ObjectClasses(this, this.getObjectClasses());
            this.m_children.addElement(this.m_objectClassHolder);
            this.m_attributesHolder = new Attributes(this, this.getAttributeTypes());
            this.m_children.addElement(this.m_attributesHolder);
            this.m_syntaxesHolder = new Syntaxes(this, this.getSyntaxes());
            this.m_children.addElement(this.m_syntaxesHolder);
            this.m_matchingRulesHolder = new MatchingRules(this, this.getMatchingRules());
            this.m_children.addElement(this.m_matchingRulesHolder);
            this.sendAdminPropertyChangeEvents(273612805, this.m_children);
            this.sendAdminPropertyChangeEvents(273219601, this.m_children);
            if (this.isDebug()) {
                this.debugMessageLn("Syntaxes");
                AdminProp.printDebug(System.out, this.getSyntaxes(), false, true, false);
            }
        }
    }

    void parseSubschema(Object object) {
        Object object2 = this.m_parent.m_serverAccess.getSearchEntry(object);
        if (this.isDebug()) {
            this.debugMessageLn("name=" + this.m_parent.m_serverAccess.getName(object2));
        }
        Object[] objectArray = this.m_parent.m_serverAccess.getAttributes(object2);
        this.parseSubschema(objectArray);
    }

    boolean mergeInNewInfo(Vector vector, int[] nArray, String string) {
        if (vector == null) {
            return false;
        }
        String string2 = SchemaObject.getId(string);
        SchemaObject schemaObject = this.findSchemaObject(vector, string2, 0x103013);
        if (schemaObject == null) {
            return false;
        }
        schemaObject.reset();
        schemaObject.parseSubschemaAttributeValue(nArray, string);
        if (schemaObject instanceof Attribute) {
            try {
                Integer n = this.getAttrPropId(schemaObject);
                schemaObject.setProp(2174998, (Object)n);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
        }
        try {
            schemaObject.setProp(8990727, (Object)Boolean.FALSE);
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        return true;
    }

    void addObjectClasses(AdminProp adminProp) {
        AdminProp.addSorted(this.m_objectClasses, adminProp);
    }

    public Vector getObjectClasses() {
        return this.m_objectClasses;
    }

    void addMatchingRules(AdminProp adminProp) {
        if (this.m_matchingRules == null) {
            this.m_matchingRules = new Vector();
        }
        AdminProp.addSorted(this.m_matchingRules, adminProp);
    }

    public Vector getMatchingRules() {
        return this.m_matchingRules;
    }

    void addSyntaxes(AdminProp adminProp) {
        if (this.m_syntaxes == null) {
            this.m_syntaxes = new Vector();
        }
        AdminProp.addSorted(this.m_syntaxes, adminProp);
    }

    public Vector getSyntaxes() {
        return this.m_syntaxes;
    }

    void addAttributeTypes(AdminProp adminProp) {
        try {
            Integer n = this.getAttrPropId(adminProp);
            adminProp.setProp(2174998, (Object)n);
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        AdminProp.addSorted(this.m_attributeTypes, adminProp);
    }

    public boolean updateAttributeTypes(AdminProp adminProp) {
        int n = this.m_attributeTypes.indexOf(adminProp);
        this.m_attributeTypes.removeElement(adminProp);
        AdminProp.addSorted(this.m_attributeTypes, adminProp);
        return n != this.m_attributeTypes.indexOf(adminProp);
    }

    public String getPropIdAttr(Integer n) {
        return this.m_parent.getPropIdAttr(n);
    }

    Integer getAttrPropId(Object object) {
        return this.m_parent.getAttrPropId(object);
    }

    public Vector getAttributeTypes() {
        return this.m_attributeTypes;
    }

    public String[] getAttributeNames(String string, boolean bl, boolean bl2) {
        Vector vector = this.getAttributeTypes();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = (Attribute)vector.elementAt(n2);
            if (!(bl && !attribute.isDNValued() || bl2 && !attribute.isCataloged())) {
                String string2 = null;
                try {
                    string2 = (String)attribute.getProp(0x110001);
                    if (string2 != null) {
                        string2 = this.m_parent.getAttrDisplayName(string2);
                    }
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
                if (string2 != null) {
                    vector2.addElement(string2);
                }
            }
            ++n2;
        }
        if (vector2.size() == 0) {
            return null;
        }
        if (string != null) {
            vector2.insertElementAt(string, 0);
        }
        return AdminProp.vectorToStringArray(vector2);
    }

    synchronized void markSchemaObject(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                ((AdminProp)vector.elementAt(n2)).setProp(8990727, (Object)Boolean.TRUE);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
            }
            ++n2;
        }
    }

    synchronized void removeMarkedSchemaObject(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            block5: {
                boolean bl;
                try {
                    bl = ((AdminProp)vector.elementAt(n2)).getBoolean(8990727);
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                    break block5;
                }
                if (bl) {
                    vector.removeElementAt(n2);
                    --n2;
                    --n;
                }
            }
            ++n2;
        }
    }

    SchemaObject findSchemaObject(Vector vector, Object object, int n) {
        try {
            return (SchemaObject)AdminProp.findObject(vector, n, object);
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return null;
        }
    }

    Object[] findSchemaObjects(Vector vector, Object object, int n) {
        Object[] objectArray;
        if (n == 0x103000 && (objectArray = AdminProp.findObjects(vector, 1519616, object)) != null) {
            return objectArray;
        }
        return AdminProp.findObjects(vector, n, object);
    }

    SchemaObject findSchemaObject(String string, int n) {
        SchemaObject schemaObject = this.findSchemaObject(this.getAttributeTypes(), string, n);
        if (schemaObject != null) {
            return schemaObject;
        }
        schemaObject = this.findSchemaObject(this.getObjectClasses(), string, n);
        if (schemaObject != null) {
            return schemaObject;
        }
        schemaObject = this.findSchemaObject(this.getMatchingRules(), string, n);
        if (schemaObject != null) {
            return schemaObject;
        }
        schemaObject = this.findSchemaObject(this.getSyntaxes(), string, n);
        if (schemaObject != null) {
            return schemaObject;
        }
        return null;
    }

    public Object[] findAttributeTypes(int n, Object object) {
        return this.findSchemaObjects(this.getAttributeTypes(), object, n);
    }

    public Object[] findObjectClasses(int n, Object object) {
        return this.findSchemaObjects(this.getObjectClasses(), object, n);
    }

    public ObjectClass findObjectClass(int n, Object object) {
        return (ObjectClass)this.findSchemaObject(this.getObjectClasses(), object, n);
    }

    public MatchingRule findMatchingRule(int n, Object object) {
        return (MatchingRule)this.findSchemaObject(this.getMatchingRules(), object, n);
    }

    public Syntax findSyntax(int n, Object object) {
        return (Syntax)this.findSchemaObject(this.getSyntaxes(), object, n);
    }

    public Attribute findAttributeType(int n, Object object) {
        return (Attribute)this.findSchemaObject(this.getAttributeTypes(), object, n);
    }

    public boolean areThereDuplicates(Vector vector, int n, Object object) {
        if (vector == null) {
            int n2 = AdminProp.count(this.getObjectClasses(), n, object, 2);
            if (n2 > 1) {
                return true;
            }
            if ((n2 += AdminProp.count(this.getAttributeTypes(), n, object, 2 - n2)) > 1) {
                return true;
            }
            if ((n2 += AdminProp.count(this.getSyntaxes(), n, object, 2 - n2)) > 1) {
                return true;
            }
            return (n2 += AdminProp.count(this.getMatchingRules(), n, object, 2 - n2)) > 1;
        }
        return AdminProp.count(vector, n, object, 2) > 1;
    }

    public static String[] getSchemaValueArray(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = vector.elementAt(n).toString();
            ++n;
        }
        return stringArray;
    }

    public void saveNewAttribute(NewAttribute newAttribute) throws PropertyException {
        this.setStatusMessage(String.valueOf(LDAPLang.getStrSaving()) + " " + newAttribute);
        try {
            IAdminProp[] iAdminPropArray;
            Vector vector = this.getAttributeTypes();
            if (Root.debugSaveAttribute) {
                this.setDebug(true);
                this.debugMessageLn("New attr='" + newAttribute + "'");
                this.setDebug(false);
            }
            if (vector != null && vector.contains(newAttribute)) {
                this.saveAttributeTypes();
                return;
            }
            if (this.m_parent.saveNewSchemaObject(newAttribute.toString(), this.m_subSchemaDn, ATTRIBUTETYPES)) {
                this.addAttributeTypes(newAttribute);
                this.m_attributesHolder.update();
                iAdminPropArray = new IAdminProp[]{newAttribute};
                this.m_attributesHolder.setProp(273220105, (Object)iAdminPropArray);
                this.m_attributesHolder.sendAdminPropertyChangeEvents(273220105, newAttribute);
            }
            if ((iAdminPropArray = this.m_parent.getErrorMessage()) != null && !iAdminPropArray.equals("")) {
                throw new PropertyException((String)iAdminPropArray);
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        this.setStatusMessage(LDAPLang.getStrReady());
    }

    public void saveNewObjectClass(NewObjectClass newObjectClass) throws PropertyException {
        this.setStatusMessage(String.valueOf(LDAPLang.getStrSaving()) + " " + newObjectClass);
        try {
            IAdminProp[] iAdminPropArray;
            Vector vector = this.getObjectClasses();
            if (Root.debugSaveObjectClass) {
                this.setDebug(true);
                this.debugMessageLn("New ObjectClass='" + newObjectClass + "'");
                this.setDebug(false);
            }
            if (vector != null && AdminProp.vectorContains(vector, newObjectClass)) {
                this.saveObjectClasses();
                return;
            }
            if (this.m_parent.saveNewSchemaObject(newObjectClass.toString(), this.m_subSchemaDn, OBJECTCLASSES)) {
                this.addObjectClasses(newObjectClass);
                this.m_objectClassHolder.update();
                iAdminPropArray = new IAdminProp[]{newObjectClass};
                this.m_attributesHolder.setProp(273220105, (Object)iAdminPropArray);
                this.m_attributesHolder.sendAdminPropertyChangeEvents(273220105, newObjectClass);
            }
            if ((iAdminPropArray = this.m_parent.getErrorMessage()) != null && !iAdminPropArray.equals("")) {
                throw new PropertyException((String)iAdminPropArray);
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        this.setStatusMessage(LDAPLang.getStrReady());
    }

    public void saveAttributeType(Attribute attribute) throws PropertyException {
        if (!this.m_parent.isBound()) {
            return;
        }
        try {
            String string = attribute.getOriginalString();
            String string2 = attribute.toString();
            this.removeSchemaObject(string, ATTRIBUTETYPES);
            this.addSchemaObject(string2, ATTRIBUTETYPES);
            if (this.updateAttributeTypes(attribute)) {
                this.m_attributesHolder.update();
                return;
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public void saveObjectClass(ObjectClass objectClass) throws PropertyException {
        if (!this.m_parent.isBound()) {
            return;
        }
        try {
            String string = objectClass.getOriginalString();
            String string2 = objectClass.toString();
            this.removeSchemaObject(string, OBJECTCLASSES);
            this.addSchemaObject(string2, OBJECTCLASSES);
            return;
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public void addSchemaObject(String string, String string2) throws PropertyException {
        try {
            if (Root.debugSaveObjectClass) {
                this.setDebug(true);
                this.debugMessageLn("set new " + string2 + " value='" + string + "'");
                this.setDebug(false);
            }
            int n = this.m_parent.m_serverAccess.addAttributeValue(this.m_subSchemaDn, string2, string);
            String string3 = this.m_parent.m_serverAccess.getErrorMessage();
            if (!string3.trim().equals("")) {
                throw new PropertyException(string3);
            }
            if (n == 3) {
                throw new PropertyException(LDAPLang.getStrTimeout());
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public void saveObjectClasses() throws PropertyException {
        if (!this.m_parent.isBound()) {
            return;
        }
        try {
            int n;
            String[] stringArray = SubSchema.getSchemaValueArray(this.getObjectClasses());
            if (stringArray == null) {
                throw new PropertyException(LDAPLang.getStrCannotSaveObjectclass());
            }
            if (Root.debugSaveObjectClass) {
                this.setDebug(true);
                n = 0;
                while (n < stringArray.length) {
                    this.debugMessageLn("objectclass[" + n + "]='" + stringArray[n] + "'");
                    ++n;
                }
                this.setDebug(false);
            }
            n = this.m_parent.m_serverAccess.replaceAttributeValue(this.m_subSchemaDn, OBJECTCLASSES, stringArray);
            String string = this.m_parent.m_serverAccess.getErrorMessage();
            if (!string.trim().equals("")) {
                throw new PropertyException(string);
            }
            if (n == 3) {
                throw new PropertyException(LDAPLang.getStrTimeout());
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public boolean removeSchemaObject(String string, String string2) throws PropertyException {
        block7: {
            if (Root.debugSaveObjectClass) {
                System.out.println("removeSchemaObject value='" + string + "'");
            }
            try {
                if (this.m_parent.isBound()) {
                    int n = this.m_parent.m_serverAccess.deleteAttributeValue(this.m_subSchemaDn, string2, string);
                    String string3 = this.m_parent.m_serverAccess.getErrorMessage();
                    if (!string3.trim().equals("")) {
                        throw new PropertyException(string3);
                    }
                    if (n != 2) {
                        return false;
                    }
                    break block7;
                }
                this.setStatusMessage(LDAPLang.getStrNotBound());
                return false;
            }
            catch (PropertyException propertyException) {
                throw propertyException;
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
        return true;
    }

    public boolean removeObjectClass(String string) throws PropertyException {
        return this.removeSchemaObject(string, OBJECTCLASSES);
    }

    public boolean removeObjectClass(ObjectClass objectClass) throws PropertyException {
        return this.removeObjectClass(objectClass.toString());
    }

    public boolean removeAttributeType(String string) throws PropertyException {
        return this.removeSchemaObject(string, ATTRIBUTETYPES);
    }

    public boolean removeAttributeType(Attribute attribute) throws PropertyException {
        return this.removeAttributeType(attribute.toString());
    }

    public void saveAttributeTypes() throws PropertyException {
        int n;
        if (!this.m_parent.isBound()) {
            return;
        }
        String[] stringArray = SubSchema.getSchemaValueArray(this.getAttributeTypes());
        if (stringArray == null) {
            return;
        }
        if (Root.debugSaveAttribute) {
            this.setDebug(true);
            n = 0;
            while (n < stringArray.length) {
                this.debugMessageLn("attribute[" + n + "]='" + stringArray[n] + "'");
                ++n;
            }
            this.setDebug(false);
        }
        try {
            n = this.m_parent.m_serverAccess.replaceAttributeValue(this.m_subSchemaDn, ATTRIBUTETYPES, stringArray);
            String string = this.m_parent.m_serverAccess.getErrorMessage();
            if (!string.trim().equals("")) {
                throw new PropertyException(string);
            }
            if (n == 3) {
                throw new PropertyException(LDAPLang.getStrTimeout());
            }
        }
        catch (PropertyException propertyException) {
            throw propertyException;
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
    }

    public void saveSyntaxes() {
    }

    public void saveMatchingRules() {
    }

    public void deleteAttribute(Attribute attribute) throws PropertyException {
        this.m_attributesHolder.removeChild(attribute);
        this.saveAttributeTypes();
    }

    public void deleteObjectClass(ObjectClass objectClass) throws PropertyException {
        this.m_objectClassHolder.removeChild(objectClass);
        String string = objectClass.getOriginalString();
        if (string != null) {
            this.removeObjectClass(string);
        }
    }

    public String getDNSyntaxId() {
        return this.m_DNSyntaxId;
    }

    public void rememberDNSyntaxId(Syntax syntax) {
        if (syntax.isDNSyntaxId()) {
            this.m_DNSyntaxId = syntax.getSyntaxId();
        }
    }

    public String getAttrDisplayName(String string) {
        return this.m_parent.getAttrDisplayName(string);
    }

    public void setAttrDisplayName(String string, String string2) {
        this.m_parent.setAttrDisplayName(string, string2);
    }

    public void setCataloged(boolean bl) {
        Vector vector = this.getAttributeTypes();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = (Attribute)vector.elementAt(n2);
            attribute.setCataloged(bl);
            ++n2;
        }
    }

    public boolean CatalogeAttr(String string, boolean bl) throws PropertyException {
        block7: {
            if (Root.debugSaveObjectClass) {
                System.out.println("CatalogeAttr attr='" + string + "'");
            }
            try {
                if (this.m_parent.isBound()) {
                    int n = bl ? this.m_parent.m_serverAccess.addAttributeValue(LDAPCATALOGS, LDAPINDEXATTR, string) : this.m_parent.m_serverAccess.deleteAttributeValue(LDAPCATALOGS, LDAPINDEXATTR, string);
                    String string2 = this.m_parent.m_serverAccess.getErrorMessage();
                    if (!string2.trim().equals("")) {
                        throw new PropertyException(string2);
                    }
                    if (n != 2) {
                        return false;
                    }
                    break block7;
                }
                this.setStatusMessage(LDAPLang.getStrNotBound());
                return false;
            }
            catch (PropertyException propertyException) {
                throw propertyException;
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
        return true;
    }

    public IAdminProp createObjectClass() {
        return this.m_objectClassHolder.createChild();
    }

    public IAdminProp createAttribute() {
        return this.m_attributesHolder.createChild();
    }

    public void cleanup() {
        int n;
        this.m_matchingRulesHolder.cleanup();
        this.m_matchingRulesHolder = null;
        this.m_syntaxesHolder.cleanup();
        this.m_syntaxesHolder = null;
        this.m_objectClassHolder.cleanup();
        this.m_objectClassHolder = null;
        this.m_attributesHolder.cleanup();
        this.m_attributesHolder = null;
        if (this.m_objectClasses != null) {
            n = 0;
            while (n < this.m_objectClasses.size()) {
                ((ObjectClass)this.m_objectClasses.elementAt(n)).cleanup();
                ++n;
            }
            this.m_objectClasses.removeAllElements();
        }
        this.m_objectClasses = null;
        if (this.m_attributeTypes != null) {
            n = 0;
            while (n < this.m_attributeTypes.size()) {
                ((Attribute)this.m_attributeTypes.elementAt(n)).cleanup();
                ++n;
            }
            this.m_attributeTypes.removeAllElements();
        }
        this.m_attributeTypes = null;
        if (this.m_matchingRules != null) {
            n = 0;
            while (n < this.m_matchingRules.size()) {
                ((MatchingRule)this.m_matchingRules.elementAt(n)).cleanup();
                ++n;
            }
            this.m_matchingRules.removeAllElements();
        }
        this.m_matchingRules = null;
        if (this.m_syntaxes != null) {
            n = 0;
            while (n < this.m_syntaxes.size()) {
                ((Syntax)this.m_syntaxes.elementAt(n)).cleanup();
                ++n;
            }
            this.m_syntaxes.removeAllElements();
        }
        this.m_syntaxes = null;
        this.m_parent = null;
        if (this.m_children != null) {
            this.m_children.removeAllElements();
        }
        this.m_children = null;
    }
}

