/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.appserver.ConfigPropValue;
import oracle.ldap.admin.appserver.UserProfile;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class AdminConfig
extends AdminProp
implements Serializable {
    static boolean DEBUG;
    public static final int PR_OBJECT_KEY = 0x101100;
    public static final int PR_CONFIG_PROPS = 4722946;
    public static final int PR_PROP_FILTER_LIST = 0x411104;
    public static final int PR_CHILD_FILTER_LIST = 4264197;
    public static final int PR_COMMAND_FILTER_LIST = 4264198;
    static final int CONFIG_TAB_NAME = 10;
    static final int MSG_SAVE_CHANGE_FAILED = 11;
    static transient int m_objSerialNumber;
    String m_url;
    AdminList m_configprops;
    ConfigFilterList m_propfilters;
    ConfigFilterList m_childfilters;
    ConfigFilterList m_commandfilters;
    transient AdminProp m_transformerOwner;
    transient UserProfile m_profile;

    public AdminConfig(UserProfile userProfile, String string) {
        this(userProfile, string, null);
    }

    public AdminConfig(UserProfile userProfile, String string, AdminProp adminProp) {
        ++m_objSerialNumber;
        this.init();
        this.initConfigProps();
        this.m_url = string;
        this.m_profile = userProfile;
        this.m_transformerOwner = adminProp;
    }

    private void init() {
        this.m_url = null;
        this.m_profile = null;
        this.m_transformerOwner = null;
        this.m_childfilters = null;
        this.m_commandfilters = null;
        this.m_propfilters = null;
        this.m_configprops = null;
        this.registerProp(0x101100, "Object Name", "The DisplayName of Object to be configured");
        this.registerProp(4722946, "Configuration Properties", "The list of properties used to configure the object");
        this.registerProp(0x411104, "Property Filters", "The list of filters to apply to the object's properties");
        this.registerProp(4264197, "Child Filters", "The list of filters to apply to the object's children");
        this.registerProp(4264198, "Command Filters", "The list of filters to apply to the object's commands");
        this.registerMessage(10, "Configuration");
        this.registerMessage(11, "Failed to save changes for configuration.");
    }

    public void initConfigProps() {
        this.m_configprops = new AdminList(this);
        try {
            this.m_configprops.setProp(2162725, (Object)new Integer(256));
            this.m_configprops.setDisplayName("AdminList");
            this.m_configprops.setSampleChild(new ConfigPropValue(this, 0, null));
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public String getObjKey() {
        return this.m_url;
    }

    public void setTransformerOwner(AdminProp adminProp) throws PropertyException {
        this.m_transformerOwner = adminProp;
        if (this.m_propfilters != null) {
            this.m_propfilters.setTransformerOwner(adminProp);
        }
        if (this.m_childfilters != null) {
            this.m_childfilters.setTransformerOwner(adminProp);
        }
        if (this.m_commandfilters != null) {
            this.m_commandfilters.setTransformerOwner(adminProp);
        }
    }

    public ConfigPropValue[] getConfigProps() {
        if (this.m_configprops == null) {
            return null;
        }
        Vector vector = this.m_configprops.getChildren();
        if (vector == null) {
            return null;
        }
        ConfigPropValue[] configPropValueArray = new ConfigPropValue[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            configPropValueArray[n] = (ConfigPropValue)vector.elementAt(n);
            ++n;
        }
        return configPropValueArray;
    }

    public ConfigFilterList getPropFilters() {
        return this.m_propfilters;
    }

    public ConfigFilterList getChildFilters() {
        return this.m_childfilters;
    }

    public ConfigFilterList getCommandFilters() {
        return this.m_commandfilters;
    }

    public void setObjKey(String string) {
        this.m_url = string;
        this.setModified(true);
    }

    public void setConfigProps(ConfigPropValue[] configPropValueArray) {
        Vector<ConfigPropValue> vector;
        if (configPropValueArray == null) {
            vector = null;
        } else {
            vector = new Vector<ConfigPropValue>();
            int n = 0;
            while (n < configPropValueArray.length) {
                vector.addElement(configPropValueArray[n]);
                ++n;
            }
        }
        this.m_configprops.setChildren(vector);
        this.setModified(true);
    }

    public void setPropFilters(ConfigFilterList configFilterList) {
        this.m_propfilters = configFilterList;
    }

    public void setChildFilters(ConfigFilterList configFilterList) {
        this.m_childfilters = configFilterList;
    }

    public void setCommandFilters(ConfigFilterList configFilterList) {
        this.m_commandfilters = configFilterList;
    }

    public void debugDumpConfigObj() {
        int n;
        Vector vector;
        if (DEBUG) {
            System.out.println("* Configuration: " + this.getObjKey() + " *");
        }
        if ((vector = this.m_configprops.getChildren()) != null) {
            if (DEBUG) {
                System.out.println("Configuration Properties:");
            }
            n = 0;
            while (n < vector.size()) {
                if (DEBUG) {
                    System.out.println(vector.elementAt(n));
                }
                ++n;
            }
        }
        if (this.m_propfilters != null) {
            n = 0;
            while (n < this.m_propfilters.size()) {
                if (DEBUG) {
                    System.out.println(this.m_propfilters.getFilterAt(n));
                }
                ++n;
            }
        }
        if (this.m_childfilters != null) {
            n = 0;
            while (n < this.m_childfilters.size()) {
                if (DEBUG) {
                    System.out.println(this.m_childfilters.getFilterAt(n));
                }
                ++n;
            }
        }
        if (this.m_commandfilters != null) {
            n = 0;
            while (n < this.m_commandfilters.size()) {
                if (DEBUG) {
                    System.out.println(this.m_commandfilters.getFilterAt(n));
                }
                ++n;
            }
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: {
                return this.getMessage(10);
            }
            case 0x101100: {
                return this.getObjKey();
            }
            case 2686979: {
                return new Integer(3);
            }
            case 3080204: {
                return new Integer(0x1000 | (this.isModified() ? 0 : 2));
            }
            case 4722946: {
                return this.m_configprops;
            }
            case 0x411104: {
                return this.getPropFilters();
            }
            case 4264197: {
                return this.getChildFilters();
            }
            case 4264198: {
                return this.getCommandFilters();
            }
            case 272695330: {
                IAdminProp[] iAdminPropArray = new IAdminProp[4];
                int n2 = 0;
                int[] nArray = new int[]{3080204};
                Object[] objectArray = new Object[4];
                objectArray[0] = new Integer(8196);
                iAdminPropArray[n2++] = new AdminPropView((IAdminProp)this, nArray, objectArray);
                iAdminPropArray[n2++] = this.getPropFilters();
                this.debugMessageLn("AdminConfig::Displaying PropFilters " + this.m_propfilters.size());
                iAdminPropArray[n2++] = this.getChildFilters();
                this.debugMessageLn("AdminConfig::Displaying ChildFilters " + this.m_childfilters.size());
                iAdminPropArray[n2++] = this.getCommandFilters();
                this.debugMessageLn("AdminConfig::Displaying CommandFilters " + this.m_commandfilters.size());
                return iAdminPropArray;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x101100: 
            case 0x110001: {
                this.setObjKey((String)object);
                return;
            }
            case 4722946: {
                this.setConfigProps((ConfigPropValue[])object);
                return;
            }
            case 0x411104: {
                this.m_propfilters = (ConfigFilterList)object;
                return;
            }
            case 4264197: {
                this.m_childfilters = (ConfigFilterList)object;
                return;
            }
            case 4264198: {
                this.m_commandfilters = (ConfigFilterList)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_transformerOwner != null) {
            this.m_transformerOwner.sendAdminPropertyChangeEvents(273612805, null);
        }
    }

    public static void main(String[] stringArray) {
    }

    public String toString() {
        String string = "<AdminConfig." + m_objSerialNumber + ":" + ">";
        return string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.out.print("serializing " + this.getClass().getName() + "...");
        }
        objectOutputStream.defaultWriteObject();
        if (DEBUG) {
            System.out.println("done");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
    }
}

