/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.appserver.AdminConfig;
import oracle.ldap.admin.appserver.ChildFilter;
import oracle.ldap.admin.appserver.CommandFilter;
import oracle.ldap.admin.appserver.ConfigChildDesc;
import oracle.ldap.admin.appserver.ConfigFilter;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.appserver.ConfigPropValue;
import oracle.ldap.admin.appserver.PropFilter;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.appserver.UserProfile;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.AdminURL;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;
import oracle.ldap.admin.common.Util;

public class AdminTransform
extends AdminProp
implements AdminPropertyChangeListener,
ICommandParent {
    static boolean DEBUG;
    static final int PR_PREDECESSOR = 5148672;
    static final int PR_ADMPROP_OBJ = 5148673;
    static final int PR_ADMPROP_URL_MODIFIER = 0x209002;
    static final int PR_CONFIG_OBJECT = 4296715;
    public static final int ACTIVE_MODE = 1;
    public static final int DISPLAY_MODE = 5;
    static final int ADMTRN_CONFIG = 1;
    static final int ADMTRN_CONFIG_BTNTEXT = 2;
    static final int ADMTRN_CONFIG_DESCRIP = 3;
    static final int ADMTRN_CANNOT_LOAD = 8000;
    static final int ADMTRN_WRONG_CONFIG_TYPE = 8001;
    static final int ADMTRN_ORPHAN_OBJECT = 8002;
    UserProfile m_profile;
    Hashtable m_child_cache;
    AdminTransform m_root;
    AdminTransform m_predecessor;
    AdminURL m_url;
    int m_urlsfx;
    int m_mode;
    IAdminProp m_admprop;
    AdminConfig m_admcnfg;
    CommandProp m_cnfgbtn;
    ConfigFilterList m_filterprops;
    ConfigFilterList m_filterchilds;
    ConfigFilterList m_filtercommands;
    static boolean DEBUG_CHILD_FILTERS;

    public AdminTransform getRoot() {
        if (this.m_root == null) {
            return this;
        }
        return this.m_root;
    }

    public AdminTransform(int n, String string, UserProfile userProfile) {
        this.init();
        this.m_admprop = this.loadClass(string, null);
        if (this.m_admprop != null) {
            this.m_mode = n;
            this.m_admprop.addAdminPropertyChangeListener(this);
            this.m_child_cache = new Hashtable();
            this.m_profile = userProfile;
            try {
                this.configure(true);
                return;
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
                return;
            }
        }
    }

    public AdminTransform(int n, IAdminProp iAdminProp, UserProfile userProfile) {
        this.init();
        this.m_admprop = iAdminProp;
        this.m_root = null;
        this.m_mode = n;
        this.m_admprop.addAdminPropertyChangeListener(this);
        this.m_child_cache = new Hashtable();
        this.m_profile = userProfile;
        try {
            this.configure(true);
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.errorMessageLn("AdminTransform::init() Exception while trying to retrieve URL of root object");
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public AdminTransform(int n, String string, IAdminProp iAdminProp, AdminTransform adminTransform, AdminTransform adminTransform2) {
        this.init();
        this.m_root = adminTransform2;
        this.m_predecessor = adminTransform;
        this.m_mode = n;
        this.m_admprop = this.loadClass(string, iAdminProp);
        if (this.m_admprop != null) {
            this.m_admprop.addAdminPropertyChangeListener(this);
            try {
                this.configure();
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
            }
        }
        AdminProp.errorMessageLn("AdminTransform::init() Could not initialize class: " + string);
    }

    public AdminTransform(int n, IAdminProp iAdminProp, AdminTransform adminTransform, AdminTransform adminTransform2, UserProfile userProfile) {
        this.init();
        this.m_root = adminTransform2;
        this.m_predecessor = adminTransform;
        this.m_mode = n;
        this.m_profile = userProfile;
        this.m_admprop = iAdminProp;
        this.m_admprop.addAdminPropertyChangeListener(this);
        try {
            this.configure();
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    private void init() {
        this.m_predecessor = null;
        this.m_url = null;
        this.m_urlsfx = 0;
        this.m_admprop = null;
        this.m_admcnfg = null;
        this.m_mode = 0;
        this.m_filterprops = null;
        this.m_filterchilds = null;
        this.m_filtercommands = null;
        this.registerProp(5148672, "Predecessor", "The physical predecessor of a class.");
        this.registerProp(5148673, "AdminProp Object", "The internal AdminProp object to be transformed.");
        this.registerProp(0x209002, "AdminProp URL Modifier", "Additional URL information added to this AdminProp URL");
        this.registerProp(4296715, "Configuration Object", "The configuration parameters of an object.");
        this.registerMessage(2, "Config");
        this.registerMessage(3, "Configurate properties of the object");
        this.registerMessage(8001, "Internal -- A type mismatch was encountered while applying a configuration: ");
        this.registerMessage(8000, "Internal -- Cannot load the server object for configuration.");
        this.registerMessage(8002, "Internal -- An orphaned object was discovered while trying to generate a URL.");
    }

    private void configure(boolean bl) throws PropertyException {
        String string = this.getAdmPropURL(false);
        if (string == null) {
            this.debugMessageLn("AdminTransform::configure() getADmPropURL()==null for " + this.m_admprop);
            return;
        }
        if (bl) {
            this.debugMessageLn("root configure() caching: " + string);
            this.m_child_cache.put(string, this.m_admprop);
        }
        if ((this.m_admcnfg = this.getConfigCache(string, false)) != null) {
            this.debugMessageLn("getConfigCache() != null : " + string);
            this.m_filterprops = this.m_admcnfg.getPropFilters();
            if (this.m_filterprops != null) {
                this.m_filterprops.setTransformerOwner(this);
            }
            this.m_filterchilds = this.m_admcnfg.getChildFilters();
            if (this.m_filterchilds != null) {
                this.m_filterchilds.setTransformerOwner(this);
            }
            this.m_filtercommands = this.m_admcnfg.getCommandFilters();
            if (this.m_filtercommands != null) {
                this.m_filtercommands.setTransformerOwner(this);
            }
            this.setConfigObj(this.m_admcnfg);
            this.updateConfigProps();
            this.applyConfigProps();
            if (DEBUG) {
                System.out.println("TRANSFORMING... [" + this + "](" + this.m_profile + "){" + this.m_admcnfg + "}");
                return;
            }
        } else {
            this.debugMessageLn("getConfigCache() == null : " + string);
        }
    }

    private void configure() throws PropertyException {
        this.configure(false);
    }

    public String getAdmPropURL(boolean bl) throws PropertyException {
        if (!bl) {
            return (String)this.m_admprop.getProp(2032789);
        }
        if (this.m_predecessor == null) {
            String string = (String)this.m_admprop.getProp(2032789);
            try {
                this.m_url = new AdminURL("http://foo", string);
            }
            catch (MalformedURLException malformedURLException) {
                AdminProp.sUnexpectedException(malformedURLException);
                throw new PropertyException("AdminTransform::getAdmPropURL: malformed url from " + string, 2, 2032789, null);
            }
            return this.m_url.toString();
        }
        String string = (String)this.m_admprop.getProp(2032789);
        String string2 = (String)this.m_predecessor.getProp(2032789);
        try {
            this.m_url = this.m_urlsfx != 0 ? new AdminURL(string2, AdminURL.makeComponent(string, this.m_urlsfx)) : new AdminURL(string2, string);
        }
        catch (MalformedURLException malformedURLException) {
            AdminProp.sUnexpectedException(malformedURLException);
            throw new PropertyException("AdminTransform::getAdmPropURL: malformed url from " + string, 2, 2032789, null);
        }
        return this.m_url.toString();
    }

    public int getAdmPropURLsuffix() {
        return this.m_urlsfx;
    }

    public IAdminProp getAdmPropObj() {
        return this.m_admprop;
    }

    public AdminTransform getPredecessor() {
        return this.m_predecessor;
    }

    private void setPredecessor(AdminTransform adminTransform) {
        this.m_predecessor = adminTransform;
    }

    private void setAdmPropURLsuffix(int n) {
        this.m_urlsfx = n;
    }

    public AdminConfig getConfigObj(Integer n) throws PropertyException {
        String string = this.getAdmPropURL(false);
        if (this.m_admcnfg == null) {
            this.m_admcnfg = this.getConfigCache(string, false);
            if (this.m_admcnfg == null) {
                this.m_admcnfg = new AdminConfig(this.m_profile, string, this);
                if (this.m_profile != null) {
                    try {
                        this.m_profile.storeConfig(string, this.getAdmPropURL(true), this.m_admcnfg);
                    }
                    catch (RepositoryException repositoryException) {
                        throw new PropertyException("Unable to store the new Config Object");
                    }
                }
                if (DEBUG) {
                    System.out.println("New Config object:" + this.m_admcnfg);
                }
            }
            if (DEBUG) {
                System.out.println("TRANSFORMING... [" + this + "](" + this.m_profile + "){" + this.m_admcnfg + "}");
            }
        }
        this.updateConfigProps();
        this.updatePropertyFilters();
        this.updateChildFilters(n);
        this.updateCommandFilters();
        return this.m_admcnfg;
    }

    private void updateConfigProps() throws PropertyException {
        ConfigPropValue[] configPropValueArray = this.m_admcnfg.getConfigProps();
        int[] nArray = (int[])this.m_admprop.getProp(282002580);
        int n = 0;
        if (nArray != null) {
            Vector<Integer> vector = new Vector<Integer>();
            boolean bl = false;
            int n2 = 0;
            while (n2 < nArray.length) {
                switch (nArray[n2]) {
                    default: {
                        if (configPropValueArray != null && n < configPropValueArray.length && nArray[n2] != configPropValueArray[n++].getPropId()) {
                            bl = true;
                        }
                        vector.addElement(new Integer(nArray[n2]));
                    }
                    case 0x101100: 
                    case 0x209002: 
                    case 0x411104: 
                    case 4264197: 
                    case 4722946: 
                    case 5148672: 
                    case 5148673: 
                }
                ++n2;
            }
            ConfigPropValue[] configPropValueArray2 = null;
            if (bl || configPropValueArray == null) {
                configPropValueArray2 = new ConfigPropValue[vector.size()];
                n2 = 0;
                while (n2 < vector.size()) {
                    Object object;
                    int n3 = (Integer)vector.elementAt(n2);
                    try {
                        object = this.m_admprop.getProp(n3);
                    }
                    catch (PropertyException propertyException) {
                        AdminProp.sUnexpectedException(propertyException);
                        object = null;
                    }
                    configPropValueArray2[n2] = new ConfigPropValue(this.m_admprop, n3, object);
                    ++n2;
                }
                this.m_admcnfg.setProp(4722946, (Object)configPropValueArray2);
                return;
            }
            configPropValueArray2 = configPropValueArray;
        }
    }

    private void updatePropertyFilters() throws PropertyException {
        if (this.m_admcnfg == null) {
            return;
        }
        ConfigFilterList configFilterList = this.m_admcnfg.getPropFilters();
        int[] nArray = (int[])this.m_admprop.getProp(282001422);
        if (configFilterList == null) {
            configFilterList = new ConfigFilterList(15, this);
        }
        if (nArray != null) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("Creating filters for " + nArray.length + " properties");
            }
            int n = 0;
            while (n < nArray.length) {
                if (configFilterList.getFilter(nArray[n], false) == null) {
                    PropFilter propFilter = new PropFilter(configFilterList, nArray[n]);
                    propFilter.setProp(1078018, (Object)this.m_admprop.getPropName(nArray[n]));
                    propFilter.setProp(1078021, (Object)this.m_admprop.getPropDescription(nArray[n]));
                    configFilterList.addFilter(propFilter);
                }
                ++n;
            }
        }
        this.m_admcnfg.setProp(0x411104, (Object)configFilterList);
        this.m_filterprops = this.m_admcnfg.getPropFilters();
        if (this.m_filterprops != null) {
            this.m_filterprops.setTransformerOwner(this);
        }
    }

    private void updateChildFilters(Integer n) throws PropertyException {
        ChildFilter childFilter;
        int n2;
        if (this.m_admcnfg == null) {
            return;
        }
        ConfigFilterList configFilterList = this.m_admcnfg.getChildFilters();
        int n3 = Util.getChildListProperty(n);
        IAdminProp[] iAdminPropArray = (IAdminProp[])this.m_admprop.getProp(n3);
        if (configFilterList != null) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("getConfigObj()::Config obj has " + configFilterList.size() + " Child filters");
            }
            n2 = 0;
            while (n2 < configFilterList.size()) {
                childFilter = (ChildFilter)configFilterList.getFilterAt(n2);
                if (DEBUG) {
                    AdminProp.sDebugMessageLn("getConfigObj()::ChildFilter[" + n2 + "]=" + childFilter);
                }
                ++n2;
            }
        }
        if (configFilterList == null) {
            configFilterList = new ConfigFilterList(10, this);
        }
        if (iAdminPropArray != null) {
            try {
                n2 = 0;
                while (n2 < iAdminPropArray.length) {
                    String string;
                    String string2 = this.getAdmPropURL(true);
                    AdminURL adminURL = new AdminURL(string2, string = (String)iAdminPropArray[n2].getProp(2032789), n3);
                    if (configFilterList.getFilter(n3, new ConfigChildDesc(adminURL), false) == null) {
                        childFilter = new ChildFilter(configFilterList, n3, adminURL);
                        childFilter.setProp(1078033, (Object)new Integer(4));
                        configFilterList.addFilter(childFilter);
                    }
                    ++n2;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new PropertyException(malformedURLException.getMessage(), 2, 4296715, null);
            }
        }
        this.m_admcnfg.setProp(4264197, (Object)configFilterList);
        this.m_filterchilds = this.m_admcnfg.getChildFilters();
        if (this.m_filterchilds != null) {
            this.m_filterchilds.setTransformerOwner(this);
        }
    }

    private void updateCommandFilters() throws PropertyException {
        CommandFilter commandFilter;
        int n;
        if (this.m_admcnfg == null) {
            return;
        }
        ConfigFilterList configFilterList = this.m_admcnfg.getCommandFilters();
        IAdminProp[] iAdminPropArray = null;
        if (this.m_admprop != null && (iAdminPropArray = (IAdminProp[])this.m_admprop.getProp(273613313)) == null) {
            iAdminPropArray = (IAdminProp[])this.m_admprop.getProp(273220108);
        }
        if (configFilterList != null) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("getConfigObj()::Config obj has " + configFilterList.size() + " Command filters");
            }
            n = 0;
            while (n < configFilterList.size()) {
                commandFilter = (CommandFilter)configFilterList.getFilterAt(n);
                if (DEBUG) {
                    AdminProp.sDebugMessageLn("getConfigObj()::CommandFilter[" + n + "]=" + commandFilter);
                }
                ++n;
            }
        }
        if (configFilterList == null) {
            configFilterList = new ConfigFilterList(20, this);
        }
        if (iAdminPropArray != null) {
            n = 0;
            while (n < iAdminPropArray.length) {
                int n2;
                Integer n3 = (Integer)((AdminProp)iAdminPropArray[n]).getProp(2687496);
                if (n3 != null && configFilterList.getFilter(n2 = n3.intValue(), false) == null) {
                    commandFilter = new CommandFilter(configFilterList, 273613313, iAdminPropArray[n]);
                    commandFilter.setProp(1078034, (Object)new Integer(4));
                    configFilterList.addFilter(commandFilter);
                }
                ++n;
            }
        }
        this.m_admcnfg.setProp(4264198, (Object)configFilterList);
        this.m_filtercommands = this.m_admcnfg.getCommandFilters();
        if (this.m_filtercommands != null) {
            this.m_filtercommands.setTransformerOwner(this);
        }
    }

    public void setConfigObj(AdminConfig adminConfig) throws PropertyException {
        if (adminConfig == null) {
            throw new PropertyException("AdminTransform::setConfigObj: null config object specified.", 1, 4296715, null);
        }
        if (!adminConfig.getObjKey().equalsIgnoreCase(this.getAdmPropURL(false))) {
            AdminProp.sDebugMessageLn("Config ObjKey=" + adminConfig.getObjKey() + "\nAdminProp URL=" + this.getAdmPropURL(false));
            throw new PropertyException(this.getMessage(8001), 1, 4296715, adminConfig.getObjKey());
        }
        this.m_admcnfg = adminConfig;
    }

    private void applyConfigProps() throws PropertyException {
        if (this.m_admcnfg == null || this.m_admprop == null) {
            return;
        }
        ConfigPropValue[] configPropValueArray = this.m_admcnfg.getConfigProps();
        if (configPropValueArray != null) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("\n\n####### applyConfigProps = Total is " + configPropValueArray.length + "\n\n\n");
            }
            int n = 0;
            while (n < configPropValueArray.length) {
                this.m_admprop.setProp(configPropValueArray[n].getPropId(), configPropValueArray[n].getPropValue());
                ++n;
            }
            try {
                this.m_admprop.saveChanges(0);
                return;
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
    }

    public void updateConfigPropValue(int n, Object object) throws PropertyException {
        if (this.m_admcnfg == null) {
            if (n != 282002580) {
                return;
            }
            if (DEBUG) {
                System.out.println("updating config object at design time: case1=" + this.m_admprop);
            }
            this.m_admcnfg = this.getConfigObj((Integer)this.m_admprop.getProp(3080204));
        } else if (n == 282002580) {
            if (DEBUG) {
                System.out.println("updating config object: case2=" + this.m_admprop);
            }
            this.updateConfigProps();
            return;
        }
        ConfigPropValue[] configPropValueArray = this.m_admcnfg.getConfigProps();
        if (configPropValueArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < configPropValueArray.length) {
            if (configPropValueArray[n2].getPropId() == n) {
                if (object == null) {
                    object = this.m_admcnfg.getProp(n);
                }
                configPropValueArray[n2].setPropValue(object);
                configPropValueArray[n2].sendAdminPropertyChangeEvents(n, object);
                return;
            }
            ++n2;
        }
    }

    private IAdminProp loadClass(String string, IAdminProp iAdminProp) {
        try {
            Class<?> clazz = Class.forName(string);
            Object var4_5 = null;
            if (clazz != null) {
                var4_5 = clazz.newInstance();
            }
            if (var4_5 instanceof IAdminProp) {
                IAdminProp iAdminProp2 = var4_5;
                if (iAdminProp != null) {
                    iAdminProp2.setProp(4784130, iAdminProp);
                }
                return iAdminProp2;
            }
            AdminProp.errorMessageLn(String.valueOf(this.getMessage(8000)) + string);
            return null;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return null;
        }
    }

    public void addConfigFilters(int n, ConfigFilterList configFilterList) {
        ConfigFilterList configFilterList2 = null;
        if (configFilterList == null) {
            return;
        }
        if (n == 10 && this.m_filterchilds == null) {
            this.m_filterchilds = configFilterList;
            return;
        }
        if (n == 15 && this.m_filterprops == null) {
            this.m_filterprops = configFilterList;
            return;
        }
        if (n == 20 && this.m_filtercommands == null) {
            this.m_filtercommands = configFilterList;
            return;
        }
        configFilterList2 = n == 10 ? this.m_filterchilds : (n == 20 ? this.m_filtercommands : this.m_filterprops);
        Vector vector = configFilterList.getAllFilters();
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            configFilterList2.addFilter((ConfigFilter)vector.elementAt(n2));
            ++n2;
        }
    }

    private AdminConfig getConfigCache(String string, boolean bl) {
        AdminConfig adminConfig = null;
        if (this.m_root == null) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("getConfigCache::Looking up url: " + string);
            }
            if (this.m_profile != null) {
                adminConfig = this.m_profile.getConfigObject(string, bl);
            } else {
                try {
                    if (DEBUG) {
                        AdminProp.sDebugMessageLn("Object: " + this.getAdmPropURL(true));
                    }
                    if (DEBUG) {
                        AdminProp.sDebugMessageLn("getConfigCache::No profile info.");
                    }
                }
                catch (PropertyException propertyException) {
                    AdminProp.sUnexpectedException(propertyException);
                }
            }
            if (DEBUG) {
                AdminProp.sDebugMessageLn("Found config in cahce:  " + adminConfig);
            }
            return adminConfig;
        }
        return this.m_root.getConfigCache(string, bl);
    }

    private IAdminProp getChildCache(String string) {
        if (this.m_root == null) {
            if (this.m_child_cache != null) {
                return (IAdminProp)this.m_child_cache.get(string);
            }
            AdminProp.errorMessageLn("Internal -- AdminTransform root is missing child cache: " + this.m_admprop.getClass().getName());
            return null;
        }
        return this.m_root.getChildCache(string);
    }

    private void putChildCache(IAdminProp iAdminProp, String string) {
        if (this.m_root == null) {
            if (this.m_child_cache == null) {
                AdminProp.errorMessageLn("Internal -- AdminTransform root is missing child cache: " + this.m_admprop.getClass().getName());
                return;
            }
            this.m_child_cache.put(string, iAdminProp);
            return;
        }
        this.m_root.putChildCache(iAdminProp, string);
    }

    public IAdminProp resolveURL(IAdminProp iAdminProp, AdminURL adminURL) {
        if (adminURL == null) {
            return null;
        }
        IAdminProp iAdminProp2 = null;
        Enumeration enumeration = adminURL.getPathEnumerator();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.debugMessageLn("resolveURL::Looking for: " + string);
            iAdminProp2 = this.getChildCache(string);
            if (iAdminProp2 != null) {
                this.debugMessageLn("resolveURL::found cached: " + string);
                iAdminProp = iAdminProp2;
                continue;
            }
            if (iAdminProp == null) continue;
            try {
                String string2;
                String string3 = AdminURL.getViewObject(string);
                String string4 = null;
                if (string3 != null) {
                    string2 = string3;
                    string4 = AdminURL.getObjComponent(string);
                } else {
                    string3 = string;
                    string2 = AdminURL.getObjComponent(string3);
                }
                int n = AdminURL.getComponentModifier(string3);
                if (n == -1 && string2 == string3) {
                    n = AdminURL.getComponentModifier(string);
                }
                if (DEBUG) {
                    AdminProp.sDebugMessageLn("resolveURL: getChildren looking for: " + string3 + " propid: " + n);
                }
                Object[] objectArray = null;
                iAdminProp2 = null;
                int n2 = 0;
                while (n2 < 5) {
                    objectArray = (Object[])iAdminProp.getProp(n);
                    if (objectArray != null) break;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                if (objectArray != null) {
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        string3 = (String)((IAdminProp)objectArray[n3]).getProp(2032789);
                        if (DEBUG) {
                            AdminProp.sDebugMessageLn("resolveURL: getChildren child[" + n3 + "] " + string3);
                        }
                        this.putChildCache((IAdminProp)objectArray[n3], string3);
                        if (string2.equalsIgnoreCase(string3) || string4 != null && string4.equalsIgnoreCase(string3)) {
                            iAdminProp = iAdminProp2 = (IAdminProp)objectArray[n3];
                            if (!DEBUG) break;
                            AdminProp.sDebugMessageLn("resolveURL: getChildren found: " + string3 + " at child[" + n3 + "]\n");
                            break;
                        }
                        ++n3;
                    }
                }
                if (iAdminProp2 != null || !DEBUG) continue;
                AdminProp.sDebugMessageLn("resolveURL: bad url component, child not found: " + string3 + " from: " + adminURL);
            }
            catch (MalformedURLException malformedURLException) {
                AdminProp.sUnexpectedException(malformedURLException);
            }
            catch (PropertyException propertyException) {}
        }
        return iAdminProp2;
    }

    public Vector resolveChildFilters(Vector vector) {
        if (vector == null || vector.size() == 0) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("resolveChildFilters():: returning null");
            }
            return null;
        }
        Vector<IAdminProp> vector2 = new Vector<IAdminProp>();
        IAdminProp iAdminProp = this.m_root == null ? this.getAdmPropObj() : this.m_root.getAdmPropObj();
        int n = 0;
        while (n < vector.size()) {
            ChildFilter childFilter = (ChildFilter)vector.elementAt(n);
            if ((childFilter.getChildFilterOp() & 1) != 0) {
                IAdminProp iAdminProp2;
                if (DEBUG) {
                    AdminProp.sDebugMessageLn("resolveChildFilters():: resolving: " + childFilter.getChildDescriptor().getURL());
                }
                if ((iAdminProp2 = this.resolveURL(iAdminProp, childFilter.getChildDescriptor().getURL())) != null) {
                    vector2.addElement(iAdminProp2);
                } else {
                    AdminProp.errorMessageLn("AdminTransform::Could not resolve URL: " + childFilter.getChildDescriptor().getURL());
                }
            }
            ++n;
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    public Object[] applyCommandFilter(Object[] objectArray) throws PropertyException {
        if (objectArray == null || this.m_filtercommands == null) {
            return objectArray;
        }
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < objectArray.length) {
            block12: {
                block11: {
                    int n2;
                    int n3 = (Integer)((AdminProp)objectArray[n]).getProp(2687496);
                    CommandFilter commandFilter = (CommandFilter)this.m_filtercommands.getFilter(n3, false);
                    if (commandFilter == null) break block11;
                    if (DEBUG) {
                        AdminProp.sDebugMessageLn("applyCommandFilters()::Found filter.");
                    }
                    if ((n2 = commandFilter.getCommandFilterOp()) == 2) break block12;
                    if (n2 == 1) {
                        ((AdminProp)objectArray[n]).setProp(8978948, (Object)new Boolean(false));
                    } else if (n2 == 4) {
                        ((AdminProp)objectArray[n]).setProp(8978948, (Object)new Boolean(true));
                    }
                    String string = commandFilter.getName();
                    if (string != null) {
                        ((AdminProp)objectArray[n]).setProp(0x110001, (Object)string);
                    }
                    if ((string = commandFilter.getDescription()) != null) {
                        ((AdminProp)objectArray[n]).setProp(1638914, (Object)string);
                    }
                }
                vector.addElement(objectArray[n]);
            }
            ++n;
        }
        return AdminProp.vectorToObjectArray(vector);
    }

    public Vector applyChildFilters(int n, Object[] objectArray, boolean bl) {
        Vector vector;
        Vector vector2;
        AdminTransform adminTransform = null;
        Vector<AdminTransform> vector3 = new Vector<AdminTransform>();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        if (!bl || this.m_filterchilds == null) {
            if (DEBUG_CHILD_FILTERS && DEBUG) {
                AdminProp.sDebugMessageLn("applyChildFilters::No filters, wrapping existing children.");
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                block30: {
                    if (this.isDebug()) {
                        try {
                            String string = (String)((IAdminProp)objectArray[n2]).getProp(2032789);
                            if (DEBUG_CHILD_FILTERS) {
                                this.debugMessageLn("applyChildFilters::wrapping " + string);
                            }
                        }
                        catch (Exception exception) {
                            AdminProp.errorMessageLn("applyChildFilters::get kid url excepted.");
                            AdminProp.sUnexpectedException(exception);
                        }
                    }
                    if (objectArray[n2] == null) {
                        vector3.addElement(null);
                    } else {
                        adminTransform = new AdminTransform(this.m_mode, (IAdminProp)objectArray[n2], this, this.m_root == null ? this : this.m_root, this.m_profile);
                        try {
                            adminTransform.setPredecessor(this);
                            adminTransform.setProp(0x209002, (Object)new Integer(n));
                        }
                        catch (PropertyException propertyException) {
                            AdminProp.sUnexpectedException(propertyException);
                            break block30;
                        }
                        vector3.addElement(adminTransform);
                    }
                }
                ++n2;
            }
            return vector3;
        }
        if (DEBUG_CHILD_FILTERS && DEBUG) {
            AdminProp.sDebugMessageLn("applyChildFilters()::Applying filters to: " + objectArray.length + " kids.");
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            block31: {
                AdminURL adminURL;
                block33: {
                    int n4;
                    block34: {
                        ChildFilter childFilter;
                        try {
                            String string = this.getAdmPropURL(true);
                            String string2 = (String)((AdminProp)objectArray[n3]).getProp(2032789);
                            adminURL = new AdminURL(string, string2, n);
                        }
                        catch (MalformedURLException malformedURLException) {
                            AdminProp.sUnexpectedException(malformedURLException);
                            break block31;
                        }
                        catch (PropertyException propertyException) {
                            AdminProp.sUnexpectedException(propertyException);
                            break block31;
                        }
                        if (DEBUG_CHILD_FILTERS && DEBUG) {
                            AdminProp.sDebugMessageLn("applyChildFilters()::Looking for filter on: " + adminURL);
                        }
                        if ((childFilter = (ChildFilter)this.m_filterchilds.getFilter(n, new ConfigChildDesc(adminURL), false)) == null) break block33;
                        if (DEBUG_CHILD_FILTERS && DEBUG) {
                            AdminProp.sDebugMessageLn("applyChildFilters()::Found filter.");
                        }
                        if ((n4 = childFilter.getChildFilterOp()) != 2) break block34;
                        adminTransform = new AdminTransform(this.m_mode, (IAdminProp)objectArray[n3], this, this.m_root == null ? this : this.m_root, this.m_profile);
                        break block31;
                    }
                    if (n4 == 1) break block31;
                }
                if (DEBUG_CHILD_FILTERS && DEBUG) {
                    AdminProp.sDebugMessageLn("applyChildFilters()::Wrapping " + adminURL);
                }
                adminTransform = new AdminTransform(this.m_mode, (IAdminProp)objectArray[n3], this, this.m_root == null ? this : this.m_root, this.m_profile);
                try {
                    adminTransform.setPredecessor(this);
                    adminTransform.setProp(0x209002, (Object)new Integer(n));
                }
                catch (PropertyException propertyException) {
                    AdminProp.sUnexpectedException(propertyException);
                }
                vector3.addElement(adminTransform);
            }
            ++n3;
        }
        if (DEBUG_CHILD_FILTERS && DEBUG) {
            AdminProp.sDebugMessageLn("applyChildFilters()::Looking for 'add' filters.");
        }
        if ((vector2 = this.m_filterchilds.getChildFilters(n, 1, false)) != null && DEBUG_CHILD_FILTERS && DEBUG) {
            AdminProp.sDebugMessageLn("applyChildFilters::Found " + vector2.size() + " addChild filters");
        }
        if ((vector = this.resolveChildFilters(vector2)) == null) {
            return vector3;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            block32: {
                adminTransform = new AdminTransform(this.m_mode, (IAdminProp)vector.elementAt(n3), this, this.m_root == null ? this : this.m_root, this.m_profile);
                try {
                    adminTransform.setPredecessor(this);
                    adminTransform.setProp(0x209002, (Object)new Integer(n));
                }
                catch (PropertyException propertyException) {
                    AdminProp.sUnexpectedException(propertyException);
                    break block32;
                }
                vector3.addElement(adminTransform);
            }
            ++n3;
        }
        return vector3;
    }

    /*
     * Exception decompiling
     */
    private int[] applyPropertyFilters(int var1_1, int[] var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getPropName(int n) {
        String string;
        PropFilter propFilter = null;
        if (this.m_filterprops != null) {
            propFilter = (PropFilter)this.m_filterprops.getFilter(n, true);
        }
        if (propFilter != null && (string = propFilter.getPropName()) != null) {
            return string;
        }
        return this.m_admprop.getPropName(n);
    }

    public String getPropDescription(int n) {
        String string;
        PropFilter propFilter = null;
        if (this.m_filterprops != null) {
            propFilter = (PropFilter)this.m_filterprops.getFilter(n, true);
        }
        if (propFilter != null && (string = propFilter.getPropDescription()) != null) {
            return string;
        }
        return this.m_admprop.getPropDescription(n);
    }

    public void deleteProp(int n) throws PropertyException {
        this.m_admprop.deleteProp(n);
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        int n;
        try {
            this.updateConfigPropValue(adminPropertyChangeEvent.getPropId(), adminPropertyChangeEvent.getNewValue());
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        if (this.m_adminPropertyChangeListener == null || (n = this.m_adminPropertyChangeListener.size()) == 0) {
            return;
        }
        adminPropertyChangeEvent = new AdminPropertyChangeEvent(this, adminPropertyChangeEvent);
        int n2 = 0;
        while (n2 < n) {
            AdminPropertyChangeListener adminPropertyChangeListener = (AdminPropertyChangeListener)this.m_adminPropertyChangeListener.elementAt(n2);
            adminPropertyChangeListener.adminPropertyChange(adminPropertyChangeEvent);
            ++n2;
        }
    }

    public Object getProp(int n) throws PropertyException {
        Integer n2 = (Integer)this.m_admprop.getProp(3080204);
        boolean bl = true;
        if ((n2 & 0x6000) == 24576) {
            bl = false;
        }
        if (AdminProp.getPropType(n) == 0x10400000) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("getProp()::Request made for XXX_LIST property.");
            }
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            objectArray = (Object[])this.m_admprop.getProp(n);
            if (objectArray != null) {
                objectArray2 = AdminProp.vectorToObjectArray(this.applyChildFilters(n, objectArray, bl));
            }
            if ((n == 273613313 || n == 273220108) && objectArray2 != null) {
                objectArray2 = this.applyCommandFilter(objectArray2);
            }
            if (this.m_mode == 5) {
                switch (n) {
                    case 273613313: {
                        if ((n2 & 0x40) != 0) break;
                    }
                    case 273220108: {
                        int n3;
                        IAdminProp[] iAdminPropArray = null;
                        if (objectArray == null) {
                            iAdminPropArray = new IAdminProp[1];
                            n3 = 0;
                        } else {
                            iAdminPropArray = new IAdminProp[objectArray2.length + 2];
                            n3 = 0;
                            while (n3 < objectArray2.length) {
                                iAdminPropArray[n3] = (IAdminProp)objectArray2[n3];
                                ++n3;
                            }
                            iAdminPropArray[n3++] = new CommandProp((IAdminProp)this, 0, null, null, 8);
                        }
                        AdminConfig adminConfig = this.getConfigObj((Integer)this.m_admprop.getProp(3080204));
                        if (adminConfig != null) {
                            adminConfig.setTransformerOwner(this);
                        }
                        String string = (String)adminConfig.getProp(0x101100);
                        iAdminPropArray[n3] = new CommandProp((IAdminProp)this, 1, String.valueOf(this.getMessage(2)) + " \"" + string + "\"", this.getMessage(3), 1, "images/msupdate.gif");
                        this.m_cnfgbtn = (CommandProp)iAdminPropArray[n3];
                        objectArray2 = iAdminPropArray;
                        break;
                    }
                }
            }
            return objectArray2;
        }
        switch (n) {
            case 5148672: {
                return this.getPredecessor();
            }
            case 2032789: {
                return this.getAdmPropURL(true);
            }
            case 0x209002: {
                return new Integer(this.getAdmPropURLsuffix());
            }
            case 5148673: {
                return this.getAdmPropObj();
            }
            case 4296715: {
                return this.getConfigObj(n2);
            }
            case 2686979: {
                Integer n4 = (Integer)this.m_admprop.getProp(n);
                if (bl && this.m_mode == 5) {
                    return new Integer(3 | n4);
                }
                return n4;
            }
            case 281083944: 
            case 281083945: 
            case 281083972: 
            case 281608214: 
            case 281608215: 
            case 282001412: 
            case 282001422: 
            case 282001424: {
                int[] nArray = (int[])this.m_admprop.getProp(n);
                if (this.isDebug() && nArray != null) {
                    this.debugMessageLn("AdminTransform::getProp(PropList): raw props=" + nArray.length);
                }
                return this.applyPropertyFilters(n, nArray, bl);
            }
        }
        int n5 = n;
        PropFilter propFilter = null;
        if (this.m_filterprops != null) {
            propFilter = (PropFilter)this.m_filterprops.getFilter(n, true);
        }
        if (propFilter != null) {
            if (DEBUG) {
                AdminProp.sDebugMessageLn("Unfiltering propid=0x" + Integer.toHexString(n) + " removing 0x" + Integer.toHexString(propFilter.getPropFlags()));
            }
            n5 &= ~propFilter.getPropFlags();
        }
        return this.m_admprop.getProp(n5);
    }

    public void setProp(int n, Object object) throws PropertyException {
        if (n == 4784134 || this.m_admprop == null) {
            super.setProp(n, object);
            return;
        }
        if ((n & 0x60000) != 0 && (n & 0x60000000) == 0) {
            throw new PropertyException("AdminTransform::setProp called on readonly property " + this.getClass().getName() + ".propID=" + Integer.toHexString(n), 1, n, null);
        }
        switch (n) {
            case 0x209002: {
                this.setAdmPropURLsuffix((Integer)object);
                return;
            }
            case 4296715: {
                this.setConfigObj((AdminConfig)object);
                return;
            }
        }
        int n2 = n;
        PropFilter propFilter = null;
        if (this.m_filterprops != null) {
            propFilter = (PropFilter)this.m_filterprops.getFilter(n, true);
        }
        if (propFilter != null) {
            this.debugMessageLn("Unfiltering propid=0x" + Integer.toHexString(n) + " removing 0x" + Integer.toHexString(propFilter.getPropFlags()));
            n2 &= ~propFilter.getPropFlags();
        }
        this.m_admprop.setProp(n2, object);
    }

    public void setProps(int[] nArray, Object[] objectArray) throws PropertyException {
        this.m_admprop.setProps(nArray, objectArray);
    }

    public void saveChanges(int n) throws SaveChangeException {
        this.m_admprop.saveChanges(n);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        AdminConfig adminConfig = this.getConfigObj((Integer)this.m_admprop.getProp(3080204));
        if (adminConfig != null) {
            adminConfig.setTransformerOwner(this);
        }
        if (DEBUG) {
            System.out.println("Ready?");
        }
        if (DEBUG) {
            System.out.println("DO CONFIGURATION [" + this + "](" + this.m_profile + "){" + adminConfig + "}");
        }
        return adminConfig;
    }

    public static void main(String[] stringArray) {
        AdminTransform adminTransform;
        AdminProp adminProp;
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        System.out.println("Starting AdminTransform Tests");
        AdminProp adminProp2 = new AdminProp();
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        String[] stringArray2 = new String[5];
        String string = "REMOTE-_CHACHA@IDCSUN3(0x2005)";
        nArray[0] = 0x102000;
        nArray[1] = 0x202001;
        nArray[2] = 0x202002;
        nArray[3] = 0x202003;
        nArray[4] = 1056772;
        nArray2[0] = -1;
        nArray2[4] = -1;
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        stringArray2[0] = "Initial String Value1";
        stringArray2[3] = null;
        stringArray2[2] = null;
        stringArray2[1] = null;
        stringArray2[4] = "Initial String Value4";
        adminProp2.registerProp(nArray[0], "aprop1", "a string property");
        adminProp2.registerProp(nArray[1], "aprop2", "an int property");
        adminProp2.registerProp(nArray[2], "aprop3", "another int property");
        adminProp2.registerProp(nArray[3], "aprop4", "yet another int property");
        adminProp2.registerProp(nArray[4], "aprop5", "another string property");
        try {
            adminProp2.setProp(nArray[0], (Object)stringArray2[0]);
            adminProp2.setProp(nArray[1], (Object)new Integer(nArray2[1]));
            adminProp2.setProp(nArray[2], (Object)new Integer(nArray2[2]));
            adminProp2.setProp(nArray[3], (Object)new Integer(nArray2[3]));
            adminProp2.setProp(nArray[4], (Object)stringArray2[4]);
            adminProp2.setProp(0x110001, (Object)string);
            if (nArray2[1] != (Integer)adminProp2.getProp(nArray[1])) {
                System.out.println("TestSetup::ap object not storing setProp()");
                return;
            }
            if (!string.equals(adminProp2.getProp(2032789))) {
                System.out.println("TestSetup::ap obj URL not stored.");
                return;
            }
        }
        catch (PropertyException propertyException) {
            System.out.println("TestSetup::ap obj test setup excepted:");
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
        AdminTransform adminTransform2 = new AdminTransform(1, adminProp2, null);
        try {
            object4 = (AdminConfig)adminTransform2.getProp(4296715);
            if (object4 == null) {
                throw new PropertyException("Test1::get config object test return null.", 2, 4296715, object4);
            }
            adminProp2.setProp(nArray[2], (Object)new Integer(999));
            adminProp2.setProp(nArray[4], (Object)"Another String value");
            adminTransform2.setProp(4296715, object4);
            if ((Integer)adminTransform2.getProp(nArray[1]) != nArray2[1] || (Integer)adminTransform2.getProp(nArray[2]) != nArray2[2] || (Integer)adminTransform2.getProp(nArray[3]) != nArray2[3]) {
                System.out.println("Test2::set(PR_CONFIG_OBJ) failed on int props .");
            }
            if (!stringArray2[0].equals((String)adminTransform2.getProp(nArray[0])) || !stringArray2[4].equals((String)adminTransform2.getProp(nArray[4]))) {
                System.out.println("Test2::set(PR_CONFIG_OBJ) failed on str props .");
            }
        }
        catch (PropertyException propertyException) {
            System.out.println("AdminTransform::get/set(PR_CONFIG_OBJ) excepted.");
            AdminProp.sUnexpectedException(propertyException);
        }
        try {
            object4 = (int[])adminTransform2.getProp(282001422);
            if (object4 == null || ((Object)object4).length == 0) {
                System.out.println("Test3setup::get visible prop list returned null list.");
                return;
            }
            int n = 0;
            while (n < ((Object)object4).length) {
                if (object4[n] != 0x110001 && object4[n] != nArray[n]) {
                    System.out.println("Test3setup::visible prop list mismatch: \norig: " + nArray[n] + "\ngetd: " + (int)object4[n]);
                    return;
                }
                ++n;
            }
        }
        catch (PropertyException propertyException) {
            System.out.println("Test3setup::get visible prop list excepted:");
            AdminProp.sUnexpectedException(propertyException);
        }
        object4 = new ConfigFilterList(15);
        ((ConfigFilterList)object4).addPropFilter(nArray[0], 65536, null, null);
        ((ConfigFilterList)object4).addPropFilter(nArray[1], 393216, null, null);
        String string2 = "3aprop";
        String string3 = "This is a prop filter test";
        ((ConfigFilterList)object4).addPropFilter(nArray[2], 0, string2, string3);
        adminTransform2.addConfigFilters(15, (ConfigFilterList)object4);
        try {
            object3 = (int[])adminTransform2.getProp(282001422);
            if (object3 == null || ((int[])object3).length == 0) {
                System.out.println("Test3::get visible prop list returned null list.");
                return;
            }
            if (((int[])object3).length == nArray.length) {
                System.out.println("Test3::get visible prop list returned all props.");
                int n = 0;
                while (n < ((int[])object3).length) {
                    System.out.println("vplst[" + n + "]=0x" + Integer.toHexString(object3[n]));
                    ++n;
                }
                return;
            }
            int n = 0;
            while (n < ((int[])object3).length) {
                if (object3[n] == nArray[0]) {
                    System.out.println("Test3::Invisible prop filter not filtering properly.");
                }
                if (object3[n] == nArray[1]) {
                    System.out.println("Test3::ReadOnly prop filter not filtering properly.");
                }
                if (object3[n] == nArray[2]) {
                    object2 = adminTransform2.getPropName(object3[n]);
                    object = adminTransform2.getPropDescription(object3[n]);
                    if (!string2.equals(object2) || !string3.equals(object)) {
                        System.out.println("Test3::prop name/desc filters not working properly.");
                    }
                }
                ++n;
            }
            if ((Integer)adminTransform2.getProp(object3[0]) != nArray2[1]) {
                System.out.println("Test3::Readonly prop filter misdirects property id:\ncorrect value: " + nArray2[1] + "\nretrieved value:" + (Integer)adminTransform2.getProp(nArray[1]));
            }
            try {
                adminTransform2.setProp(object3[0], (Object)new Integer(9999));
                System.out.println("Test3::Readonly prop filter allows writing.");
            }
            catch (PropertyException propertyException) {}
        }
        catch (PropertyException propertyException) {
            System.out.println("Test3 excepted:");
            AdminProp.sUnexpectedException(propertyException);
        }
        object3 = new AdminProp();
        AdminProp adminProp3 = new AdminProp();
        object2 = new AdminProp();
        object = new AdminProp();
        AdminProp adminProp4 = new AdminProp();
        AdminProp adminProp5 = new AdminProp();
        AdminProp adminProp6 = new AdminProp();
        AdminProp adminProp7 = new AdminProp();
        AdminProp adminProp8 = new AdminProp();
        AdminProp adminProp9 = new AdminProp();
        String[] stringArray3 = new String[10];
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = new Object[3];
        Object[] objectArray4 = new Object[2];
        Object[] objectArray5 = new Object[1];
        Object[] objectArray6 = new Object[1];
        stringArray3[0] = "A";
        stringArray3[1] = "B1";
        stringArray3[2] = "B2";
        stringArray3[3] = "C1";
        stringArray3[4] = "C2";
        stringArray3[5] = "C3";
        stringArray3[6] = "D1";
        stringArray3[7] = "D2";
        stringArray3[8] = "E1";
        stringArray3[9] = "E2";
        try {
            ((AdminProp)object3).setProp(0x110001, (Object)stringArray3[0]);
            adminProp3.setProp(0x110001, (Object)stringArray3[1]);
            ((AdminProp)object2).setProp(0x110001, (Object)stringArray3[2]);
            ((AdminProp)object).setProp(0x110001, (Object)stringArray3[3]);
            adminProp4.setProp(0x110001, (Object)stringArray3[4]);
            adminProp5.setProp(0x110001, (Object)stringArray3[5]);
            adminProp6.setProp(0x110001, (Object)stringArray3[6]);
            adminProp7.setProp(0x110001, (Object)stringArray3[7]);
            adminProp8.setProp(0x110001, (Object)stringArray3[8]);
            adminProp9.setProp(0x110001, (Object)stringArray3[9]);
            ((AdminProp)object3).setProp(273612805, (Object)objectArray2);
            adminProp3.setProp(273612805, (Object)objectArray3);
            ((AdminProp)object2).setProp(273612805, (Object)objectArray4);
            adminProp4.setProp(273612805, (Object)objectArray5);
            adminProp6.setProp(273612805, (Object)objectArray6);
            objectArray2[0] = adminProp3;
            objectArray2[1] = object2;
            objectArray3[0] = object;
            objectArray3[1] = adminProp4;
            objectArray3[2] = adminProp5;
            objectArray4[0] = adminProp6;
            objectArray4[1] = adminProp7;
            objectArray5[0] = adminProp8;
            objectArray6[0] = adminProp9;
        }
        catch (PropertyException propertyException) {
            System.out.println("Test4Setup::Exception while configuring tree");
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
        AdminTransform adminTransform3 = new AdminTransform(1, (IAdminProp)object3, null);
        String string4 = "http://foo/A/B1(0x104f0005)/C2(0x104f0005)/E1(0x104f0005)";
        try {
            objectArray = (Object[])adminTransform3.getProp(273612805);
            adminProp = (AdminProp)objectArray[0];
            objectArray = (Object[])adminProp.getProp(273612805);
            adminProp = (AdminProp)objectArray[1];
            objectArray = (Object[])adminProp.getProp(273612805);
            adminProp = (AdminProp)objectArray[0];
            if (!string4.equals((String)adminProp.getProp(2032789))) {
                System.out.println("Test4::Generated url is different from expected:\n Expected: " + string4 + "\nGenerated: " + (String)adminProp.getProp(2032789));
            }
        }
        catch (PropertyException propertyException) {
            System.out.println("Test4::Exception while traversing Transform tree");
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
        string4 = "http://foo/A/B2(0x104f0005)/D1(0x104f0005)/E2(0x104f0005)";
        try {
            adminProp = (AdminProp)adminTransform3.resolveURL(adminTransform3, new AdminURL(string4));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Test5::setup test url excepted.");
            AdminProp.sUnexpectedException(malformedURLException);
        }
        if (adminProp == null) {
            System.out.println("Test5::Test url resolved to null");
            return;
        }
        if (adminProp != adminProp9) {
            try {
                System.out.println("Test5::Url resolved to different object:\nexpected: " + adminProp9.getProp(0x110001) + "\nresolved: " + (String)adminProp.getProp(0x110001));
                return;
            }
            catch (PropertyException propertyException) {
                System.out.println("Test5::Url resolved to different object.");
                AdminProp.sUnexpectedException(propertyException);
                return;
            }
        }
        String string5 = "http://foo/A/B1(0x104f0005)";
        String string6 = "http://foo/A/B1(0x104f0005)/C2(0x104f0005)";
        String string7 = "http://foo/A/B1(0x104f0005)/C2(0x104f0005)/E1(0x104f0005)";
        String string8 = "http://foo/A/B2(0x104f0005)/D1(0x104f0005)/E2(0x104f0005)";
        ConfigFilterList configFilterList = new ConfigFilterList(10);
        ConfigFilterList configFilterList2 = new ConfigFilterList(10);
        try {
            configFilterList.addChildFilter(273612805, "http://foo/A/B2(0x104f0005)", 2);
            configFilterList2.addChildFilter(273612805, "http://foo/A/B1(0x104f0005)/C1(0x104f0005)", 2);
            configFilterList2.addChildFilter(273612805, string6, 2);
            configFilterList2.addChildFilter(273612805, "http://foo/A/B1(0x104f0005)/C3(0x104f0005)", 2);
            configFilterList.addChildFilter(273612805, string6, 1);
            configFilterList.addChildFilter(273612805, string8, 1);
            configFilterList.addChildFilter(273612805, string5, 4);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Test6::setup filter creation excepted.");
            AdminProp.sUnexpectedException(malformedURLException);
            return;
        }
        adminTransform3 = new AdminTransform(1, (IAdminProp)object3, null);
        adminTransform3.addConfigFilters(10, configFilterList);
        try {
            objectArray = (Object[])adminTransform3.getProp(273612805);
            adminTransform = (AdminTransform)objectArray[0];
            adminProp3 = (AdminProp)adminTransform3.resolveURL(adminTransform3, new AdminURL(string5));
            adminProp4 = (AdminProp)adminTransform3.resolveURL(adminTransform3, new AdminURL(string6));
            adminProp8 = (AdminProp)adminTransform3.resolveURL(adminTransform3, new AdminURL(string7));
            adminProp9 = (AdminProp)adminTransform3.resolveURL(adminTransform3, new AdminURL(string8));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Test6::setup object resolution excepted.");
            AdminProp.sUnexpectedException(malformedURLException);
            return;
        }
        catch (PropertyException propertyException) {
            System.out.println("Test6::setup object resolution excepted.");
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
        if (adminProp3 == null || adminProp4 == null || adminProp8 == null || adminProp9 == null) {
            System.out.println("Test6::setup objects could not be resolved.");
            return;
        }
        adminTransform.addConfigFilters(10, configFilterList2);
        try {
            int n;
            objectArray = (Object[])adminTransform3.getProp(273612805);
            if (objectArray == null) {
                System.out.println("Test6::No Filtered A children found.");
                return;
            }
            if (objectArray.length != 3) {
                System.out.println("Test6::Number of filtered kids different from expected:\nexpected: 3\ngot: " + objectArray.length);
                n = 0;
                while (n < objectArray.length) {
                    System.out.println("kids[" + n + "]=" + ((AdminProp)objectArray[0]).getProp(2032789));
                    ++n;
                }
            }
            if (((AdminTransform)objectArray[0]).getAdmPropObj() != adminProp3) {
                System.out.println("Test6::Filtered child B1 not found.");
                System.out.println("kids[0]=" + ((AdminProp)objectArray[0]).getProp(2032789));
            }
            if (((AdminTransform)objectArray[1]).getAdmPropObj() != adminProp4) {
                System.out.println("Test6::Filtered child C2 not found.");
                System.out.println("kids[1]=" + ((AdminProp)objectArray[1]).getProp(2032789));
            }
            adminProp = (AdminTransform)objectArray[1];
            if (((AdminTransform)objectArray[2]).getAdmPropObj() != adminProp9) {
                System.out.println("Test6::Filtered child E2 not found.");
                System.out.println("kids[2]=" + ((AdminProp)objectArray[2]).getProp(2032789));
            }
            if ((objectArray = (Object[])adminProp.getProp(273612805)) == null) {
                System.out.println("Test6::No C2 children found.");
                return;
            }
            if (objectArray.length != 1) {
                System.out.println("Test6::Number of C2 kids different from expected:\nexpected: 1\ngot: " + objectArray.length);
                n = 0;
                while (n < objectArray.length) {
                    System.out.println("kids[" + n + "]=" + ((AdminProp)objectArray[0]).getProp(2032789));
                    ++n;
                }
            }
            if (((AdminTransform)objectArray[0]).getAdmPropObj() != adminProp8) {
                System.out.println("Test6::C2 child E1 not found.");
                System.out.println("kids[0]=" + ((AdminProp)objectArray[0]).getProp(2032789));
            }
        }
        catch (PropertyException propertyException) {
            System.out.println("Test6::Exception while traversing filtered Transform tree");
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
        System.out.println("Ending AdminTransform Tests");
    }
}

