/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.AppServerUser;
import oracle.ldap.admin.appserver.AuthenticationException;
import oracle.ldap.admin.appserver.ProfileList;
import oracle.ldap.admin.appserver.Repository;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.appserver.UserList;
import oracle.ldap.admin.appserver.UserProfile;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminRoot;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class AppServer
extends AdminProp
implements ICommandParent {
    static boolean DEBUG;
    public static final int PR_SERVER_USER = 0x103000;
    public static final int PR_SERVER_PASSWD = 13643777;
    public static final int PR_SERVER_CONFIRM_PASSWD = 13643778;
    public static final int PR_SERVER_USER_READONLY = 1454083;
    public static final int LOGON_MODE = 0;
    public static final int DISPLAY_MODE = 1;
    static final String REPOSITORY_SERIALIZE_OUTPUT_FILE = "AdminServer.cfg";
    static final int LOGON_TITLE = 10;
    static final int ADM_APP_SERVER = 11;
    static final int USER_LIST = 15;
    static final int PROFILE_LIST = 16;
    static final int VERSION_STR = 17;
    static final int INCOMPLETE_LOGON = 18;
    static final int MAX_CHILDREN = 2;
    static final int ADM_PROFILES = 0;
    static final int ADM_USERS = 1;
    static final int FLAG_HIDEKIDS = 1;
    static final int CMD_SAVE_REPOSITORY = 1;
    static final int PR_STR_SAVE_REPOSITORY_BTNTEXT = 12289;
    static final int PR_STR_SAVE_REPOSITORY_DESCRIP = 12290;
    static int[] LOGON_PROPS;
    static int[] CHANGEPWD_PROPS;
    static boolean m_compress;
    static Repository m_pstore;
    AppServerUser m_user;
    String m_name;
    String m_passwd;
    String m_confirmPasswd;
    Vector m_kids;
    private String[] m_args;
    private boolean m_doInitArgs;
    boolean m_bConnected;
    IAdminProp[] m_cmds;
    int m_mode;
    int m_flag;

    public AppServer() {
        try {
            this.init();
            if (m_pstore == null) {
                m_pstore = AppServer.initRepository();
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        catch (PropertyException propertyException) {}
    }

    public AppServer(Repository repository, AppServerUser appServerUser) {
        try {
            this.init();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (PropertyException propertyException) {}
        m_pstore = repository;
        this.m_user = appServerUser;
        if (this.m_user != null) {
            this.m_name = this.m_user.getName();
            this.m_passwd = this.m_user.getPassword();
        }
    }

    private void init() throws IOException, ClassNotFoundException, PropertyException {
        this.m_user = null;
        this.m_kids = null;
        this.m_args = null;
        this.m_bConnected = false;
        this.m_name = null;
        this.m_passwd = null;
        this.m_confirmPasswd = null;
        this.m_args = null;
        this.m_doInitArgs = true;
        this.m_mode = 0;
        this.m_flag = 0;
        this.initCommand();
        this.registerProp(0x103000, "Username", "Name of Profile Repository user");
        this.registerProp(13643777, "Password", "Password of Profile Repository user");
        this.registerProp(13643778, "Confirm Password", "Confirm Password of Profile Repository user");
        this.registerProp(1454083, "Username", "Name of Profile Repository user");
        this.registerMessage(10, "Profile Repository Logon");
        this.registerMessage(11, "Profile Repository");
        this.registerMessage(15, "Users");
        this.registerMessage(16, "Profiles");
        this.registerMessage(17, "InterOffice Profile Repository\nv1.0");
        this.registerMessage(18, "You did not specify enough information to establish a connection to the Profile Repository");
    }

    public static Repository initRepository() throws IOException, ClassNotFoundException {
        Repository repository;
        String string = System.getProperty("user.home");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        if (string == null) {
            string = ".";
        }
        File file = new File(string, REPOSITORY_SERIALIZE_OUTPUT_FILE);
        if (DEBUG) {
            System.out.println("Config Path:" + string + " " + REPOSITORY_SERIALIZE_OUTPUT_FILE);
        }
        if (file.exists() && (repository = AppServer.loadRepository(file)) != null) {
            m_pstore = repository;
            return repository;
        }
        m_pstore = new Repository();
        return m_pstore;
    }

    public void initCommand() throws PropertyException {
        this.registerMessage(12289, "Save");
        this.registerMessage(12290, "Save the configuration into AdminServer.cfg");
        this.m_cmds = new IAdminProp[1];
        this.m_cmds[0] = new CommandProp((IAdminProp)this, 1, this.getMessage(12289), this.getMessage(12290), 1, "images/msupdate.gif");
    }

    public void parseArgs() {
        if (!this.m_doInitArgs) {
            return;
        }
        if (this.m_args != null) {
            int n = 0;
            while (n < this.m_args.length) {
                if (this.m_args[n].equals("-AppServer:Start") || this.m_args[n].equals("-ProfileRepository:Start")) {
                    ++n;
                    while (n < this.m_args.length) {
                        if (this.m_args[n].equals("-AppServer:End") || this.m_args[n].equals("-ProfileRepository:End")) break;
                        if (this.m_args[n].equals("-hideChildren")) {
                            this.setHideKids(true);
                            this.setMode(1);
                        } else if (this.m_args[n].charAt(0) == '-') {
                            System.out.println("Unknow arg " + this.m_args[n]);
                        }
                        ++n;
                    }
                }
                ++n;
            }
        }
        this.m_doInitArgs = false;
    }

    public void setArgs(String[] stringArray) {
        this.m_args = stringArray;
        this.m_doInitArgs = true;
    }

    public String[] getArgs() {
        return this.m_args;
    }

    public int getMode() {
        this.parseArgs();
        return this.m_mode;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public boolean isConnected() {
        return this.m_bConnected;
    }

    public void setConnected(boolean bl) {
        this.m_bConnected = bl;
    }

    public void setUser(AppServerUser appServerUser) {
        this.m_user = appServerUser;
        this.m_name = appServerUser.getName();
        this.m_passwd = appServerUser.getPassword();
    }

    public void setHideKids(boolean bl) {
        if (bl) {
            this.m_flag |= 1;
            return;
        }
        this.m_flag &= 0xFFFFFFFE;
    }

    public boolean getHideKids() {
        this.parseArgs();
        return (this.m_flag & 1) != 0;
    }

    private void setKidProp(int n, int n2, Object object) throws PropertyException {
        if (this.m_kids == null || this.getHideKids()) {
            return;
        }
        Vector vector = ((AdminList)this.m_kids.elementAt(n)).getChildren();
        int n3 = 0;
        while (n3 < vector.size()) {
            ((IAdminProp)vector.elementAt(n3)).setProp(n2, object);
            ++n3;
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: {
                return this.getMessage(11);
            }
            case 2031764: {
                return this.getMessage(10);
            }
            case 2686979: {
                return new Integer(3);
            }
            case 3080204: {
                return new Integer(0x200000 | (this.getMode() == 0 ? (this.isConnected() ? 4 : 0) | (this.isConnected() ? 8192 : 24576) : 64));
            }
            case 282001422: {
                if (this.getMode() == 1) {
                    return null;
                }
                if (this.getMode() == 0) {
                    if (this.m_name == null || this.m_name.length() == 0) {
                        return LOGON_PROPS;
                    }
                    return CHANGEPWD_PROPS;
                }
            }
            case 0x10190099: {
                return this.getArgs();
            }
            case 1048731: {
                return this.getMessage(17);
            }
            case 0x103000: 
            case 1454083: {
                return this.m_name;
            }
            case 13643777: {
                return this.m_passwd;
            }
            case 13643778: {
                if (this.m_confirmPasswd == null) {
                    return this.m_passwd;
                }
                return this.m_confirmPasswd;
            }
            case 273613313: {
                return this.m_cmds;
            }
            case 282002580: {
                int[] nArray = new int[]{0x103000};
                return nArray;
            }
            case 273612805: {
                if (DEBUG) {
                    System.out.println("retrieve PR_TREE_VIEW_CHILDREN_LIST");
                }
                if (this.getHideKids()) {
                    return null;
                }
                this.m_kids = new Vector(2);
                ProfileList profileList = new ProfileList(m_pstore);
                this.m_kids.addElement(profileList);
                UserList userList = new UserList(m_pstore);
                this.m_kids.addElement(userList);
                return AdminProp.vectorToObjectArray(this.m_kids);
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x103000: {
                this.m_name = (String)object;
                return;
            }
            case 13643777: {
                this.m_passwd = (String)object;
                return;
            }
            case 13643778: {
                this.m_confirmPasswd = (String)object;
                return;
            }
            case 8454180: {
                this.setKidProp(0, n, object);
                this.setKidProp(1, n, object);
                m_pstore.disconnect();
                return;
            }
            case 0x10190099: {
                this.setArgs((String[])object);
                return;
            }
        }
        super.setProp(n, object);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        try {
            switch (n) {
                case 1: {
                    String string = System.getProperty("user.home");
                    if (string == null) {
                        string = System.getProperty("java.home");
                    }
                    if (string == null) {
                        string = ".";
                    }
                    File file = new File(string, REPOSITORY_SERIALIZE_OUTPUT_FILE);
                    if (DEBUG) {
                        System.out.println("Config Path:" + string + " " + REPOSITORY_SERIALIZE_OUTPUT_FILE);
                    }
                    this.saveRepository(file);
                    return null;
                }
            }
            return null;
        }
        catch (IOException iOException) {
            if (n == 1 && DEBUG) {
                System.out.println("Unable to serialize the repository.");
            }
            iOException.printStackTrace();
            return null;
        }
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (DEBUG) {
            AdminProp.sDebugMessageLn("SaveChanges: authenticating user");
        }
        if (!this.isConnected()) {
            try {
                if (this.m_name == null) {
                    throw new SaveChangeException(this.getMessage(18), 4);
                }
                if (this.m_user == null) {
                    this.m_user = m_pstore.getUser(this.m_name);
                }
                this.m_user.authenticateUser(this.m_passwd);
                this.setConnected(true);
                return;
            }
            catch (RepositoryException repositoryException) {
                throw new SaveChangeException(repositoryException.getMessage(), 4);
            }
            catch (AuthenticationException authenticationException) {
                throw new SaveChangeException(authenticationException.getMessage(), 4);
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println("Exception while authentcating user.");
                }
                AdminProp.sUnexpectedException(exception);
                return;
            }
        }
        String string = this.m_user.getPassword();
        String string2 = this.m_passwd;
        String string3 = this.m_confirmPasswd;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (!string2.equals(string3)) {
            throw new SaveChangeException("Invalid password changes.");
        }
        if (!string2.equals(string)) {
            this.m_user.setPassword(string2);
        }
    }

    public void saveRepository(File file) throws IOException {
        ObjectOutputStream objectOutputStream;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (m_compress) {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        } else {
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
        }
        if (m_pstore != null) {
            m_pstore.saveToDatabase(objectOutputStream);
        }
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public static Repository loadRepository(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream;
        Object object;
        if (DEBUG) {
            System.out.print("Loading repository ...");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        if (m_compress) {
            object = new GZIPInputStream(fileInputStream);
            objectInputStream = new ObjectInputStream((InputStream)object);
        } else {
            objectInputStream = new ObjectInputStream(fileInputStream);
        }
        object = (Repository)objectInputStream.readObject();
        objectInputStream.close();
        if (DEBUG) {
            System.out.println("done.");
        }
        return object;
    }

    public static void main(String[] stringArray) {
    }

    public void changeToUserView() {
        try {
            AppServerUser appServerUser = m_pstore.getUser(this.m_name);
            if (appServerUser == null) {
                return;
            }
            UserProfile userProfile = m_pstore.createUserProfile(appServerUser.getProfiles());
            if (userProfile == null) {
                return;
            }
            if (DEBUG) {
                AdminProp.sDebugMessageLn("Creating user: " + this.m_name + " with profiles " + appServerUser.getProfiles());
            }
            AdminRoot adminRoot = new AdminRoot();
            AdminTransform adminTransform = new AdminTransform(5, adminRoot, userProfile);
            Vector<AdminTransform> vector = new Vector<AdminTransform>(1);
            vector.addElement(adminTransform);
            if (DEBUG) {
                System.out.println("Told app server root about it new children");
                return;
            }
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
    }

    static {
        LOGON_PROPS = new int[]{0x103000, 13643777};
        CHANGEPWD_PROPS = new int[]{1454083, 13643777, 13643778};
    }
}

