/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.AppServer;
import oracle.ldap.admin.appserver.AppServerUser;
import oracle.ldap.admin.appserver.AuthenticationException;
import oracle.ldap.admin.appserver.Repository;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class AppServerRoot
extends AdminProp {
    AppServerUser m_user;
    IAdminProp m_root;
    Object m_parent;
    String[] m_args;
    String m_name = "";
    String m_password = "";
    Object[] m_kids;
    public static final int PR_USER = 0x103000;
    public static final int PR_PASSWORD = 13643777;
    static final int LOGON_TITLE = 10;
    static final int INCOMPLETE_LOGON = 18;
    boolean m_connected = false;
    static Repository m_pstore;

    public Object getParent() {
        return this.m_parent;
    }

    public void setParent(Object object) {
        this.m_parent = object;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x103000, "User", "User name");
        this.registerProp(13643777, "Password", "User password");
        this.registerMessage(10, "Profile Repository Logon");
        this.registerMessage(18, "You did not specify enough information to establish a connection to the Profile Repository");
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x103000: {
                return this.m_name;
            }
            case 13643777: {
                return this.m_password;
            }
            case 0x10190099: {
                return this.m_args;
            }
            case 4784130: {
                return this.m_parent;
            }
            case 2686979: {
                return new Integer(3);
            }
            case 2031764: {
                return this.getMessage(10);
            }
            case 3080204: {
                if (this.isConnected()) {
                    return new Integer(1056772);
                }
                return new Integer(0x106000);
            }
            case 273612805: {
                if (this.m_user == null) {
                    return null;
                }
                this.m_kids = this.m_user.getRootChildren(this.m_args);
                this.m_user.clearKid();
                boolean bl = false;
                int n2 = 0;
                if (this.m_kids != null) {
                    int n3 = 0;
                    n2 = this.m_kids.length;
                    while (n3 < n2) {
                        if (this.m_kids[n3] instanceof AppServer || this.m_kids[n3] instanceof AdminTransform && ((AdminTransform)this.m_kids[n3]).m_admprop instanceof AppServer) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (!bl) {
                    AppServer appServer = new AppServer(m_pstore, this.m_user);
                    appServer.setHideKids(true);
                    appServer.setMode(0);
                    appServer.setConnected(true);
                    IAdminProp[] iAdminPropArray = new IAdminProp[n2 + 1];
                    int n4 = 0;
                    while (n4 < n2) {
                        iAdminPropArray[n4] = (IAdminProp)this.m_kids[n4];
                        ++n4;
                    }
                    iAdminPropArray[n2] = appServer;
                    this.m_kids = iAdminPropArray;
                }
                return this.m_kids;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x103000: {
                this.m_name = (String)object;
                return;
            }
            case 13643777: {
                this.m_password = (String)object;
                return;
            }
            case 4784130: {
                this.m_parent = object;
                return;
            }
            case 8454180: {
                if (this.m_user != null) {
                    this.m_user.setProp(n, object);
                }
                return;
            }
            case 0x10190099: {
                this.m_args = (String[])object;
                if (this.m_user != null) {
                    this.m_user.setProp(n, object);
                }
                return;
            }
        }
        super.setProp(n, object);
    }

    boolean isConnected() {
        return this.m_connected;
    }

    void setConnected(boolean bl) {
        this.m_connected = bl;
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            if (m_pstore == null) {
                m_pstore = AppServer.initRepository();
            }
            if (this.m_name == null) {
                throw new SaveChangeException(this.getMessage(18));
            }
            this.m_user = m_pstore.getUser(this.m_name);
            if (this.m_user == null) {
                throw new SaveChangeException("Logon information is incorrect.");
            }
            this.m_user.authenticateUser(this.m_password);
            this.setConnected(true);
            return;
        }
        catch (RepositoryException repositoryException) {
            throw new SaveChangeException(repositoryException.getMessage());
        }
        catch (AuthenticationException authenticationException) {
            throw new SaveChangeException(authenticationException.getMessage());
        }
        catch (SaveChangeException saveChangeException) {
            throw saveChangeException;
        }
        catch (Exception exception) {
            throw new SaveChangeException(exception.getMessage());
        }
    }
}

