/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import oracle.ldap.admin.appserver.ConfigChildDesc;
import oracle.ldap.admin.appserver.ConfigFilter;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.common.AdminURL;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class ChildFilter
extends ConfigFilter
implements Serializable {
    static boolean DEBUG;
    public static final int FOP_ADD_CHILD = 1;
    public static final int FOP_DEL_CHILD = 2;
    public static final int FOP_SHOW_CHILD = 4;
    public static final int INVALID_FILTER_OPERATOR = 16;
    static final int PR_CFILTER_CHILD_NAME = 1471250;
    static final int PR_CFILTER_CHILD_URL = 11957011;
    static final int PR_CFILTER_CHILD_OP = 1078033;
    ConfigChildDesc m_child_desc;
    int m_filterop;

    void init() {
        this.m_child_desc = null;
        this.m_filterop = 4;
        this.registerProp(11957011, "URL", "URL of the object to be filtered");
        this.registerProp(1078033, "Operation", "Filter operation to be applied to object");
        this.registerMessage(1, "Add");
        this.registerMessage(2, "Hide");
        this.registerMessage(4, "Show");
        this.registerMessage(16, "Invalid Child Filter Operator");
    }

    public ChildFilter(ConfigFilterList configFilterList, int n, AdminURL adminURL) throws MalformedURLException {
        this(configFilterList, n, adminURL.toString(), 4);
    }

    public ChildFilter(ConfigFilterList configFilterList, int n, String string) throws MalformedURLException {
        this(configFilterList, n, string, 4);
        if (n == -4) {
            this.registerProp(1471250, "Name", "Name of the object to be filtered");
        }
    }

    public ChildFilter(ConfigFilterList configFilterList, int n, String string, int n2) throws MalformedURLException {
        super(n, 10, configFilterList);
        this.init();
        this.m_child_desc = new ConfigChildDesc(1, string);
        this.m_filterop = n2;
        this.m_parent = configFilterList;
    }

    public ConfigChildDesc getChildDescriptor() {
        return this.m_child_desc;
    }

    public int getChildFilterOp() {
        return this.m_filterop;
    }

    public void setChildFilterOp(int n) {
        this.m_filterop = n;
        this.sendAdminPropertyChangeEvents(1078033, null);
    }

    public String toString() {
        String string = super.toString();
        String string2 = this.getMessage(this.m_filterop);
        if (this.m_child_desc == null) {
            return "Property: " + string + " Oper: " + string2 + " URL: none";
        }
        return "Property: " + string + " Oper: " + string2 + " URL: " + this.m_child_desc.toString();
    }

    public boolean equals(ChildFilter childFilter) {
        if (super.equals(childFilter)) {
            return this.m_child_desc.equals(childFilter.getChildDescriptor()) && this.m_filterop == childFilter.getChildFilterOp();
        }
        return false;
    }

    private int getOperation(Object object) throws PropertyException {
        if (object instanceof String) {
            if (object == this.getMessage(1)) {
                return 1;
            }
            if (object == this.getMessage(2)) {
                return 2;
            }
            if (object == this.getMessage(4)) {
                return 4;
            }
            throw new PropertyException(this.getMessage(16));
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new PropertyException(this.getMessage(16));
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x110001: 
            case 1471250: {
                if (this.m_type != 10) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return this.m_child_desc.getObjectName();
            }
            case 11957011: {
                if (this.m_type != 10) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return this.m_child_desc.toString();
            }
            case 1078033: {
                if (this.m_type != 10) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return this.getMessage(this.m_filterop);
            }
            case 276758675: {
                int[] nArray = (int[])this.getProp(282001422);
                Object[] objectArray = new Object[nArray.length];
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] == 1078033) {
                        String[] stringArray = new String[]{this.getMessage(2), this.getMessage(4)};
                        objectArray[n2] = stringArray;
                    } else {
                        objectArray[n2] = null;
                    }
                    ++n2;
                }
                return objectArray;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 11957011: {
                if (this.m_type != 10) {
                    throw new PropertyException(this.getMessage(900), 1, n, null);
                }
                try {
                    this.m_child_desc = new ConfigChildDesc(1, (String)object);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new PropertyException(malformedURLException.getMessage(), 1, n, null);
                }
            }
            case 1078033: {
                if (this.m_type != 10) {
                    throw new PropertyException(this.getMessage(900), 1, n, null);
                }
                switch (this.getOperation(object)) {
                    case 1: {
                        this.m_filterop = 1;
                        return;
                    }
                    case 2: {
                        this.m_filterop = 2;
                        return;
                    }
                    case 4: {
                        this.m_filterop = 4;
                    }
                }
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_transformerOwner != null) {
            this.m_transformerOwner.sendAdminPropertyChangeEvents(273612805, null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.out.print("serializing " + this.getClass().getName() + "...");
        }
        objectOutputStream.defaultWriteObject();
        if (DEBUG) {
            System.out.println("done");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
    }
}

