/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.ldap.admin.appserver.ConfigFilter;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class CommandFilter
extends ConfigFilter
implements Serializable {
    static boolean DEBUG;
    public static final int FOP_DISABLE_COMMAND = 1;
    public static final int FOP_REMOVE_COMMAND = 2;
    public static final int FOP_ENABLE_COMMAND = 4;
    public static final int INVALID_FILTER_OPERATOR = 16;
    static final int PR_CMDFILTER_COMMAND_ICON = 7762705;
    static final int PR_CMDFILTER_COMMAND_NAME = 1078035;
    static final int PR_CMDFILTER_COMMAND_DESCRIPTION = 1078036;
    static final int PR_CMDFILTER_COMMAND_OP = 1078034;
    int m_filterop;
    int m_cmdid;
    String m_nameNew;
    String m_nameOrig;
    transient Image m_icon;
    String m_iconName;
    String m_descriptionNew;
    String m_descriptionOrig;

    private void init() {
        this.m_filterop = 4;
        this.m_cmdid = 0;
        this.m_icon = null;
        this.m_descriptionOrig = null;
        this.m_nameOrig = null;
        this.m_descriptionNew = null;
        this.m_nameNew = null;
        this.registerProp(1078035, "Name", "Name of the command to be filtered");
        this.registerProp(1078036, "Description", "DEscription of the command to be filtered");
        this.registerProp(1078034, "Operation", "Filter operation to be applied to command object");
        this.registerMessage(1, "Disable");
        this.registerMessage(2, "Remove");
        this.registerMessage(4, "Eable");
        this.registerMessage(16, "Invalid Command Filter Operator");
    }

    public CommandFilter(ConfigFilterList configFilterList, int n, IAdminProp iAdminProp) throws PropertyException {
        this(configFilterList, n, iAdminProp, 4);
    }

    public CommandFilter(ConfigFilterList configFilterList, int n, IAdminProp iAdminProp, int n2) throws PropertyException {
        super(n, 20, configFilterList);
        this.init();
        this.m_filterop = n2;
        this.m_parent = configFilterList;
        if (iAdminProp != null) {
            this.m_cmdid = (Integer)iAdminProp.getProp(2687496);
            this.m_descriptionOrig = (String)iAdminProp.getProp(1638914);
            this.m_nameOrig = (String)iAdminProp.getProp(0x110001);
            this.m_iconName = (String)iAdminProp.getProp(1638408);
            if (((Boolean)iAdminProp.getProp(8978948)).booleanValue()) {
                this.m_filterop = 4;
                return;
            }
            this.m_filterop = 1;
        }
    }

    public int getCommandFilterOp() {
        return this.m_filterop;
    }

    public int getCommandID() {
        return this.m_cmdid;
    }

    public String getName() {
        return this.m_nameNew;
    }

    public String getDescription() {
        return this.m_descriptionNew;
    }

    public String toString() {
        String string = super.toString();
        String string2 = this.getMessage(this.m_filterop);
        return "Command: " + string + " Oper: " + string2;
    }

    public boolean equals(CommandFilter commandFilter) {
        if (super.equals(commandFilter)) {
            return this.m_filterop == commandFilter.getCommandFilterOp();
        }
        return false;
    }

    private int getOperation(Object object) throws PropertyException {
        if (object instanceof String) {
            if (object == this.getMessage(4)) {
                return 4;
            }
            if (object == this.getMessage(1)) {
                return 1;
            }
            if (object == this.getMessage(2)) {
                return 2;
            }
            throw new PropertyException(this.getMessage(16));
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new PropertyException(this.getMessage(16));
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 1078035: 
            case 0x110001: {
                if (this.m_type != 20) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                if (this.m_nameNew == null) {
                    return this.m_nameOrig;
                }
                return this.m_nameNew;
            }
            case 7762705: {
                if (this.m_type != 20) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return this.m_icon;
            }
            case 1078034: {
                if (this.m_type != 20) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                return this.getMessage(this.m_filterop);
            }
            case 1078036: {
                if (this.m_type != 20) {
                    throw new PropertyException(this.getMessage(900), 2, n, null);
                }
                if (this.m_descriptionNew == null) {
                    return this.m_descriptionOrig;
                }
                return this.m_descriptionNew;
            }
            case 276758675: {
                int[] nArray = (int[])this.getProp(282001422);
                Object[] objectArray = new Object[nArray.length];
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] == 1078034) {
                        String[] stringArray = new String[3];
                        switch (this.m_filterop) {
                            case 4: {
                                stringArray[0] = this.getMessage(4);
                                stringArray[1] = this.getMessage(1);
                                stringArray[2] = this.getMessage(2);
                                break;
                            }
                            case 1: {
                                stringArray[0] = this.getMessage(1);
                                stringArray[1] = this.getMessage(4);
                                stringArray[2] = this.getMessage(2);
                                break;
                            }
                            default: {
                                stringArray[0] = this.getMessage(2);
                                stringArray[1] = this.getMessage(4);
                                stringArray[2] = this.getMessage(4);
                            }
                        }
                        objectArray[n2] = stringArray;
                    } else {
                        objectArray[n2] = null;
                    }
                    ++n2;
                }
                return objectArray;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 1078035: 
            case 0x110001: {
                this.m_nameNew = (String)object;
                return;
            }
            case 1078036: {
                this.m_descriptionNew = (String)object;
                return;
            }
            case 1078034: {
                if (this.m_type != 20) {
                    throw new PropertyException(this.getMessage(900), 1, n, null);
                }
                switch (this.getOperation(object)) {
                    case 4: {
                        this.m_filterop = 4;
                        return;
                    }
                    case 1: {
                        this.m_filterop = 1;
                        return;
                    }
                    case 2: {
                        this.m_filterop = 2;
                    }
                }
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
        if (this.m_transformerOwner != null) {
            this.m_transformerOwner.sendAdminPropertyChangeEvents(273612805, null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.out.print("serializing " + this.getClass().getName() + "...");
        }
        objectOutputStream.defaultWriteObject();
        if (DEBUG) {
            System.out.println("done");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
    }
}

