/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.Serializable;
import java.net.MalformedURLException;
import oracle.ldap.admin.common.AdminURL;

public class ConfigChildDesc
implements Serializable {
    public static final int CDESC_URL = 1;
    public static final int CDESC_SCRIPT = 10;
    AdminURL m_url;
    String m_name;
    int m_type;
    private transient String m_objectname;

    public ConfigChildDesc(int n, String string) throws MalformedURLException {
        if (n == 1) {
            this.m_url = new AdminURL(string);
            this.m_type = n;
            this.m_name = string;
        }
    }

    public ConfigChildDesc(AdminURL adminURL) {
        this.m_name = adminURL.toString();
        this.m_type = 1;
        this.m_url = adminURL;
        this.m_objectname = null;
    }

    public int getType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }

    public AdminURL getURL() {
        return this.m_url;
    }

    public String getObjectName() {
        if (this.m_objectname == null) {
            int n = this.m_name.lastIndexOf(47);
            if (n > 0) {
                this.m_objectname = this.m_name.substring(n + 1);
                int n2 = this.m_objectname.lastIndexOf(40);
                if (n2 > 0) {
                    this.m_objectname = this.m_objectname.substring(0, n2);
                }
            } else {
                this.m_objectname = this.m_name;
            }
        }
        return this.m_objectname;
    }

    private boolean verifyType(int n) {
        switch (n) {
            case 1: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.m_name;
    }

    public boolean equals(ConfigChildDesc configChildDesc) {
        if (this.m_type != configChildDesc.getType()) {
            return false;
        }
        switch (this.m_type) {
            default: 
        }
        return this.m_name.equalsIgnoreCase(configChildDesc.getName());
    }
}

