/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.appserver.AdminConfig;
import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.Repository;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.appserver.UserProfile;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminRoot;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

public class Profile
extends AdminProp
implements Serializable {
    static boolean DEBUG;
    final int INVALID_PROFILE_KEY = 10;
    static final int PR_COMMENT = 0x108800;
    static final int PR_USERS = 269912065;
    String m_name;
    String m_comment;
    Repository m_pstore;
    transient Vector m_users;
    transient AdminProp m_kid;
    private transient AdminList m_parent;
    Hashtable m_DB_byURL;
    Hashtable m_DB_byDN;

    public Profile(Repository repository, String string) {
        this.init();
        this.m_pstore = repository;
        this.m_name = string;
        this.m_DB_byURL = new Hashtable();
        this.m_DB_byDN = new Hashtable();
    }

    public Profile(Repository repository, String string, AdminList adminList) {
        this(repository, string);
        this.m_parent = adminList;
    }

    private void init() {
        this.m_name = null;
        this.m_pstore = null;
        this.m_users = null;
        this.m_comment = null;
        this.m_parent = null;
        this.m_kid = null;
        this.m_DB_byURL = null;
        this.m_DB_byDN = null;
        this.registerProp(0x100001, "Name", "The profile's name");
        this.registerProp(0x108800, "Comment", "Comments on the profile");
        this.registerProp(269912065, "Users", "List of users using this profile");
        this.registerMessage(10, "Incomplete information was provided when trying to store a configuration object");
    }

    public Hashtable getDNcache() {
        return this.m_DB_byDN;
    }

    public Hashtable getURLcache() {
        return this.m_DB_byURL;
    }

    public String getName() {
        return this.m_name;
    }

    public void setParent(AdminList adminList) {
        this.m_parent = adminList;
    }

    public void storeConfig(String string, String string2, AdminConfig adminConfig) throws RepositoryException {
        if (string == null || string2 == null) {
            throw new RepositoryException(this.getMessage(10));
        }
        if (adminConfig == null) {
            return;
        }
        this.m_DB_byDN.put(string.toLowerCase(), adminConfig);
        this.m_DB_byURL.put(string2.toLowerCase(), adminConfig);
        if (DEBUG) {
            System.out.println("Config:DN:" + string + " URL:" + string2 + ", has been store in profile:" + this);
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x100001: 
            case 0x110001: {
                return this.m_name;
            }
            case 0x108800: {
                return this.m_comment;
            }
            case 269912065: {
                this.updateUsers();
                if (this.m_users != null && this.m_users.size() != 0) {
                    int n2 = this.m_users.size();
                    String[] stringArray = new String[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        stringArray[n3] = this.m_users.elementAt(n3).toString();
                        ++n3;
                    }
                    return stringArray;
                }
                return null;
            }
            case 3080204: {
                return new Integer(0x102000);
            }
            case 273612805: {
                AdminProp[] adminPropArray;
                if (this.m_kid == null) {
                    adminPropArray = new AdminRoot();
                    String[] stringArray = new String[]{"-AppServer:Start", "-hideChildren", "-AppServer:End"};
                    adminPropArray.setProp(0x10190099, (Object)stringArray);
                    UserProfile userProfile = this.m_pstore.createUserProfile(this.m_name);
                    if (DEBUG) {
                        System.out.println("------------------------------->" + this.m_name);
                    }
                    this.m_kid = new AdminTransform(5, (IAdminProp)adminPropArray, userProfile);
                }
                adminPropArray = new AdminProp[]{this.m_kid};
                return adminPropArray;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 0x100001: 
            case 0x110001: {
                this.m_name = (String)object;
                return;
            }
            case 269912065: {
                return;
            }
            case 0x108800: {
                this.m_comment = (String)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    private void updateUsers() {
        if (this.m_pstore != null) {
            this.m_users = this.m_pstore.getUsersOfProfile(this.m_name);
        }
    }

    public void saveChanges(int n) throws SaveChangeException {
        try {
            Profile profile = this.m_pstore.getProfile(this.m_name);
            if (profile == null) {
                this.m_pstore.addProfile(this);
                if (this.m_parent != null) {
                    this.m_parent.addChild(this);
                    this.m_parent.sendAdminPropertyChangeEvents(273612805, null);
                    this.m_parent.sendAdminPropertyChangeEvents(273219601, null);
                    return;
                }
            }
        }
        catch (RepositoryException repositoryException) {
            AdminProp.sUnexpectedException(repositoryException);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.print("serializing " + this.getClass().getName() + "...");
        objectOutputStream.defaultWriteObject();
        System.out.println("done");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init();
        objectInputStream.defaultReadObject();
    }
}

