/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.util.Vector;
import oracle.ldap.admin.appserver.Profile;
import oracle.ldap.admin.appserver.Repository;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

class ProfileList
extends AdminList
implements ICommandParent {
    static boolean DEBUG;
    static final int PR_STR_ADD_PROFILE_BTNTEXT = 12544;
    static final int PR_STR_ADD_PROFILE_DESCRIP = 12545;
    static final int PR_STR_PROFILE_LIST = 12546;
    static final int CMD_ADD_PROFILE = -8;
    Repository m_pstore;

    public ProfileList(Repository repository) {
        this.m_pstore = repository;
        this.registerMessage(12544, "New Profile");
        this.registerMessage(12545, "Create a new Admin Server profile");
        this.registerMessage(12546, "Profiles");
        this.setDisplayName(this.getMessage(12546));
        IAdminProp[] iAdminPropArray = new IAdminProp[]{new CommandProp((IAdminProp)this, -8, this.getMessage(12544), this.getMessage(12545), 1, "images/configure.gif")};
        this.setCommandList(iAdminPropArray);
        this.rebuildChildrenList();
    }

    public void setChildren(Vector vector) {
        if (vector == null) {
            this.rebuildChildrenList();
            return;
        }
        super.setChildren(vector);
    }

    private void rebuildChildrenList() {
        super.setChildren((Vector)null);
        if (this.m_pstore == null) {
            return;
        }
        Vector vector = this.m_pstore.getProfileNames();
        if (vector != null) {
            vector.size();
            int n = 0;
            while (n < vector.size()) {
                try {
                    Profile profile = this.m_pstore.getProfile((String)vector.elementAt(n));
                    if (profile != null) {
                        profile.setParent(this);
                        super.addChildSorted(profile);
                        if (DEBUG) {
                            System.out.print("retrieve profile --->");
                        }
                        if (DEBUG) {
                            System.out.println(profile.getName());
                        }
                    }
                }
                catch (RepositoryException repositoryException) {
                    AdminProp.sUnexpectedException(repositoryException);
                }
                ++n;
            }
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 273612805: {
                return super.getProp(273612805);
            }
            case 2686995: {
                return new Integer(1);
            }
            case 0x10110021: {
                String[] stringArray = new String[]{"Name"};
                return stringArray;
            }
            case 282001424: {
                int[] nArray = new int[]{0x110001};
                return nArray;
            }
            case 281083936: {
                int[] nArray = new int[]{20};
                return nArray;
            }
        }
        return super.getProp(n);
    }

    public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
        int n = (Integer)iAdminProp.getProp(2687496);
        switch (n) {
            case -8: {
                if (DEBUG) {
                    System.out.println("Creating a new profile");
                }
                return new Profile(this.m_pstore, "", this);
            }
        }
        return null;
    }
}

