/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.appserver;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.appserver.AdminConfig;
import oracle.ldap.admin.appserver.AdminTransform;
import oracle.ldap.admin.appserver.ChildFilter;
import oracle.ldap.admin.appserver.ConfigFilterList;
import oracle.ldap.admin.appserver.Profile;
import oracle.ldap.admin.appserver.PropFilter;
import oracle.ldap.admin.appserver.Repository;
import oracle.ldap.admin.appserver.RepositoryException;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminRoot;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class UserProfile
extends AdminProp
implements Serializable {
    static boolean DEBUG;
    String m_name;
    String[] m_args;
    Vector m_pcache_byDN;
    Vector m_pcache_byURL;
    Vector m_pfNames;
    Repository m_pstore;
    AdminProp m_kid;

    public UserProfile() {
        this.init();
    }

    public void setArgs(String[] stringArray) {
        this.m_args = stringArray;
    }

    public UserProfile(Repository repository, String string, Hashtable hashtable, Hashtable hashtable2) {
        this.init();
        this.m_pstore = repository;
        this.m_pfNames = new Vector(1);
        this.m_name = string;
        this.m_pfNames.addElement(this.m_name);
        this.m_pcache_byDN = new Vector(1);
        this.m_pcache_byDN.addElement(hashtable);
        this.m_pcache_byURL = new Vector(1);
        this.m_pcache_byURL.addElement(hashtable2);
    }

    public UserProfile(Repository repository, String[] stringArray, Vector vector, Vector vector2) {
        this.init();
        this.m_pstore = repository;
        this.m_pfNames = new Vector();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                this.m_pfNames.addElement(stringArray[n]);
                ++n;
            }
        }
        this.m_pcache_byDN = vector;
        this.m_pcache_byURL = vector2;
    }

    private void init() {
        this.m_pcache_byDN = null;
        this.m_pcache_byURL = null;
        this.m_pfNames = null;
        this.m_pstore = null;
        this.registerProp(0x100001, "Name", "The profile's name");
    }

    public void debugDumpProfile() {
        if (DEBUG) {
            System.out.println("**** User Profile - begin ****");
        }
        int n = 0;
        while (n < this.m_pfNames.size()) {
            if (DEBUG) {
                System.out.println("** Profile: " + this.m_pfNames.elementAt(n) + "** - begin");
            }
            Hashtable hashtable = (Hashtable)this.m_pcache_byDN.elementAt(n);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                AdminConfig adminConfig = (AdminConfig)hashtable.get(string);
                if (DEBUG) {
                    System.out.println("\n\n* Config@(" + string + ")=");
                }
                adminConfig.debugDumpConfigObj();
            }
            if (DEBUG) {
                System.out.println("** Profile: " + this.m_pfNames.elementAt(n) + "** - end");
            }
            ++n;
        }
        if (DEBUG) {
            System.out.println("**** User Profile - end ****");
        }
    }

    public Vector getProfileObjs(String string, boolean bl) {
        Vector vector = bl ? this.m_pcache_byURL : this.m_pcache_byDN;
        if (vector == null) {
            return null;
        }
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        string = string.toLowerCase();
        while (enumeration.hasMoreElements()) {
            Object v;
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            if (hashtable == null || (v = hashtable.get(string)) == null) continue;
            vector2.addElement(v);
        }
        if (vector2.size() == 0) {
            return null;
        }
        return vector2;
    }

    public AdminConfig getConfigObject(String string, boolean bl) {
        Vector vector = this.getProfileObjs(string, bl);
        if (vector == null) {
            return null;
        }
        if (vector.size() == 1) {
            return (AdminConfig)vector.elementAt(0);
        }
        AdminConfig adminConfig = new AdminConfig(this, string);
        AdminConfig adminConfig2 = (AdminConfig)vector.firstElement();
        adminConfig.setConfigProps(adminConfig2.getConfigProps());
        ConfigFilterList configFilterList = new ConfigFilterList(15);
        int n = 0;
        while (n < vector.size()) {
            ConfigFilterList configFilterList2 = ((AdminConfig)vector.elementAt(n)).getPropFilters();
            if (configFilterList2 != null) {
                int n2 = 0;
                while (n2 < configFilterList2.size()) {
                    PropFilter propFilter = (PropFilter)configFilterList2.getFilterAt(n2);
                    PropFilter propFilter2 = (PropFilter)configFilterList.getFilter(propFilter.getPropID(), false);
                    if (propFilter2 == null) {
                        configFilterList.addFilter(propFilter);
                    } else {
                        boolean bl2 = false;
                        boolean bl3 = propFilter2.isVisible();
                        boolean bl4 = propFilter2.isReadOnly();
                        if (!bl3 && propFilter.isVisible()) {
                            bl2 = true;
                            bl3 = true;
                        }
                        if (bl4 && !propFilter.isReadOnly()) {
                            bl2 = true;
                            bl4 = false;
                        }
                        if (bl2) {
                            PropFilter propFilter3 = (PropFilter)propFilter.clone();
                            propFilter3.setVisible(bl3);
                            propFilter3.setReadOnly(bl4);
                            configFilterList.delPropFilter(propFilter2);
                            configFilterList.addFilter(propFilter3);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        adminConfig.setPropFilters(configFilterList);
        ConfigFilterList configFilterList3 = new ConfigFilterList(10);
        int n3 = 0;
        while (n3 < vector.size()) {
            ConfigFilterList configFilterList4 = ((AdminConfig)vector.elementAt(n3)).getChildFilters();
            if (configFilterList4 != null) {
                int n4 = 0;
                while (n4 < configFilterList4.size()) {
                    ChildFilter childFilter = (ChildFilter)configFilterList4.getFilterAt(n4);
                    ChildFilter childFilter2 = (ChildFilter)configFilterList3.getFilter(childFilter.getPropID(), childFilter.getChildDescriptor(), false);
                    if (childFilter2 == null) {
                        configFilterList3.addFilter(childFilter);
                    } else if (childFilter2.getChildFilterOp() == 2 && childFilter.getChildFilterOp() == 4) {
                        configFilterList3.delChildFilter(childFilter2);
                        configFilterList3.addFilter(childFilter);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        adminConfig.setChildFilters(configFilterList3);
        return adminConfig;
    }

    public void storeConfig(String string, String string2, AdminConfig adminConfig) throws RepositoryException {
        Enumeration enumeration = this.m_pfNames.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Profile profile = this.m_pstore.getProfile(string3);
            if (profile == null) continue;
            profile.storeConfig(string, string2, adminConfig);
        }
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x100001: 
            case 0x110001: {
                return this.m_name;
            }
            case 3080204: {
                return new Integer(0x102000);
            }
            case 273612805: {
                AdminProp[] adminPropArray;
                if (this.m_kid == null) {
                    adminPropArray = new AdminRoot();
                    if (this.m_args != null) {
                        adminPropArray.setProp(0x10190099, (Object)this.m_args);
                    }
                    this.m_kid = new AdminTransform(5, (IAdminProp)adminPropArray, this);
                }
                adminPropArray = new AdminProp[]{this.m_kid};
                return adminPropArray;
            }
        }
        return super.getProp(n);
    }

    public static void main(String[] stringArray) {
    }
}

