/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.Frame;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.PropToolbar;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;

class AdminPropertyChangeSpy
implements AdminPropertyChangeListener {
    AdminPropertyChangeListener m_apcl;
    int refCount;

    public String getClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        return String.valueOf(this.getClassName(this.getClass())) + " for " + this.getClassName(this.m_apcl.getClass());
    }

    public AdminPropertyChangeSpy(AdminPropertyChangeListener adminPropertyChangeListener) {
        this.m_apcl = adminPropertyChangeListener;
    }

    boolean checkForEditRequest(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        try {
            boolean bl = true;
            int n = adminPropertyChangeEvent.getPropId();
            switch (n) {
                case 2031761: 
                case 2031762: {
                    Object object = adminPropertyChangeEvent.getNewValue();
                    if (object != null) {
                        AdminUtil.showSBMessage(null, (String)object);
                    }
                    return true;
                }
                case 4785303: {
                    Object object = adminPropertyChangeEvent.getNewValue();
                    if (object == null) {
                        object = ((IAdminProp)adminPropertyChangeEvent.getSource()).getProp(n);
                    }
                    PropToolbar.showCommandProgress((IAdminProp)object, (Frame)((Object)AdminUtil.getNavigator()));
                    return true;
                }
                case 4784293: {
                    bl = false;
                }
                case 4784294: {
                    if (adminPropertyChangeEvent.isUsed()) {
                        return true;
                    }
                    adminPropertyChangeEvent.setUsed(true);
                    Object object = adminPropertyChangeEvent.getNewValue();
                    if (object == null) {
                        object = ((IAdminProp)adminPropertyChangeEvent.getSource()).getProp(n);
                    }
                    if (object != null) {
                        if (bl) {
                            AdminUtil.editStandalone((IAdminProp)object, null);
                        } else {
                            AdminUtil.edit((IAdminProp)object);
                        }
                    }
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return false;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        IAdminProp iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource();
        int n = adminPropertyChangeEvent.getPropId();
        if (AdminUtil.DEBUG_NOTIFICATIONS) {
            System.out.println("\nadminPropertyChange called on " + iAdminProp.getPropName(n) + " " + this);
        }
        if (this.checkForEditRequest(adminPropertyChangeEvent)) {
            if (AdminUtil.DEBUG_NOTIFICATIONS) {
                System.out.println("adminPropertyChange not propagated.\n");
            }
            return;
        }
        if (this.m_apcl != null) {
            this.m_apcl.adminPropertyChange(adminPropertyChangeEvent);
        }
        if (AdminUtil.DEBUG_NOTIFICATIONS) {
            System.out.println("adminPropertyChange handled.\n");
        }
    }

    public void addref() {
        ++this.refCount;
    }

    public int release() {
        return --this.refCount;
    }
}

