/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DrawnRectangle
extends Rectangle {
    protected static int _defaultThickness = 2;
    protected Component drawInto;
    private int thick;
    private Color lineColor;

    public DrawnRectangle(Component component) {
        this(component, _defaultThickness, 0, 0, 0, 0);
    }

    public DrawnRectangle(Component component, int n) {
        this(component, n, 0, 0, 0, 0);
    }

    public DrawnRectangle(Component component, int n, int n2, int n3, int n4) {
        this(component, _defaultThickness, n, n2, n3, n4);
    }

    public DrawnRectangle(Component component, int n, int n2, int n3, int n4, int n5) {
        this.drawInto = component;
        this.thick = n;
        this.setBounds(n2, n3, n4, n5);
    }

    public int getThickness() {
        return this.thick;
    }

    public void setThickness(int n) {
        this.thick = n;
    }

    public Color getLineColor() {
        if (this.lineColor == null) {
            this.lineColor = this.drawInto.getBackground();
        }
        return this.lineColor;
    }

    public void paintInset() {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            this.drawTopLeftLines(graphics, this.getLineColor().darker());
            this.drawBottomRightLines(graphics, this.getLineColor().brighter());
        }
    }

    private void drawTopLeftLines(Graphics graphics, Color color) {
        int n = this.getThickness();
        graphics.setColor(color);
        int n2 = 0;
        while (n2 < n) {
            graphics.drawLine(this.x + n2, this.y + n2, this.x + this.width - (n2 + 1), this.y + n2);
            graphics.drawLine(this.x + n2, this.y + n2 + 1, this.x + n2, this.y + this.height - (n2 + 1));
            ++n2;
        }
    }

    private void drawBottomRightLines(Graphics graphics, Color color) {
        int n = this.getThickness();
        graphics.setColor(color);
        int n2 = 1;
        while (n2 <= n) {
            graphics.drawLine(this.x + n2 - 1, this.y + this.height - n2, this.x + this.width - n2, this.y + this.height - n2);
            graphics.drawLine(this.x + this.width - n2, this.y + n2 - 1, this.x + this.width - n2, this.y + this.height - n2);
            ++n2;
        }
    }
}

