/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.CommandPopupMenu;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.ISelectionOwner;
import oracle.ldap.admin.client.NavHTree;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.common.AdminTreeItem;
import oracle.ldap.admin.client.common.AdminTreeRootItem;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.TabView;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropView;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

public class NavItem
extends AdminTreeItem
implements EditorOwner,
AdminPropertyChangeListener,
ISelectionOwner {
    Component m_comp;
    boolean m_locked = false;
    boolean m_initColor = true;
    Color m_color;
    Font m_font;
    int m_fontStyle;
    boolean m_initFont = true;
    boolean reinitializeAppearance = true;
    Color fontColor;
    Font newFont;
    IAdminProp m_selection;
    IAdminProp _prop;
    IAdminProp[] _cmdList;
    String _lastSBMessage;
    Point _point;
    boolean _selected = false;
    boolean _addListener = false;
    static final String _icon = "images/file.gif";

    public NavItem(Component component, IAdminProp iAdminProp) {
        this(iAdminProp, _icon, component);
        this._prop = iAdminProp;
        this.m_comp = component;
    }

    public NavItem(IAdminProp iAdminProp, String string, Component component) {
        super(AdminUtil.getLabel(iAdminProp), null);
        this.m_comp = component;
        String string2 = null;
        try {
            string2 = (String)iAdminProp.getProp(1638408);
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
        Image image = null;
        if (string2 != null) {
            image = AdminUtil.loadImage(string2, component);
        }
        if (image == null) {
            image = AdminUtil.loadImage(string, component);
        }
        this.setIcon(image);
        this._prop = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(this._prop, this);
    }

    public NavItem(IAdminProp iAdminProp, Image image) {
        super(AdminUtil.getLabel(iAdminProp), image);
        this._prop = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(this._prop, this);
    }

    public boolean checkSelectionPermission() {
        block5: {
            NavHTree navHTree = (NavHTree)this.getAdminTree();
            if (navHTree == null) {
                return false;
            }
            if (navHTree.isUsingTreeView()) {
                return true;
            }
            Component component = AdminUtil.getEditor(this.m_comp);
            if (component == null || !(component instanceof IEditor)) break block5;
            IEditor iEditor = (IEditor)((Object)component);
            try {
                StringBuffer stringBuffer = new StringBuffer();
                if (iEditor.isModified(stringBuffer) && !AdminUtil.warnUserAboutEditorChange(AdminUtil.getFrame(this.m_comp), iEditor, stringBuffer.toString())) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent, int n, int n2) {
        super.mousePressed(mouseEvent);
        if (mouseEvent.isMetaDown()) {
            NavHTree navHTree = (NavHTree)this.getAdminTree();
            Point point = navHTree.getCanvasOrigin();
            point.x += n;
            point.y += n2;
            this.showMenu(point);
            this._point = null;
        }
    }

    protected synchronized void showMenu(Point point) {
        NavHTree navHTree = (NavHTree)this.getAdminTree();
        CommandPopupMenu commandPopupMenu = new CommandPopupMenu(new SimpleWrapper(this._prop), AdminUtil.getEditor(this.m_comp));
        if (commandPopupMenu.getItemCount() > 0) {
            ((Container)((Object)navHTree)).add((Component)((Object)commandPopupMenu));
            new Thread(new ShowMenu(commandPopupMenu, navHTree, point)).start();
        }
    }

    public void showMenuBackground(Point point) {
        try {
            this.showMenu(point);
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        if (adminPropertyChangeEvent.getPropId() == 0x110001) {
            this.reinitializeAppearance = true;
            this.setLabel(this._prop);
        }
        switch (adminPropertyChangeEvent.getPropId()) {
            case 0x110001: {
                this.reinitializeAppearance = true;
                this.m_initFont = true;
                this.m_initColor = true;
                this.setLabel(this._prop);
                break;
            }
            case 12583682: {
                this.m_initColor = true;
                this.setLabel(this._prop);
                break;
            }
            case 1049116: 
            case 2097693: 
            case 0x200303: {
                this.m_initFont = true;
                this.reinitializeAppearance = true;
                this.setLabel(this._prop);
                break;
            }
        }
        this.setStatusBars();
    }

    public void setProp(IAdminProp iAdminProp) {
        this._prop = iAdminProp;
        this._addListener = true;
        this.setLabel(iAdminProp);
        this.setStatusBars();
    }

    public IAdminProp getProp() {
        return this._prop;
    }

    public boolean isValidObject() {
        int n;
        Integer n2 = null;
        try {
            n2 = (Integer)this._prop.getProp(3080204);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
            return false;
        }
        if (n2 != null && ((n = n2.intValue()) & 1) == 1) {
            String string = null;
            try {
                string = (String)this._prop.getProp(7929867);
            }
            catch (PropertyException propertyException) {
                new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
                return false;
            }
            if (string == null) {
                return false;
            }
            PropertyException propertyException = new PropertyException(string);
            new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
            return false;
        }
        return true;
    }

    public boolean isLogonObject() {
        int n;
        Integer n2 = null;
        try {
            n2 = (Integer)this._prop.getProp(3080204);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
            return false;
        }
        return n2 != null && ((n = n2.intValue()) & 0x6000) == 24576;
    }

    public void showLogonDialog(Component component) {
        if (component == null) {
            component = EditorFactory.getEditor(this._prop, this);
        }
        AdminUtil.showLogonDialog(this._prop, component);
    }

    static String identifyObject(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName();
    }

    public boolean doSelect() {
        boolean bl = false;
        if (!this.m_locked) {
            this.m_locked = true;
            Frame frame = AdminUtil.getFrame(this.m_comp);
            try {
                if (frame != null) {
                    if (NavigatorFrame.DEBUG_CURSOR) {
                        System.out.println("doSelect():  WAIT_CURSOR");
                    }
                    ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
                }
                bl = this.doSelect2();
            }
            finally {
                Object var4_3 = null;
                if (frame != null) {
                    if (NavigatorFrame.DEBUG_CURSOR) {
                        System.out.println("doSelect():  DEFAULT_CURSOR");
                    }
                    ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                }
                this.m_locked = false;
            }
        }
        if (bl) {
            this.resetMenu();
        }
        this.setSelection(this._prop);
        return bl;
    }

    boolean isConnected() {
        return AdminUtil.isConnected(this._prop);
    }

    public boolean doSelect2() {
        Object object;
        Frame frame = AdminUtil.getFrame(this.m_comp);
        boolean bl = this.isLogonObject();
        boolean bl2 = this.isValidObject();
        if (frame != null) {
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("doSelect2():  WAIT_CURSOR");
            }
            ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
        }
        if (!bl) {
            object = (NavHTree)this.getAdminTree();
            if (((NavHTree)object).isUsingTreeView()) {
                AdminUtil.showEditor(this.m_comp, null, this._prop);
                return true;
            }
            try {
                Component component = AdminUtil.getEditor(this.m_comp);
                if (component != null && component instanceof TabView) {
                    TabView tabView = (TabView)((Object)component);
                    this._selected = true;
                    if (this._point != null) {
                        this.showMenu(this._point);
                        this._point = null;
                    }
                    if (tabView.display(this._prop)) {
                        return true;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
        }
        object = null;
        if (bl2 && object == null) {
            if (!bl && AdminUtil.displayObject(this.m_comp, this._prop)) {
                this.setStatusBars();
                this._selected = true;
                if (this._point != null) {
                    this.showMenu(this._point);
                    this._point = null;
                }
                return true;
            }
            object = EditorFactory.getEditor(this._prop, (EditorOwner)this, this.m_comp);
        }
        this.setStatusBars();
        if (bl) {
            if (frame != null) {
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("doSelect2():  DEFAULT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
            }
            this.showLogonDialog((Component)object);
            if (frame != null) {
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("doSelect2():  WAIT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
            }
            if (this.isConnected()) {
                object = EditorFactory.getEditor(this._prop, this);
                AdminUtil.showEditor(this.m_comp, (Component)object, this._prop);
                AdminUtil.setEditorTitle(this.m_comp, this.getStringPath());
                this.init();
            } else {
                this.clearSelection2();
            }
        } else if (object instanceof Frame) {
            try {
                ((Component)((Frame)object)).setVisible(true);
            }
            catch (Exception exception) {}
        } else if (bl2) {
            AdminUtil.showEditor(this.m_comp, (Component)object, this._prop);
            AdminUtil.setEditorTitle(this.m_comp, this.getStringPath());
        } else {
            AdminUtil.showEditor(this.m_comp, null, null);
        }
        this._selected = true;
        if (this._point != null) {
            if (frame != null) {
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("doSelect2():  DEFAULT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
            }
            this.showMenu(this._point);
            this._point = null;
        }
        return true;
    }

    public boolean doDeselect() {
        this._selected = false;
        this.removeSBMessage();
        this.clearSelection2();
        return true;
    }

    protected void resetMenu() {
        NavItem navItem = this;
        while (navItem.getParent() instanceof NavItem) {
            navItem = (NavItem)navItem.getParent();
        }
        AdminUtil.resetMenu(this.m_comp, navItem._prop);
    }

    protected void setStatusBars() {
        this.removeSBMessage();
        this.setStatusSB();
        this.setLogonSB();
    }

    protected void setStatusBars(String string) {
        this.removeSBMessage();
        AdminUtil.showSBMessage(this.m_comp, string);
        this.setLogonSB();
    }

    protected void setLogonSB() {
        if (this._prop != null) {
            try {
                Integer n = (Integer)this._prop.getProp(3080204);
                if ((n & 4) != 0) {
                    AdminUtil.showSBLogin(this.m_comp, "Logged-on");
                    return;
                }
                AdminUtil.showSBLogin(this.m_comp, "Not Logged-on");
                return;
            }
            catch (PropertyException propertyException) {
                new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
                return;
            }
        }
    }

    protected void setStatusSB() {
        if (this._prop != null) {
            try {
                this._lastSBMessage = (String)this._prop.getProp(0x1F000F);
                if (this._lastSBMessage != null) {
                    AdminUtil.showSBMessage(this.m_comp, this._lastSBMessage);
                    return;
                }
                AdminUtil.showSBMessage(this.m_comp, ClientLang.getStrReady());
                return;
            }
            catch (PropertyException propertyException) {
                new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
                return;
            }
        }
    }

    protected void removeSBMessage() {
        AdminUtil.removeSBMessage(this.m_comp, this._lastSBMessage);
    }

    public void setLabel(IAdminProp iAdminProp) {
        super.setLabel(AdminUtil.getLabel(iAdminProp));
    }

    public IAdminProp getAdminProp() {
        return this._prop;
    }

    public Color getColor() {
        Serializable serializable;
        int n = 0;
        Object var2_2 = null;
        if (!this.m_initColor) {
            return this.m_color;
        }
        this.m_initColor = false;
        this.m_color = null;
        try {
            serializable = (Integer)this._prop.getProp(12583682);
            if (serializable != null) {
                n = serializable;
            }
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
            return null;
        }
        if (n == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                serializable = Color.blue;
                break;
            }
            case 4: {
                serializable = Color.gray;
                break;
            }
            default: {
                serializable = var2_2;
            }
        }
        this.m_color = serializable;
        return this.m_color;
    }

    public Font getFont() {
        int n;
        int n2 = 0;
        Font font = null;
        if (!this.m_initFont) {
            if (this.m_font != null) {
                return this.m_font;
            }
            return this.m_comp.getFont();
        }
        this.m_initFont = false;
        try {
            Integer n3 = (Integer)this._prop.getProp(0x200303);
            if (n3 != null) {
                n2 = n3;
            }
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
            return null;
        }
        if (n2 == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (this.m_fontStyle == n && this.m_font != null) {
            return this.m_font;
        }
        font = this.m_comp.getFont();
        this.m_fontStyle = n;
        this.m_font = new Font(font.getName(), n, font.getSize());
        return this.m_font;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void initializeAppearance(Graphics graphics) {
        Font font = null;
        int n = 0;
        int n2 = 0;
        this.reinitializeAppearance = false;
        try {
            Integer n3;
            Integer n4 = (Integer)this._prop.getProp(0x200303);
            if (n4 != null) {
                n2 = n4;
            }
            if ((n3 = (Integer)this._prop.getProp(12583682)) != null) {
                n = n3;
            }
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame(this.m_comp), propertyException);
            return;
        }
        if (n2 != 0 || n != 0) {
            if (n2 != 0) {
                int n5;
                font = graphics.getFont();
                switch (n2) {
                    case 1: {
                        n5 = 1;
                        break;
                    }
                    case 2: {
                        n5 = 2;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
                new Font(font.getName(), n5, font.getSize());
            }
            if (n != 0) {
                switch (n) {
                    case 1: {
                        this.fontColor = Color.blue;
                        return;
                    }
                    case 4: {
                        this.fontColor = Color.gray;
                        return;
                    }
                }
                this.fontColor = null;
                return;
            }
        }
    }

    public void paint(Graphics graphics) {
        Font font = null;
        Color color = null;
        if (this.reinitializeAppearance) {
            this.initializeAppearance(graphics);
        }
        if (this.newFont != null) {
            font = graphics.getFont();
            graphics.setFont(this.newFont);
        }
        if (this.fontColor != null) {
            color = graphics.getColor();
            graphics.setColor(this.fontColor);
        }
        try {
            this.DTreeExtendedItem_paint(graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (font != null) {
            graphics.setFont(font);
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    public boolean hasSelection() {
        return this.m_selection != null;
    }

    public IAdminProp getSelection() {
        return this.m_selection;
    }

    public void setSelection(IAdminProp iAdminProp) {
        this.m_selection = iAdminProp;
        AdminUtil.setSelectionOwner(this.m_comp, this);
    }

    public void clearSelection() {
    }

    public void clearSelection2() {
        this.m_selection = null;
        AdminUtil.removeSelectionOwner(this.m_comp, this);
    }

    public void init() {
    }

    public String getStringPath() {
        StringBuffer stringBuffer = new StringBuffer(this.getLabel());
        NavItem navItem = this;
        while ((navItem = ((AdminTreeItem)navItem).getParent()) != null) {
            String string;
            if (navItem instanceof AdminTreeRootItem) {
                string = ((AdminTreeRootItem)((Object)navItem)).getLabel();
                stringBuffer.insert(0, "/");
                if (string == null) break;
                stringBuffer.insert(0, string);
                break;
            }
            string = ((AdminTreeItem)navItem).getLabel();
            stringBuffer.insert(0, "/");
            if (string == null) continue;
            stringBuffer.insert(0, string);
        }
        stringBuffer.insert(0, "/");
        return stringBuffer.toString();
    }

    class ShowMenu
    implements Runnable {
        CommandPopupMenu m_menu;
        NavHTree m_tree;
        Point m_p;

        public ShowMenu(CommandPopupMenu commandPopupMenu, NavHTree navHTree, Point point) {
            NavItem.this = NavItem.this;
            this.m_menu = commandPopupMenu;
            this.m_tree = navHTree;
            this.m_p = point;
        }

        public void run() {
            this.m_menu.show((Component)((Object)this.m_tree), this.m_p.x, this.m_p.y);
        }
    }

    class SimpleWrapper
    extends AdminPropView
    implements ICommandParent {
        public SimpleWrapper(IAdminProp iAdminProp) {
            super(iAdminProp);
            NavItem.this = NavItem.this;
        }

        public Object getProp(int n) throws PropertyException {
            switch (n) {
                case 273613313: {
                    IAdminProp[] iAdminPropArray = (IAdminProp[])super.getProp(n);
                    IAdminProp[] iAdminPropArray2 = new IAdminProp[]{new CommandProp((IAdminProp)this, -21, ClientLang.getStrTearOff(), "", "images/tearOff.gif")};
                    return AdminUtil.mergeCmdList(iAdminPropArray, iAdminPropArray2);
                }
            }
            return super.getProp(n);
        }

        public IAdminProp doCommand(IAdminProp iAdminProp) {
            return NavItem.this._prop;
        }
    }
}

