/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import oracle.ldap.admin.client.AdminExec;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.CommandProgress;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.ICommandEditor;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.WorkCommand;
import oracle.ldap.admin.client.common.AdminToolBar;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.Util;

public class PropToolbar
extends AdminToolBar
implements AdminPropertyChangeListener {
    public static boolean DEBUG;
    public static final int IMAGE_WIDTH = 22;
    public static final int IMAGE_HEIGHT = 22;
    private static String BACKGROUND_MESSAGE;
    Vector _cmdList = new Vector();
    int _firstPropItem = -1;
    boolean _hideSpecialCommands = false;
    boolean _isGlobal = false;
    Vector _specialCmdList;
    Vector _hiddenItemList;
    int[] _ids;
    IAdminProp _prop;

    public IAdminProp getProp() {
        return this._prop;
    }

    public void setHideSpecialCommands(boolean bl) {
        this._hideSpecialCommands = bl;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public void setGlobal(boolean bl) {
        this._isGlobal = true;
    }

    public IAdminProp[] getSpecialCommands() {
        return (IAdminProp[])AdminProp.vectorToObjectArray(this._specialCmdList);
    }

    public void removeFromSpecialList(IAdminProp iAdminProp) {
        try {
            Integer n = (Integer)iAdminProp.getProp(2687495);
            this.createItem(n, iAdminProp, this._cmdList.indexOf(iAdminProp));
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
        this._specialCmdList.removeElement(iAdminProp);
    }

    public Vector getCmdList() {
        return this._cmdList;
    }

    public void unhide(int n) {
        int n2 = this._cmdList.indexOf(this._specialCmdList.elementAt(n));
        if (n2 < 0) {
            if (DEBUG) {
                System.out.println(" PropToolbar.unhide: couldn't find location of hidden item! i=" + n);
            }
            return;
        }
        if (this._hiddenItemList == null) {
            if (DEBUG) {
                System.out.println(" PropToolbar.unhide: _hiddenItemList == null");
            }
            return;
        }
        if (n2 >= this.getItemCount()) {
            if (DEBUG) {
                System.out.println(" PropToolbar.unhide: j=" + n2 + " >= itemCount=" + this.getItemCount());
            }
            this.addItem(this._hiddenItemList.elementAt(n));
            return;
        }
        if (DEBUG) {
            System.out.println(" PropToolbar.unhide: inserting i=" + n + " j=" + n2);
        }
        this.addItem(this._hiddenItemList.elementAt(n), this.getAdminItem(n2));
    }

    public void unhideAll() {
        if (DEBUG) {
            System.out.println("\n PropToolbar.unhideAll called");
        }
        if (this._specialCmdList == null || this._specialCmdList.size() == 0) {
            if (DEBUG) {
                System.out.println(" PropToolbar.unhideAll: Nothing to unhide");
            }
            return;
        }
        int n = this._specialCmdList.size();
        int n2 = 0;
        while (n2 < n) {
            this.unhide(n2);
            ++n2;
        }
        this._hiddenItemList = null;
        this._specialCmdList = null;
        this._hideSpecialCommands = false;
        if (DEBUG) {
            System.out.println(" PropToolbar.unhideAll: done\n");
        }
    }

    public void hideCmd(IAdminProp iAdminProp, int n) {
        if (DEBUG) {
            System.out.println("\n PropToolbar.hideCmd i=" + n);
        }
        this._hideSpecialCommands = true;
        if (this._specialCmdList == null) {
            this._specialCmdList = new Vector();
        }
        this._specialCmdList.addElement(iAdminProp);
        Object object = this.getAdminItem(n -= this._specialCmdList.size());
        if (object == null) {
            return;
        }
        if (this._hiddenItemList == null) {
            this._hiddenItemList = new Vector();
        }
        this._hiddenItemList.addElement(object);
        this.removeItem(object);
        if (DEBUG) {
            System.out.println(" PropToolbar.hideCmd: done\n");
        }
    }

    public void mergeIn(PropToolbar propToolbar) {
        if (DEBUG) {
            System.out.println("\nPropToolbar.mergeIn called");
        }
        Vector vector = propToolbar.getCmdList();
        int n = vector.size();
        if (vector == null || n == 0) {
            if (DEBUG) {
                System.out.println("PropToolbar.mergeIn: toolbar is empty");
            }
            return;
        }
        int n2 = this._cmdList.size();
        int n3 = 0;
        while (n3 < n) {
            block16: {
                try {
                    int n4;
                    IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n3);
                    if (iAdminProp == null || (n4 = ((Integer)iAdminProp.getProp(2687496)).intValue()) >= 0 || n4 == -1) break block16;
                    if (DEBUG) {
                        System.out.println("PropToolbar.mergeIn: found item global id=" + n4);
                    }
                    if (DEBUG) {
                        System.out.println("PropToolbar.mergeIn: dislayname=" + iAdminProp.getProp(0x110001));
                    }
                    int n5 = 0;
                    while (n5 < n2) {
                        IAdminProp iAdminProp2 = (IAdminProp)this._cmdList.elementAt(n5);
                        if (iAdminProp2.getProp(4784659) == null && n4 == (Integer)iAdminProp2.getProp(2687496)) {
                            if (DEBUG) {
                                System.out.println("PropToolbar.mergeIn: make global toolbar handle this item! j=" + n5);
                            }
                            try {
                                Image image;
                                propToolbar.hideCmd(iAdminProp, n3);
                                Boolean bl = (Boolean)iAdminProp.getProp(8978948);
                                iAdminProp2.setProp(8978948, bl);
                                this.setItemEnabled(n5, bl);
                                String string = (String)iAdminProp.getProp(1638408);
                                String string2 = (String)iAdminProp2.getProp(1638408);
                                iAdminProp2.setProp(4784659, iAdminProp);
                                String string3 = this.getPropTooltip(iAdminProp);
                                if (DEBUG) {
                                    System.out.println("PropToolbar.mergeIn: tip=" + string3);
                                }
                                this.setItemHelpText(n5, string3);
                                if (!(string == null || string2 != null && string.equals(string2) || (image = AdminUtil.loadImage(string, (Component)((Object)this))) == null)) {
                                    this.setItemIcon(n5, image);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break;
                        }
                        ++n5;
                    }
                }
                catch (Exception exception) {}
            }
            ++n3;
        }
        if (DEBUG) {
            System.out.println("PropToolbar.mergeIn: done\n");
        }
    }

    public void mergeOut(PropToolbar propToolbar) {
        if (DEBUG) {
            System.out.println("\nPropToolbar.mergeOut ");
        }
        Vector vector = propToolbar.getCmdList();
        int n = vector.size();
        if (vector == null || n == 0) {
            if (DEBUG) {
                System.out.println("PropToolbar.mergeOut: toolbar is empty");
            }
            return;
        }
        int n2 = this._cmdList.size();
        int n3 = 0;
        while (n3 < n) {
            block15: {
                try {
                    int n4;
                    IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n3);
                    if (iAdminProp == null || (n4 = ((Integer)iAdminProp.getProp(2687496)).intValue()) >= 0 || n4 == -1) break block15;
                    if (DEBUG) {
                        System.out.println("PropToolbar.mergeOut: found item global id=" + n4);
                    }
                    if (DEBUG) {
                        System.out.println("PropToolbar.mergeOut: dislayname=" + iAdminProp.getProp(0x110001));
                    }
                    int n5 = 0;
                    while (n5 < n2) {
                        IAdminProp iAdminProp2 = (IAdminProp)this._cmdList.elementAt(n5);
                        if (iAdminProp2.getProp(4784659) == iAdminProp) {
                            if (DEBUG) {
                                System.out.println("PropToolbar.mergeOut: global toolbar is handling this item! j=" + n5);
                            }
                            try {
                                Image image;
                                iAdminProp2.setProp(8978948, Boolean.FALSE);
                                iAdminProp2.setProp(4784659, null);
                                this.setItemHelpText(n5, this.getPropTooltip(iAdminProp2));
                                String string = (String)iAdminProp.getProp(1638408);
                                String string2 = (String)iAdminProp2.getProp(1638408);
                                if (string != null && string2 != null && !string.equals(string2) && (image = AdminUtil.loadImage(string2, (Component)((Object)this))) != null) {
                                    this.setItemIcon(n5, image);
                                }
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        ++n5;
                    }
                }
                catch (Exception exception) {}
            }
            ++n3;
        }
        propToolbar.unhideAll();
        if (DEBUG) {
            System.out.println("PropToolbar.mergeOut done\n");
        }
    }

    public void setAuxillaryToolbar(PropToolbar propToolbar) {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        if (DEBUG) {
            System.out.println("\nPropToolbar.setAuxillaryToolbar toolbar=" + propToolbar);
        }
        if ((n3 = this._cmdList.size()) == 0) {
            if (DEBUG) {
                System.out.println("PropToolbar.setAuxillaryToolbar no items");
            }
            if (DEBUG) {
                System.out.println("PropToolbar.setAuxillaryToolbar Done");
            }
            return;
        }
        Object[] objectArray2 = objectArray = propToolbar == null ? null : propToolbar.getSpecialCommands();
        if (DEBUG) {
            System.out.println("PropToolbar.setAuxillaryToolbar specialCmds=" + AdminProp.objectArrayToVector(objectArray));
        }
        if (objectArray == null || objectArray.length == 0) {
            try {
                int n4 = 0;
                while (n4 < n3 - 1) {
                    IAdminProp iAdminProp = (IAdminProp)this._cmdList.elementAt(n4);
                    Integer n5 = (Integer)iAdminProp.getProp(2687496);
                    if (n5 >= 0) {
                        iAdminProp.setProp(8978948, Boolean.TRUE);
                    } else {
                        iAdminProp.setProp(8978948, Boolean.FALSE);
                        iAdminProp.setProp(4784659, null);
                        this.setItemHelpText(n4, this.getPropTooltip(iAdminProp));
                    }
                    ++n4;
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        int[] nArray = new int[objectArray.length];
        boolean[] blArray = new boolean[objectArray.length];
        int n6 = 0;
        while (n6 < objectArray.length) {
            try {
                nArray[n6] = (Integer)objectArray[n6].getProp(2687496);
                blArray[n6] = false;
            }
            catch (Exception exception) {}
            ++n6;
        }
        if (this._ids == null) {
            this._ids = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                try {
                    this._ids[n2] = (Integer)((IAdminProp)this._cmdList.elementAt(n2)).getProp(2687496);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n3 - 1) {
            Object object;
            String string;
            IAdminProp iAdminProp;
            n = 0;
            while (n < nArray.length) {
                if (this._ids[n2] == nArray[n]) {
                    blArray[n] = true;
                    try {
                        Image image;
                        iAdminProp = (IAdminProp)this._cmdList.elementAt(n2);
                        if (DEBUG) {
                            System.out.println("PropToolbar.setAuxillaryToolbar link cmd=" + iAdminProp + " to specialCmd=" + objectArray[n]);
                        }
                        iAdminProp.setProp(8978948, objectArray[n].getProp(8978948));
                        string = (String)objectArray[n].getProp(1638408);
                        object = (String)iAdminProp.getProp(1638408);
                        iAdminProp.setProp(4784659, objectArray[n]);
                        this.setItemHelpText(n2, this.getPropTooltip((IAdminProp)objectArray[n]));
                        if (string == null || object != null && string.equals(object) || (image = AdminUtil.loadImage(string, (Component)((Object)this))) == null) break;
                        this.setItemIcon(n2, image);
                    }
                    catch (Exception exception) {}
                    break;
                }
                ++n;
            }
            if (n == nArray.length) {
                try {
                    iAdminProp = (IAdminProp)this._cmdList.elementAt(n2);
                    if (this._ids[n2] < 0) {
                        iAdminProp.setProp(8978948, Boolean.FALSE);
                        iAdminProp.setProp(4784659, null);
                        this.setItemHelpText(n2, this.getPropTooltip(iAdminProp));
                        string = (String)iAdminProp.getProp(1638408);
                        object = AdminUtil.loadImage(string, (Component)((Object)this));
                        if (object != null) {
                            this.setItemIcon(n2, (Image)object);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        n = 0;
        while (n < nArray.length) {
            if (!blArray[n]) {
                propToolbar.removeFromSpecialList((IAdminProp)objectArray[n]);
            }
            ++n;
        }
        if (DEBUG) {
            System.out.println("PropToolbar.setAuxillaryToolbar Done");
        }
    }

    public PropToolbar() {
        AdminUtil.setBackground((Component)((Object)this));
    }

    public PropToolbar(IAdminProp iAdminProp) {
        this();
        this._prop = iAdminProp;
        this.setPropBtns(iAdminProp);
    }

    public PropToolbar(IAdminProp iAdminProp, boolean bl) {
        this();
        this._prop = iAdminProp;
        this.setHideSpecialCommands(bl);
        this.setPropBtns(iAdminProp);
    }

    public PropToolbar(IAdminProp iAdminProp, Component component) {
        this();
        this._prop = iAdminProp;
        this.setAllBtns(iAdminProp, component);
    }

    public PropToolbar(IAdminProp iAdminProp, Component component, boolean bl) {
        this();
        this._prop = iAdminProp;
        this.setHideSpecialCommands(bl);
        this.setAllBtns(iAdminProp, component);
    }

    public PropToolbar(Component component) {
        this();
        this.setCompBtns(component);
    }

    public boolean isPopulated() {
        return this._cmdList.size() > 0 || this._specialCmdList != null && this._specialCmdList.size() > 0;
    }

    public static boolean isSeparator(IAdminProp iAdminProp) {
        try {
            Integer n = (Integer)iAdminProp.getProp(2687495);
            if (n == 8) {
                return true;
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
        return false;
    }

    public boolean isVisibleCmd(IAdminProp iAdminProp) {
        return (this._specialCmdList == null || !this._specialCmdList.contains(iAdminProp)) && !PropToolbar.isSeparator(iAdminProp);
    }

    public boolean isPopulatedVisibly() {
        int n = this._cmdList.size();
        int n2 = 0;
        while (n2 < n) {
            IAdminProp iAdminProp = (IAdminProp)this._cmdList.elementAt(n2);
            if (!(this._specialCmdList != null && this._specialCmdList.contains(iAdminProp) || PropToolbar.isSeparator(iAdminProp))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isAnyItemActive() {
        int n = this._cmdList.size();
        int n2 = 0;
        while (n2 < n) {
            IAdminProp iAdminProp = (IAdminProp)this._cmdList.elementAt(n2);
            if ((this._specialCmdList == null || !this._specialCmdList.contains(iAdminProp)) && this.isPropEnabled(iAdminProp)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void removeAll() {
        super.removeAll();
        this._cmdList.removeAllElements();
    }

    protected void initCommandList() {
        this.initCommandList(0);
    }

    public Image getPropIcon(IAdminProp iAdminProp) {
        Image image = null;
        try {
            String string;
            image = (Image)iAdminProp.getProp(7929864);
            if (image == null && (string = (String)iAdminProp.getProp(1638408)) != null) {
                image = AdminUtil.loadImage(string, (Component)((Object)this));
            }
        }
        catch (Exception exception) {}
        if (image == null || image.getWidth(null) <= 0) {
            image = this.createPropImage(iAdminProp);
        } else if (image.getWidth(null) < 22 || image.getHeight(null) < 22) {
            image = image.getScaledInstance(22, 22, 4);
        }
        return image;
    }

    protected void initCommandList(int n) {
        if (n < 0) {
            return;
        }
        try {
            int n2 = n;
            int n3 = this._cmdList.size();
            while (n2 < n3) {
                Integer n4;
                IAdminProp iAdminProp = (IAdminProp)this._cmdList.elementAt(n2);
                AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
                Integer n5 = (Integer)iAdminProp.getProp(2687495);
                if (n5 == 8) {
                    this.addSeparator(6);
                } else if (this._hideSpecialCommands && (n4 = (Integer)iAdminProp.getProp(2687496)) != null && n4 < 0) {
                    if (this._specialCmdList == null) {
                        this._specialCmdList = new Vector();
                    }
                    this._specialCmdList.addElement(iAdminProp);
                } else {
                    this.createItem(n5, iAdminProp, n2);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
        this.validate();
    }

    public void createItem(Integer n, IAdminProp iAdminProp, int n2) throws PropertyException {
        switch (n) {
            case 1: {
                Image image = this.getPropIcon(iAdminProp);
                this.addButton(n2, image, this.getPropTooltip(iAdminProp), this.isPropEnabled(iAdminProp));
                return;
            }
            case 2: {
                Image image = this.getPropIcon(iAdminProp);
                this.addCheck(n2, image, this.isPropSelected(iAdminProp), this.getPropTooltip(iAdminProp), this.isPropEnabled(iAdminProp));
                return;
            }
            case 16: {
                int n3 = (Integer)iAdminProp.getProp(2687505);
                int n4 = (Integer)iAdminProp.getProp(2687504);
                int n5 = (Integer)iAdminProp.getProp(7930386);
                this.addSpinBox(n2, n3, n4, n5, this.getPropTooltip(iAdminProp), this.isPropEnabled(iAdminProp));
                return;
            }
            case 4: {
                Image image = this.getPropIcon(iAdminProp);
                this.addRadio(n2, image, this.isPropSelected(iAdminProp), this.getPropTooltip(iAdminProp), this.isPropEnabled(iAdminProp));
                return;
            }
        }
        System.out.println("Proptoolbar.init(): Unknown CommandProp type.");
    }

    public void removeProp() {
        if (this._firstPropItem == -1) {
            return;
        }
        int n = this._cmdList.size() - 1;
        while (n >= this._firstPropItem) {
            AdminUtil.removeAdminPropertyChangeListener((IAdminProp)this._cmdList.elementAt(n), this);
            this._cmdList.removeElementAt(n);
            --n;
        }
        this.removeAll();
    }

    public void setPropBtns(IAdminProp iAdminProp) {
        this.removeProp();
        try {
            if (iAdminProp != null) {
                IAdminProp[] iAdminPropArray = AdminUtil.getCommandList(iAdminProp, 273613313);
                if (iAdminPropArray == null) {
                    return;
                }
                if (this._firstPropItem == -1) {
                    this._firstPropItem = this._cmdList.size();
                }
                int n = 0;
                while (n < iAdminPropArray.length) {
                    this._cmdList.addElement(iAdminPropArray[n]);
                    ++n;
                }
                this.initCommandList(this._firstPropItem);
                return;
            }
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
        }
    }

    public void setCompBtns(Component component) {
        this.setAllBtns(null, component);
    }

    public void setAllBtns(IAdminProp iAdminProp, Component component) {
        this.removeAll();
        if (iAdminProp != null || component != null && component instanceof ICommandEditor) {
            try {
                Object[] objectArray = null;
                Object[] objectArray2 = null;
                if (iAdminProp != null) {
                    objectArray = AdminUtil.getCommandList(iAdminProp, 273613313);
                }
                if (DEBUG) {
                    System.out.println("PropToolbar.setAllBtns cmdListProp = " + Util.objectArrayToVector(objectArray));
                }
                if ((component = AdminUtil.removeScrollBox(component)) != null && component instanceof ICommandEditor) {
                    ICommandEditor iCommandEditor = (ICommandEditor)((Object)component);
                    objectArray2 = iCommandEditor.getCommandList();
                    if (DEBUG) {
                        System.out.println("PropToolbar.setAllBtns cmdListComp = " + Util.objectArrayToVector(objectArray2));
                    }
                }
                if (objectArray != null && objectArray2 != null) {
                    int n = 0;
                    while (n < objectArray.length) {
                        this._cmdList.addElement(objectArray[n]);
                        ++n;
                    }
                    this._firstPropItem = n;
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        this._cmdList.addElement(objectArray2[n2]);
                        ++n2;
                    }
                } else if (objectArray != null) {
                    int n = 0;
                    while (n < objectArray.length) {
                        this._cmdList.addElement(objectArray[n]);
                        ++n;
                    }
                    this._firstPropItem = 0;
                } else if (objectArray2 != null) {
                    int n = 0;
                    while (n < objectArray2.length) {
                        this._cmdList.addElement(objectArray2[n]);
                        ++n;
                    }
                    this._firstPropItem = -1;
                }
                if (this.isPopulated()) {
                    this.initCommandList();
                }
                this.validate();
                return;
            }
            catch (PropertyException propertyException) {
                new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
                return;
            }
            catch (Exception exception) {
                AdminProp.sUnexpectedException(exception);
                return;
            }
        }
    }

    private Image createBlankImage(int n) {
        int[] nArray = new int[484];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 22) {
            int n4 = 0;
            while (n4 < 22) {
                nArray[n2++] = n;
                ++n4;
            }
            ++n3;
        }
        return ((Component)((Object)this)).createImage(new MemoryImageSource(22, 22, nArray, 0, 22));
    }

    private Image createPropImage(IAdminProp iAdminProp) {
        String string;
        try {
            string = (String)iAdminProp.getProp(0x110001);
        }
        catch (PropertyException propertyException) {
            return this.createBlankImage(Color.lightGray.getRGB());
        }
        Font font = new Font("Monospaced", 0, 14);
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
        int n = fontMetrics.stringWidth(string) + 4;
        int n2 = fontMetrics.getHeight() + 2;
        Frame frame = AdminUtil.getFrame((Component)((Object)this));
        if (frame == null) {
            frame = new Frame();
            frame.addNotify();
        }
        Image image = frame.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        graphics.setFont(font);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.black);
        graphics.drawString(string, 2, fontMetrics.getAscent() + 1);
        return image;
    }

    private boolean isPropSelected(IAdminProp iAdminProp) {
        try {
            return (Boolean)iAdminProp.getProp(8978949);
        }
        catch (PropertyException propertyException) {
            return true;
        }
    }

    private boolean isPropEnabled(IAdminProp iAdminProp) {
        try {
            return (Boolean)iAdminProp.getProp(8978948);
        }
        catch (PropertyException propertyException) {
            return true;
        }
    }

    private String getPropTooltip(IAdminProp iAdminProp) {
        try {
            return (String)iAdminProp.getProp(0x110001);
        }
        catch (PropertyException propertyException) {
            return "";
        }
    }

    Frame getFrame() {
        return AdminUtil.getFrame((Component)((Object)this));
    }

    public void adminToolBarItemActionPerformed(int n) {
        IAdminProp iAdminProp = (IAdminProp)this._cmdList.elementAt(n);
        PropToolbar.callCommand(iAdminProp, this.getFrame());
    }

    public void adminSpinBoxValueChanged(int n, Integer n2) {
        IAdminProp iAdminProp = (IAdminProp)this._cmdList.elementAt(n);
        try {
            iAdminProp.setProp(7930386, n2);
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        PropToolbar.callCommand(iAdminProp, this.getFrame());
    }

    public static void callCommand(IAdminProp iAdminProp, Component component) {
        new runCommand(iAdminProp, component);
    }

    public static IAdminProp showCommandProgress(IAdminProp iAdminProp, Frame frame, boolean bl) throws PropertyException {
        String string = (String)iAdminProp.getProp(0x110001);
        if (string == null) {
            string = "Command";
        }
        new CommandProgress(iAdminProp, frame, string, bl);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        IAdminProp iAdminProp2 = (IAdminProp)iAdminProp.getProp(4784643);
        return iAdminProp2;
    }

    public static IAdminProp showCommandProgress(IAdminProp iAdminProp, Frame frame) throws PropertyException {
        String string = (String)iAdminProp.getProp(0x110001);
        if (string == null) {
            string = "Command";
        }
        new CommandProgress(iAdminProp, frame, string, true);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PropToolbar(");
        int n = 0;
        int n2 = this._cmdList.size();
        int n3 = 0;
        while (n < n2) {
            Object e = this._cmdList.elementAt(n);
            if (e == null) {
                stringBuffer.append("null");
            } else {
                String string = e.toString();
                if (string.length() == 0) {
                    stringBuffer.append("|");
                } else {
                    stringBuffer.append("'");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
            }
            if (n + 1 < n2) {
                stringBuffer.append(", ");
            }
            ++n3;
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        IAdminProp iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource();
        if (this._specialCmdList != null && this._specialCmdList.contains(iAdminProp)) {
            if (!DEBUG) return;
            System.out.println("PropToolbar.adminPropertyChange ignore special prop " + iAdminProp);
            return;
        }
        int n = 0;
        int n2 = this._cmdList.size();
        int n3 = 0;
        while (n < n2) {
            if (this._cmdList.elementAt(n) == iAdminProp) {
                switch (adminPropertyChangeEvent.getPropId()) {
                    case 8978948: {
                        String string;
                        if (DEBUG && (string = String.valueOf(iAdminProp)).length() != 0) {
                            System.out.print("PropToolbar.adminPropertyChange");
                            System.out.print(" item=" + string);
                            System.out.println(" PR_ENABLED=" + adminPropertyChangeEvent.getNewValue());
                        }
                        this.setItemEnabled(n3, (Boolean)adminPropertyChangeEvent.getNewValue());
                        return;
                    }
                    case 1638408: {
                        Image image;
                        String string = (String)adminPropertyChangeEvent.getNewValue();
                        if (string == null || (image = AdminUtil.loadImage(string, (Component)((Object)this))) == null) return;
                        this.setItemIcon(n3, image);
                        return;
                    }
                    case 0x110001: {
                        this.setItemHelpText(n3, (String)adminPropertyChangeEvent.getNewValue());
                        return;
                    }
                    case 8978949: {
                        this.setCheckState(n3, (Boolean)adminPropertyChangeEvent.getNewValue());
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (this._specialCmdList != null && AdminProp.vectorContains(this._specialCmdList, this._cmdList.elementAt(n))) {
                --n3;
            }
            ++n3;
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        int n = 0;
        int n2 = this._cmdList.size();
        while (n < n2) {
            AdminUtil.removeAdminPropertyChangeListener((IAdminProp)this._cmdList.elementAt(n), this);
            ++n;
        }
        super.finalize();
    }

    public void showStatusMessage(String string) {
        int n = this._cmdList.size();
        int n2 = 0;
        while (n2 < n) {
            IAdminProp iAdminProp = (IAdminProp)this._cmdList.elementAt(n2);
            try {
                String string2 = (String)iAdminProp.getProp(0x110001);
                if (string2 != null && string2.equals(string)) {
                    String string3 = (String)iAdminProp.getProp(1638914);
                    if (string3 != null && string3.length() == 0) {
                        string3 = null;
                    }
                    if (string3 != null && string3.startsWith(string)) {
                        AdminUtil.showSBMessage((Component)((Object)this), string3);
                        return;
                    }
                    if (string3 != null && !string3.equals(string)) {
                        AdminUtil.showSBMessage((Component)((Object)this), String.valueOf(string) + " / " + string3);
                        return;
                    }
                    AdminUtil.showSBMessage((Component)((Object)this), string);
                    return;
                }
            }
            catch (Exception exception) {
                AdminProp.sUnexpectedException(exception);
            }
            ++n2;
        }
        AdminUtil.showSBMessage((Component)((Object)this), string);
    }

    public void removeStatusMessage(String string) {
        AdminUtil.removeSBMessage((Component)((Object)this), string);
    }

    static {
        BACKGROUND_MESSAGE = "Command will be excuted in the background.";
    }

    static class runCommand
    implements Runnable {
        IAdminProp m_ap;
        Component m_c;

        public runCommand(IAdminProp iAdminProp, Component component) {
            this.m_ap = iAdminProp;
            this.m_c = component;
            new Thread(this).start();
        }

        public void run() {
            Object object;
            Object object2;
            Component component = this.m_c;
            IAdminProp iAdminProp = this.m_ap;
            Frame frame = AdminUtil.getFrame(component);
            Dialog dialog = AdminUtil.getDialog(component);
            try {
                object2 = (String)iAdminProp.getProp(1639168);
                if (object2 != null && ((ErrorAlert)(object = new ErrorAlert(frame, (String)object2, (String)iAdminProp.getProp(0x110001), 1, 3, true))).getResults() != 1) {
                    return;
                }
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
            }
            if (dialog != null) {
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("run():  PropToolbar::   WAIT_CURSOR");
                }
                ((Component)dialog).setCursor(Cursor.getPredefinedCursor(3));
            } else {
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("run(): PropToolbar::  WAIT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
            }
            try {
                object2 = iAdminProp;
                object = null;
                Integer n = (Integer)object2.getProp(2687509);
                int n2 = 0;
                if (n != null) {
                    n2 = n;
                }
                if ((n2 & 1) != 0) {
                    new ErrorAlert(frame, BACKGROUND_MESSAGE, (String)object2.getProp(0x110001), 1, 1);
                    WorkCommand workCommand = new WorkCommand((IAdminProp)object2);
                    AdminExec.setFrame(frame);
                    AdminExec.execute(workCommand);
                } else {
                    object = (n2 & 2) != 0 ? PropToolbar.showCommandProgress((IAdminProp)object2, frame, true) : ((n2 & 4) != 0 ? PropToolbar.showCommandProgress((IAdminProp)object2, frame, false) : (IAdminProp)object2.getProp(4784643));
                }
                if (dialog != null) {
                    if (NavigatorFrame.DEBUG_CURSOR) {
                        System.out.println("run():  PropToolbar:: DEFAULT_CURSOR");
                    }
                    ((Component)dialog).setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    if (NavigatorFrame.DEBUG_CURSOR) {
                        System.out.println("run():  PropToolbar:: DEFAULT_CURSOR");
                    }
                    ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                }
                if (object != null) {
                    AdminUtil.editStandalone((IAdminProp)object, (IAdminProp)object2, component);
                    return;
                }
            }
            catch (Exception exception) {
                if (dialog != null) {
                    if (NavigatorFrame.DEBUG_CURSOR) {
                        System.out.println("run(): PropToolbar::  DEFAULT_CURSOR");
                    }
                    ((Component)dialog).setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    if (NavigatorFrame.DEBUG_CURSOR) {
                        System.out.println("run(): PropToolbar::  DEFAULT_CURSOR");
                    }
                    ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                }
                new ErrorAlert(AdminUtil.getFrame(frame), exception);
            }
        }
    }
}

