/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.CenteredDialog;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.common.AdminBorderPanel;
import oracle.ldap.admin.client.common.AdminImageCanvas;
import oracle.ldap.admin.client.common.AdminMultiLineLabel;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class SplashCanvas
extends AdminBorderPanel
implements MouseListener {
    Image m_logo;
    String m_Admin = "";
    static String m_spashScreen;
    SplashCanvas m_inner;
    AdminMultiLineLabel m_mll;
    boolean m_logonSplashScreen = false;
    Dialog m_dialog;

    public SplashCanvas() {
        this(true);
    }

    public SplashCanvas(boolean bl) {
        if (bl) {
            AdminUtil.setBackground((Component)((Object)this));
        }
        Image image = SplashCanvas.getBannerImage();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", (Component)((Object)new AdminImageCanvas(image, true)));
        this.m_mll = new AdminMultiLineLabel(String.valueOf(this.m_Admin) + SplashCanvas.getVersion());
        this.m_mll.setAlignment(3);
        ((Container)((Object)this)).add("South", (Component)((Object)this.m_mll));
        this.setInsets(20, 20, 20, 20);
    }

    public static Image getBannerImage() {
        IAdminProp iAdminProp;
        if (m_spashScreen == null && (iAdminProp = AdminUtil.getRoot()) != null) {
            try {
                IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273612805);
                if (iAdminPropArray != null) {
                    int n = 0;
                    while (n < iAdminPropArray.length) {
                        String string = (String)iAdminPropArray[n].getProp(1639543);
                        if (string != null) {
                            m_spashScreen = string;
                            Image image = AdminUtil.loadImage(m_spashScreen, null);
                            if (image != null) {
                                return image;
                            }
                            m_spashScreen = null;
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                AdminProp.sUnexpectedException(exception);
            }
        }
        if (m_spashScreen == null) {
            m_spashScreen = "images/logo.gif";
        }
        return AdminUtil.loadImage(m_spashScreen, null);
    }

    public void setLogonSplashScreen() {
        this.m_logonSplashScreen = true;
        if (this.m_mll != null) {
            ((Container)((Object)this)).remove((Component)((Object)this.m_mll));
        }
        this.setInsets(0, 0, 0, 0);
        if (this.m_inner != null) {
            this.m_inner.setLogonSplashScreen();
        }
    }

    public SplashCanvas(Image image) {
        this.m_logo = image;
    }

    public void setDialog(Dialog dialog) {
        this.m_dialog = dialog;
        if (this.m_inner != null) {
            ((Component)((Object)this.m_inner)).addMouseListener(this);
        }
        if (this.m_mll != null) {
            ((Component)((Object)this.m_mll)).addMouseListener(this);
        }
        this.m_dialog.addMouseListener(this);
        ((Component)((Object)this)).addMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_dialog.dispose();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.m_logo == null) {
            this.m_logo = SplashCanvas.getBannerImage();
        }
        if (this.m_logo != null) {
            int n = this.m_logo.getWidth((ImageObserver)((Object)this));
            int n2 = this.m_logo.getHeight((ImageObserver)((Object)this));
            if (dimension.width < n) {
                dimension.width = n;
            }
            if (dimension.height < n2) {
                dimension.height = n2;
            }
        } else {
            dimension.width = 300;
            dimension.height = 300;
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_logo != null) {
            Dimension dimension = ((Component)((Object)this)).getSize();
            Insets insets = this.getInsets();
            int n = insets.left;
            if (!this.m_logonSplashScreen) {
                return;
            }
            graphics.drawImage(this.m_logo, n, insets.top, dimension.width, dimension.height, Color.black, (ImageObserver)((Object)this));
            graphics.setColor(AdminUtil.getDefaultBackgroundColor());
            this.drawRaisedFrame(graphics, n, insets.top, dimension.width, dimension.height, 4);
        }
    }

    public static String getVersion() {
        String string = "";
        IAdminProp iAdminProp = AdminUtil.getRoot();
        IAdminProp[] iAdminPropArray = null;
        String string2 = "";
        if (iAdminProp != null) {
            try {
                iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273612805);
            }
            catch (Exception exception) {
                AdminProp.sUnexpectedException(exception);
            }
        }
        if (iAdminPropArray != null) {
            int n = 0;
            while (n < iAdminPropArray.length) {
                IAdminProp iAdminProp2 = iAdminPropArray[n];
                try {
                    string2 = (String)iAdminProp2.getProp(1048731);
                    if (string2 != null) {
                        string = String.valueOf(string) + string2 + "\n";
                    }
                }
                catch (PropertyException propertyException) {
                    AdminProp.sUnexpectedException(propertyException);
                }
                ++n;
            }
        }
        return string;
    }

    public static void showAboutDialog(Frame frame) {
        CenteredDialog centeredDialog = new CenteredDialog(frame, NavigatorFrame._aboutMenuLabel, true);
        centeredDialog.setContentLayout(new BorderLayout());
        ((Component)((Object)centeredDialog)).setSize(450, 500);
        SplashCanvas splashCanvas = new SplashCanvas();
        centeredDialog.addContentComponent((Component)((Object)splashCanvas));
        splashCanvas.setDialog((Dialog)((Object)centeredDialog));
        ((Dialog)((Object)centeredDialog)).setModal(true);
        centeredDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        ((Component)frame).setBounds(150, 130, 200, 100);
        SplashCanvas.showAboutDialog(frame);
    }
}

