/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextListener;
import java.util.Vector;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ldap.admin.client.common.AdminPanel;

public class AdminTextArea
extends AdminPanel {
    private ScrollBox m_scrollBox;
    private LWTextArea m_textarea;
    RedirectEvents m_redirectEvents;

    public void setEnabled(boolean bl) {
        this.m_textarea.setEnabled(bl);
        super.setEnabled(bl);
    }

    public AdminTextArea() {
        this.m_textarea = new LWTextArea();
        this.initRedirectEvents((Component)this.m_textarea, true);
        this.setScrollBars(-1);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.m_scrollBox);
    }

    public void setToolTipValue(String string) {
        this.m_textarea.setToolTipValue(string);
    }

    public AdminTextArea(int n, int n2) {
        this.m_textarea = new LWTextArea("", n, n2);
        this.initRedirectEvents((Component)this.m_textarea, true);
        this.setScrollBars(-1);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.m_scrollBox);
    }

    public AdminTextArea(String string) {
        this.m_textarea = new LWTextArea(string);
        this.initRedirectEvents((Component)this.m_textarea, true);
        this.setScrollBars(-1);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.m_scrollBox);
    }

    public AdminTextArea(String string, int n, int n2) {
        this.m_textarea = new LWTextArea(string, n, n2);
        this.initRedirectEvents((Component)this.m_textarea, true);
        this.setScrollBars(-1);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.m_scrollBox);
    }

    public AdminTextArea(String string, int n, int n2, int n3) {
        this.m_textarea = new LWTextArea(string, n, n2);
        this.initRedirectEvents((Component)this.m_textarea, true);
        this.setScrollBars(n3);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.m_scrollBox);
    }

    public void setScrollBars(int n) {
        if (this.m_scrollBox == null) {
            this.m_scrollBox = new ScrollBox();
        }
        if (n == -1) {
            n = 0;
        }
        this.m_scrollBox.setHDisplayPolicy(n);
        this.m_scrollBox.setVDisplayPolicy(n);
        this.m_scrollBox.setContent((Component)this.m_textarea);
    }

    public void setEditable(boolean bl) {
        this.m_textarea.setEditable(bl);
        if (!bl) {
            this.m_textarea.setBackground(Color.lightGray);
        }
    }

    public void addTextListener(TextListener textListener) {
        this.m_textarea.addTextListener(textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.m_textarea.removeTextListener(textListener);
    }

    public int getCaretPosition() {
        return this.m_textarea.getCaretPosition();
    }

    public void append(String string) {
        this.m_textarea.append(string);
    }

    public String getSelectedText() {
        return this.m_textarea.getSelectedText();
    }

    public synchronized int getSelectionEnd() {
        return this.m_textarea.getSelectionEnd();
    }

    public synchronized int getSelectionStart() {
        return this.m_textarea.getSelectionStart();
    }

    public String getText() {
        return this.m_textarea.getText();
    }

    public void setText(String string) {
        this.m_textarea.setText(string);
    }

    public boolean isEditable() {
        return this.m_textarea.isEditable();
    }

    public void removeNotify() {
        this.m_textarea.removeNotify();
    }

    public void select(int n, int n2) {
        this.m_textarea.select(n, n2);
    }

    public void selectAll() {
        this.m_textarea.selectAll();
    }

    public void setCaretPosition(int n) {
        this.m_textarea.setCaretPosition(n);
    }

    public void setSelectionEnd(int n) {
        this.m_textarea.setSelectionEnd(n);
    }

    public void setSelectionStart(int n) {
        this.m_textarea.setSelectionStart(n);
    }

    public int getRows() {
        return this.m_textarea.getRows();
    }

    public void setRows(int n) {
        this.m_textarea.setRows(n);
    }

    public Dimension getPreferredSize(int n, int n2) {
        FontMetrics fontMetrics;
        Font font = this.getFont();
        int n3 = 8;
        int n4 = 10;
        if (font != null && (fontMetrics = ((Component)((Object)this)).getFontMetrics(font)) != null) {
            n3 = fontMetrics.stringWidth("m");
            n4 = fontMetrics.getHeight();
        }
        n4 = n4 * n + 8;
        n3 = n3 + n2 + 8;
        return new Dimension(n3, n4);
    }

    public Dimension getMinimumSize(int n, int n2) {
        return this.getPreferredSize(1, 20);
    }

    public void initRedirectEvents(Component component, boolean bl) {
        if (this.m_redirectEvents == null) {
            this.m_redirectEvents = new RedirectEvents((Component)((Object)this));
        }
        if (bl) {
            component.addKeyListener(this.m_redirectEvents);
            component.addMouseListener(this.m_redirectEvents);
            component.addFocusListener(this.m_redirectEvents);
            return;
        }
        component.removeKeyListener(this.m_redirectEvents);
        component.removeMouseListener(this.m_redirectEvents);
        component.removeFocusListener(this.m_redirectEvents);
    }

    public void addMouseListener(MouseListener mouseListener2) {
        this.m_redirectEvents.addMouseListener(mouseListener2);
    }

    public void removeMouseListener(MouseListener mouseListener2) {
        this.m_redirectEvents.removeMouseListener(mouseListener2);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.m_redirectEvents.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.m_redirectEvents.removeKeyListener(keyListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.m_redirectEvents.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.m_redirectEvents.removeFocusListener(focusListener);
    }

    public int getLineStartOffset(int n) {
        int n2;
        String string = this.m_textarea.getText();
        int n3 = string.length();
        int n4 = 0;
        int n5 = n;
        while ((n2 = string.indexOf(10, n4)) > 0) {
            if (n5-- <= 0 || (n4 = n2 + n4) >= n3) break;
        }
        if (n4 >= n3) {
            n4 = n3 - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return n4;
    }

    class RedirectEvents
    implements KeyListener,
    MouseListener,
    FocusListener {
        Component m_c;
        Vector m_keyListeners = new Vector();
        Vector m_focusListeners = new Vector();
        Vector m_mouseListeners = new Vector();

        public RedirectEvents(Component component) {
            AdminTextArea.this = AdminTextArea.this;
            this.m_c = component;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.redirectEvent(mouseEvent, 1);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.redirectEvent(mouseEvent, 2);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.redirectEvent(mouseEvent, 3);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.redirectEvent(mouseEvent, 4);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.redirectEvent(mouseEvent, 5);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.redirectEvent(keyEvent, 1);
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.redirectEvent(keyEvent, 2);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.redirectEvent(keyEvent, 3);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.redirectEvent(focusEvent, 1);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.redirectEvent(focusEvent, 2);
        }

        public void addKeyListener(KeyListener keyListener) {
            this.m_keyListeners.addElement(keyListener);
        }

        public void removeKeyListener(KeyListener keyListener) {
            this.m_keyListeners.removeElement(keyListener);
        }

        public void addFocusListener(FocusListener focusListener) {
            this.m_focusListeners.addElement(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            this.m_focusListeners.removeElement(focusListener);
        }

        public void addMouseListener(MouseListener mouseListener2) {
            this.m_mouseListeners.addElement(mouseListener2);
        }

        public void removeMouseListener(MouseListener mouseListener2) {
            this.m_mouseListeners.removeElement(mouseListener2);
        }

        public void redirectEvent(KeyEvent keyEvent, int n) {
            KeyEvent keyEvent2 = new KeyEvent(this.m_c, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
            int n2 = this.m_keyListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                KeyListener keyListener = (KeyListener)this.m_keyListeners.elementAt(n3);
                switch (n) {
                    case 1: {
                        keyListener.keyTyped(keyEvent2);
                        break;
                    }
                    case 2: {
                        keyListener.keyPressed(keyEvent2);
                        break;
                    }
                    case 3: {
                        keyListener.keyReleased(keyEvent2);
                        break;
                    }
                }
                ++n3;
            }
        }

        public void redirectEvent(MouseEvent mouseEvent, int n) {
            MouseEvent mouseEvent2 = new MouseEvent(this.m_c, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            int n2 = this.m_mouseListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                MouseListener mouseListener2 = (MouseListener)this.m_mouseListeners.elementAt(n3);
                switch (n) {
                    case 1: {
                        mouseListener2.mouseClicked(mouseEvent2);
                        break;
                    }
                    case 2: {
                        mouseListener2.mousePressed(mouseEvent2);
                        break;
                    }
                    case 3: {
                        mouseListener2.mouseReleased(mouseEvent2);
                        break;
                    }
                    case 4: {
                        mouseListener2.mouseEntered(mouseEvent2);
                        break;
                    }
                    case 5: {
                        mouseListener2.mouseExited(mouseEvent2);
                        break;
                    }
                }
                ++n3;
            }
        }

        public void redirectEvent(FocusEvent focusEvent, int n) {
            FocusEvent focusEvent2 = new FocusEvent(this.m_c, focusEvent.getID());
            int n2 = this.m_focusListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                FocusListener focusListener = (FocusListener)this.m_focusListeners.elementAt(n3);
                switch (n) {
                    case 1: {
                        focusListener.focusGained(focusEvent2);
                        break;
                    }
                    case 2: {
                        focusListener.focusLost(focusEvent2);
                        break;
                    }
                }
                ++n3;
            }
        }
    }
}

