/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.common;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import oracle.ewt.dTree.DTreeSimpleParent;
import oracle.ldap.admin.client.common.AdminTree;

public class AdminTreeItem
extends DTreeSimpleParent {
    Color m_color;
    Font m_font;

    public AdminTreeItem(String string, Image image) {
        super(string, image);
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setIcon(Image image) {
        super.setIcon(image);
    }

    public void setLabel(String string) {
        super.setLabel(string);
    }

    public AdminTree getAdminTree() {
        return (AdminTree)super.getTree();
    }

    public boolean hasChildren() {
        int n = this.getItemCount();
        return n > 0;
    }

    public void DTreeExtendedItem_paint(Graphics graphics) {
        int n = 0;
        this.DTreeItem_paint(graphics);
        if (n != 0) {
            graphics.translate(-n, 0);
        }
    }

    public void DTreeItem_paint(Graphics graphics) {
        if (this.getTree() == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        Image image = this.getIcon();
        String string = this.getLabel();
        int n = fontMetrics.getHeight() + 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getX();
        int n5 = this.getY();
        n4 += n3;
        n5 = this.getY();
        if (n2 > n) {
            n5 += (n2 - n) / 2;
        }
        if (string != null) {
            Color color;
            Color color2 = graphics.getColor();
            boolean bl = true;
            int n6 = fontMetrics.stringWidth(string) + 4;
            if (bl) {
                color = graphics.getColor();
                if (color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255) {
                    graphics.setColor(Color.black);
                }
                graphics.fillRect(n4, n5, n6, n);
            }
            color = graphics.getColor();
            if (bl) {
                graphics.setColor(Color.white);
            } else if (color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255) {
                graphics.setColor(Color.black);
            }
            graphics.drawString(string, n4 + 2, n5 + fontMetrics.getAscent() + fontMetrics.getLeading() + 2);
            graphics.setColor(color2);
        }
    }

    public AdminTreeItem[] getAdminChildren() {
        int n = this.getItemCount();
        if (n > 0) {
            AdminTreeItem[] adminTreeItemArray = new AdminTreeItem[n];
            int n2 = 0;
            while (n2 < n) {
                adminTreeItemArray[n2] = (AdminTreeItem)this.getItem(n2);
                ++n2;
            }
            return adminTreeItemArray;
        }
        return null;
    }

    public String getAccessibleType() {
        return this.getLabel();
    }
}

