/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.RelativePlacement;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.datamodels.v2_1.DataAdaptor;
import com.roguewave.chart.standard.v2_1.Chart;
import com.roguewave.chart.standard.v2_1.MultiColumnBarChart;
import com.roguewave.chart.standard.v2_1.events.ChartClickEvent;
import com.roguewave.chart.standard.v2_1.events.ChartClickListener;
import com.roguewave.chart.standard.v2_1.parts.SingleRowLegend;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.common.AdminScrollPane;
import oracle.ldap.admin.client.propEditors.ChartDataModel;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class BarView
extends AdminScrollPane
implements RelativePlacement,
ChartClickListener,
AdminPropertyChangeListener {
    Object[] m_items;
    int[] prop_list;
    int item_count;
    int prop_count;
    int c_status;
    Color[] colors;
    Integer t_Status;
    Chart component;

    public BarView(IAdminProp iAdminProp, DataModel dataModel) {
        Object object;
        MultiColumnBarChart multiColumnBarChart = null;
        multiColumnBarChart = new MultiColumnBarChart();
        if (dataModel != null) {
            object = new DataAdaptor(dataModel);
            int n = 0;
            while (n < dataModel.getColumnCount()) {
                object.setColumnLabel(" ", n);
                ++n;
            }
            this.component = new Chart((ChartBuilder)multiColumnBarChart, 2, (DataModel)object);
        }
        this.init(iAdminProp);
        this.component.addChartClickListener((ChartClickListener)this);
        this.setView(iAdminProp);
        this.setOrientation(iAdminProp);
        this.setColor(iAdminProp);
        this.setLegend(iAdminProp);
        this.component.setDrawAreaInsets(new Insets(50, 25, 25, 50));
        this.component.setLabelColor(Color.black);
        this.component.setTitleColor(Color.blue);
        this.component.setTitleBackgroundColor(Color.cyan.darker());
        object = new Font("TimesNewRoman", 0, 11);
        this.component.setLegendItemFont((Font)object);
        this.component.setLabelFont((Font)object);
        this.component.setScale2DFont((Font)object);
        this.component.setLegendPosition(new RelativePosition(0.5, 0.975, -2, 0, 3));
        this.component.setLabelsShown(false);
        AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
        this.addScrollComponent((Component)this.component);
    }

    private void init(IAdminProp iAdminProp) {
        try {
            this.t_Status = (Integer)iAdminProp.getProp(2162758);
            if (this.t_Status != null) {
                this.c_status = this.t_Status;
            }
            this.m_items = (Object[])iAdminProp.getProp(272695365);
            this.prop_list = (int[])iAdminProp.getProp(281083972);
            if (this.prop_list != null) {
                this.prop_count = this.prop_list.length;
            }
            if (this.m_items != null) {
                this.item_count = this.m_items.length;
                return;
            }
        }
        catch (PropertyException propertyException) {}
    }

    public void chartClick(ChartClickEvent chartClickEvent) {
        AdminUtil.editStandalone((IAdminProp)this.m_items[chartClickEvent.getColumn(0)], null, (Component)((Object)this));
    }

    void setOrientation(IAdminProp iAdminProp) {
        int n = 0;
        try {
            Integer n2 = (Integer)iAdminProp.getProp(2162759);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (PropertyException propertyException) {}
        if (n == 1) {
            this.component.setChartOrientation(true);
            return;
        }
        this.component.setChartOrientation(false);
    }

    void setColor(IAdminProp iAdminProp) {
        try {
            this.colors = (Color[])iAdminProp.getProp(269549634);
        }
        catch (PropertyException propertyException) {}
        if (this.colors == null & this.c_status == 3) {
            StandardColors standardColors = new StandardColors();
            int n = 0;
            while (n < this.item_count) {
                if (this.c_status == 3) {
                    this.component.setProperty("ForegroundColor", (Object)standardColors.color(n), 0, n, 1, 1);
                }
                ++n;
            }
            return;
        }
        if (this.colors != null) {
            int n = 0;
            while (n < this.prop_count) {
                int n2 = 0;
                while (n2 < this.item_count) {
                    if (this.c_status == 3) {
                        this.component.setProperty("ForegroundColor", (Object)this.colors[n2], n, n2, 1, 1);
                    } else {
                        this.component.setProperty("ForegroundColor", (Object)this.colors[n], n, n2, 1, 1);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    void setView(IAdminProp iAdminProp) {
        int n = 0;
        try {
            Integer n2 = (Integer)iAdminProp.getProp(2162760);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (PropertyException propertyException) {}
        if (n == 1) {
            this.component.setViewMode(0);
            return;
        }
        this.component.setViewMode(2);
    }

    void setLegend(IAdminProp iAdminProp) {
        String[] stringArray = null;
        try {
            stringArray = (String[])iAdminProp.getProp(269549635);
            this.colors = (Color[])iAdminProp.getProp(269549634);
        }
        catch (PropertyException propertyException) {}
        if (this.c_status == 3) {
            if (this.colors != null & stringArray != null) {
                this.component.setLegend((Customizer)new SingleRowLegend(stringArray, this.colors));
            } else {
                this.component.setLegend((Customizer)new SingleRowLegend());
            }
        }
        this.resizeWidth(stringArray);
    }

    void resizeWidth(String[] stringArray) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        fontMetrics.getHeight();
        int n = 0;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Dimension dimension = this.component.getSize();
            if ((n += fontMetrics.stringWidth(stringArray[n3])) + 30 > dimension.width) {
                this.component.setSize(new Dimension(dimension.width + 40, dimension.height));
            }
            ++n3;
        }
    }

    void setData(IAdminProp iAdminProp) {
        this.init(iAdminProp);
        ChartDataModel chartDataModel = new ChartDataModel(iAdminProp, (Component)((Object)this));
        if (chartDataModel != null) {
            DataAdaptor dataAdaptor = new DataAdaptor((DataModel)chartDataModel);
            int n = 0;
            while (n < chartDataModel.getColumnCount()) {
                dataAdaptor.setColumnLabel(" ", n);
                ++n;
            }
            this.component.setData((DataModel)dataAdaptor);
            this.setRange(iAdminProp);
        }
    }

    void setChartType(IAdminProp iAdminProp) {
        int n = 0;
        try {
            Integer n2 = (Integer)iAdminProp.getProp(2162771);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (PropertyException propertyException) {}
        switch (n) {
            case 2: {
                this.component.setChartType("Bar");
                return;
            }
        }
    }

    void setTitle(IAdminProp iAdminProp) {
        String string = null;
        try {
            string = (String)iAdminProp.getProp(0x110050);
        }
        catch (PropertyException propertyException) {}
        this.component.setTitle(string);
    }

    void setRange(IAdminProp iAdminProp) {
        Double[] doubleArray = null;
        try {
            doubleArray = (Double[])iAdminProp.getProp(273743936);
        }
        catch (PropertyException propertyException) {}
        if (doubleArray[0] != null & doubleArray[1] != null) {
            this.component.setDataRange(doubleArray[0].doubleValue(), doubleArray[1].doubleValue());
        }
    }

    public static Component createChart(IAdminProp iAdminProp, EditorOwner editorOwner) {
        ChartDataModel chartDataModel = new ChartDataModel(iAdminProp);
        BarView barView = new BarView(iAdminProp, chartDataModel);
        chartDataModel.setParent((Component)((Object)barView));
        return barView;
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            IAdminProp iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource();
            switch (adminPropertyChangeEvent.getPropId()) {
                case 2162758: 
                case 272695365: 
                case 281083972: {
                    this.setData(iAdminProp);
                    break;
                }
                case 2162771: {
                    this.setChartType(iAdminProp);
                    break;
                }
                case 269549634: {
                    this.setColor(iAdminProp);
                    break;
                }
                case 269549635: {
                    this.setLegend(iAdminProp);
                    break;
                }
                case 2162760: {
                    this.setView(iAdminProp);
                    break;
                }
                case 2162759: {
                    this.setOrientation(iAdminProp);
                    break;
                }
                case 0x110050: {
                    this.setTitle(iAdminProp);
                    break;
                }
                case 273743936: {
                    this.setRange(iAdminProp);
                    break;
                }
            }
            this.component.repaint();
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    void unexpectedException(Exception exception) {
        System.out.println("Unexpected Exception " + exception);
    }
}

