/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.events.DataUpdateListener;
import java.awt.Component;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class ChartDataModel
implements DataModel {
    IAdminProp m_ap;
    Object[] m_items;
    String[] legends;
    String title;
    int[] prop_list;
    int item_count;
    int prop_count;
    int cstatus;
    int ctype;
    Double[] arr_range;
    Integer[] y_incrs;
    Component m_parent;
    Vector listeners = new Vector();

    public void setParent(Component component) {
        this.m_parent = component;
    }

    public ChartDataModel(IAdminProp iAdminProp) {
        this(iAdminProp, null);
    }

    public ChartDataModel(IAdminProp iAdminProp, Component component) {
        this.m_ap = iAdminProp;
        this.m_parent = component;
        try {
            this.m_items = (Object[])this.m_ap.getProp(272695365);
            if (this.m_items == null) {
                new ErrorAlert(AdminUtil.getFrame(this.m_parent), "No of Items has to be atleast 1");
            }
            this.prop_list = (int[])this.m_ap.getProp(281083972);
            if (this.prop_list == null) {
                new ErrorAlert(AdminUtil.getFrame(this.m_parent), "No of Properties has to be atleast 1");
            }
            if (this.prop_list != null) {
                this.prop_count = this.prop_list.length;
            }
            if (this.m_items != null) {
                this.item_count = this.m_items.length;
            }
            this.ctype = (Integer)this.m_ap.getProp(2162771);
            this.arr_range = (Double[])this.m_ap.getProp(273743936);
            if (this.ctype != 1 & this.arr_range == null) {
                this.arr_range = new Double[2];
                this.arr_range[0] = new Double(0.0);
                this.arr_range[1] = new Double(300.0);
            }
            this.legends = (String[])this.m_ap.getProp(269549635);
            this.title = (String)this.m_ap.getProp(0x110050);
            this.cstatus = (Integer)this.m_ap.getProp(2162758);
            return;
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
            return;
        }
    }

    public double getValue(int n, int n2) {
        Object object = null;
        if (this.m_items == null || this.prop_list == null) {
            return 1.0;
        }
        switch (this.ctype) {
            case 2: {
                if (n2 > this.m_items.length || n > this.prop_list.length) {
                    return 1.0;
                }
                try {
                    object = ((IAdminProp)this.m_items[n2]).getProp(this.prop_list[n]);
                    break;
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                    return 1.0;
                }
            }
            case 1: {
                if ((n > this.m_items.length || n2 > 1) && this.cstatus == 3) {
                    return 1.0;
                }
                if ((n > this.prop_list.length || n2 > 1) && this.cstatus == 1) {
                    return 1.0;
                }
                try {
                    if (this.cstatus == 3) {
                        object = ((IAdminProp)this.m_items[n]).getProp(this.prop_list[n2]);
                        break;
                    }
                    if (this.cstatus != 1) break;
                    object = ((IAdminProp)this.m_items[n2]).getProp(this.prop_list[n]);
                    break;
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                    return 1.0;
                }
            }
        }
        if (object == null) {
            return 1.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName() {
        if (this.title != null) return this.title;
        switch (this.cstatus) {
            case 1: {
                try {
                    return (String)this.m_ap.getProp(0x110001);
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                    return "Chart";
                }
            }
            default: {
                return "Chart";
            }
        }
    }

    public String getColumnVariableName() {
        return "";
    }

    public String getRowVariableName() {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRowLabel(int n) {
        if (this.legends == null) {
            if (this.m_items == null) return "Unnamed Row" + n;
            if (!(this.ctype == 1 & this.cstatus == 3)) return ((AdminProp)this.m_items[0]).getPropName(this.prop_list[n]);
            try {
                return (String)((AdminProp)this.m_items[n]).getProp(0x110001);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
                return "Unnamed Row" + n;
            }
        } else {
            if (n >= this.legends.length) return "Unnamed Row" + n;
            return this.legends[n];
        }
    }

    public String getColumnLabel(int n) {
        try {
            if (this.m_items != null) {
                return (String)((IAdminProp)this.m_items[n]).getProp(0x110001);
            }
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        return "Bad column";
    }

    public int getRowCount() {
        if (this.cstatus == 3 & this.ctype == 1) {
            return this.item_count;
        }
        if (this.cstatus == 1 & this.ctype == 1) {
            return this.prop_count;
        }
        return this.prop_count;
    }

    public int getColumnCount() {
        if (this.cstatus == 3 & this.ctype == 1) {
            return this.prop_count;
        }
        if (this.cstatus == 1 & this.ctype == 1) {
            return this.item_count;
        }
        return this.item_count;
    }

    public double getRangeLow() {
        if (this.ctype != 1) {
            return this.arr_range[0];
        }
        return 1.0;
    }

    public double getRangeHigh() {
        if (this.ctype != 1) {
            return this.arr_range[1];
        }
        return 1.0;
    }

    public void dataUpdate() {
    }

    public void addDataUpdateListener(DataUpdateListener dataUpdateListener) {
        this.listeners.addElement(dataUpdateListener);
    }

    public void removeDataUpdateListener(DataUpdateListener dataUpdateListener) {
        this.listeners.removeElement(dataUpdateListener);
    }

    Object[] getItems() {
        if (this.m_items == null) {
            try {
                this.m_items = (Object[])this.m_ap.getProp(272695365);
            }
            catch (PropertyException propertyException) {
                return null;
            }
        }
        return this.m_items;
    }

    void unexpectedException(Exception exception) {
        System.out.println("Unexpected Exception " + exception);
    }
}

