/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminSearchCriteria;
import oracle.ldap.admin.client.propEditors.CriteriaPanel;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;

public class CriteriaView
extends AdminSearchCriteria
implements IEditor,
AdminPropertyChangeListener {
    public static boolean DEBUG;
    IAdminProp m_ap;
    Object m_currValue;
    String m_defaultOp;

    public CriteriaView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        this.m_ap = iAdminProp;
        this.m_ap.addAdminPropertyChangeListener(this);
        this.init();
        this.updateEnable();
    }

    public String[] getAttributeNames(Object object) {
        if (object instanceof IAdminProp) {
            try {
                return (String[])((IAdminProp)object).getProp(270468175);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Object[] getAttributeTypes(Object object) {
        if (object instanceof IAdminProp) {
            try {
                return (Object[])((IAdminProp)object).getProp(276759696);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Object[] getAttributeOpList(Object object) {
        if (object instanceof IAdminProp) {
            try {
                return (Object[])((IAdminProp)object).getProp(276759697);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void init() {
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        try {
            stringArray = (String[])this.m_ap.getProp(270468192);
            stringArray2 = (String[])this.m_ap.getProp(270468175);
            string = (String)this.m_ap.getProp(2032737);
            string2 = (String)this.m_ap.getProp(2032740);
            objectArray = (Object[])this.m_ap.getProp(276759696);
            objectArray2 = (Object[])this.m_ap.getProp(276759697);
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
        if (string == null) {
            string = stringArray2[0];
        }
        this.m_defaultOp = string2 == null ? stringArray[0] : string2;
        this.initState(stringArray2, string, stringArray, string2, objectArray, objectArray2);
        try {
            Object object = this.m_ap.getProp(8324195);
            if (object != null) {
                this.setDataConstraint(object);
            }
            this.m_currValue = object;
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public void updateEnable() {
        try {
            Object object = this.m_ap.getProp(2686979);
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                if ((n & 2) == 0) {
                    this.setEnabled(false);
                    return;
                }
                this.setEnabled(true);
                return;
            }
        }
        catch (Exception exception) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (((Component)((Object)this)).getParent() != null) {
            ((Component)((Object)this)).getParent().setEnabled(bl);
        }
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            switch (adminPropertyChangeEvent.getPropId()) {
                case 2686979: {
                    this.updateEnable();
                    break;
                }
                case 2032737: 
                case 270468175: 
                case 270468192: {
                    this.init();
                    break;
                }
                case 8324195: {
                    try {
                        Object object = adminPropertyChangeEvent.getNewValue();
                        if (object == null) {
                            object = this.m_ap.getProp(8324195);
                        }
                        if (object == null) break;
                        this.setDataConstraint(object);
                        this.m_currValue = object;
                    }
                    catch (Exception exception) {
                        new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
                    }
                    break;
                }
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public void doCommand() {
        this.commit(1);
    }

    public void dataConstraintChanged() {
        if (DEBUG) {
            System.out.println("dataConstraintChanged");
        }
        AdminUtil.notifyState(2, (Component)((Object)this));
    }

    public void dataConstraintChanged(Object object) {
        if (DEBUG) {
            System.out.print("dataConstraintChanged dc = ");
            this.printDC(object);
            System.out.println();
        }
        if (DEBUG) {
            System.out.print("              curr value = ");
            this.printDC(this.m_currValue);
            System.out.println();
        }
        if (!this.compare(this.m_currValue, object)) {
            if (DEBUG) {
                System.out.println("              doesn't compare!");
            }
            AdminUtil.notifyState(2, (Component)((Object)this));
            return;
        }
        AdminUtil.notifyState(4, (Component)((Object)this));
    }

    public static Component createCriteriaView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        AdminPanel adminPanel = new AdminPanel();
        ((Container)((Object)adminPanel)).setLayout(new BorderLayout());
        CriteriaView criteriaView = new CriteriaView(iAdminProp, editorOwner);
        ((Container)((Object)adminPanel)).add("Center", (Component)((Object)criteriaView));
        return new CriteriaPanel((Component)((Object)adminPanel), criteriaView, iAdminProp);
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 8;
    }

    public void setupToolbar(int n) {
    }

    public void printDC(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            System.out.print("(");
            int n = 0;
            while (n < objectArray.length) {
                this.printDC(objectArray[n]);
                if (n + 1 != objectArray.length) {
                    System.out.print(" ");
                }
                ++n;
            }
            System.out.print(")");
            return;
        }
        System.out.print("'");
        System.out.print(object);
        System.out.print("'");
    }

    public boolean uninitConstraint(Object object) {
        Object[] objectArray;
        return object instanceof Object[] && (objectArray = (Object[])object).length == 3 && objectArray[1] instanceof String && objectArray[0].equals(this.m_defaultOp) && (objectArray[2] == null || objectArray[2].equals(""));
    }

    public boolean compare(Object object, Object object2) {
        if (object instanceof Object[] && object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            int n = 0;
            while (n < objectArray.length) {
                if (!this.compare(objectArray[n], objectArray2[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (object != null && object2 != null) {
            return object.equals(object2);
        }
        return object == object2;
    }

    public boolean isModified(StringBuffer stringBuffer) {
        Object object = this.getDataConstraint();
        if (this.uninitConstraint(object)) {
            object = null;
            if (DEBUG) {
                System.out.println("dc is uninitialized m_currValue=" + this.m_currValue);
            }
        }
        try {
            this.m_ap.setProp(8324195, object);
        }
        catch (Exception exception) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
        }
        if (DEBUG) {
            System.out.print("isModified dc = ");
            this.printDC(object);
            System.out.println();
        }
        if (DEBUG) {
            System.out.print("   curr value = ");
            this.printDC(this.m_currValue);
            System.out.println();
        }
        if (!this.compare(this.m_currValue, object)) {
            if (DEBUG) {
                System.out.println("   doesn't compare! Editor is modified.");
            }
            if (stringBuffer != null) {
                stringBuffer.append(ClientLang.getStrCriteriaModified());
            }
            return true;
        }
        return false;
    }

    public void revert() {
    }

    public boolean commit() {
        return this.commit(0);
    }

    public boolean commit(int n) {
        try {
            Object object = this.getDataConstraint();
            if (DEBUG) {
                System.out.print("CriteriaView.commit: ");
                this.printDC(object);
                System.out.println();
            }
            this.m_ap.setProp(8324195, object);
            this.m_ap.saveChanges(n);
            this.m_currValue = object;
        }
        catch (Exception exception) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
        }
        return true;
    }

    public void update() {
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public IAdminProp properties() {
        return null;
    }

    public void shutdown() {
        this.m_ap.removeAdminPropertyChangeListener(this);
    }
}

