/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Vector;
import oracle.ldap.admin.client.propEditors.GraphCanvas;
import oracle.ldap.admin.client.propEditors.GraphNode;
import oracle.ldap.admin.client.propEditors.NodeLabel;

class GraphLayout {
    GraphCanvas m_parent;
    int m_type;
    Vector m_nodes;

    public GraphLayout(GraphCanvas graphCanvas, int n) {
        this.m_parent = graphCanvas;
        this.m_nodes = this.m_parent.getNodes();
        this.m_type = n;
        this.doLayout();
    }

    public int getType() {
        return this.m_type;
    }

    public void doLayout() {
        Dimension dimension = ((Component)((Object)this.m_parent)).getSize();
        Insets insets = this.m_parent.getInsets();
        switch (this.m_type) {
            case 6: {
                if (this.m_nodes != null) {
                    Vector vector = this.m_parent.getTopLevelNodes();
                    if (vector == null) break;
                    this.doDirectedLayout(vector, 20, 20);
                    break;
                }
            }
            case 2: {
                Vector vector;
                if (this.m_nodes == null || (vector = this.m_parent.getTopLevelNodes()) == null) break;
                this.doOrgLayout(vector, 20, 75);
                break;
            }
            case 1: {
                if (this.m_nodes == null) break;
                this.doBoxLayout(75, 75);
                break;
            }
        }
        this.m_parent.resizeToPreferredSize();
    }

    public void doOrgLayout(Vector vector, int n, int n2) {
        int n3 = 0;
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            GraphNode graphNode = (GraphNode)vector.elementAt(n5);
            int n6 = graphNode.getTotalWidth();
            Dimension dimension = graphNode.getDimension();
            int n7 = n + n3 + (n6 - dimension.width) / 2;
            graphNode.setOrigin(n7, n2);
            Vector vector2 = graphNode.getChildNodes();
            this.doOrgLayout(vector2, n + n3, n2 + dimension.height + 40);
            n3 += n6;
            ++n5;
        }
    }

    public void doDirectedLayout(Vector vector, int n, int n2) {
        int n3 = vector.size();
        int n4 = 2;
        int n5 = 1;
        int n6 = 20;
        int n7 = n;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n3) {
            GraphNode graphNode = (GraphNode)vector.elementAt(n10);
            NodeLabel nodeLabel = graphNode.getLabel();
            Dimension dimension = nodeLabel == null ? new Dimension(0, 0) : nodeLabel.getDimension();
            Integer n11 = (Integer)graphNode.getProp(2098309);
            int n12 = 1;
            if (n11 != null) {
                n12 = n11;
            }
            String string = "";
            if ((n12 & 2) != 0) {
                string = String.valueOf(string) + "\\n";
                n2 += n9 + n4;
                n9 = 0;
                n = n7;
            }
            if (n9 < dimension.height) {
                n9 = dimension.height;
            }
            if ((n12 & 8) != 0) {
                string = String.valueOf(string) + "<";
                n += n6 * ++n8;
            }
            if ((n12 & 0x10) != 0) {
                string = String.valueOf(string) + ">";
                n -= n6 * --n8;
            }
            if ((n12 & 0x40) != 0) {
                string = String.valueOf(string) + "{";
                if (n8 != 0) {
                    n -= n6;
                }
            }
            if ((n12 & 0x80) != 0) {
                string = String.valueOf(string) + "}";
                if (n8 != 0) {
                    n -= n6;
                }
            }
            if ((n12 & 0x200) != 0) {
                string = String.valueOf(string) + "<>";
                if (n8 != 0) {
                    n -= n6;
                }
            }
            if ((n12 & 0x20) != 0) {
                string = String.valueOf(string) + "(\\n>)";
            }
            if ((n12 & 4) != 0) {
                string = String.valueOf(string) + "(+\\n)";
            }
            graphNode.setOrigin(n, n2);
            graphNode.getOrigin();
            if ((n12 & 0x20) != 0) {
                n2 += n9 + n4;
                n9 = 0;
                n = n7 + n6 * ++n8;
            } else if ((n12 & 0x40) != 0) {
                if (n8 == 0) {
                    n8 = 1;
                }
                n2 += n9 + n4;
                n9 = 0;
                n = n7 + n6 * n8;
            } else if ((n12 & 0x80) != 0) {
                if (n8 != 0) {
                    --n8;
                }
                n2 += n9 + n4;
                n9 = 0;
                n = n7 + n6 * n8;
            } else if ((n12 & 4) != 0) {
                n2 += n9 + n4;
                n9 = 0;
                n = n7 + n6 * n8;
            } else {
                n += dimension.width + n5;
            }
            ++n10;
        }
    }

    public void doBoxLayout(int n, int n2) {
        int n3 = this.m_nodes.size();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n6);
            Dimension dimension = graphNode.getDimension();
            if (n4 < dimension.width) {
                n4 = dimension.width;
            }
            if (n5 < dimension.height) {
                n5 = dimension.height;
            }
            ++n6;
        }
        int n7 = 20;
        int n8 = 20;
        int n9 = (int)Math.sqrt(n3 * (n5 += n8) / (n4 += n7));
        int n10 = n;
        int n11 = n2;
        int n12 = 0;
        while (n12 < n3) {
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n12);
            graphNode.setOrigin(n10, n11);
            if (n9 == 0 || n12 % n9 == 0) {
                n10 = n;
                n11 += n5;
            } else {
                n10 += n4;
            }
            ++n12;
        }
    }
}

