/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.util.Hashtable;
import oracle.ldap.admin.client.common.AdminButton;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;

class GridBagConst
extends AdminProp {
    static final int PR_TYPE = 1454080;
    static final int PR_ANCHOR = 2109441;
    static final int PR_FILL = 0x203002;
    static final int PR_GX = 0x203003;
    static final int PR_GY = 2109444;
    static final int PR_WX = 0x503005;
    static final int PR_WY = 5255174;
    static final int PR_GH = 2109447;
    static final int PR_GHSIZE = 2109448;
    static final int PR_GW = 2109449;
    static final int PR_GWSIZE = 2109456;
    static final int PR_IX = 2109457;
    static final int PR_IY = 2109458;
    static final int PR_INL = 2109459;
    static final int PR_INR = 2109460;
    static final int PR_INT = 2109461;
    static final int PR_INB = 2109462;
    static final int PR_DESC = 11546647;
    GridBagConstraints m_gbc;
    String m_displayName;
    Component m_c;
    static Hashtable anchors = new Hashtable();
    static Hashtable fills;
    static Hashtable sizes;

    public Component getComponent() {
        return this.m_c;
    }

    public GridBagConstraints getConstraints() {
        return this.m_gbc;
    }

    public GridBagConst() {
    }

    public GridBagConst(GridBagConstraints gridBagConstraints, Component component, GridView gridView) {
        this.m_gbc = (GridBagConstraints)gridBagConstraints.clone();
        try {
            if (component instanceof AdminLabel) {
                this.m_displayName = "L'" + ((AdminLabel)((Object)component)).getText() + "'";
            } else if (component instanceof AdminButton) {
                this.m_displayName = "B'" + ((AdminButton)((Object)component)).getLabel() + "'";
            } else if (component instanceof GridViewItem) {
                GridViewItem gridViewItem = (GridViewItem)((Object)component);
                this.m_displayName = ((IAdminProp)gridView.getObject()).getPropName(gridViewItem.getPropId());
            } else {
                this.m_displayName = component.getClass().getName();
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
        this.m_c = component;
    }

    public GridBagConst(GridBagConstraints gridBagConstraints, String string) {
        this.m_gbc = gridBagConstraints;
        if (gridBagConstraints == null) {
            this.m_gbc = new GridBagConstraints();
        }
        this.m_displayName = string;
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(0x100001, "Name", "");
        this.registerProp(0x100001, "Type", "");
        this.registerProp(2109441, "Anchor", "This field is used when the component is smaller than its display area.");
        this.registerPropTranslations(2109441, anchors);
        this.registerProp(0x203002, "Fill", "This field is used when the component's display area is larger than the component's requested size.");
        this.registerPropTranslations(0x203002, fills);
        this.registerProp(0x203003, "Grid X", "");
        this.registerProp(2109444, "Grid Y", "");
        this.registerProp(2109447, "Grid Height", "");
        this.registerProp(2109448, "Height", "");
        this.registerPropTranslations(2109448, sizes);
        this.registerProp(2109449, "Grid Width", "");
        this.registerProp(2109456, "Width", "");
        this.registerPropTranslations(2109456, sizes);
        this.registerProp(0x503005, "Weight X", "");
        this.registerProp(5255174, "Weight Y", "");
        this.registerProp(2109457, "Pad X", "");
        this.registerProp(2109458, "Pad Y", "");
        this.registerProp(2109459, "Inset Left", "");
        this.registerProp(2109460, "Inset Right", "");
        this.registerProp(2109461, "Inset Top", "");
        this.registerProp(2109462, "Inset Bottom", "");
        this.registerProp(11546647, "AWT Size", "");
    }

    public Object getProp(int n) throws PropertyException {
        switch (n) {
            case 0x100001: 
            case 0x110001: {
                return this.m_displayName;
            }
            case 1454080: {
                if (this.m_c != null) {
                    String string = this.m_c.getClass().getName();
                    int n2 = string.lastIndexOf(46);
                    if (n2 < 0) {
                        return string;
                    }
                    return string.substring(n2 + 1);
                }
                return "";
            }
            case 2109441: {
                return new Integer(this.m_gbc.anchor);
            }
            case 0x203002: {
                return new Integer(this.m_gbc.fill);
            }
            case 0x203003: {
                return new Integer(this.m_gbc.gridx);
            }
            case 2109444: {
                return new Integer(this.m_gbc.gridy);
            }
            case 2109447: 
            case 2109448: {
                return new Integer(this.m_gbc.gridheight);
            }
            case 2109449: 
            case 2109456: {
                return new Integer(this.m_gbc.gridwidth);
            }
            case 0x503005: {
                return new Double(this.m_gbc.weightx);
            }
            case 5255174: {
                return new Double(this.m_gbc.weighty);
            }
            case 2109457: {
                return new Integer(this.m_gbc.ipadx);
            }
            case 2109458: {
                return new Integer(this.m_gbc.ipady);
            }
            case 2109459: {
                return new Integer(this.m_gbc.insets.left);
            }
            case 2109460: {
                return new Integer(this.m_gbc.insets.right);
            }
            case 2109461: {
                return new Integer(this.m_gbc.insets.top);
            }
            case 2109462: {
                return new Integer(this.m_gbc.insets.bottom);
            }
            case 11546647: {
                String string = "Bounds( " + this.m_c.getBounds().toString() + ")\n" + "PreferredSize( " + this.m_c.getPreferredSize().toString() + ")";
                Container container = this.m_c.getParent();
                while (container != null) {
                    string = String.valueOf(string) + "\n" + container.getClass().getName();
                    container = container.getParent();
                }
                return string;
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 2109441: {
                this.m_gbc.anchor = (Integer)object;
                return;
            }
            case 0x203002: {
                this.m_gbc.fill = (Integer)object;
                return;
            }
            case 0x203003: {
                this.m_gbc.gridx = (Integer)object;
                return;
            }
            case 2109444: {
                this.m_gbc.gridy = (Integer)object;
                return;
            }
            case 2109447: {
                this.m_gbc.gridheight = (Integer)object;
                return;
            }
            case 2109448: {
                switch ((Integer)object) {
                    case -1: 
                    case 0: {
                        this.m_gbc.gridheight = (Integer)object;
                        return;
                    }
                }
                switch (this.m_gbc.gridheight) {
                    case -1: 
                    case 0: {
                        this.m_gbc.gridheight = 1;
                    }
                }
                return;
            }
            case 2109449: {
                this.m_gbc.gridwidth = (Integer)object;
                return;
            }
            case 2109456: {
                switch ((Integer)object) {
                    case -1: 
                    case 0: {
                        this.m_gbc.gridwidth = (Integer)object;
                        return;
                    }
                }
                switch (this.m_gbc.gridwidth) {
                    case -1: 
                    case 0: {
                        this.m_gbc.gridwidth = 1;
                    }
                }
                return;
            }
            case 0x503005: {
                this.m_gbc.weightx = (Double)object;
                return;
            }
            case 5255174: {
                this.m_gbc.weighty = (Double)object;
                return;
            }
            case 2109457: {
                this.m_gbc.ipadx = (Integer)object;
                return;
            }
            case 2109458: {
                this.m_gbc.ipady = (Integer)object;
                return;
            }
            case 2109459: {
                this.m_gbc.insets.left = (Integer)object;
                return;
            }
            case 2109460: {
                this.m_gbc.insets.right = (Integer)object;
                return;
            }
            case 2109461: {
                this.m_gbc.insets.top = (Integer)object;
                return;
            }
            case 2109462: {
                this.m_gbc.insets.bottom = (Integer)object;
                return;
            }
        }
        super.setProp(n, object);
    }

    public void saveChanges(int n) throws SaveChangeException {
    }

    static void hashput(Hashtable hashtable, Object object, String string) {
        hashtable.put(object, string);
    }

    static {
        GridBagConst.hashput(anchors, new Integer(11), "NORTH");
        GridBagConst.hashput(anchors, new Integer(12), "NORTHEAST");
        GridBagConst.hashput(anchors, new Integer(13), "EAST");
        GridBagConst.hashput(anchors, new Integer(14), "SOUTHEAST");
        GridBagConst.hashput(anchors, new Integer(15), "SOUTH");
        GridBagConst.hashput(anchors, new Integer(16), "SOUTHWEST");
        GridBagConst.hashput(anchors, new Integer(17), "WEST");
        GridBagConst.hashput(anchors, new Integer(18), "NORTHWEST");
        fills = new Hashtable();
        GridBagConst.hashput(fills, new Integer(0), "NONE");
        GridBagConst.hashput(fills, new Integer(2), "HORIZONTAL");
        GridBagConst.hashput(fills, new Integer(3), "VERTICAL");
        GridBagConst.hashput(fills, new Integer(1), "BOTH");
        sizes = new Hashtable();
        GridBagConst.hashput(sizes, new Integer(1), "One");
        GridBagConst.hashput(sizes, new Integer(2), "Two");
        GridBagConst.hashput(sizes, new Integer(3), "Three");
        GridBagConst.hashput(sizes, new Integer(4), "Four");
        GridBagConst.hashput(sizes, new Integer(0), "REMAINDER");
        GridBagConst.hashput(sizes, new Integer(-1), "RELATIVE");
    }
}

