/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.common.AdminBorderPanel;
import oracle.ldap.admin.client.common.AdminScrollPane;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class GridPanelView
extends AdminBorderPanel
implements AdminPropertyChangeListener,
IEditor {
    IAdminProp m_ap;
    IAdminProp[] m_objList;
    EditorOwner m_owner;

    public GridPanelView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        this.m_ap = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
        this.init(editorOwner);
    }

    public static Component createGridPanelView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        Object object = new GridPanelView(iAdminProp, editorOwner);
        try {
            Integer n = (Integer)iAdminProp.getProp(2098294);
            if (n != null && (n & 1) != 0) {
                object = new AdminScrollPane((Component)object);
            }
        }
        catch (PropertyException propertyException) {}
        return object;
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            switch (adminPropertyChangeEvent.getPropId()) {
                case 272630352: {
                    if (adminPropertyChangeEvent.getSource() != this.m_ap) break;
                    this.removeAll();
                    this.shutdown(false);
                    this.init(this.m_owner);
                    AdminUtil.fixup((Component)((Object)this));
                    break;
                }
                case 282001422: {
                    AdminUtil.fixup((Component)((Object)this));
                    break;
                }
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    void init(EditorOwner editorOwner) {
        Object object;
        GridBagConstraints[] gridBagConstraintsArray;
        this.m_owner = editorOwner;
        try {
            this.m_objList = (IAdminProp[])this.m_ap.getProp(272630352);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get object list " + propertyException);
            return;
        }
        try {
            gridBagConstraintsArray = (GridBagConstraints[])this.m_ap.getProp(1639543);
            if (gridBagConstraintsArray != null) {
                this.setGroupBoxBorder((String)gridBagConstraintsArray, 0);
            }
        }
        catch (PropertyException propertyException) {}
        if (this.m_objList == null) {
            this.debugMessageLn("No property list!!");
            return;
        }
        gridBagConstraintsArray = null;
        try {
            gridBagConstraintsArray = (GridBagConstraints[])this.m_ap.getProp(275776081);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get property list " + propertyException);
        }
        if (gridBagConstraintsArray != null && gridBagConstraintsArray.length < this.m_objList.length) {
            gridBagConstraintsArray = null;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        ((Container)((Object)this)).setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = null;
        if (gridBagConstraintsArray == null) {
            gridBagConstraints = new GridBagConstraints();
        }
        boolean bl = true;
        try {
            Integer n = (Integer)this.m_ap.getProp(0x200252);
            if (n != null) {
                bl = n == 2;
            }
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        int n = 0;
        while (n < this.m_objList.length) {
            if (gridBagConstraintsArray == null) {
                if (bl) {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.insets.top = n == 0 ? 5 : 0;
                    gridBagConstraints.insets.left = 5;
                    gridBagConstraints.insets.right = 5;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.anchor = 12;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.weightx = 1.0;
                    if (n == this.m_objList.length - 1) {
                        gridBagConstraints.insets.bottom = 5;
                        gridBagConstraints.weighty = 1.0;
                        gridBagConstraints.gridheight = 0;
                        gridBagConstraints.fill = 1;
                    }
                } else {
                    gridBagConstraints.gridx = n;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.insets.left = n == 0 ? 5 : 0;
                    gridBagConstraints.insets.bottom = 5;
                    gridBagConstraints.insets.top = 5;
                    gridBagConstraints.fill = 3;
                    gridBagConstraints.anchor = 12;
                    gridBagConstraints.gridheight = 0;
                    gridBagConstraints.weighty = 1.0;
                    if (n == this.m_objList.length - 1) {
                        gridBagConstraints.insets.right = 5;
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.gridwidth = 0;
                        gridBagConstraints.fill = 1;
                    }
                }
            } else {
                gridBagConstraints = gridBagConstraintsArray[n];
            }
            if ((object = EditorFactory.getEditor(this.m_objList[n], editorOwner)) != null) {
                gridBagLayout.setConstraints((Component)object, gridBagConstraints);
                ((Container)((Object)this)).add((Component)object);
                this.m_objList[n].addAdminPropertyChangeListener(this);
            }
            ++n;
        }
        try {
            object = (String)this.m_ap.getProp(1638690);
            if (object != null) {
                this.setGroupBoxBorder((String)object, 2);
                return;
            }
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
    }

    void debugMessageLn(String string) {
        System.out.println(string);
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2 = super.getPreferredSize();
        Container container = ((Component)((Object)this)).getParent();
        if (dimension2 != null && container != null && (dimension = container.getSize()) != null && dimension2.width < dimension.width) {
            dimension2.width = dimension.width;
        }
        return dimension2;
    }

    public boolean displayObject(Object object) {
        if (this.getObject() == object) {
            return true;
        }
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (iEditor.displayObject(object)) {
                        return true;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return false;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 32768;
    }

    public void setupToolbar(int n) {
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n2]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.setupToolbar(n);
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n2;
        }
    }

    public boolean isModified(StringBuffer stringBuffer) {
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (iEditor.isModified(stringBuffer)) {
                        return true;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return false;
    }

    public void revert() {
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.revert();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
    }

    public boolean commit() {
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        boolean bl = true;
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (!iEditor.commit()) {
                        bl = false;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return bl;
    }

    public void update() {
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.update();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
    }

    public IAdminProp[] getCommandList() {
        IAdminProp[] iAdminPropArray = null;
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iAdminPropArray = AdminUtil.mergeCmdList(iAdminPropArray, iEditor.getCommandList());
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return iAdminPropArray;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean bl) {
        if (bl) {
            AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
        }
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.shutdown();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        this.shutdownObjList();
    }

    public void shutdownObjList() {
        if (this.m_objList == null) {
            return;
        }
        int n = 0;
        while (n < this.m_objList.length) {
            AdminUtil.removeAdminPropertyChangeListener(this.m_objList[n], this);
            ++n;
        }
    }

    public IAdminProp properties() {
        return null;
    }
}

