/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Dimension;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GridViewLabel
extends AdminLabel
implements GridViewItem {
    GridView m_parent;
    IAdminProp m_ap;
    Object m_initValue;
    Object m_rollbackValue;
    int m_propId;
    int m_extraSize;
    boolean useMinSizing = true;

    public GridViewLabel(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, String string) {
        this(gridView, iAdminProp, n, bl, string, string.trim().length() > 0 ? ":" : "");
    }

    public GridViewLabel(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, String string, String string2) {
        super(String.valueOf(string) + string2, 2);
        this.m_parent = gridView;
        this.m_ap = iAdminProp;
        this.m_propId = n;
        if (string == null) {
            string = "<nolabel>";
        }
        this.m_initValue = string;
    }

    public int getPropId() {
        return this.m_propId;
    }

    public Object getItemValue() {
        return this.getText();
    }

    public Object getInitValue() {
        return this.m_initValue;
    }

    public void setInitValue(Object object) {
        this.m_initValue = object;
    }

    public boolean setObject(Object object) {
        this.m_ap = (IAdminProp)object;
        this.update();
        return true;
    }

    public void setItemValue(Object object) {
        this.setText((String)object);
    }

    public void setExtraSize(int n) {
        this.m_extraSize = n;
    }

    public void shutdown() {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        Object object = this.m_initValue;
        if (this.m_parent.isSyncProp(this.m_propId)) {
            object = this.m_rollbackValue;
        }
        if (object == null) {
            return !"<nolabel>".equals(this.getItemValue());
        }
        return !object.equals(this.getItemValue());
    }

    public void revert() {
        this.setText(this.m_initValue.toString());
    }

    public void update() {
        try {
            this.m_initValue = this.m_ap.getProp(this.getPropId());
            this.revert();
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public void commit() {
        this.m_initValue = this.getItemValue();
    }

    public void disableMinSizing() {
        this.useMinSizing = false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.useMinSizing && dimension.width < 100) {
            dimension.width = 100;
        }
        dimension.width += this.m_extraSize;
        return dimension;
    }
}

