/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.ewt.lwAWT.lwText.NumberTextField;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.common.AdminNumberTextField;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GridViewNumTextField
extends AdminNumberTextField
implements GridViewItem,
ActionListener,
FocusListener {
    boolean m_saveOnFocusLost = false;
    Object m_initValue;
    Object m_rollbackValue;
    GridView m_parent;
    IAdminProp m_ap;
    int m_propId;

    public GridViewNumTextField(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, Object object) {
        this.setDataType(this.getItemType());
        int n2 = gridView.getPropWidth(n, 0);
        if (n2 > 0) {
            this.setColumns(n2);
        }
        this.m_parent = gridView;
        this.m_ap = iAdminProp;
        this.m_propId = n;
        this.addActionListener(this);
        this.setEditable(!bl);
        if (object != null) {
            this.setNumber((Number)object);
        }
        this.m_rollbackValue = this.m_initValue = object;
        if (this.m_parent.isSyncProp(n)) {
            this.m_saveOnFocusLost = true;
        }
        ((Component)((Object)this)).addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (GridView.DEBUG) {
            System.out.println("Checking to see if saving textfield because focus is lost");
        }
        if (this.m_saveOnFocusLost && this.isModified(null)) {
            try {
                int[] nArray = new int[1];
                Object[] objectArray = new Object[1];
                nArray[0] = this.m_propId;
                objectArray[0] = this.getItemValue();
                this.m_parent.setModified(this.m_propId);
                this.m_ap.setProps(nArray, objectArray);
                return;
            }
            catch (PropertyException propertyException) {
                new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent)), propertyException);
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.m_parent.actionPerformed(null);
    }

    public int getPropId() {
        return this.m_propId;
    }

    public boolean setObject(Object object) {
        this.m_ap = (IAdminProp)object;
        this.update();
        return true;
    }

    public Object getInitValue() {
        return this.m_initValue;
    }

    public void setInitValue(Object object) {
        this.m_initValue = object;
    }

    public Object getItemValue() {
        return this.getNumber();
    }

    public void setItemValue(Object object) {
        this.setNumber((Number)object);
        this.focusLost(null);
    }

    public void shutdown() {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        if (this.isModified2(stringBuffer)) {
            if (GridView.DEBUG) {
                System.out.println("isModified old='" + this.m_initValue + "' new='" + this.getItemValue() + "'");
                if (this.m_initValue != null && this.getItemValue() != null) {
                    System.out.println("isModified old='" + this.m_initValue.getClass().getName() + "' new='" + this.getItemValue().getClass().getName() + "'");
                }
            }
            return true;
        }
        return false;
    }

    public boolean isModified2(StringBuffer stringBuffer) {
        Object object = this.m_initValue;
        if (this.m_parent.isSyncProp(this.m_propId)) {
            object = this.m_rollbackValue;
        }
        if (object == this.getItemValue()) {
            return false;
        }
        if (object != null && this.getItemValue() == null) {
            return true;
        }
        if (object == null) {
            return !this.getDefaultValue().equals(this.getItemValue());
        }
        return !object.equals(this.getItemValue());
    }

    public void revert() {
        if (this.m_initValue != null) {
            this.setNumber((Number)this.m_initValue);
            return;
        }
        this.setNumber(this.getDefaultValue());
    }

    public void update() {
        try {
            this.m_initValue = this.m_ap.getProp(this.getPropId());
            this.revert();
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public void commit() {
        this.m_rollbackValue = this.m_initValue = this.getItemValue();
    }

    public Class getItemType() {
        if (NumberTextField.class$java$lang$Integer != null) {
            return NumberTextField.class$java$lang$Integer;
        }
        NumberTextField.class$java$lang$Integer = GridViewNumTextField.class$("java.lang.Integer");
        return NumberTextField.class$java$lang$Integer;
    }

    public Number getDefaultValue() {
        return new Integer(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

