/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.common.AdminButton;
import oracle.ldap.admin.client.common.AdminCheckboxGroup;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.common.AdminMultiLineLabel;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminTextField;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewAdminProp;
import oracle.ldap.admin.client.propEditors.GridViewAdminPropLOV;
import oracle.ldap.admin.client.propEditors.GridViewArrAdminProp;
import oracle.ldap.admin.client.propEditors.GridViewArrBoolean;
import oracle.ldap.admin.client.propEditors.GridViewArrDate;
import oracle.ldap.admin.client.propEditors.GridViewArrInteger;
import oracle.ldap.admin.client.propEditors.GridViewArrJavaBean;
import oracle.ldap.admin.client.propEditors.GridViewArrObject;
import oracle.ldap.admin.client.propEditors.GridViewArrString;
import oracle.ldap.admin.client.propEditors.GridViewArrTime;
import oracle.ldap.admin.client.propEditors.GridViewBoolean;
import oracle.ldap.admin.client.propEditors.GridViewDate;
import oracle.ldap.admin.client.propEditors.GridViewDateLOV;
import oracle.ldap.admin.client.propEditors.GridViewDouble;
import oracle.ldap.admin.client.propEditors.GridViewDoubleLOV;
import oracle.ldap.admin.client.propEditors.GridViewInteger;
import oracle.ldap.admin.client.propEditors.GridViewIntegerLOV;
import oracle.ldap.admin.client.propEditors.GridViewIntegerRange;
import oracle.ldap.admin.client.propEditors.GridViewIntegerRangeBoolean;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.client.propEditors.GridViewJavaBean;
import oracle.ldap.admin.client.propEditors.GridViewJavaBeanLOV;
import oracle.ldap.admin.client.propEditors.GridViewLabel;
import oracle.ldap.admin.client.propEditors.GridViewListLOVButton;
import oracle.ldap.admin.client.propEditors.GridViewLong;
import oracle.ldap.admin.client.propEditors.GridViewLongLOV;
import oracle.ldap.admin.client.propEditors.GridViewObject;
import oracle.ldap.admin.client.propEditors.GridViewObjectLOV;
import oracle.ldap.admin.client.propEditors.GridViewPassword;
import oracle.ldap.admin.client.propEditors.GridViewRadio;
import oracle.ldap.admin.client.propEditors.GridViewString;
import oracle.ldap.admin.client.propEditors.GridViewStringLOV;
import oracle.ldap.admin.client.propEditors.GridViewText;
import oracle.ldap.admin.client.propEditors.GridViewTimeLOV;
import oracle.ldap.admin.client.propEditors.ISetupToolbar;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.AdminSort;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.common.SaveChangeException;
import oracle.ldap.admin.common.Util;

class GridViewPanel
extends AdminPanel
implements AdminPropertyChangeListener {
    static final int LOV_SIZE_LIMIT_ON_UNIX = 20;
    IAdminProp m_ap;
    int m_rows;
    GridView m_parent;
    GridBagConstraints[] m_gbcList;
    String[] m_units;
    Object[] m_lov;
    int[] m_propList;
    String m_groupTitle;
    String[] m_names;
    int[] m_length;
    int[] m_width;
    int[] m_height;
    String[] m_colNames;
    String[] m_rowNames;
    Integer m_skipRows;
    int[] m_disabledProps;
    int[] m_propsWithHiddenLabel;
    int[] m_syncProps;
    int[] m_hidden;
    int[] m_groupTitleProps;
    Component m_groupBoxTitle;
    Vector m_gridViews = new Vector();
    boolean m_blockUpdate = false;

    public GridViewPanel(IAdminProp iAdminProp, GridView gridView) {
        this.m_ap = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
        this.m_parent = gridView;
        gridView.m_panel = this;
        try {
            this.init(gridView);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Insets insets = null;
        try {
            Object object = this.m_ap.getProp(7930270);
            if (object instanceof Insets) {
                insets = (Insets)object;
            } else {
                int[] nArray = new int[]{2163836, 2163838, 2163837, 2163839};
                Object[] objectArray = this.m_ap.getProps(nArray);
                if (objectArray != null && objectArray.length == 4) {
                    int n = 0;
                    while (n < objectArray.length) {
                        if (objectArray[n] != null) {
                            if (insets == null) {
                                insets = new Insets(0, 0, 0, 0);
                            }
                            int n2 = (Integer)objectArray[n];
                            switch (n) {
                                case 0: {
                                    insets.left = n2;
                                    break;
                                }
                                case 1: {
                                    insets.right = n2;
                                    break;
                                }
                                case 2: {
                                    insets.top = n2;
                                    break;
                                }
                                case 3: {
                                    insets.bottom = n2;
                                    break;
                                }
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        catch (PropertyException propertyException) {}
        if (insets != null && (insets.top != 0 || insets.left != 0 || insets.right != 0 || insets.bottom != 0)) {
            this.setInsets(insets.top, insets.left, insets.right, insets.bottom);
        }
    }

    public void initFocus() {
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        if (componentArray == null) {
            return;
        }
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof AdminTextField) {
                componentArray[n].requestFocus();
                return;
            }
            ++n;
        }
    }

    public int getPropHeight(int n) {
        if (this.m_height != null && this.m_propList != null) {
            int n2 = 0;
            while (n2 < this.m_propList.length) {
                if (this.m_propList[n2] == n) {
                    return this.m_height[n2];
                }
                ++n2;
            }
        }
        if (AdminProp.isPropArray(n) || AdminProp.getPropType(n) == 0x700000 || AdminProp.getPropType(n) == 0x400000 || AdminProp.getPropType(n) == 0xB00000) {
            return 4;
        }
        return 1;
    }

    public int getPropWidth(int n) {
        if (this.m_width == null || this.m_propList == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.m_propList.length) {
            if (this.m_propList[n2] == n) {
                return this.m_width[n2];
            }
            ++n2;
        }
        return -1;
    }

    public int getPropLength(int n) {
        if (this.m_length == null || this.m_propList == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.m_propList.length) {
            if (this.m_propList[n2] == n) {
                return this.m_length[n2];
            }
            ++n2;
        }
        return -1;
    }

    public int getRowCount() {
        return this.m_rows;
    }

    public void shutdown() {
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            ((GridViewItem)this.m_gridViews.elementAt(n2)).shutdown();
            ++n2;
        }
    }

    public void setupToolbar(int n) {
        int n2 = this.m_gridViews.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = this.m_gridViews.elementAt(n3);
            if (e instanceof ISetupToolbar) {
                ((ISetupToolbar)e).setupToolbar(n);
            }
            ++n3;
        }
    }

    public void commitProp(int n) throws Exception {
        int n2 = this.m_gridViews.size();
        int n3 = 0;
        while (n3 < n2) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n3);
            if (gridViewItem.getPropId() == n) {
                if (GridView.DEBUG) {
                    System.out.println("commitProp('" + this.m_ap.getPropName(n) + "', '" + gridViewItem.getItemValue() + "')");
                }
                this.m_ap.setProp(n, gridViewItem.getItemValue());
            }
            ++n3;
        }
    }

    public void rebuild() {
        this.removeAll();
        this.m_gridViews.removeAllElements();
        this.m_parent.resetLinkFieldAndLabel();
        try {
            this.init(this.m_parent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        AdminUtil.fixup((Component)((Object)this.m_parent));
    }

    public boolean cmpIntArray(int[] nArray, int[] nArray2) {
        if (nArray == null != (nArray2 == null)) {
            if (GridView.DEBUG) {
                System.out.println("arr1=" + nArray + " != arr2=" + nArray2);
            }
            return false;
        }
        if (nArray == nArray2) {
            return true;
        }
        if (nArray.length != nArray2.length) {
            if (GridView.DEBUG) {
                System.out.println("length1=" + nArray.length + " != length2=" + nArray2.length);
            }
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                if (GridView.DEBUG) {
                    System.out.println("i = " + n + " val1=" + nArray[n] + " != val2=" + nArray2[n]);
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object[] sortEnumeration(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        try {
            AdminSort.qsort(vector, true);
        }
        catch (Exception exception) {
            return null;
        }
        return AdminProp.vectorToObjectArray(vector);
    }

    public boolean cmpObject(Object object, Object object2, boolean bl) {
        if (object == null != (object2 == null)) {
            return false;
        }
        if (object == object2) {
            return true;
        }
        if (!bl) {
            if (object instanceof Hashtable) {
                Hashtable hashtable = (Hashtable)object;
                Hashtable hashtable2 = (Hashtable)object2;
                Object[] objectArray = this.sortEnumeration(hashtable.keys());
                if (this.cmpObjectArray(objectArray, this.sortEnumeration(hashtable2.keys()), false)) {
                    if (objectArray != null) {
                        int n = 0;
                        while (n < objectArray.length) {
                            Object v;
                            Object v2 = hashtable.get(objectArray[n]);
                            if (!this.cmpObject(v2, v = hashtable2.get(objectArray[n]), false)) {
                                if (GridView.DEBUG) {
                                    System.out.println("hashtable key = " + objectArray[n] + " val1=" + v2 + " val2=" + v);
                                }
                                return false;
                            }
                            ++n;
                        }
                    }
                    return true;
                }
                return false;
            }
            if (object instanceof int[]) {
                return this.cmpIntArray((int[])object, (int[])object2);
            }
            if (object instanceof Object[]) {
                return this.cmpObjectArray((Object[])object, (Object[])object2, false);
            }
        }
        return object.equals(object2);
    }

    public boolean cmpObjectArray(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null != (objectArray2 == null)) {
            if (GridView.DEBUG) {
                System.out.println("arr1=" + objectArray + " != arr2=" + objectArray2);
            }
            return false;
        }
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray.length != objectArray2.length) {
            if (GridView.DEBUG) {
                System.out.println("length1=" + objectArray.length + " != length2=" + objectArray2.length);
            }
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!this.cmpObject(objectArray[n], objectArray2[n], bl)) {
                if (GridView.DEBUG) {
                    System.out.println("i = " + n + " val1=" + objectArray[n] + " val2=" + objectArray2[n]);
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean cmpObjectArray(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray == null != (nArray2 == null)) {
            if (GridView.DEBUG) {
                System.out.println("arr1=" + nArray + " != arr2=" + nArray2);
            }
            return false;
        }
        if (nArray == nArray2) {
            return true;
        }
        if (nArray.length != nArray2.length) {
            if (GridView.DEBUG) {
                System.out.println("length1=" + nArray.length + " != length2=" + nArray2.length);
            }
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                if (GridView.DEBUG) {
                    System.out.println("i = " + n + " val1=" + nArray[n] + " val2=" + nArray2[n]);
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean setObject(Object object) {
        Object object2;
        IAdminProp iAdminProp = (IAdminProp)object;
        if (this.m_ap == iAdminProp) {
            return true;
        }
        try {
            int[] nArray = (int[])iAdminProp.getProp(282001422);
            if (!this.cmpIntArray(nArray, this.m_propList)) {
                if (GridView.DEBUG) {
                    System.out.println("props are different");
                }
                return false;
            }
            Object[] objectArray = iAdminProp.getPropNames(this.m_propList);
            if (!this.cmpObjectArray(objectArray, this.m_names, true)) {
                if (GridView.DEBUG) {
                    System.out.println("names are different");
                }
                return false;
            }
            object2 = (GridBagConstraints[])iAdminProp.getProp(275841152);
            if (!this.cmpObjectArray((Object[])object2, this.m_gbcList, true)) {
                if (GridView.DEBUG) {
                    System.out.println("gbc are different");
                }
                return false;
            }
            Object[] objectArray2 = (String[])iAdminProp.getProp(270467219);
            if (!this.cmpObjectArray(objectArray2, this.m_units, true)) {
                if (GridView.DEBUG) {
                    System.out.println("units are different");
                }
                return false;
            }
            Integer n = (Integer)iAdminProp.getProp(2687525);
            if (!this.cmpObject(n, this.m_skipRows, true)) {
                if (GridView.DEBUG) {
                    System.out.println("Amount to skip rows are different");
                }
                return false;
            }
            Object[] objectArray3 = (String[])iAdminProp.getProp(270074403);
            if (!this.cmpObjectArray(objectArray3, this.m_colNames, true)) {
                if (GridView.DEBUG) {
                    System.out.println("Column names are different");
                }
                return false;
            }
            Object[] objectArray4 = (String[])iAdminProp.getProp(270074404);
            if (!this.cmpObjectArray(objectArray4, this.m_rowNames, true)) {
                if (GridView.DEBUG) {
                    System.out.println("Row names are different");
                }
                return false;
            }
            int[] nArray2 = (int[])iAdminProp.getProp(282001952);
            if (!this.cmpObjectArray(nArray2, this.m_length, true)) {
                if (GridView.DEBUG) {
                    System.out.println("lengths are different");
                }
                return false;
            }
            int[] nArray3 = (int[])iAdminProp.getProp(282001953);
            if (!this.cmpObjectArray(nArray3, this.m_width, true)) {
                if (GridView.DEBUG) {
                    System.out.println("widths are different");
                }
                return false;
            }
            int[] nArray4 = (int[])iAdminProp.getProp(282001954);
            if (!this.cmpObjectArray(nArray4, this.m_height, true)) {
                if (GridView.DEBUG) {
                    System.out.println("heights are different");
                }
                return false;
            }
            Object[] objectArray5 = (Object[])iAdminProp.getProp(276758675);
            if (!this.cmpObjectArray(objectArray5, this.m_lov, false)) {
                if (GridView.DEBUG) {
                    System.out.println("lov are different");
                }
                return false;
            }
            String string = (String)this.m_ap.getProp(1638690);
            if (!this.cmpObject(string, this.m_groupTitle, true)) {
                if (GridView.DEBUG) {
                    System.out.println("group title are different");
                }
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
        this.m_ap = (IAdminProp)object;
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            object2 = (GridViewItem)this.m_gridViews.elementAt(n2);
            if (!object2.setObject(object)) {
                this.rebuild();
                break;
            }
            ++n2;
        }
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        return true;
    }

    public void printPropList(String string, int[] nArray) {
        System.out.println(String.valueOf(string) + " " + nArray);
        int n = 0;
        while (nArray != null && n < nArray.length) {
            String string2 = this.m_ap.getPropName(nArray[n]);
            if (string2 == null) {
                string2 = "0x" + Integer.toHexString(nArray[n]);
            }
            System.out.println("\t" + string2);
            ++n;
        }
        System.out.println("\tdone");
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        int[] nArray = new int[1];
        while (true) {
            Object object;
            if (GridView.DEBUG) {
                System.out.println("adminPropertyChange");
            }
            nArray[0] = adminPropertyChangeEvent.getPropId();
            if (nArray[0] == 282001422 || nArray[0] == 281609329 || nArray[0] == 276758675) {
                if (GridView.DEBUG) {
                    System.out.println("rebuilding view");
                }
                object = new Hashtable();
                this.saveState((Hashtable)object);
                this.rebuild();
                this.restoreState((Hashtable)object);
            } else if (nArray[0] == 281609325) {
                try {
                    if (GridView.DEBUG) {
                        System.out.println("PR_GRID_VIEW_PROP_DISABLE_LIST");
                    }
                    if (GridView.DEBUG) {
                        this.printPropList("old disabled list:", this.m_disabledProps);
                    }
                    object = (int[])this.m_ap.getProp(nArray[0]);
                    if (GridView.DEBUG) {
                        this.printPropList("new disabled list:", (int[])object);
                    }
                    int[] nArray2 = GridViewPanel.subtract(this.m_disabledProps, (int[])object);
                    if (GridView.DEBUG) {
                        this.printPropList("enable list (old-new):", nArray2);
                    }
                    int[] nArray3 = GridViewPanel.subtract((int[])object, this.m_disabledProps);
                    if (GridView.DEBUG) {
                        this.printPropList("disable list (new-old):", nArray3);
                    }
                    if (nArray2 != null) {
                        this.enableProps(nArray2, true);
                    }
                    if (nArray3 != null) {
                        this.enableProps(nArray3, false);
                    }
                    this.m_disabledProps = (int[])object;
                }
                catch (Exception exception) {}
            } else if (!this.blockUpdate()) {
                this.update(nArray);
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public boolean isMSWindows() {
        return true;
    }

    boolean useLovButton(Object[] objectArray, int n, boolean bl) {
        if (objectArray != null && objectArray[n] != null) {
            if (objectArray[n] instanceof int[]) {
                return false;
            }
            if (objectArray[n] instanceof IAdminProp) {
                return true;
            }
            if (bl) {
                return true;
            }
            if (this.isMSWindows()) {
                return false;
            }
            if (objectArray[n] instanceof Hashtable) {
                return ((Hashtable)objectArray[n]).size() >= 20;
            }
            return ((Object[])objectArray[n]).length >= 20;
        }
        return false;
    }

    boolean useLov(Object[] objectArray, int n) {
        if (objectArray != null && objectArray[n] != null) {
            if (objectArray[n] instanceof IAdminProp) {
                try {
                    Integer n2 = (Integer)((IAdminProp)objectArray[n]).getProp(2688106);
                    if (n2 != null && (n2 & 2) != 0) {
                        return true;
                    }
                }
                catch (Exception exception) {}
                return false;
            }
            if (objectArray[n] instanceof int[]) {
                return false;
            }
            if (this.isMSWindows()) {
                return true;
            }
            if (objectArray[n] instanceof Hashtable) {
                return ((Hashtable)objectArray[n]).size() < 20;
            }
            return ((Object[])objectArray[n]).length < 20;
        }
        return false;
    }

    void init(GridView gridView) {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = null;
        AdminButton adminButton = null;
        boolean bl = false;
        GridBagConstraints gridBagConstraints = null;
        int n = 2;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.m_rows = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = (gridView.getStatus() & 0x100000) != 0;
        boolean bl5 = (gridView.getStatus() & 0x200000) != 0;
        boolean bl6 = (gridView.getStatus() & 0x10000) != 0;
        boolean bl7 = (gridView.getStatus() & 0x20000) != 0;
        gridView.getStatus();
        boolean bl8 = (gridView.getStatus() & 0x400000) != 0;
        AdminCheckboxGroup adminCheckboxGroup = null;
        try {
            this.m_propList = (int[])this.m_ap.getProp(282001422);
            object4 = (Integer)this.m_ap.getProp(2686979);
            if (object4 != null && ((Integer)object4 & 2) == 0) {
                bl = true;
            }
            if ((object3 = (Boolean)this.m_ap.getProp(8455199)) != null) {
                bl3 = (Boolean)object3;
            }
            object2 = (String)this.m_ap.getProp(1638690);
            this.m_groupTitle = object2;
            string = (String)this.m_ap.getProp(1638914);
            object = (Integer)this.m_ap.getProp(2163876);
            if (object != null) {
                n4 = (Integer)object;
            }
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get property list " + propertyException);
            return;
        }
        if (this.m_propList != null) {
            object4 = null;
            try {
                int[] nArray = (int[])this.m_ap.getProp(281609329);
                object4 = nArray;
                this.m_hidden = nArray;
                if (object4 != null && ((Object)object4).length != 0) {
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < this.m_propList.length) {
                        int n7 = 0;
                        while (n7 < this.m_hidden.length) {
                            if (this.m_propList[n6] == this.m_hidden[n7]) {
                                ++n5;
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    if (n5 == this.m_propList.length) {
                        this.m_propList = null;
                    }
                }
            }
            catch (PropertyException propertyException) {
                this.debugMessageLn("Couldn't get list of hidden properties " + propertyException);
            }
        }
        if (this.m_propList == null) {
            if (string != null) {
                object4 = new AdminMultiLineLabel(string);
                ((AdminMultiLineLabel)((Object)object4)).setAlignment(3);
                ((Container)((Object)this)).setLayout(new BorderLayout());
                super.add("Center", (Component)object4);
                return;
            }
            return;
        }
        try {
            this.m_skipRows = (Integer)this.m_ap.getProp(2687525);
            if (this.m_skipRows != null) {
                n2 = this.m_skipRows;
            }
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get skip rows: " + propertyException);
        }
        try {
            this.m_colNames = (String[])this.m_ap.getProp(270074403);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of column names: " + propertyException);
        }
        try {
            this.m_rowNames = (String[])this.m_ap.getProp(270074404);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of row names: " + propertyException);
        }
        if (this.m_rowNames != null && this.m_colNames == null) {
            this.m_rowNames = null;
        }
        object4 = null;
        try {
            object4 = (String[])this.m_ap.getProp(270467219);
            this.m_units = object4;
            if (object4 != null && ((Object)object4).length != 0) {
                n = 3;
            }
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of units array" + propertyException);
        }
        object3 = null;
        try {
            int[] nArray = (int[])this.m_ap.getProp(282001954);
            object3 = nArray;
            this.m_height = nArray;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of height array" + propertyException);
        }
        object2 = null;
        try {
            int[] nArray = (int[])this.m_ap.getProp(270075001);
            object2 = nArray;
            this.m_groupTitleProps = nArray;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of disabledProp array" + propertyException);
        }
        object = null;
        try {
            int[] nArray = (int[])this.m_ap.getProp(281609325);
            object = nArray;
            this.m_disabledProps = nArray;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of disabledProp array" + propertyException);
        }
        int[] nArray = null;
        try {
            nArray = (int[])this.m_ap.getProp(281609327);
            this.m_syncProps = nArray;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of syncProp array" + propertyException);
        }
        int[] nArray2 = null;
        try {
            nArray2 = (int[])this.m_ap.getProp(281609326);
            this.m_propsWithHiddenLabel = nArray2;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of propsWithHiddenLabel array" + propertyException);
        }
        int[] nArray3 = null;
        try {
            nArray3 = (int[])this.m_ap.getProp(282001953);
            this.m_width = nArray3;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of width array" + propertyException);
        }
        int[] nArray4 = null;
        try {
            nArray4 = (int[])this.m_ap.getProp(282001952);
            this.m_length = nArray4;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of length array" + propertyException);
        }
        GridBagConstraints[] gridBagConstraintsArray = null;
        try {
            gridBagConstraintsArray = (GridBagConstraints[])this.m_ap.getProp(275841152);
            this.m_gbcList = gridBagConstraintsArray;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get property list " + propertyException);
        }
        if (gridBagConstraintsArray != null) {
            if (string != null) {
                if (gridBagConstraintsArray.length < n * this.m_propList.length + 1) {
                    gridBagConstraintsArray = null;
                }
            } else if (gridBagConstraintsArray.length < n * this.m_propList.length) {
                gridBagConstraintsArray = null;
            }
        }
        try {
            objectArray = this.m_ap.getProps(this.m_propList);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get property values " + propertyException);
            propertyException.printStackTrace();
            return;
        }
        if (objectArray == null) {
            this.debugMessageLn("No value list!!");
            return;
        }
        String[] stringArray = this.m_ap.getPropNames(this.m_propList);
        this.m_names = stringArray;
        if (stringArray == null) {
            this.debugMessageLn("No name list!!");
            return;
        }
        Object[] objectArray2 = null;
        try {
            objectArray2 = (Object[])this.m_ap.getProp(276758675);
            this.m_lov = objectArray2;
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get list of values array" + propertyException);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        ((Container)((Object)this)).setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints2 = null;
        if (gridBagConstraintsArray == null) {
            gridBagConstraints2 = new GridBagConstraints();
        }
        int n8 = 0;
        while (n8 < this.m_propList.length) {
            block163: {
                Object object6;
                block167: {
                    block166: {
                        Object object7;
                        Object object8;
                        Object object9;
                        Object object10;
                        block165: {
                            block164: {
                                object10 = null;
                                object6 = null;
                                object9 = null;
                                adminButton = null;
                                if (AdminProp.isPropHidden(this.m_propList[n8]) || Util.isMember(this.m_hidden, this.m_propList[n8])) break block163;
                                if (gridBagConstraintsArray == null) {
                                    if (n8 == 0 && string != null) {
                                        gridBagConstraints2.gridx = 0;
                                        gridBagConstraints2.gridy = 0;
                                        gridBagConstraints2.insets.top = 20;
                                        gridBagConstraints2.insets.bottom = 20;
                                        gridBagConstraints2.insets.left = 0;
                                        gridBagConstraints2.insets.right = 0;
                                        gridBagConstraints2.fill = 1;
                                        gridBagConstraints2.anchor = 18;
                                        gridBagConstraints2.gridwidth = 0;
                                        gridBagConstraints2.weightx = 0.0;
                                        object8 = new AdminMultiLineLabel(string);
                                        ((AdminMultiLineLabel)((Object)object8)).setAlignment(3);
                                        this.traceSetConstraints(gridBagLayout, (Component)object8, gridBagConstraints2);
                                        super.add((Component)object8);
                                        gridBagConstraints2.insets.top = 0;
                                        gridBagConstraints2.insets.bottom = 0;
                                        n3 = 1;
                                    }
                                    if (n8 == n2 && this.m_colNames != null) {
                                        int n9 = -1;
                                        while (n9 < this.m_colNames.length) {
                                            GridViewLabel gridViewLabel = null;
                                            if (n9 == -1 || this.m_colNames[n9] == null || this.m_colNames[n9].length() == 0) {
                                                object6 = this.useLovButton(objectArray2, n8, AdminProp.isPropArray(this.m_propList[n8])) ? new AdminLabel("            ") : new AdminLabel("                ");
                                            } else {
                                                gridViewLabel = new GridViewLabel(gridView, this.m_ap, this.m_propList[n8 + n9], false, this.m_colNames[n9], "");
                                                object6 = gridViewLabel;
                                                gridViewLabel.setExtraSize(n4);
                                            }
                                            gridBagConstraints2.gridx = n9 + 1;
                                            gridBagConstraints2.gridy = n8 + n3;
                                            gridBagConstraints2.insets.left = bl3 ? 0 : 5;
                                            gridBagConstraints2.insets.top = 5;
                                            gridBagConstraints2.insets.right = 5;
                                            gridBagConstraints2.fill = 0;
                                            gridBagConstraints2.anchor = 18;
                                            gridBagConstraints2.gridwidth = n9 + 1 == this.m_colNames.length ? 0 : (n9 + 2 == this.m_colNames.length ? -1 : 1);
                                            gridBagConstraints2.weightx = 0.0;
                                            if ((gridBagConstraints2.anchor == 18 || gridBagConstraints2.anchor == 17) && gridViewLabel != null) {
                                                gridViewLabel.setAlignment(1);
                                            }
                                            if (GridView.DEBUG) {
                                                System.out.println("column at x=" + gridBagConstraints2.gridx + " y=" + gridBagConstraints2.gridy);
                                            }
                                            this.traceSetConstraints(gridBagLayout, (Component)object6, gridBagConstraints2);
                                            super.add((Component)object6);
                                            ++n9;
                                        }
                                        ++n3;
                                    }
                                    gridBagConstraints2.gridy = this.m_colNames != null ? (n8 >= n2 ? (this.m_rowNames != null && this.m_rowNames.length <= (n8 - n2) / this.m_colNames.length ? this.m_rowNames.length + n3 + n2 : (n8 - n2) / this.m_colNames.length + n3 + n2) : n8 + n3) : n8 + n3;
                                    gridBagConstraints2.insets.top = 5;
                                    gridBagConstraints2.gridx = 0;
                                    gridBagConstraints2.insets.left = bl3 ? 0 : 5;
                                    gridBagConstraints2.insets.right = 5;
                                    gridBagConstraints2.fill = 0;
                                    gridBagConstraints2.anchor = 18;
                                    gridBagConstraints2.gridwidth = -1;
                                    gridBagConstraints2.weightx = 0.0;
                                    if (object4 != null) {
                                        gridBagConstraints2.gridwidth = 1;
                                    }
                                } else {
                                    if (n8 == 0 && string != null) {
                                        gridBagConstraints2 = gridBagConstraintsArray[n8 * n + n3];
                                        object8 = new AdminMultiLineLabel(string);
                                        this.traceSetConstraints(gridBagLayout, (Component)object8, gridBagConstraints2);
                                        super.add((Component)object8);
                                        n3 = 1;
                                    }
                                    gridBagConstraints2 = gridBagConstraintsArray[n8 * n + n3];
                                }
                                object8 = null;
                                if (gridBagConstraints2 != null) {
                                    boolean bl9 = false;
                                    if (this.useLovButton(objectArray2, n8, AdminProp.isPropArray(this.m_propList[n8]))) {
                                        object8 = new GridViewListLOVButton(gridView, this.m_ap, this.m_propList[n8], stringArray[n8], objectArray2[n8]);
                                        object6 = object8;
                                        ((Component)object6).addFocusListener(gridView);
                                    } else if (this.m_colNames == null || n8 < n2 || (n8 - n2) % this.m_colNames.length == 0 || this.m_rowNames != null && this.m_rowNames.length <= (n8 - n2) / this.m_colNames.length) {
                                        object7 = null;
                                        int n10 = n8 - n2;
                                        object6 = null;
                                        if (n8 >= n2 && this.m_rowNames != null && this.m_rowNames.length > (n10 /= this.m_colNames == null ? 1 : this.m_colNames.length)) {
                                            bl9 = true;
                                            if (this.m_rowNames[n10] != null && this.m_rowNames[n10].length() != 0) {
                                                if (GridView.DEBUG) {
                                                    System.out.println("label at x=" + gridBagConstraints2.gridx + " y=" + gridBagConstraints2.gridy);
                                                }
                                                object7 = new GridViewLabel(gridView, this.m_ap, this.m_propList[n8], false, this.m_rowNames[n10]);
                                                object6 = object7;
                                                ((GridViewLabel)object7).disableMinSizing();
                                            } else {
                                                if (GridView.DEBUG) {
                                                    System.out.println("label at x=" + gridBagConstraints2.gridx + " y=" + gridBagConstraints2.gridy);
                                                }
                                                object6 = new AdminLabel("");
                                            }
                                        } else if (stringArray[n8] != null && stringArray[n8].length() > 0) {
                                            object7 = new GridViewLabel(gridView, this.m_ap, this.m_propList[n8], false, stringArray[n8]);
                                            object6 = object7;
                                            ((GridViewLabel)object7).setExtraSize(n4);
                                        }
                                        if ((gridBagConstraints2.anchor == 18 || gridBagConstraints2.anchor == 17) && object7 != null) {
                                            object7.setAlignment(1);
                                        }
                                    }
                                    if (object6 != null && (bl9 || AdminProp.getPropType(this.m_propList[n8]) != 0x800000)) {
                                        if (object6 instanceof AdminButton) {
                                            adminButton = (AdminButton)object6;
                                        }
                                        if (bl4 && object6 instanceof AdminButton) {
                                            if (!bl6 && !Util.isMember(nArray2, this.m_propList[n8])) {
                                                object7 = new GridViewLabel(gridView, this.m_ap, this.m_propList[n8], false, stringArray[n8]);
                                                object7.setAlignment(1);
                                                ((GridViewLabel)object7).setExtraSize(n4);
                                                gridBagConstraints2.gridx = 0;
                                                gridBagConstraints2.gridwidth = 1;
                                                this.traceSetConstraints(gridBagLayout, (Component)object7, gridBagConstraints2);
                                                super.add((Component)object7);
                                                object10 = object7;
                                            }
                                            object7 = null;
                                            try {
                                                String string2;
                                                if (objectArray2 != null && n8 < objectArray2.length && objectArray2[n8] instanceof IAdminProp && (string2 = (String)((IAdminProp)objectArray2[n8]).getProp(1639538)) != null && (object7 = AdminUtil.loadImage(string2, null)) != null) {
                                                    ((AdminButton)object6).setLabel("");
                                                    ((AdminButton)object6).setImage((Image)object7);
                                                }
                                            }
                                            catch (Exception exception) {
                                                object7 = null;
                                            }
                                            if (object7 == null) {
                                                ((AdminButton)object6).setLabel(ClientLang.getStrBrowse());
                                            }
                                            gridBagConstraints2.gridwidth = 1;
                                            gridBagConstraints2.insets.top = 5;
                                            gridBagConstraints2.gridx = 2;
                                            this.traceSetConstraints(gridBagLayout, (Component)object6, gridBagConstraints2);
                                            super.add((Component)object6);
                                        } else if (!bl6 && !Util.isMember(nArray2, this.m_propList[n8])) {
                                            if (bl9) {
                                                gridBagConstraints2.insets.right = 30;
                                            }
                                            object9 = object6;
                                            this.traceSetConstraints(gridBagLayout, (Component)object6, gridBagConstraints2);
                                            super.add((Component)object6);
                                        }
                                    }
                                }
                                if (gridBagConstraintsArray != null) break block164;
                                gridBagConstraints2.gridwidth = 0;
                                gridBagConstraints2.anchor = 18;
                                gridBagConstraints2.insets.top = 5;
                                if (stringArray[n8] == null || stringArray[n8].length() == 0) {
                                    gridBagConstraints2.gridx = 0;
                                    gridBagConstraints2.insets.left = 5;
                                } else {
                                    gridBagConstraints2.gridx = 1;
                                }
                                if (bl8 && Util.isMember(nArray2, this.m_propList[n8]) && AdminProp.getPropType(this.m_propList[n8]) == 0x400000) {
                                    gridBagConstraints2.gridx = 0;
                                }
                                gridBagConstraints2.weightx = 1.0;
                                gridBagConstraints2.insets.right = bl3 ? 0 : (object4 != null && object4[n8] != null ? 5 : 25);
                                if (bl4) {
                                    gridBagConstraints2.gridwidth = 1;
                                    gridBagConstraints2.insets.right = 5;
                                }
                                if (bl6) {
                                    gridBagConstraints2.insets.left = 30;
                                    if (bl7 && AdminProp.getPropType(this.m_propList[n8]) == 0x800000) {
                                        gridBagConstraints2.insets.left -= 10;
                                    }
                                }
                                if (this.m_colNames != null) {
                                    gridBagConstraints2.weightx = 0.0;
                                    gridBagConstraints2.insets.top = 5;
                                    gridBagConstraints2.gridx = 1;
                                    if (this.m_rowNames != null && this.m_rowNames.length <= (n8 - n2) / this.m_colNames.length) {
                                        gridBagConstraints2.gridx = 1;
                                    } else if (n8 >= n2) {
                                        gridBagConstraints2.anchor = 12;
                                        gridBagConstraints2.gridx = 1 + (n8 - n2) % this.m_colNames.length;
                                        if (gridBagConstraints2.gridx - 1 + 1 == this.m_colNames.length) {
                                            gridBagConstraints2.gridwidth = 0;
                                            gridBagConstraints2.weightx = 1.0;
                                        } else {
                                            gridBagConstraints2.gridwidth = gridBagConstraints2.gridx - 1 + 2 == this.m_colNames.length ? -1 : 1;
                                        }
                                        gridBagConstraints2.insets.right = 2;
                                    }
                                    if (GridView.DEBUG) {
                                        System.out.println("editor at x=" + gridBagConstraints2.gridx + " y=" + gridBagConstraints2.gridy);
                                    }
                                    if (AdminProp.getPropType(this.m_propList[n8]) == 0x800000) {
                                        gridBagConstraints2.anchor = 11;
                                    }
                                    if (adminCheckboxGroup != null && this.m_colNames != null && (n8 - n2) % this.m_colNames.length == 0) {
                                        adminCheckboxGroup = null;
                                    }
                                }
                                gridBagConstraints2.fill = 2;
                                gridBagConstraints2.weighty = n8 == this.m_propList.length - 1 && bl2 ? 1.0 : 0.0;
                                if (object4 != null && object4[n8] != null) {
                                    gridBagConstraints2.gridwidth = 1;
                                }
                                break block165;
                            }
                            gridBagConstraints2 = gridBagConstraintsArray[n8 * n + 1 + n3];
                            if (gridBagConstraints2 == null) break block163;
                        }
                        this.m_rows = AdminProp.isPropArray(this.m_propList[n8]) ? (this.m_rows += 4) : ++this.m_rows;
                        boolean bl10 = false;
                        if (bl || AdminProp.isPropReadonly(this.m_propList[n8])) {
                            bl10 = true;
                        }
                        if (object6 != null && object10 == null) {
                            object10 = object6;
                        }
                        int n11 = AdminProp.getPropType(this.m_propList[n8]);
                        switch (n11) {
                            case 0xE00000: {
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewLongLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewLong(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x200000: {
                                if (!bl10 && objectArray2 != null && objectArray2[n8] instanceof int[]) {
                                    object7 = (int[])objectArray2[n8];
                                    if (object7[0] == false && object7[1] == true) {
                                        object6 = new GridViewIntegerRangeBoolean(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                        break;
                                    }
                                    object6 = new GridViewIntegerRange(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewIntegerLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewInteger(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x500000: {
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewDoubleLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewDouble(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0xD00000: {
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewStringLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewPassword(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x100000: {
                                if (this.useLov(objectArray2, n8)) {
                                    Hashtable hashtable;
                                    Object v;
                                    if (!bl10) {
                                        object6 = new GridViewStringLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                        break;
                                    }
                                    object7 = objectArray[n8];
                                    if (objectArray2[n8] instanceof Hashtable && (v = (hashtable = (Hashtable)objectArray2[n8]).get(object7)) != null) {
                                        object7 = v;
                                    }
                                    object6 = new GridViewString(gridView, this.m_ap, this.m_propList[n8], bl10, object7);
                                    break;
                                }
                                if (objectArray2 != null && objectArray2[n8] instanceof int[]) {
                                    object7 = (int[])objectArray2[n8];
                                    if (object7[0] == false && object7[1] == true) {
                                        object6 = new GridViewBoolean(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8], " " + stringArray[n8]);
                                        if (!(object10 instanceof AdminLabel)) break;
                                        super.remove((Component)object10);
                                        break;
                                    }
                                    object6 = new GridViewString(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                    break;
                                }
                                object6 = new GridViewString(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0xB00000: {
                                object6 = new GridViewText(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x800000: {
                                if (bl5) {
                                    if (adminCheckboxGroup == null) {
                                        adminCheckboxGroup = new AdminCheckboxGroup();
                                    }
                                    object7 = new GridViewRadio(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8], n8 >= n2 && this.m_colNames != null && (this.m_rowNames == null || n8 - n2 < this.m_colNames.length * this.m_rowNames.length) ? "" : " " + stringArray[n8], adminCheckboxGroup);
                                    object6 = object7;
                                    object5 = object7;
                                    break;
                                }
                                object7 = new GridViewBoolean(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8], " " + stringArray[n8]);
                                object6 = object7;
                                object5 = object7;
                                break;
                            }
                            case 0x900000: {
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewTimeLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewDate(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x300000: {
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewDateLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewDate(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x400000: {
                                object6 = this.useLov(objectArray2, n8) && !bl10 ? new GridViewAdminPropLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]) : new GridViewAdminProp(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                if (gridBagConstraintsArray != null) break;
                                gridBagConstraints2.insets.bottom = 5;
                                break;
                            }
                            case 0x700000: {
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewObjectLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewObject(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x600000: {
                                if (this.useLov(objectArray2, n8) && !bl10) {
                                    object6 = new GridViewJavaBeanLOV(gridView, this.m_ap, this.m_propList[n8], objectArray[n8], objectArray2[n8]);
                                    break;
                                }
                                object6 = new GridViewJavaBean(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10200000: {
                                object6 = new GridViewArrInteger(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10100000: {
                                object6 = new GridViewArrString(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10800000: {
                                object6 = new GridViewArrBoolean(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10300000: {
                                object6 = new GridViewArrTime(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10900000: {
                                object6 = new GridViewArrDate(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10C00000: {
                                object6 = new GridViewArrInteger(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10400000: {
                                object6 = new GridViewArrAdminProp(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10700000: {
                                object6 = new GridViewArrObject(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            case 0x10600000: {
                                object6 = new GridViewArrJavaBean(gridView, this.m_ap, this.m_propList[n8], bl10, objectArray[n8]);
                                break;
                            }
                            default: {
                                object6 = new AdminLabel("No field editor for field:\nProperty Type = " + n11 + "\nProperty ID   = 0x" + Integer.toHexString(this.m_propList[n8]) + "\nProperty Name = " + this.m_ap.getPropName(this.m_propList[n8]));
                                object8 = null;
                            }
                        }
                        if (object8 != null) {
                            ((GridViewListLOVButton)object8).setGVI((Component)object6);
                        }
                        if (object10 != null) {
                            gridView.linkFieldAndLabel((Component)object10, (Component)object6);
                        }
                        if (!Util.isMember((int[])object2, this.m_propList[n8])) {
                            if (object9 != null && object9 instanceof AdminLabel) {
                                ((AdminLabel)((Object)object9)).setLabelFor((Component)object6);
                            }
                            this.traceSetConstraints(gridBagLayout, (Component)object6, gridBagConstraints2);
                            this.add((Component)object6);
                        } else {
                            this.m_groupBoxTitle = object6;
                            this.m_gridViews.addElement(object6);
                        }
                        if (!(object6 instanceof AdminLabel)) {
                            ((Component)object6).addFocusListener(gridView);
                            this.setToolTipValue((Component)object6, this.m_ap.getPropDescription(this.m_propList[n8]));
                            if (bl7 && object5 != null && !(object6 instanceof GridViewRadio) && !(object6 instanceof GridViewBoolean)) {
                                if (GridView.DEBUG) {
                                    System.out.println("addEnabledField parent=" + object5 + " field=" + (Object)object6);
                                }
                                object5.addEnabledFields((Component)object6, (Component)((Object)adminButton));
                            }
                        }
                        if (Util.isMember((int[])object, this.m_propList[n8])) {
                            ((Component)object6).setEnabled(false);
                        }
                        if (object4 == null || object4[n8] == null) break block163;
                        if (gridBagConstraintsArray != null) break block166;
                        if (gridBagConstraints == null) {
                            gridBagConstraints = new GridBagConstraints();
                        }
                        gridBagConstraints.gridy = gridBagConstraints2.gridy;
                        gridBagConstraints.gridx = gridBagConstraints2.gridx + 1;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.anchor = 18;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.insets.top = 5;
                        gridBagConstraints.insets.right = 25;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.weighty = 0.0;
                        break block167;
                    }
                    gridBagConstraints = gridBagConstraintsArray[n8 * n + 2 + n3];
                    if (gridBagConstraints == null) break block163;
                }
                object6 = new AdminLabel((String)object4[n8]);
                this.traceSetConstraints(gridBagLayout, (Component)object6, gridBagConstraints);
                object6.setLabelFor(null);
                this.add((Component)object6);
            }
            ++n8;
        }
    }

    public void traceSetConstraints(GridBagLayout gridBagLayout, Component component, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public Component add(Component component) {
        if (component instanceof GridViewItem) {
            this.m_gridViews.addElement(component);
        }
        return super.add(component);
    }

    void debugMessageLn(String string) {
        System.out.println(string);
    }

    public void saveState(Hashtable hashtable) {
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            if (gridViewItem.isModified(null)) {
                hashtable.put(new Integer(gridViewItem.getPropId()), gridViewItem.getItemValue());
            }
            ++n2;
        }
    }

    public void restoreState(Hashtable hashtable) {
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            int n3 = gridViewItem.getPropId();
            Object v = hashtable.get(new Integer(n3));
            if (v != null) {
                gridViewItem.setItemValue(v);
            }
            ++n2;
        }
    }

    public boolean isModified(StringBuffer stringBuffer) {
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            if (gridViewItem.isModified(stringBuffer)) {
                if (GridView.DEBUG) {
                    System.out.println("Property modified is ='" + this.m_ap.getPropName(gridViewItem.getPropId()) + "'. The new value is ='" + gridViewItem.getItemValue() + "'");
                }
                if (stringBuffer != null) {
                    stringBuffer.append(String.valueOf(ClientLang.getStrPropMod()) + "\n    " + this.m_ap.getPropName(gridViewItem.getPropId()) + "\n");
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void revert() {
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            if (gridViewItem.isModified(null)) {
                if (GridView.DEBUG) {
                    System.out.println("revert('" + this.m_ap.getPropName(gridViewItem.getPropId()) + "', '" + gridViewItem.getItemValue() + "')");
                }
                gridViewItem.revert();
                this.m_parent.setLabelColor(gridViewItem);
            }
            ++n2;
        }
    }

    public void commit() {
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            if (gridViewItem.isModified(null)) {
                if (GridView.DEBUG) {
                    System.out.println("commit('" + this.m_ap.getPropName(gridViewItem.getPropId()) + "', '" + gridViewItem.getItemValue() + "')");
                }
                gridViewItem.commit();
                this.m_parent.setLabelColor(gridViewItem);
            }
            ++n2;
        }
    }

    public void update() {
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            gridViewItem.update();
            if (GridView.DEBUG) {
                System.out.println("update('" + this.m_ap.getPropName(gridViewItem.getPropId()) + "', '" + gridViewItem.getItemValue() + "')");
            }
            this.m_parent.setLabelColor(gridViewItem);
            ++n2;
        }
    }

    public void enableProps(int[] nArray, boolean bl) {
        if (GridView.DEBUG) {
            System.out.println("Enable(" + bl + ") propCount=" + nArray.length);
        }
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            int n3 = 0;
            while (n3 < nArray.length) {
                if (gridViewItem.getPropId() == nArray[n3]) {
                    if (GridView.DEBUG) {
                        System.out.println("Enable propId=" + nArray[n3]);
                    }
                    if (GridView.DEBUG) {
                        System.out.println("enable('" + this.m_ap.getPropName(gridViewItem.getPropId()) + "', '" + gridViewItem.getItemValue() + "')");
                    }
                    ((Component)((Object)gridViewItem)).setEnabled(bl);
                    this.m_parent.setLabelColor(gridViewItem);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void update(int[] nArray) {
        if (GridView.DEBUG) {
            System.out.println("Updates propCount=" + nArray.length);
        }
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            GridViewItem gridViewItem = (GridViewItem)this.m_gridViews.elementAt(n2);
            int n3 = 0;
            while (n3 < nArray.length) {
                if (gridViewItem.getPropId() == nArray[n3]) {
                    if (GridView.DEBUG) {
                        System.out.println("Update propId=" + nArray[n3] + " " + this.m_ap.getPropName(nArray[n3]));
                    }
                    if (GridView.DEBUG) {
                        System.out.println("update('" + this.m_ap.getPropName(gridViewItem.getPropId()) + "', '" + gridViewItem.getItemValue() + "')");
                    }
                    gridViewItem.update();
                    this.m_parent.setLabelColor(gridViewItem);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public boolean save() {
        return this.save(true);
    }

    /*
     * Unable to fully structure code
     */
    public boolean save(boolean var1_1) {
        block31: {
            if (GridView.DEBUG) {
                System.out.println("Calling GridViewPanel.save(" + var1_1 + ")");
            }
            var2_2 = false;
            var3_3 = this.m_gridViews.size();
            var6_4 = 0;
            var7_5 = 0;
            while (var6_4 < var3_3) {
                var4_6 = (GridViewItem)this.m_gridViews.elementAt(var6_4);
                if (var4_6.isModified(null)) {
                    ++var7_5;
                }
                ++var6_4;
            }
            if (var7_5 == 0) {
                try {
                    if (var1_1) {
                        this.m_ap.saveChanges(0);
                    }
                }
                catch (SaveChangeException var8_7) {
                    new ErrorAlert(AdminUtil.getFrame((Component)this), var8_7);
                    return false;
                }
                return true;
            }
            if (GridView.DEBUG) {
                System.out.println("Saving");
            }
            var8_8 = new int[var7_5];
            var9_9 = new Object[var7_5];
            var10_10 = new Vector<Object>();
            var6_4 = 0;
            var5_11 = 0;
            while (var6_4 < var3_3 && var5_11 < var7_5) {
                var4_6 = (GridViewItem)this.m_gridViews.elementAt(var6_4);
                if (var4_6.isModified(null)) {
                    if (GridView.DEBUG) {
                        System.out.println("prop modified=" + this.m_ap.getPropName(var4_6.getPropId()) + " valueType=" + var4_6.getItemValue().getClass().getName() + " value=" + var4_6.getItemValue());
                    }
                    var10_10.addElement(var4_6);
                    var10_10.addElement(var4_6.getInitValue());
                    var8_8[var5_11] = var4_6.getPropId();
                    var9_9[var5_11] = var4_6.getItemValue();
                    if (AdminProp.getPropType(var4_6.getPropId()) == 0x400000) {
                        var4_6.commit();
                    }
                    ++var5_11;
                }
                ++var6_4;
            }
            try {
                this.m_ap.setProps(var8_8, var9_9);
                var2_2 = true;
            }
            catch (PropertyException var11_12) {
                new ErrorAlert(AdminUtil.getFrame((Component)this), var11_12);
                return false;
            }
            try {
                if (var2_2) {
                    if (var1_1) {
                        if (GridView.DEBUG) {
                            System.out.println("Calling saveChanges1...");
                        }
                        this.m_ap.saveChanges(0);
                    } else if (GridView.DEBUG) {
                        System.out.println("Not calling saveChanges1...");
                    }
                    this.commit();
                } else if (var1_1) {
                    if (GridView.DEBUG) {
                        System.out.println("Calling saveChanges2...");
                    }
                    this.m_ap.saveChanges(0);
                } else if (GridView.DEBUG) {
                    System.out.println("Not calling saveChanges2...");
                }
                break block31;
            }
            catch (SaveChangeException var11_13) {
                if (var11_13.isNotice()) {
                    new ErrorAlert(AdminUtil.getFrame((Component)this), var11_13, ClientLang.getStrNotice(), 2, 1);
                    return false;
                }
                if (var11_13.isWarning()) {
                    new ErrorAlert(AdminUtil.getFrame((Component)this), var11_13, ClientLang.getStrWarning(), 1, 1);
                } else if (var11_13.isReminder()) {
                    new ErrorAlert(AdminUtil.getFrame((Component)this), var11_13, ClientLang.getStrNotice(), 2, 1, false);
                    return false;
                }
                var3_3 = var10_10.size();
                var6_4 = 0;
                ** while (var6_4 < var3_3)
            }
lbl-1000:
            // 1 sources

            {
                var4_6 = (GridViewItem)var10_10.elementAt(var6_4);
                var4_6.setInitValue(var10_10.elementAt(var6_4 + 1));
                this.m_parent.setLabelColor(var4_6);
                var6_4 += 2;
                continue;
            }
lbl87:
            // 1 sources

            new ErrorAlert(AdminUtil.getFrame((Component)this), var11_13);
            return false;
        }
        return true;
    }

    public void setBlockUpdate(boolean bl) {
        this.m_blockUpdate = bl;
    }

    public boolean blockUpdate() {
        return this.m_blockUpdate;
    }

    public void unexpectedException(Exception exception) {
        System.out.println("Unexpected Exception " + exception);
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2;
        try {
            dimension2 = super.getPreferredSize();
        }
        catch (Exception exception) {
            return new Dimension(200, 400);
        }
        Container container = ((Component)((Object)this)).getParent();
        if (dimension2 != null && container != null && (dimension = container.getSize()) != null) {
            if (dimension2.width < 300) {
                dimension2.width = 300;
            } else if (dimension2.width < dimension.width - 25) {
                dimension2.width = dimension.width - 25;
            }
        }
        return dimension2;
    }

    void printPreferredSize(Dimension dimension) {
        if (GridView.DEBUG) {
            System.out.println("\nGridView preferredSize w=" + dimension.width + " h=" + dimension.height);
        }
        int n = this.m_gridViews.size();
        int n2 = 0;
        while (n2 < n) {
            Component component = (Component)this.m_gridViews.elementAt(n2);
            Dimension dimension2 = component.getPreferredSize();
            if (GridView.DEBUG) {
                System.out.println(String.valueOf(component.getClass().getName()) + " pw=" + dimension2.width + " h=" + dimension2.height);
            }
            dimension2 = component.getSize();
            if (GridView.DEBUG) {
                System.out.println(String.valueOf(component.getClass().getName()) + " sw=" + dimension2.width + " h=" + dimension2.height);
            }
            ++n2;
        }
        if (GridView.DEBUG) {
            System.out.println("");
        }
    }

    public void setEnabled(boolean bl) {
        if (GridView.DEBUG) {
            System.out.println("GridViewPanel.setEnabled = " + bl);
        }
        super.setEnabled(bl);
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            GridViewItem gridViewItem;
            if (componentArray[n] instanceof GridViewItem && !AdminProp.isPropReadonly((gridViewItem = (GridViewItem)((Object)componentArray[n])).getPropId())) {
                componentArray[n].setEnabled(bl);
            }
            ++n;
        }
    }

    public static int[] subtract(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return null;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            int n4 = nArray[n2];
            n3 = 0;
            while (n3 < nArray2.length) {
                if (n4 == nArray2[n3]) break;
                ++n3;
            }
            if (n3 == nArray2.length) {
                nArray3[n++] = n4;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray4 = new int[n];
        int n5 = 0;
        while (n5 < n) {
            nArray4[n5] = nArray3[n5];
            ++n5;
        }
        return nArray4;
    }

    public boolean isSyncProp(int n) {
        return Util.isMember(this.m_syncProps, n);
    }

    public Component getGroupBoxTitle() {
        return this.m_groupBoxTitle;
    }
}

