/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.events.DataUpdateListener;
import java.awt.Component;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class LineDataModel
implements DataModel {
    IAdminProp m_ap;
    Object[] m_items = new Object[2000];
    Object[] d_items;
    String[] legends;
    String[] xLabels;
    String title;
    int[] prop_list;
    int item_count;
    int prop_count;
    int ctype;
    Double[] arr_range;
    Integer[] y_incrs;
    Component m_parent;
    Vector listeners = new Vector();

    public void setParent(Component component) {
        this.m_parent = component;
    }

    public LineDataModel(IAdminProp iAdminProp) {
        this(iAdminProp, null);
    }

    public LineDataModel(IAdminProp iAdminProp, Component component) {
        this.m_ap = iAdminProp;
        this.m_parent = component;
        try {
            this.d_items = (Object[])this.m_ap.getProp(272695365);
            if (this.d_items == null) {
                new ErrorAlert(AdminUtil.getFrame(this.m_parent), "No of Items has to be atleast 1");
            }
            this.legends = (String[])this.m_ap.getProp(269549635);
            this.xLabels = (String[])this.m_ap.getProp(0x10110041);
            this.prop_list = (int[])this.m_ap.getProp(281083972);
            if (this.xLabels != null) {
                this.prop_count = this.xLabels.length;
            }
            if (this.legends != null) {
                this.item_count = this.legends.length;
            }
            this.ctype = (Integer)this.m_ap.getProp(2162771);
            this.arr_range = (Double[])this.m_ap.getProp(273743936);
            if (this.arr_range == null) {
                this.arr_range = new Double[2];
                this.arr_range[0] = new Double(0.0);
                this.arr_range[1] = new Double(300.0);
            }
            this.title = (String)this.m_ap.getProp(0x110050);
        }
        catch (PropertyException propertyException) {
            this.unexpectedException(propertyException);
        }
        this.computeValues();
    }

    void computeValues() {
        Object[] objectArray = null;
        if (this.d_items != null & this.prop_list != null) {
            int n = 0;
            while (n < this.item_count) {
                try {
                    objectArray = (Object[])((IAdminProp)this.d_items[n]).getProp(this.prop_list[0]);
                }
                catch (PropertyException propertyException) {
                    this.unexpectedException(propertyException);
                }
                int n2 = n * objectArray.length;
                int n3 = 0;
                while (n3 < objectArray.length) {
                    this.m_items[n3 + n2] = objectArray[n3];
                    ++n3;
                }
                ++n;
            }
        }
    }

    public double getValue(int n, int n2) {
        Object object = null;
        if (this.m_items == null) {
            return 1.0;
        }
        if (n > this.item_count || n2 > this.prop_count) {
            return 1.0;
        }
        object = this.m_items[this.prop_count * n + n2];
        if (object == null) {
            return 1.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 1.0;
    }

    public String getName() {
        if (this.title == null) {
            try {
                return (String)this.m_ap.getProp(0x110001);
            }
            catch (PropertyException propertyException) {
                this.unexpectedException(propertyException);
                return "No Title";
            }
        }
        return this.title;
    }

    public String getColumnVariableName() {
        return "";
    }

    public String getRowVariableName() {
        return "";
    }

    public String getRowLabel(int n) {
        if (this.legends == null) {
            return "No legend";
        }
        if (n < this.legends.length) {
            return this.legends[n];
        }
        return "Unnamed Row" + n;
    }

    public String getColumnLabel(int n) {
        if (this.xLabels[n] == null) {
            return "No legend";
        }
        if (n < this.xLabels.length) {
            return this.xLabels[n];
        }
        return "";
    }

    public int getRowCount() {
        return this.item_count;
    }

    public int getColumnCount() {
        return this.prop_count;
    }

    public double getRangeLow() {
        return this.arr_range[0];
    }

    public double getRangeHigh() {
        return this.arr_range[1];
    }

    public void dataUpdate() {
    }

    public void addDataUpdateListener(DataUpdateListener dataUpdateListener) {
        this.listeners.addElement(dataUpdateListener);
    }

    public void removeDataUpdateListener(DataUpdateListener dataUpdateListener) {
        this.listeners.removeElement(dataUpdateListener);
    }

    Object[] getItems() {
        if (this.m_items == null) {
            try {
                this.m_items = (Object[])this.m_ap.getProp(272695365);
            }
            catch (PropertyException propertyException) {
                return null;
            }
        }
        return this.m_items;
    }

    void unexpectedException(Exception exception) {
        System.out.println("Unexpected Exception " + exception);
    }
}

