/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import oracle.ldap.admin.client.common.AdminTextArea;
import oracle.ldap.admin.client.propEditors.MyItems;

class ListTextArea
extends AdminTextArea {
    static int DEFAULT_COLUMNS = 30;
    MyItems items;
    int[] selected = new int[0];
    int rows;
    boolean multipleMode = false;
    int visibleIndex = -1;
    transient ActionListener actionListener;
    transient ItemListener itemListener;
    static final int DEFAULT_VISIBLE_ROWS = 4;

    public void listTextAreaInit() {
        this.items = new MyItems(this);
        this.addMouseListener(new mouseListener());
    }

    public Component getScrollPane() {
        return this;
    }

    public void valueChanged(Object object) {
    }

    public ListTextArea() {
        this(0, false);
    }

    public ListTextArea(int n) {
        this(n, false);
    }

    public ListTextArea(int n, boolean bl) {
        super(n != 0 ? n : 4, DEFAULT_COLUMNS);
        this.rows = n != 0 ? n : 4;
        this.multipleMode = bl;
        this.listTextAreaInit();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public synchronized String[] getItems() {
        String[] stringArray = new String[this.items.size()];
        this.items.copyInto(stringArray);
        return stringArray;
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public synchronized void add(String string, int n) {
        this.addItem(string, n);
    }

    public synchronized void addItem(String string, int n) {
        if (n < -1 || n >= this.items.size()) {
            n = -1;
        }
        if (n == -1) {
            this.items.addElement(string);
            return;
        }
        this.items.insertElementAt(string, n);
    }

    public synchronized void replaceItem(String string, int n) {
        this.remove(n);
        this.add(string, n);
    }

    public synchronized void removeAll() {
        this.clear();
    }

    public synchronized void clear() {
        this.items.removeAllElements();
        this.selected = new int[0];
    }

    public synchronized void remove(String string) {
        int n = this.items.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in list");
        }
        this.remove(n);
    }

    public synchronized void remove(int n) {
        this.delItem(n);
    }

    public synchronized void delItem(int n) {
        this.delItems(n, n);
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public synchronized int[] getSelectedIndexes() {
        int n = this.getSelectionStart();
        if (n < 0) {
            return new int[0];
        }
        int n2 = this.getSelectionEnd();
        if (n2 < 0) {
            return new int[0];
        }
        if (n != n2) {
            n = this.items.indexToRowNumber(n);
            n2 = this.items.indexToRowNumber(n2);
        } else {
            n2 = n = this.items.indexToRowNumber(n);
        }
        this.selected = new int[n2 - n + 1];
        int n3 = n;
        while (n3 <= n2) {
            this.selected[n3 - n] = n3;
            ++n3;
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public void select(int n) {
        ListTextArea listTextArea = this;
        synchronized (listTextArea) {
            this.items.select(n);
            return;
        }
    }

    public synchronized void deselect(int n) {
        this.items.deselect(n);
    }

    public boolean isIndexSelected(int n) {
        return this.isSelected(n);
    }

    public boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getRows() {
        return super.getRows();
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public synchronized void setMultipleMode(boolean bl) {
        this.multipleMode = bl;
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int n) {
        this.visibleIndex = n;
    }

    public Dimension getPreferredSize(int n) {
        return this.getPreferredSize(n, DEFAULT_COLUMNS);
    }

    public Dimension getMinimumSize(int n) {
        return this.getMinimumSize(n, DEFAULT_COLUMNS);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",selected=" + this.getSelectedItem();
    }

    public synchronized void delItems(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            this.items.removeElementAt(n3);
            --n3;
        }
    }

    class mouseListener
    extends MouseAdapter {
        public void mouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.getClickCount();
        }

        mouseListener() {
            ListTextArea.this = ListTextArea.this;
        }
    }
}

