/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.propEditors.GraphNode;
import oracle.ldap.admin.client.propEditors.Shape;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class NodeGauge
implements Shape,
AdminPropertyChangeListener {
    GraphNode m_parent;
    IAdminProp m_ap;
    Point origin;
    Dimension g_dim;
    Point p;
    Dimension d;
    double lowestValue;
    double highestValue = 100.0;
    double scaleGrad = 10.0;
    double value;
    Font captionFont = new Font("Helvetica", 0, 12);
    Font numbersFont = new Font("Helvetica", 0, 8);
    String caption = "Uncaptioned Meter";
    Vector zones = new Vector();
    static final Color[] g_color = new Color[3];
    double[] normalzone = new double[2];
    double[] lowzone = new double[2];
    double[] highzone = new double[2];
    Double[] normal = new Double[2];
    Double[] low = new Double[2];
    Double[] high = new Double[2];
    Graphics offScreenGraphics;
    Boolean f_state;
    Gaugeflasher gf;
    int type;
    int relative_x;
    int relative_y;
    boolean flashOn = false;
    Integer state;
    int idx = -1;

    public NodeGauge(IAdminProp iAdminProp, GraphNode graphNode) {
        this.m_ap = iAdminProp;
        this.m_parent = graphNode;
        try {
            this.type = (Integer)this.m_ap.getProp(2098263);
            if (this.type != 3) {
                this.lowestValue = (Double)this.m_ap.getProp(5243985);
                this.highestValue = (Double)this.m_ap.getProp(5243986);
                this.scaleGrad = (Double)this.m_ap.getProp(5243992);
                this.value = (Double)this.m_ap.getProp(0x500450);
                this.low = (Double[])this.m_ap.getProp(273679445);
                this.normal = (Double[])this.m_ap.getProp(273679444);
                this.high = (Double[])this.m_ap.getProp(273679446);
            }
            this.caption = (String)this.m_ap.getProp(1049683);
            this.f_state = (Boolean)this.m_ap.getProp(8389721);
            if (this.f_state != null) {
                this.flashOn = this.f_state;
            }
            this.flashMe(this.flashOn);
            this.state = (Integer)this.m_ap.getProp(2097694);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent.getCanvas())), propertyException);
        }
        NodeGauge.g_color[0] = Color.yellow;
        NodeGauge.g_color[1] = Color.green;
        NodeGauge.g_color[2] = Color.red;
        this.setCaption(this.caption);
        this.setValue(this.value);
        switch (this.type) {
            case 1: {
                this.setlowZone(this.low);
                this.sethighZone(this.high);
                this.setnormZone(this.normal);
                break;
            }
        }
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
    }

    public void setlowZone(Double[] doubleArray) {
        if (doubleArray[0] != null) {
            this.lowzone[0] = doubleArray[0];
            this.lowzone[1] = doubleArray[1];
        }
        this.setZone("cyanzone", this.lowzone[0], this.lowzone[1], g_color[0]);
        this.repaint();
    }

    public void sethighZone(Double[] doubleArray) {
        if (doubleArray[0] != null) {
            this.highzone[0] = doubleArray[0];
            this.highzone[1] = doubleArray[1];
        }
        this.setZone("redzone", this.highzone[0], this.highzone[1], g_color[2]);
        this.repaint();
    }

    public void setnormZone(Double[] doubleArray) {
        if (doubleArray[0] != null) {
            this.normalzone[0] = doubleArray[0];
            this.normalzone[1] = doubleArray[1];
        }
        this.setZone("bluezone", this.normalzone[0], this.normalzone[1], g_color[1]);
        this.repaint();
    }

    public double[] getLowZone() {
        return this.lowzone;
    }

    public double[] getHighZone() {
        return this.highzone;
    }

    public double[] getNormalZone() {
        return this.normalzone;
    }

    public void setMinRange(double d) {
        this.lowestValue = d;
        this.repaint();
    }

    public void setMaxRange(double d) {
        this.highestValue = d;
        this.repaint();
    }

    public void setValue(double d) {
        this.value = d;
        if (this.value < this.lowestValue) {
            this.value = this.lowestValue;
        }
        if (this.value > this.highestValue) {
            this.value = this.highestValue;
        }
        this.repaint();
    }

    public double getMinimum() {
        return this.lowestValue;
    }

    public double getMaximum() {
        return this.highestValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setCaption(String string) {
        this.caption = string;
        this.repaint();
    }

    public void setGaugeType(int n) {
        this.type = n;
        this.repaint();
    }

    public void setZone(String string, double d, double d2, Color color) {
        if (d < this.lowestValue) {
            d = this.lowestValue;
        }
        if (d2 < this.lowestValue) {
            d2 = this.lowestValue;
        }
        if (d > this.highestValue) {
            d = this.highestValue;
        }
        if (d2 > this.highestValue) {
            d2 = this.highestValue;
        }
        this.zones.addElement(new MeterZone(string, d, d2, color));
        this.repaint();
    }

    public GraphNode getParent() {
        return this.m_parent;
    }

    public void flashMe(boolean bl) {
        if (this.gf == null && bl) {
            this.gf = new Gaugeflasher();
            this.gf.start();
            return;
        }
        if (this.gf != null && bl) {
            this.gf.resume();
            return;
        }
        if (this.gf != null && !bl && this.gf.isAlive()) {
            this.gf.suspend();
        }
    }

    public void repaint() {
        this.offScreenGraphics = this.m_parent.getCanvas().getGraphics();
        if (this.offScreenGraphics != null && this.flashOn) {
            Color color = this.m_parent.getCanvas().getBackground();
            this.offScreenGraphics.setColor(color);
            if (this.type == 4) {
                this.offScreenGraphics.fillRect(this.origin.x, this.origin.y, this.g_dim.width + 17, this.g_dim.height);
            } else if (this.type == 1) {
                this.offScreenGraphics.fillRect(this.origin.x - 43, this.origin.y - 38, 91, 42);
            }
        }
        if (this.offScreenGraphics != null) {
            this.update(this.offScreenGraphics);
        }
    }

    public void paint(Graphics graphics) {
        if (this.type == 1) {
            this.drawMeter(graphics);
            return;
        }
        if (this.type == 4) {
            this.drawThermoMeter(graphics);
            return;
        }
        if (this.type != 2 && this.type == 3) {
            this.drawSignalGauge(graphics);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void drawSignalGauge(Graphics graphics) {
        Image image = null;
        if (this.state != null) {
            image = this.state == 1 ? AdminUtil.loadImage("images/gaugeon.gif", (Component)((Object)this.m_parent.getCanvas())) : AdminUtil.loadImage("images/gaugeoff.gif", (Component)((Object)this.m_parent.getCanvas()));
        }
        this.p = this.m_parent.getOrigin();
        this.d = this.m_parent.getDimension();
        if (this.relative_x == 0) {
            this.relative_x = this.d.width + 16;
        }
        if (this.relative_y == 0) {
            this.relative_y = -15;
        }
        if (this.origin == null) {
            this.origin = new Point(this.p.x + this.relative_x, this.p.y + this.relative_y);
        } else {
            this.origin.setLocation(this.p.x + this.relative_x, this.p.y + this.relative_y);
        }
        this.g_dim = this.g_dim == null && image != null ? new Dimension(image.getWidth((ImageObserver)((Object)this.m_parent.getCanvas())), image.getHeight((ImageObserver)((Object)this.m_parent.getCanvas()))) : new Dimension(32, 32);
        if (image != null && !this.flashOn) {
            graphics.drawImage(image, this.origin.x, this.origin.y, this.g_dim.width, this.g_dim.height, (ImageObserver)((Object)this.m_parent.getCanvas()));
        } else if (this.getParent().getCanvas().getImage() != null) {
            graphics.drawImage(this.getParent().getCanvas().getImage(), this.origin.x, this.origin.y, this.origin.x + this.g_dim.width, this.origin.y + this.g_dim.height, this.origin.x, this.origin.y, this.origin.x + this.g_dim.width, this.origin.y + this.g_dim.height, (ImageObserver)((Object)this.m_parent.getCanvas()));
        }
        graphics.getFontMetrics().stringWidth(this.caption.toString());
        if (!this.flashOn && this.caption != null) {
            graphics.setColor(Color.black);
            graphics.setFont(this.captionFont);
            Font font = graphics.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            graphics.drawString(this.caption, this.origin.x + this.g_dim.width / 2 - fontMetrics.stringWidth(this.caption.toString()) / 2, this.origin.y + this.g_dim.height + 12);
        }
    }

    private void drawMeter(Graphics graphics) {
        double d;
        double d2 = Math.PI / 180;
        int n = 700;
        int n2 = 700;
        this.p = this.m_parent.getOrigin();
        this.d = this.m_parent.getDimension();
        if (this.relative_x == 0) {
            this.relative_x = this.d.width / 2;
        }
        if (this.relative_y == 0) {
            this.relative_y = -15;
        }
        if (this.origin == null) {
            this.origin = new Point(this.p.x + this.relative_x, this.p.y + this.relative_y);
        } else {
            this.origin.setLocation(this.p.x + this.relative_x, this.p.y + this.relative_y);
        }
        if (this.g_dim == null) {
            this.g_dim = new Dimension(75, 71);
        }
        if (!this.flashOn) {
            int n3 = 0;
            while (n3 < this.zones.size()) {
                MeterZone meterZone = (MeterZone)this.zones.elementAt(n3);
                d = this.valueToAngle(meterZone.getZoneLow());
                double d3 = this.valueToAngle(meterZone.getZoneHigh());
                graphics.setColor(meterZone.getZoneColor());
                graphics.fillArc(this.origin.x - 26, this.origin.y - 29, 53, 56, (int)d, (int)(d3 - d));
                ++n3;
            }
        }
        if (!this.flashOn) {
            graphics.setColor(Color.black);
        }
        double d4 = this.lowestValue;
        while (d4 <= this.highestValue) {
            d = this.valueToAngle(d4);
            d = 360.0 - d;
            int n4 = this.origin.x + (int)(Math.cos(d *= d2) * 26.0);
            int n5 = this.origin.y + (int)(Math.sin(d) * 28.0);
            int n6 = this.origin.x + (int)(Math.cos(d) * 29.0);
            int n7 = this.origin.y + (int)(Math.sin(d) * 31.0);
            if (!this.flashOn) {
                graphics.drawLine(n4, n5, n6, n7);
            }
            int n8 = (int)(Math.cos(d) * 31.0);
            int n9 = (int)(Math.sin(d) * 33.0);
            int n10 = 0;
            int n11 = 0;
            n10 = n8 < 0 ? this.origin.x + n8 - 8 : this.origin.x + n8 + 8;
            n11 = this.origin.y + n9 + 2;
            if (!this.flashOn) {
                graphics.setFont(this.numbersFont);
            }
            int n12 = graphics.getFontMetrics().stringWidth(String.valueOf(d4)) / 2;
            if (!this.flashOn) {
                graphics.drawString(String.valueOf(d4), n10 - n12, n11);
            }
            d4 += this.scaleGrad;
        }
        d = this.valueToAngle(this.value);
        d = 360.0 - d;
        d *= d2;
        if (!this.flashOn) {
            graphics.setColor(Color.black);
        }
        if (!this.flashOn) {
            graphics.drawLine(this.origin.x, this.origin.y, this.origin.x + (int)(Math.cos(d) * 26.0), this.origin.y + (int)(Math.sin(d) * 28.0));
        }
        if (!this.flashOn) {
            graphics.fillRect(this.origin.x, this.origin.y, 3, 3);
        }
        int n13 = graphics.getFontMetrics().stringWidth(this.caption);
        if (!this.flashOn && this.caption != null) {
            graphics.setFont(this.captionFont);
            graphics.drawString(this.caption, this.origin.x - n13 / 2, this.origin.y - 51);
        }
    }

    private void drawThermoMeter(Graphics graphics) {
        int n = 10;
        int n2 = (int)((double)n * 1.3);
        int n3 = n2 / 2;
        this.p = this.m_parent.getOrigin();
        this.d = this.m_parent.getDimension();
        if (this.relative_x == 0) {
            this.relative_x = -32;
        }
        if (this.origin == null) {
            this.origin = new Point(this.p.x + this.relative_x, this.p.y + this.relative_y);
        } else {
            this.origin.setLocation(this.p.x + this.relative_x, this.p.y + this.relative_y);
        }
        if (this.g_dim == null) {
            this.g_dim = new Dimension(n + 6, this.d.height + 8);
        }
        if (!this.flashOn) {
            graphics.fillRoundRect(this.origin.x + 3, this.origin.y, n, this.d.height, n, n);
        }
        if (!this.flashOn) {
            graphics.fillOval(this.origin.x + 2, this.origin.y + this.d.height - n3, n2, n2);
        }
        graphics.setColor(Color.black);
        double d = ((double)this.d.height - (double)(3 * n3)) / ((this.highestValue - this.lowestValue) / this.scaleGrad);
        if (!this.flashOn) {
            graphics.setFont(this.numbersFont);
        }
        if (!this.flashOn) {
            double d2 = this.lowestValue;
            double d3 = 0.0;
            while (d2 <= this.highestValue) {
                int n4 = (int)d * (int)d3;
                graphics.drawLine(this.origin.x + 3 + n / 2, this.origin.y + this.d.height - n3 - n4, this.origin.x + 3 + n / 2 + 4, this.origin.y + this.d.height - n3 - n4);
                graphics.drawString(String.valueOf(d2), this.origin.x + 13 + n / 2, this.origin.y + this.d.height - n3 - n4);
                d3 += 1.0;
                d2 += this.scaleGrad;
            }
        }
        if (!this.flashOn) {
            graphics.setColor(Color.red);
        }
        if (!this.flashOn) {
            graphics.drawLine(this.origin.x + 3 + n / 2, this.origin.y + this.d.height - n3, this.origin.x + 3 + n / 2, this.origin.y + this.d.height - n3 - (int)(d * ((this.value - this.lowestValue) / this.scaleGrad)));
        }
        if (!this.flashOn && this.caption != null) {
            graphics.setColor(Color.black);
            graphics.setFont(this.captionFont);
            int n5 = graphics.getFontMetrics().stringWidth(this.caption);
            graphics.drawString(this.caption, this.origin.x + 3 - n5, this.origin.y + this.d.height);
        }
    }

    private double valueToAngle(double d) {
        double d2 = 10.0;
        double d3 = 170.0;
        double d4 = (d3 - d2) / (this.highestValue - this.lowestValue);
        return d3 - (d - this.lowestValue) * d4;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public Dimension getDimension() {
        return this.g_dim;
    }

    public void setOrigin(Point point) {
        this.origin = point;
    }

    public void setOrigin(int n, int n2) {
        this.relative_x = n - this.p.x;
        this.relative_y = n2 - this.p.y;
    }

    public void setDimension(Dimension dimension) {
        this.g_dim = dimension;
    }

    public void setDimension(int n, int n2) {
        this.g_dim.width = n;
        this.g_dim.height = n2;
    }

    public boolean isMouseOn(int n, int n2) {
        if (this.type == 1) {
            return this.origin.x - 26 <= n && n <= this.origin.x + 26 && n2 >= this.origin.y - 29 && n2 <= this.origin.y;
        }
        if (this.type == 4) {
            return this.origin.x <= n && n <= this.origin.x + this.g_dim.width && this.origin.y <= n2 && n2 <= this.origin.y + this.g_dim.height;
        }
        if (this.type == 3) {
            return this.origin.x <= n && n <= this.origin.x + this.g_dim.width && this.origin.y <= n2 && n2 <= this.origin.y + this.g_dim.height;
        }
        return false;
    }

    public boolean isDraggable() {
        return true;
    }

    public void drawLast(Graphics graphics) {
        Point point = this.m_parent.getCanvas().getRubberband().lastBounds();
        if (this.type == 1) {
            graphics.drawRect(point.x - 45, point.y - 60, this.g_dim.width + 14, this.g_dim.height - 8);
            return;
        }
        if (this.type == 4 || this.type == 3) {
            graphics.drawRect(point.x, point.y, this.g_dim.width, this.g_dim.height);
        }
    }

    public void drawNext(Graphics graphics) {
        Point point = this.m_parent.getCanvas().getRubberband().bounds();
        if (this.type == 1) {
            graphics.drawRect(point.x - 45, point.y - 60, this.g_dim.width + 14, this.g_dim.height - 8);
            return;
        }
        if (this.type == 4 || this.type == 3) {
            graphics.drawRect(point.x, point.y, this.g_dim.width, this.g_dim.height);
        }
    }

    /*
     * Exception decompiling
     */
    public void adminPropertyChange(AdminPropertyChangeEvent var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 512;
    }

    public void setupToolbar(int n) {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        return false;
    }

    public void revert() {
    }

    public boolean commit() {
        return true;
    }

    public void update() {
    }

    public void shutdown() {
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
        if (this.gf != null && this.gf.isAlive()) {
            this.gf.stopme();
        }
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public IAdminProp properties() {
        return null;
    }

    class MeterZone
    implements Cloneable {
        private String zonename;
        private double lo;
        private double hi;
        private Color zonecolor;

        public MeterZone(String string, double d, double d2, Color color) {
            NodeGauge.this = NodeGauge.this;
            this.zonename = string;
            this.lo = d;
            this.hi = d2;
            this.zonecolor = color;
        }

        public String getZoneName() {
            return this.zonename;
        }

        public double getZoneLow() {
            return this.lo;
        }

        public double getZoneHigh() {
            return this.hi;
        }

        public Color getZoneColor() {
            return this.zonecolor;
        }
    }

    class Gaugeflasher
    extends Thread {
        boolean m_running = false;

        public Gaugeflasher() {
            super("GaugeFlasher");
            NodeGauge.this = NodeGauge.this;
        }

        public void start() {
            this.m_running = true;
            super.start();
        }

        public void stopme() {
            NodeGauge.this.gf = null;
            this.m_running = false;
            super.stop();
        }

        public void run() {
            while (this.m_running) {
                NodeGauge.this.flashOn = true;
                NodeGauge.this.repaint();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                NodeGauge.this.flashOn = false;
                NodeGauge.this.repaint();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

