/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.propEditors.GraphLine;
import oracle.ldap.admin.client.propEditors.GraphNode;
import oracle.ldap.admin.client.propEditors.Shape;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class NodePort
implements Shape {
    GraphNode m_parent;
    IAdminProp m_portObj;
    IAdminProp[] m_items;
    Vector m_lines = new Vector();
    Point m_origin = new Point(0, 0);
    Dimension m_dim;
    String m_name;
    Color m_color;
    int m_order;
    int m_placement;
    int m_shape;
    int m_fill;
    private final int port_width = 8;
    private final int port_height = 8;
    boolean isExpanded = false;

    public NodePort(IAdminProp iAdminProp, GraphNode graphNode) {
        this.m_portObj = iAdminProp;
        this.m_parent = graphNode;
        try {
            this.m_name = (String)this.m_portObj.getProp(1049621);
            this.m_color = (Color)this.m_portObj.getProp(12583959);
            Integer n = (Integer)this.m_portObj.getProp(2098198);
            this.m_order = n != null ? n : 1;
            Integer n2 = (Integer)this.m_portObj.getProp(2098201);
            this.m_placement = n2 != null ? n2 : 4;
            Integer n3 = (Integer)this.m_portObj.getProp(2098227);
            this.m_shape = n3 != null ? n3 : 1;
            Integer n4 = (Integer)this.m_portObj.getProp(2098228);
            if (n4 != null) {
                this.m_fill = n4;
                return;
            }
            this.m_fill = 1;
            return;
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent.getCanvas())), propertyException);
            return;
        }
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public String getName() {
        return this.m_name;
    }

    public Point getOrigin() {
        return this.m_origin;
    }

    public Dimension getDimension() {
        return new Dimension(8, 8);
    }

    public void setOrigin(Point point) {
        this.m_origin = point;
    }

    public void setOrigin(int n, int n2) {
        this.m_origin.x = n;
        this.m_origin.y = n2;
    }

    public void setDimension(Dimension dimension) {
    }

    public void setDimension(int n, int n2) {
    }

    public boolean isMouseOn(int n, int n2) {
        return this.m_origin.x <= n && n <= this.m_origin.x + 8 && this.m_origin.y <= n2 && n2 <= this.m_origin.y + 8;
    }

    public boolean isDraggable() {
        return false;
    }

    public void drawLast(Graphics graphics) {
    }

    public void drawNext(Graphics graphics) {
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setState(boolean bl) {
        this.isExpanded = bl;
    }

    public Vector getLines() {
        return this.m_lines;
    }

    public NodePort findPort(IAdminProp iAdminProp) {
        return this.m_parent.findPort(iAdminProp);
    }

    public NodePort findNodePort(IAdminProp iAdminProp) {
        if (iAdminProp == this.m_portObj) {
            return this;
        }
        return null;
    }

    public int getPlacement() {
        return this.m_placement;
    }

    public GraphNode getParent() {
        return this.m_parent;
    }

    public Object getObject() {
        return this.m_portObj;
    }

    public void setupToolbar(int n) {
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 512;
    }

    public void addLines(GraphLine graphLine) {
        this.m_lines.addElement(graphLine);
    }

    public void removeLines(GraphLine graphLine) {
        this.m_lines.removeElement(graphLine);
    }

    public void removeLines() {
        this.m_lines.removeAllElements();
    }

    public void createLines() {
        try {
            this.m_items = (IAdminProp[])this.m_portObj.getProp(272630816);
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent.getCanvas())), propertyException);
        }
        if (this.m_items != null) {
            int n = 0;
            while (n < this.m_items.length) {
                GraphLine graphLine = new GraphLine(this.m_items[n], this);
                this.m_lines.addElement(graphLine);
                ++n;
            }
        }
    }

    public Point recalcOrigin(Point point, int n, int n2, int n3) {
        Point point2 = this.m_parent.getOrigin();
        this.m_dim = this.m_parent.getDimension();
        switch (this.m_placement) {
            case 3: {
                point.x = point2.x + this.m_dim.width / n * n2 - 4;
                point.y = point2.y - 8;
                break;
            }
            case 4: {
                point.x = point2.x + this.m_dim.width / n * n2 - 4;
                point.y = point2.y + this.m_dim.height + n3 + 2;
                break;
            }
            case 2: {
                point.x = point2.x - 8;
                point.y = point2.y + this.m_dim.height / n * n2 - 4;
                break;
            }
            case 1: {
                point.x = point2.x + this.m_dim.width;
                point.y = point2.y + this.m_dim.height / n * n2 - 4;
                break;
            }
        }
        this.m_origin.x = point.x;
        this.m_origin.y = point.y;
        return point;
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        if (this.m_color != null) {
            graphics.setColor(this.m_color);
        }
        if (this.m_fill == 2) {
            if (this.m_shape == 2) {
                graphics.drawOval(this.m_origin.x, this.m_origin.y, 8, 8);
            } else if (this.m_shape == 1) {
                graphics.drawRect(this.m_origin.x, this.m_origin.y, 8, 8);
            }
        } else if (this.m_shape == 2) {
            graphics.fillOval(this.m_origin.x, this.m_origin.y, 8, 8);
        } else if (this.m_shape == 1) {
            graphics.fillRect(this.m_origin.x, this.m_origin.y, 8, 8);
        }
        if (this.m_color != null) {
            graphics.setColor(color);
        }
    }
}

