/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.propEditors.GraphNode;
import oracle.ldap.admin.client.propEditors.Rubberband;
import oracle.ldap.admin.client.propEditors.Shape;
import oracle.ldap.admin.client.propEditors.ShapeCircle;
import oracle.ldap.admin.client.propEditors.ShapeImage;
import oracle.ldap.admin.client.propEditors.ShapeNone;
import oracle.ldap.admin.client.propEditors.ShapeRect;

class NodeShape
implements Shape {
    Shape m_shapePainter;
    GraphNode m_parent;
    Rubberband m_band;
    boolean m_fillValue;
    String m_imageName;
    Image m_image;

    public NodeShape(int n, int n2, GraphNode graphNode) {
        this.m_parent = graphNode;
        this.m_band = this.m_parent.getCanvas().getRubberband();
        this.m_imageName = this.m_parent.getImage();
        if (this.m_imageName != null) {
            this.m_image = AdminUtil.loadImage(this.m_imageName, (Component)((Object)this.m_parent.getCanvas()));
        }
        this.m_fillValue = n2 == 1;
        switch (n) {
            case 1: {
                this.m_shapePainter = new ShapeRect(this.m_fillValue, this.m_band);
                return;
            }
            case 2: {
                this.m_shapePainter = new ShapeCircle(this.m_fillValue, this.m_band);
                return;
            }
            case 3: {
                if (this.m_image != null) {
                    this.m_shapePainter = new ShapeImage(this.m_fillValue, this.m_band, this.m_image, this.m_parent);
                    return;
                }
                this.m_shapePainter = new ShapeRect(this.m_fillValue, this.m_band);
                return;
            }
        }
        this.m_shapePainter = new ShapeNone(this.m_fillValue, this.m_band, this.m_parent);
    }

    public GraphNode getParent() {
        return this.m_parent;
    }

    public Shape getShape() {
        return this.m_shapePainter;
    }

    public void paint(Graphics graphics) {
        this.m_shapePainter.paint(graphics);
    }

    public Point getOrigin() {
        return this.m_shapePainter.getOrigin();
    }

    public Dimension getDimension() {
        return this.m_shapePainter.getDimension();
    }

    public void setOrigin(Point point) {
        this.m_shapePainter.setOrigin(point);
    }

    public void setDimension(Dimension dimension) {
        this.m_shapePainter.setDimension(dimension);
    }

    public void setOrigin(int n, int n2) {
        this.m_shapePainter.setOrigin(n, n2);
    }

    public void setDimension(int n, int n2) {
        this.m_shapePainter.setDimension(n, n2);
    }

    public boolean isMouseOn(int n, int n2) {
        return this.m_shapePainter.isMouseOn(n, n2);
    }

    public boolean isDraggable() {
        return this.m_shapePainter.isDraggable();
    }

    public void drawLast(Graphics graphics) {
        this.m_shapePainter.drawLast(graphics);
    }

    public void drawNext(Graphics graphics) {
        this.m_shapePainter.drawNext(graphics);
    }
}

