/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.RelativePlacement;
import com.roguewave.chart.standard.v2_1.Chart;
import com.roguewave.chart.standard.v2_1.PieChart;
import com.roguewave.chart.standard.v2_1.events.ChartClickEvent;
import com.roguewave.chart.standard.v2_1.events.ChartClickListener;
import com.roguewave.chart.standard.v2_1.parts.SingleRowLegend;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.propEditors.ChartDataModel;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class PieView
extends AdminPanel
implements RelativePlacement,
ChartClickListener,
AdminPropertyChangeListener {
    Object[] m_items;
    String[] legends;
    int[] prop_list;
    int item_count;
    int prop_count;
    int c_status;
    int orient;
    int view;
    Color[] colors;
    Chart component;
    Integer t_status;

    public PieView(IAdminProp iAdminProp, DataModel dataModel) {
        PieChart pieChart = null;
        pieChart = new PieChart(false, 0);
        this.component = new Chart((ChartBuilder)pieChart, 2, dataModel);
        this.init(iAdminProp);
        this.component.addChartClickListener((ChartClickListener)this);
        this.setView(iAdminProp);
        this.setColor(iAdminProp);
        this.component.setDrawAreaInsets(new Insets(50, 25, 25, 50));
        this.component.setLabelColor(Color.black);
        this.component.setTitleColor(Color.blue);
        this.component.setTitleBackgroundColor(Color.cyan.darker());
        AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", (Component)this.component);
    }

    private void init(IAdminProp iAdminProp) {
        try {
            this.m_items = (Object[])iAdminProp.getProp(272695365);
            this.prop_list = (int[])iAdminProp.getProp(281083972);
            if (this.prop_list != null) {
                this.prop_count = this.prop_list.length;
            }
            if (this.m_items != null) {
                this.item_count = this.m_items.length;
            }
            if ((this.t_status = (Integer)iAdminProp.getProp(2162758)) != null) {
                this.c_status = this.t_status;
                return;
            }
        }
        catch (PropertyException propertyException) {}
    }

    public void chartClick(ChartClickEvent chartClickEvent) {
        if (this.c_status == 3) {
            AdminUtil.editStandalone((IAdminProp)this.m_items[chartClickEvent.getRow(0)], null, (Component)((Object)this));
            return;
        }
        if (this.c_status == 1) {
            AdminUtil.editStandalone((IAdminProp)this.m_items[chartClickEvent.getColumn(0)], null, (Component)((Object)this));
        }
    }

    void setColor(IAdminProp iAdminProp) {
        try {
            this.colors = (Color[])iAdminProp.getProp(269549634);
        }
        catch (PropertyException propertyException) {}
        if (this.colors != null) {
            if (this.c_status == 1) {
                int n = 0;
                while (n < this.prop_count) {
                    this.component.setProperty("ForegroundColor", (Object)this.colors[n], n, 0, 1, 1);
                    ++n;
                }
                return;
            }
            if (this.c_status == 3) {
                int n = 0;
                while (n < this.item_count) {
                    this.component.setProperty("ForegroundColor", (Object)this.colors[n], n, 0, 1, 1);
                    ++n;
                }
            }
        }
    }

    void setView(IAdminProp iAdminProp) {
        if (this.view == 1) {
            this.component.setViewMode(0);
            return;
        }
        this.component.setViewMode(2);
    }

    void setData(IAdminProp iAdminProp) {
        this.init(iAdminProp);
        this.component.setData((DataModel)new ChartDataModel(iAdminProp, (Component)((Object)this)));
    }

    void setTitle(IAdminProp iAdminProp) {
        String string = null;
        try {
            string = (String)iAdminProp.getProp(0x110050);
        }
        catch (PropertyException propertyException) {}
        this.component.setTitle(string);
    }

    void setLegend(IAdminProp iAdminProp) {
        String[] stringArray = null;
        try {
            stringArray = (String[])iAdminProp.getProp(269549635);
        }
        catch (PropertyException propertyException) {}
        if (this.colors != null & stringArray != null) {
            this.component.setLegend((Customizer)new SingleRowLegend(stringArray, this.colors));
            return;
        }
        this.component.setLegend((Customizer)new SingleRowLegend());
    }

    void setChartType(IAdminProp iAdminProp) {
        int n = 0;
        try {
            Integer n2 = (Integer)iAdminProp.getProp(2162771);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (PropertyException propertyException) {}
        switch (n) {
            case 2: {
                this.component.setChartType("Bar");
                return;
            }
        }
    }

    public static Component createChart(IAdminProp iAdminProp, EditorOwner editorOwner) {
        ChartDataModel chartDataModel = new ChartDataModel(iAdminProp);
        PieView pieView = new PieView(iAdminProp, chartDataModel);
        chartDataModel.setParent((Component)((Object)pieView));
        return pieView;
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            IAdminProp iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource();
            switch (adminPropertyChangeEvent.getPropId()) {
                case 2162758: 
                case 272695365: 
                case 281083972: {
                    this.setData(iAdminProp);
                    break;
                }
                case 269549634: {
                    this.setColor(iAdminProp);
                    break;
                }
                case 2162760: {
                    this.setView(iAdminProp);
                    break;
                }
                case 0x110050: {
                    this.setTitle(iAdminProp);
                    break;
                }
                case 269549635: {
                    this.setLegend(iAdminProp);
                    break;
                }
                case 2162771: {
                    this.setChartType(iAdminProp);
                    break;
                }
            }
            this.component.repaint();
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    void unexpectedException(Exception exception) {
        System.out.println("Unexpected Exception " + exception);
    }
}

